/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.IUserCustomConfigItemUI;
import com.kingdee.eas.framework.config.UserCustomConfigData;
import com.kingdee.eas.framework.config.UserCustomConfigHelper;
import com.kingdee.eas.framework.config.UserCustomConfigItem;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserCustomConfigSolution;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;

public class ColumnSettingUI
extends CoreUI
implements IUserCustomConfigItemUI {
    private KDTable tableEdit;
    private static String RESNAME = "com.kingdee.eas.framework.config.Preferences";
    private ResourceBundleHelper resHelper = new ResourceBundleHelper(RESNAME);
    private KDTable tableComponent;
    private static final String commonSorterRes = "com.kingdee.eas.base.commonquery.client.CommonSorterPanel";
    private static final String COLUMNKEY = "ColumnKey";
    private static final String COLUMNNAME = "ColumnName";
    private static final String COLUMNWIDTH = "ColumnWidth";
    private static final String COLUMNALIGN = "ColumnAlign";
    private static final String COLUMNSORTED = "ColumnSorted";
    private static final String COLUMNVISIBLE = "ColumnVisible";
    private static final String COLUMNFROZEN = "ColumnFrozen";
    private UserCustomConfigData userConfigData;
    private UserCustomConfigSolution solution;
    private UserCustomConfigItem item;
    private UserCustomConfigHelper helper;

    public ColumnSettingUI() throws Exception {
        this.initialize();
    }

    private void initialize() throws BOSException {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "North");
        this.add((Component)this.getTableEdit(), "Center");
    }

    private Component getButtonPanel() {
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        KDPanel panel1 = new KDPanel();
        GridLayout gridLayout = new GridLayout();
        gridLayout.setVgap(2);
        gridLayout.setHgap(2);
        panel1.setLayout((LayoutManager)gridLayout);
        KDWorkButton moveUpRowButton = new KDWorkButton();
        moveUpRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        moveUpRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnSettingUI.this.moveUpRowButton_actionPerformed(e);
            }
        });
        panel1.add((Component)moveUpRowButton);
        KDWorkButton moveDownRowButton = new KDWorkButton();
        moveDownRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        moveDownRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnSettingUI.this.moveDownRowButton_actionPerformed(e);
            }
        });
        panel1.add((Component)moveDownRowButton);
        panel.add((Component)panel1, (Object)"East");
        return panel;
    }

    private KDTable getTableEdit() {
        if (this.tableEdit == null) {
            this.tableEdit = new KDTable();
            this.tableEdit.getSelectManager().setSelectMode(1);
            this.initTable(this.tableEdit);
        }
        return this.tableEdit;
    }

    private void initTable(KDTable table) {
        String[] headTitles = new String[]{COLUMNKEY, this.resHelper.getString(COLUMNNAME), this.resHelper.getString(COLUMNWIDTH), this.resHelper.getString(COLUMNALIGN), this.resHelper.getString(COLUMNSORTED), this.resHelper.getString(COLUMNVISIBLE), this.resHelper.getString(COLUMNFROZEN)};
        String[] columnKeys = new String[]{COLUMNKEY, COLUMNNAME, COLUMNWIDTH, COLUMNALIGN, COLUMNSORTED, COLUMNVISIBLE, COLUMNFROZEN};
        int[] columnWidth = new int[]{100, 120, 50, 60, 60, 60, 50};
        for (int i = 0; i < 7; ++i) {
            IColumn column = table.addColumn();
            column.setWidth(columnWidth[i]);
            column.setKey(columnKeys[i]);
            if (i == 0 || i == 4 || i == 6) {
                column.getStyleAttributes().setHided(true);
            }
            if (i == 1) {
                column.getStyleAttributes().setLocked(true);
                column.getStyleAttributes().setBackground(new Color(217, 217, 208));
            }
            if (i != 3) continue;
            JComboBox<String> c = new JComboBox<String>();
            c.addItem("left");
            c.addItem("center");
            c.addItem("right");
            KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(c);
            column.setEditor((ICellEditor)cellEditor);
        }
        IRow row = null;
        row = table.addHeadRow();
        for (int i = 0; i < 7; ++i) {
            row.getCell(i).setValue((Object)headTitles[i]);
        }
        table.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        table.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
    }

    private UserCustomConfigItemData getItemDataByTB(KDTable tb) {
        UserCustomConfigItemData itemData = new UserCustomConfigItemData();
        for (int i = 0; i < tb.getRowCount(); ++i) {
            IRow row = tb.getRow(i);
            Object[] rowDatas = this.getRowData(i);
            String key = (String)rowDatas[0];
            String values = "";
            for (int j = 1; j < rowDatas.length; ++j) {
                values = values + rowDatas[j] + ",";
            }
            itemData.getColumnData().put(key, values);
        }
        return itemData;
    }

    private void fillData(UserCustomConfigItemData data, KDTable table) {
        table.removeRows();
        for (String key : data.getColumnData().keySet()) {
            String values = (String)data.getColumnData().get(key);
            IRow row = table.addRow();
            row.getCell(0).setValue((Object)key);
            ColumnItemData columnData = this.string2ColumnData(values);
            row.getCell(1).setValue((Object)columnData.getTitle());
            row.getCell(2).setValue((Object)String.valueOf(columnData.getWidth()));
            row.getCell(3).setValue((Object)columnData.getAlign());
            row.getCell(4).setValue((Object)columnData.isSorted());
            row.getCell(5).setValue((Object)columnData.isHidden());
            row.getCell(6).setValue((Object)columnData.isLocked());
        }
    }

    @Override
    public void saveData(UserCustomConfigData data) {
        this.getItemData(data);
    }

    private void getItemData(UserCustomConfigData data) {
        data.setItemData(this.solution.getName(), this.item.getName(), this.getItemDataByTB(this.tableEdit));
    }

    @Override
    public void setItem(UserCustomConfigData data, UserCustomConfigSolution solution, UserCustomConfigItem item, UserCustomConfigHelper helper) {
        this.userConfigData = data;
        this.solution = solution;
        this.item = item;
        this.helper = helper;
        if (item.getComponent() != null) {
            this.tableComponent = (KDTable)item.getComponent();
            UserCustomConfigItemData itemData = solution.isSelected() ? this.getColumnDataFromTable(this.tableComponent) : this.getItemDataByUserConfig();
            data.setItemData(solution.getName(), item.getName(), itemData);
            this.fillData(itemData, this.tableEdit);
        }
    }

    private UserCustomConfigItemData getItemDataByUserConfig() {
        return this.userConfigData.getItemData(this.solution.getName(), this.item.getName());
    }

    protected void moveUpRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.tableEdit.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.tableEdit.getSelectManager().getActiveColumnIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonSorterRes, (String)"moveWarning"));
        } else {
            if (selectedRowIndex == 0) {
                return;
            }
            this.moveUpRow();
            this.tableEdit.getSelectManager().select(selectedRowIndex - 1, selectedColIndex);
        }
    }

    protected void moveDownRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.tableEdit.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonSorterRes, (String)"moveWarning"));
        } else {
            if (selectedRowIndex == this.tableEdit.getRowCount() - 1) {
                return;
            }
            this.moveDownRow();
        }
    }

    private void moveUpRow() {
        int selectedRowIndex = this.tableEdit.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.tableEdit.getSelectManager().getActiveColumnIndex();
        Object[] modifyRowData = this.getRowData(selectedRowIndex - 1);
        Object[] currentRowData = this.getRowData(selectedRowIndex);
        this.setRowData(selectedRowIndex - 1, currentRowData);
        this.setRowData(selectedRowIndex, modifyRowData);
        this.tableEdit.getColumn(1).getStyleAttributes().setLocked(true);
        this.tableEdit.getColumn(1).getStyleAttributes().setBackground(new Color(217, 217, 208));
        this.tableEdit.getSelectManager().select(selectedRowIndex - 1, selectedColIndex);
    }

    private void moveDownRow() {
        int selectedRowIndex = this.tableEdit.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.tableEdit.getSelectManager().getActiveColumnIndex();
        Object[] modifyRowData = this.getRowData(selectedRowIndex + 1);
        Object[] currentRowData = this.getRowData(selectedRowIndex);
        this.setRowData(selectedRowIndex + 1, currentRowData);
        this.setRowData(selectedRowIndex, modifyRowData);
        this.tableEdit.getColumn(1).getStyleAttributes().setLocked(true);
        this.tableEdit.getColumn(1).getStyleAttributes().setBackground(new Color(217, 217, 208));
        this.tableEdit.getSelectManager().select(selectedRowIndex + 1, selectedColIndex);
    }

    private Object[] getRowData(int rowIndex) {
        int length = this.tableEdit.getColumnCount();
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            objects[i] = this.tableEdit.getRow(rowIndex).getCell(i).getValue();
        }
        return objects;
    }

    private void setRowData(int rowIndex, Object[] objects) {
        if (objects != null) {
            int length = objects.length;
            for (int i = 0; i < length; ++i) {
                this.tableEdit.getRow(rowIndex).getCell(i).setValue(objects[i]);
            }
        }
    }

    public UserCustomConfigItemData getColumnDataFromTable(KDTable tb) {
        UserCustomConfigItemData itemData = new UserCustomConfigItemData();
        KDTColumns columns = tb.getColumns();
        for (int i = 0; i < tb.getColumnCount(); ++i) {
            IColumn col = tb.getColumn(i);
            ColumnItemData columnData = new ColumnItemData();
            columnData.setIndex(i);
            columnData.setKey(col.getKey());
            if (tb.getHeadRowCount() == 1) {
                columnData.setTitle((String)tb.getHeadRow(0).getCell(i).getValue());
            }
            columnData.setWidth(col.getWidth());
            columnData.setAlign(col.getStyleAttributes().getHorizontalAlign());
            columnData.setHidden(col.getStyleAttributes().isHided());
            columnData.setLocked(col.getStyleAttributes().isLocked());
            itemData.getColumnData().put(col.getKey(), columnData.toString());
        }
        return itemData;
    }

    @Override
    public UserCustomConfigItemData getItemDataFromUI(UserCustomConfigItem item) {
        UserCustomConfigItemData itemData = null;
        if (item != null && item.getComponent() instanceof KDTable) {
            itemData = this.getColumnDataFromTable((KDTable)item.getComponent());
        }
        return itemData;
    }

    @Override
    public void applyConfig(UserCustomConfigData configData, UserCustomConfigItem item) {
        if (item.getComponent() != null && item.getComponent() instanceof KDTable && this.getDefaultItemData(configData, item.getName()) != null) {
            this.applyToTable((KDTable)item.getComponent(), this.getDefaultItemData(configData, item.getName()));
        }
    }

    private void applyToTable(KDTable table, UserCustomConfigItemData itemData) {
        if (itemData == null) {
            return;
        }
        for (String key : itemData.getColumnData().keySet()) {
            ColumnItemData columnData = this.string2ColumnData((String)itemData.getColumnData().get(key));
            IColumn col = table.getColumn(key);
            col.getStyleAttributes().setHided(columnData.isHidden());
            col.setWidth(columnData.getWidth());
            col.getStyleAttributes().setHorizontalAlign(columnData.getAlign());
        }
    }

    private UserCustomConfigItemData getDefaultItemData(UserCustomConfigData configData, String itemName) {
        return configData.getItemData(configData.getDefaultSolution().getName(), itemName);
    }

    public ColumnItemData string2ColumnData(String values) {
        String[] value = values.split(",");
        if (value.length != 6) {
            return null;
        }
        ColumnItemData data = new ColumnItemData();
        data.setTitle(value[0]);
        data.setWidth(Integer.parseInt(value[1]));
        data.setAlign(this.getAlign(value[2]));
        data.setSorted(Boolean.parseBoolean(value[3]));
        data.setHidden(Boolean.parseBoolean(value[4]));
        data.setLocked(Boolean.parseBoolean(value[5]));
        return data;
    }

    public Styles.HorizontalAlignment getAlign(String str) {
        if (str.equalsIgnoreCase("left")) {
            return Styles.HorizontalAlignment.LEFT;
        }
        if (str.equalsIgnoreCase("center")) {
            return Styles.HorizontalAlignment.CENTER;
        }
        if (str.equalsIgnoreCase("right")) {
            return Styles.HorizontalAlignment.RIGHT;
        }
        return Styles.HorizontalAlignment.LEFT;
    }
}

