/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComponentDialog;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ctrl.swing.util.JVM;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.commonquery.TableXMLHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FontSizeEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.config.AbstractTablePreferencesHelper;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserXMLHelper;
import com.kingdee.eas.framework.config.client.AbstractTablePreferences;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TablePreferences
extends AbstractTablePreferences {
    private KDTable tableEdit;
    private static String RESNAME = "com.kingdee.eas.framework.config.Preferences";
    private ResourceBundleHelper resHelper;
    private KDTable tableComponent;
    private static final String commonSorterRes = "com.kingdee.eas.base.commonquery.client.CommonSorterPanel";
    private static final String commonTableRes = "com.kingdee.eas.base.commonquery.client.CommonTablePanelResource";
    private static final String commonQueryRes = "com.kingdee.eas.base.commonquery.cqResource";
    private static final Locale zh_en = new Locale("l1");
    private static final String COLUMNKEY = "ColumnKey";
    private static final String COLUMNNAME = "ColumnName";
    private static final String COLUMNWIDTH = "ColumnWidth";
    private static final String COLUMNALIGN = "ColumnAlign";
    private static final String COLUMNSORTED = "ColumnSorted";
    private static final String COLUMNVISIBLE = "ColumnVisible";
    private static final String COLUMNFROZEN = "ColumnFrozen";
    private static final String COLUMNINDEX = "ColumnIndex";
    private static final int COLUMNFROZEN_INDEX = 6;
    private boolean isHidden = false;
    private boolean isFroze = false;
    private KDPanel buttonPanel;
    private KDTable currentTable;
    private AbstractTablePreferencesHelper helper;
    private KDWorkButton moveUpRowButton;
    private KDWorkButton moveDownRowButton;
    private KDWorkButton moveUpToTopButton;
    private KDWorkButton moveDownToBottomButton;
    private KDWorkButton isAllHidden;
    private KDWorkButton isAlLFroze;
    private KDWorkButton restoreButton;
    private KDWorkButton findButton;
    private KDPanel panel;
    private Map hiddenColumns = new HashMap();
    public CoreUI owner;
    private List<String> allFieldSumList = null;
    private List<String> fieldSumList = null;
    private int SPACE = 3;
    private int BUTTON_HEIGHT = 20;
    private KDComponentDialog findDialog;
    private KDButton findNextBtn;
    private KDButton closeBtn;
    private KDLabelContainer findNextLabel;
    private KDTextField findNextTxt;
    private String textToFound = "";
    private int foundIndex = -1;
    private int currentIndex = 0;
    private KDComponentDialog notFoundDialog;
    private KDComponentDialog finishSearchDialog;
    private boolean finishSearch = false;

    public TablePreferences() throws Exception {
        this.resHelper = new ResourceBundleHelper(RESNAME);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.remove((Component)this.kDButton2);
        this.helper = (AbstractTablePreferencesHelper)this.getUIContext().get("helper");
        this.moveUpRowButton.setEnabled(this.helper.isCanMoveColumn());
        this.moveDownRowButton.setEnabled(this.helper.isCanMoveColumn());
        this.currentTable = (KDTable)this.getUIContext().get("CurrentTable");
        if (this.getUIContext().get("owner") != null) {
            this.owner = (CoreUI)this.getUIContext().get("owner");
        }
        if (this.currentTable != null) {
            UserCustomConfigItemData data = this.helper.getColumnDataFromTable(this.currentTable, null);
            data = this.helper.getGenricDataFromTable(this.currentTable, data);
            this.fillGenericData(data);
            this.fillTableData(data, this.tableEdit);
            this.fillSumData(data);
            if (this.isColAllHidden()) {
                this.isHidden = true;
                this.isAllHidden.setText(EASResource.getString((String)commonTableRes, (String)"aLLDisplay"));
            }
        }
        this.applyColumnSetting();
        if (this.helper != null) {
            this.restoreButton.setEnabled(this.helper.isCanRestore());
            this.isAllHidden.setEnabled(this.helper.isCanSetHideColumn());
            this.isAlLFroze.setEnabled(this.helper.isCanSetFrozeColumn());
            this.moveUpRowButton.setEnabled(this.helper.isCanMoveColumn());
            this.moveDownRowButton.setEnabled(this.helper.isCanMoveColumn());
            this.moveUpToTopButton.setEnabled(this.helper.isCanMoveColumn());
            this.moveDownToBottomButton.setEnabled(this.helper.isCanMoveColumn());
            this.findButton.setEnabled(this.helper.isCanFind());
        }
        this.applyGeneralSetting();
        this.kDButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePreferences.this.applyConfigFromUI(TablePreferences.this.currentTable);
                if (TablePreferences.this.owner != null && TablePreferences.this.owner instanceof ListUI) {
                    try {
                        StringWriter writer = null;
                        writer = new StringWriter();
                        try {
                            UserXMLHelper.saveData(TablePreferences.this.helper.getUserDataFromUI(), (Writer)writer);
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle((Throwable)e1);
                        }
                        Map solutions = TableXMLHelper.loadPreferenceData((String)writer.toString()).getSolutions();
                        String tableFullName = TablePreferences.this.owner.getClass().getName() + "." + ((ListUI)TablePreferences.this.owner).getMainTable().getName();
                        com.kingdee.eas.base.commonquery.UserCustomConfigItemData commonqueryData = (com.kingdee.eas.base.commonquery.UserCustomConfigItemData)solutions.get(tableFullName);
                        KDTable tblMain = ((ListUI)TablePreferences.this.owner).getTableForBOTP();
                        if (tblMain != null && tblMain.getDataRequestManager().getDataRequestMode() == 1) {
                            ((ListUI)TablePreferences.this.owner).refreshList4TablePreference(commonqueryData);
                        }
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
                TablePreferences.this.destroyWindow();
            }
        });
        this.kDButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePreferences.this.destroyWindow();
            }
        });
        this.tableEdit.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
            }

            public void editStarting(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                if (colIndex != 6) {
                    return;
                }
                if (rowIndex == 0) {
                    return;
                }
                Object objIsChecked = e.getValue();
                boolean isCheck = false;
                if (objIsChecked instanceof Boolean) {
                    isCheck = (Boolean)objIsChecked;
                }
                TablePreferences.this.setFrozenColumn(rowIndex, isCheck);
                for (int i = rowIndex + 1; i < 0; --i) {
                    if (!TablePreferences.this.hiddenColumns.containsKey(String.valueOf(i))) continue;
                    Object[] objs = (Object[])TablePreferences.this.hiddenColumns.get(String.valueOf(i));
                    objs[6] = isCheck;
                    TablePreferences.this.hiddenColumns.put(String.valueOf(i), objs);
                }
                if (!isCheck) {
                    MsgBox.showInfo((String)TablePreferences.this.resHelper.getString("FrozenInfo"));
                }
            }
        });
        if (this.helper.isSimpleModel()) {
            this.tableEdit.getColumn(3).getStyleAttributes().setHided(true);
            this.tableEdit.getColumn(5).getStyleAttributes().setHided(true);
        }
        if (zh_en.equals(SysContext.getSysContext().getLocale())) {
            this.kDLabel1.setBounds(new Rectangle(308, 32, 150, 19));
            this.kDLabel2.setBounds(new Rectangle(308, 112, 150, 19));
            this.KDLabHeadHeight.setBounds(new Rectangle(16, 33, 159, 19));
            this.kDLabHeadFont.setBounds(new Rectangle(16, 72, 159, 19));
            this.KDLabBodyHeight.setBounds(new Rectangle(16, 111, 159, 19));
            this.KDLabBodyFont.setBounds(new Rectangle(16, 149, 159, 19));
            this.kDNumHeadHeight.setBounds(new Rectangle(193, 33, 102, 19));
            this.kDComHeadFont.setBounds(new Rectangle(193, 72, 102, 19));
            this.kDNumBodyHeight.setBounds(new Rectangle(193, 111, 102, 19));
            this.kDComBodyFont.setBounds(new Rectangle(193, 149, 102, 19));
        }
    }

    private boolean isColAllHidden() {
        int size = this.tableEdit.getRowCount();
        boolean allHidden = true;
        for (int i = 0; i < size; ++i) {
            IRow row = this.tableEdit.getRow(i);
            if (row.getCell(5).getValue() != Boolean.FALSE) continue;
            allHidden = false;
            break;
        }
        return allHidden;
    }

    private void setFrozenColumn(int rowIndex, boolean isCheck) {
        int rowCount = this.tableEdit.getRowCount();
        int start = 0;
        int stop = 0;
        if (!isCheck) {
            int i;
            start = 0;
            stop = rowIndex;
            for (i = 0; i < rowCount; ++i) {
                this.tableEdit.getRow(i).getCell(6).setValue((Object)false);
            }
            for (i = start; i < stop; ++i) {
                this.tableEdit.getRow(i).getCell(6).setValue((Object)true);
            }
        } else {
            start = rowIndex;
            stop = rowCount;
            for (int i = start; i < stop; ++i) {
                this.tableEdit.getRow(i).getCell(6).setValue((Object)false);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDPanel2.add((Component)this.getButtonPanel(), null);
        this.kDPanel2.add((Component)this.getTableEdit(), null);
        this.kDTabbedPane1.removeAll();
        this.kDTabbedPane1.add((Component)this.kDPanel2, (Object)this.resHelper.getString("General"));
        this.kDTabbedPane1.add((Component)this.kDPanel1, (Object)this.resHelper.getString("Others"));
        this.kDTabbedPane1.add((Component)this.kDPanel5, (Object)this.resHelper.getString("kDPanel3.constraints"));
        this.kDTabbedPane1.setComponentAt(0, (Component)this.kDPanel2);
        this.kDTabbedPane1.setComponentAt(1, (Component)this.kDPanel1);
        this.initKdTableSum();
        this.kDTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TablePreferences.this.kDTabbedPane1.getSelectedIndex() == 2) {
                    TablePreferences.this.tableEdit.getEditManager().stopEditing();
                    TablePreferences.this.fillSumData(null);
                }
            }
        });
    }

    private void applyGeneralSetting() {
    }

    private KDTable getTableEdit() {
        if (this.tableEdit == null) {
            this.tableEdit = new KDTable();
            this.tableEdit.getSelectManager().setSelectMode(2);
            this.initTable(this.tableEdit);
        }
        this.tableEdit.setBounds(new Rectangle(11, 28, 453, 300));
        return this.tableEdit;
    }

    private KDPanel getButtonPanel() {
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        KDPanel panel1 = new KDPanel();
        GridBagLayout bagLayOut = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.insets.right = 1;
        panel1.setLayout((LayoutManager)bagLayOut);
        this.restoreButton = new KDWorkButton();
        this.restoreButton.setName("kDButton2");
        this.restoreButton.setText(((AbstractTablePreferences)this).resHelper.getString("kDButton2.text"));
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserCustomConfigItemData data = TablePreferences.this.helper.getDefaultUserData(TablePreferences.this.currentTable);
                TablePreferences.this.fillGenericData(data);
                TablePreferences.this.fillTableData(data, TablePreferences.this.tableEdit);
                TablePreferences.this.fillSumData(data);
            }
        });
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        bagLayOut.setConstraints((Component)this.restoreButton, gbc);
        panel1.add((Component)this.restoreButton);
        this.isAllHidden = new KDWorkButton();
        this.isAllHidden.setText(EASResource.getString((String)commonTableRes, (String)"allHideen"));
        this.isAllHidden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePreferences.this.isAllHidden_actionPerformed(e);
            }
        });
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        bagLayOut.setConstraints((Component)this.isAllHidden, gbc);
        panel1.add((Component)this.isAllHidden);
        this.isAlLFroze = new KDWorkButton();
        this.isAlLFroze.setText(EASResource.getString((String)commonTableRes, (String)"allFroze"));
        this.isAlLFroze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePreferences.this.isAlLFroze_actionPerformed(e);
            }
        });
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        bagLayOut.setConstraints((Component)this.isAlLFroze, gbc);
        panel1.add((Component)this.isAlLFroze);
        this.moveUpRowButton = new KDWorkButton();
        this.moveUpRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.moveUpRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePreferences.this.moveUpRowButton_actionPerformed(e);
            }
        });
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.ipady = 1;
        bagLayOut.setConstraints((Component)this.moveUpRowButton, gbc);
        panel1.add((Component)this.moveUpRowButton);
        this.moveDownRowButton = new KDWorkButton();
        this.moveDownRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.moveDownRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePreferences.this.moveDownRowButton_actionPerformed(e);
            }
        });
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        bagLayOut.setConstraints((Component)this.moveDownRowButton, gbc);
        panel1.add((Component)this.moveDownRowButton);
        this.moveUpToTopButton = new KDWorkButton();
        this.moveUpToTopButton.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.moveUpToTopButton.setToolTipText(EASResource.getString((String)commonTableRes, (String)"moveUpToTop"));
        this.moveUpToTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePreferences.this.moveUpToTopButton_actionPerformed(e);
            }
        });
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.ipady = 1;
        bagLayOut.setConstraints((Component)this.moveUpToTopButton, gbc);
        panel1.add((Component)this.moveUpToTopButton);
        this.moveDownToBottomButton = new KDWorkButton();
        this.moveDownToBottomButton.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.moveDownToBottomButton.setToolTipText(EASResource.getString((String)commonTableRes, (String)"moveDownToBottom"));
        this.moveDownToBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePreferences.this.moveDownToBottomButton_actionPerformed(e);
            }
        });
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.ipady = 1;
        bagLayOut.setConstraints((Component)this.moveDownToBottomButton, gbc);
        panel1.add((Component)this.moveDownToBottomButton);
        this.findButton = new KDWorkButton();
        this.findButton.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.findButton.setToolTipText(EASResource.getString((String)commonTableRes, (String)"find"));
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePreferences.this.findRowButton_actionPerformed(e);
            }
        });
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.ipady = 1;
        bagLayOut.setConstraints((Component)this.findButton, gbc);
        panel1.add((Component)this.findButton);
        panel.add((Component)panel1, (Object)"East");
        this.buttonPanel = panel;
        if (zh_en.equals(SysContext.getSysContext().getLocale())) {
            this.buttonPanel.setBounds(new Rectangle(50, 5, 400, 23));
        } else {
            this.buttonPanel.setBounds(new Rectangle(125, 5, 340, 23));
        }
        return panel;
    }

    private void initTable(KDTable table) {
        KDTableHelper.releaseEnterAndTab((JComponent)table);
        String[] headTitles = new String[]{COLUMNKEY, this.resHelper.getString(COLUMNNAME), this.resHelper.getString(COLUMNWIDTH), this.resHelper.getString(COLUMNALIGN), this.resHelper.getString(COLUMNSORTED), this.resHelper.getString(COLUMNVISIBLE), this.resHelper.getString(COLUMNFROZEN), "index"};
        String[] columnKeys = new String[]{COLUMNKEY, COLUMNNAME, COLUMNWIDTH, COLUMNALIGN, COLUMNSORTED, COLUMNVISIBLE, COLUMNFROZEN, COLUMNINDEX};
        int[] columnWidth = new int[]{100, 120, 50, 60, 60, 60, 50, 0};
        for (int i = 0; i < 8; ++i) {
            IColumn column = table.addColumn();
            column.setWidth(columnWidth[i]);
            column.setKey(columnKeys[i]);
            if (i == 0 || i == 4 || i == 7) {
                column.getStyleAttributes().setHided(true);
            }
            if (i == 1) {
                column.getStyleAttributes().setLocked(true);
                column.getStyleAttributes().setBackground(new Color(217, 217, 208));
            }
            if (i == 2) {
                KDFormattedTextField tableWidth = new KDFormattedTextField(0);
                tableWidth.setMinimumValue((Comparable)new Integer(1));
                tableWidth.setMaximumValue((Comparable)new Integer(1000));
                tableWidth.setDataVerifierType(-1);
                KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)tableWidth);
                column.setEditor((ICellEditor)cellEditor);
            }
            if (i != 3) continue;
            Vector<String> values = new Vector<String>();
            values.addElement(this.resHelper.getString("left"));
            values.addElement(this.resHelper.getString("center"));
            values.addElement(this.resHelper.getString("right"));
            JComboBox c = new JComboBox(values);
            KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(c);
            column.setEditor((ICellEditor)cellEditor);
        }
        IRow row = null;
        row = table.addHeadRow();
        for (int i = 0; i < 8; ++i) {
            row.getCell(i).setValue((Object)headTitles[i]);
        }
        table.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        table.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
    }

    private void applyColumnSetting() {
        IColumn column = this.tableEdit.getColumn(COLUMNVISIBLE);
        if (column != null && !this.helper.isCanSetHideColumn()) {
            column.getStyleAttributes().setLocked(true);
            column.getStyleAttributes().setBackground(new Color(217, 217, 208));
        }
        if ((column = this.tableEdit.getColumn(COLUMNFROZEN)) != null && !this.helper.isCanSetFrozeColumn()) {
            column.getStyleAttributes().setLocked(true);
            column.getStyleAttributes().setBackground(new Color(217, 217, 208));
        }
    }

    private void fillGenericData(UserCustomConfigItemData data) {
        String headHeight = (String)data.getGenericData().get("HeadHeight");
        String rowHeight = (String)data.getGenericData().get("RowHeight");
        String headFont = (String)data.getGenericData().get("HeadFontSize");
        FontSizeEnum headEnum = FontSizeEnum.getEnum(headFont);
        String rowFont = (String)data.getGenericData().get("RowFontSize");
        FontSizeEnum bodyEnum = FontSizeEnum.getEnum(rowFont);
        this.kDNumHeadHeight.setMaximumNumber((Number)new Integer(100));
        this.kDNumHeadHeight.setMinimumNumber((Number)new Integer(10));
        this.kDNumBodyHeight.setMaximumNumber((Number)new Integer(100));
        this.kDNumBodyHeight.setMinimumNumber((Number)new Integer(10));
        this.kDNumHeadHeight.setNumberValue((Number)new Integer(headHeight == null ? "20" : headHeight));
        this.kDNumBodyHeight.setNumberValue((Number)new Integer(rowHeight == null ? "20" : rowHeight));
        this.kDComHeadFont.setSelectedItem((Object)(headEnum == null ? FontSizeEnum.FontSize9 : headEnum));
        this.kDComBodyFont.setSelectedItem((Object)(bodyEnum == null ? FontSizeEnum.FontSize9 : bodyEnum));
    }

    private void fillTableData(UserCustomConfigItemData data, KDTable table) {
        table.removeRows();
        ArrayList<TableRowModel> rowsModel = new ArrayList<TableRowModel>();
        boolean hiddenIndex = false;
        for (String key : data.getColumnData().keySet()) {
            if (this.helper.getHideColumn().contains(key) || key.equalsIgnoreCase("id")) continue;
            ColumnItemData columnData = (ColumnItemData)data.getColumnData().get(key);
            TableRowModel rowModel = new TableRowModel();
            rowModel.key = key;
            rowModel.title = columnData.getTitle();
            if (columnData.isHidden()) {
                rowModel.width = String.valueOf(columnData.getWidth());
            } else {
                rowModel.width = String.valueOf(columnData.getWidth());
            }
            rowModel.align = this.resHelper.getString(columnData.getAlign().toString());
            rowModel.sorted = columnData.isSorted();
            rowModel.hidden = columnData.isHidden();
            rowModel.locked = columnData.isLocked();
            rowModel.index = new Integer(columnData.getIndex());
            rowsModel.add(rowModel);
        }
        TableRowModel[] _rowsArray = new TableRowModel[rowsModel.size()];
        rowsModel.toArray(_rowsArray);
        Arrays.sort(_rowsArray, new TableRowModelComparator());
        for (int i = 0; i < _rowsArray.length; ++i) {
            IRow row = table.addRow();
            this.setRowData(row, _rowsArray[i]);
        }
    }

    private UserCustomConfigItemData getItemDataByTB() {
        UserCustomConfigItemData itemData = new UserCustomConfigItemData();
        Object row = null;
        int rowCount = this.tableEdit.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ColumnItemData colData = this.toColumnItemData(this.getRowData(i));
            itemData.getColumnData().put(colData.getKey(), colData);
        }
        itemData.getColumnData().putAll(this.hiddenColumns);
        itemData.getGenericData().put("HeadHeight", this.kDNumHeadHeight.getNumberValue() != null ? this.kDNumHeadHeight.getNumberValue().toString() : "20");
        itemData.getGenericData().put("RowHeight", this.kDNumBodyHeight.getNumberValue() != null ? this.kDNumBodyHeight.getNumberValue().toString() : "20");
        itemData.getGenericData().put("HeadFontSize", this.kDComHeadFont.getSelectedItem().toString());
        itemData.getGenericData().put("RowFontSize", this.kDComBodyFont.getSelectedItem().toString());
        itemData.setTotalColumns(this.getRtFieldSumList());
        return itemData;
    }

    protected void isAllHidden_actionPerformed(ActionEvent e) {
        int size = this.tableEdit.getRowCount();
        if (!this.isHidden) {
            this.isAllHidden.setText(EASResource.getString((String)commonTableRes, (String)"aLLDisplay"));
            this.isHidden = true;
            for (int i = 0; i < size; ++i) {
                IRow row = this.tableEdit.getRow(i);
                if (row.getStyleAttributes().isLocked()) continue;
                Boolean flag = new Boolean(true);
                row.getCell(5).setValue((Object)flag);
            }
        } else {
            this.isAllHidden.setText(EASResource.getString((String)commonTableRes, (String)"allHideen"));
            this.isHidden = false;
            for (int i = 0; i < size; ++i) {
                IRow row = this.tableEdit.getRow(i);
                if (row.getStyleAttributes().isLocked()) continue;
                Boolean flag = new Boolean(false);
                row.getCell(5).setValue((Object)flag);
            }
        }
    }

    protected void isAlLFroze_actionPerformed(ActionEvent e) {
        int size = this.tableEdit.getRowCount();
        if (!this.isFroze) {
            this.isAlLFroze.setText(EASResource.getString((String)commonTableRes, (String)"allActive"));
            this.isFroze = true;
            for (int i = 0; i < size; ++i) {
                IRow row = this.tableEdit.getRow(i);
                if (row.getStyleAttributes().isLocked()) continue;
                Boolean flag = new Boolean(true);
                row.getCell(6).setValue((Object)flag);
            }
        } else {
            this.isAlLFroze.setText(EASResource.getString((String)commonTableRes, (String)"allFroze"));
            this.isFroze = false;
            for (int i = 0; i < size; ++i) {
                IRow row = this.tableEdit.getRow(i);
                if (row.getStyleAttributes().isLocked()) continue;
                Boolean flag = new Boolean(false);
                row.getCell(6).setValue((Object)flag);
            }
        }
    }

    private void moveUpToTopButton_actionPerformed(ActionEvent e) {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tableEdit);
        if (selectedRows.length == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)commonSorterRes, (String)"moveWarning"));
            return;
        }
        int selectedColIndex = this.tableEdit.getSelectManager().getActiveColumnIndex();
        for (int i = 0; i < selectedRows.length; ++i) {
            this.moveUpOneRowTo(selectedRows[i], i);
        }
        this.tableEdit.getSelectManager().select(0, selectedColIndex, selectedRows.length - 1, selectedColIndex);
    }

    private void moveUpOneRowTo(int fromRow, int toRow) {
        for (int i = 0; i < fromRow - toRow; ++i) {
            this.moveUpRow(fromRow - i);
        }
    }

    private void moveUpRow(int selectedRowIndex) {
        int selectedColIndex = this.tableEdit.getSelectManager().getActiveColumnIndex();
        TableRowModel modifyRowData = this.getRowData(selectedRowIndex - 1);
        TableRowModel currentRowData = this.getRowData(selectedRowIndex);
        Integer _tempIndex = modifyRowData.index;
        modifyRowData.index = currentRowData.index;
        currentRowData.index = _tempIndex;
        this.setRowData(this.tableEdit.getRow(selectedRowIndex - 1), currentRowData);
        this.setRowData(this.tableEdit.getRow(selectedRowIndex), modifyRowData);
        this.tableEdit.getColumn(1).getStyleAttributes().setLocked(true);
        this.tableEdit.getColumn(1).getStyleAttributes().setBackground(new Color(217, 217, 208));
    }

    protected void moveUpRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.tableEdit.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.tableEdit.getSelectManager().getActiveColumnIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonSorterRes, (String)"moveWarning"));
        } else {
            if (selectedRowIndex == 0) {
                return;
            }
            this.moveUpRow();
            this.tableEdit.getSelectManager().select(selectedRowIndex - 1, selectedColIndex);
        }
    }

    private void moveDownToBottomButton_actionPerformed(ActionEvent e) {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tableEdit);
        if (selectedRows.length == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)commonSorterRes, (String)"moveWarning"));
            return;
        }
        int selectedColIndex = this.tableEdit.getSelectManager().getActiveColumnIndex();
        for (int i = 0; i < selectedRows.length; ++i) {
            this.moveDownOneRowTo(selectedRows[selectedRows.length - i - 1], this.tableEdit.getRowCount() - i - 1);
        }
        this.tableEdit.getSelectManager().select(this.tableEdit.getRowCount() - selectedRows.length, selectedColIndex, this.tableEdit.getRowCount(), selectedColIndex);
    }

    private void moveDownOneRowTo(int fromRow, int toRow) {
        for (int i = 0; i < toRow - fromRow; ++i) {
            this.moveDownRow(fromRow + i);
        }
    }

    private void moveDownRow(int selectedRowIndex) {
        int selectedColIndex = this.tableEdit.getSelectManager().getActiveColumnIndex();
        TableRowModel modifyRowData = this.getRowData(selectedRowIndex + 1);
        TableRowModel currentRowData = this.getRowData(selectedRowIndex);
        Integer _tempIndex = modifyRowData.index;
        modifyRowData.index = currentRowData.index;
        currentRowData.index = _tempIndex;
        this.setRowData(this.tableEdit.getRow(selectedRowIndex + 1), currentRowData);
        this.setRowData(this.tableEdit.getRow(selectedRowIndex), modifyRowData);
        this.tableEdit.getColumn(1).getStyleAttributes().setLocked(true);
        this.tableEdit.getColumn(1).getStyleAttributes().setBackground(new Color(217, 217, 208));
        this.tableEdit.getSelectManager().select(selectedRowIndex + 1, selectedColIndex);
    }

    protected void moveDownRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.tableEdit.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonSorterRes, (String)"moveWarning"));
        } else {
            if (selectedRowIndex == this.tableEdit.getRowCount() - 1) {
                return;
            }
            this.moveDownRow();
        }
    }

    private void moveUpRow() {
        int selectedRowIndex = this.tableEdit.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.tableEdit.getSelectManager().getActiveColumnIndex();
        TableRowModel modifyRowData = this.getRowData(selectedRowIndex - 1);
        TableRowModel currentRowData = this.getRowData(selectedRowIndex);
        Integer _tempIndex = modifyRowData.index;
        modifyRowData.index = currentRowData.index;
        currentRowData.index = _tempIndex;
        this.setRowData(this.tableEdit.getRow(selectedRowIndex - 1), currentRowData);
        this.setRowData(this.tableEdit.getRow(selectedRowIndex), modifyRowData);
        this.tableEdit.getColumn(1).getStyleAttributes().setLocked(true);
        this.tableEdit.getColumn(1).getStyleAttributes().setBackground(new Color(217, 217, 208));
        this.tableEdit.getSelectManager().select(selectedRowIndex - 1, selectedColIndex);
    }

    private void moveDownRow() {
        int selectedRowIndex = this.tableEdit.getSelectManager().getActiveRowIndex();
        int selectedColIndex = this.tableEdit.getSelectManager().getActiveColumnIndex();
        TableRowModel modifyRowData = this.getRowData(selectedRowIndex + 1);
        TableRowModel currentRowData = this.getRowData(selectedRowIndex);
        Integer _tempIndex = modifyRowData.index;
        modifyRowData.index = currentRowData.index;
        currentRowData.index = _tempIndex;
        this.setRowData(this.tableEdit.getRow(selectedRowIndex + 1), currentRowData);
        this.setRowData(this.tableEdit.getRow(selectedRowIndex), modifyRowData);
        this.tableEdit.getColumn(1).getStyleAttributes().setLocked(true);
        this.tableEdit.getColumn(1).getStyleAttributes().setBackground(new Color(217, 217, 208));
        this.tableEdit.getSelectManager().select(selectedRowIndex + 1, selectedColIndex);
    }

    private TableRowModel getRowData(int rowIndex) {
        IRow row = this.tableEdit.getRow(rowIndex);
        TableRowModel rowData = new TableRowModel();
        rowData.key = (String)row.getCell(0).getValue();
        if (row.getCell(1).getValue() instanceof Icon) {
            Icon image = (Icon)row.getCell(1).getValue();
            rowData.title = image.toString();
        } else {
            rowData.title = (String)row.getCell(1).getValue();
        }
        if (row.getCell(2).getValue() == null) {
            rowData.width = "100";
        } else {
            rowData.width = row.getCell(2).getValue().toString();
        }
        rowData.align = (String)row.getCell(3).getValue();
        rowData.sorted = (Boolean)row.getCell(4).getValue();
        rowData.hidden = (Boolean)row.getCell(5).getValue();
        rowData.locked = (Boolean)row.getCell(6).getValue();
        rowData.index = (Integer)row.getCell(7).getValue();
        return rowData;
    }

    private ColumnItemData toColumnItemData(TableRowModel model) {
        ColumnItemData data = new ColumnItemData();
        data.setAlign(this.helper.getAlign(model.align));
        data.setHidden(model.hidden);
        data.setIndex(model.index);
        data.setKey(model.key);
        data.setLocked(model.locked);
        data.setSorted(model.sorted);
        data.setTitle(model.title);
        data.setWidth(Integer.parseInt(model.width));
        return data;
    }

    private void setRowData(IRow row, TableRowModel model) {
        row.getCell(0).setValue((Object)model.key);
        if ("attacheMentId".equals(model.key) || ("ENTRY".toLowerCase() + "." + "attacheMentId").equals(model.key) || "entrys.attacheMentId".equals(model.key)) {
            Icon image = EASResource.getIcon((String)"imgBill_icon_4");
            row.getCell(1).setValue((Object)image);
        } else {
            row.getCell(1).setValue((Object)model.title);
        }
        row.getCell(2).setValue((Object)model.width);
        row.getCell(3).setValue((Object)model.align);
        row.getCell(4).setValue((Object)model.sorted);
        row.getCell(5).setValue((Object)model.hidden);
        row.getCell(6).setValue((Object)model.locked);
        row.getCell(7).setValue((Object)model.index);
        row.getStyleAttributes().setHided(model.rowHided);
        row.getStyleAttributes().setLocked(model.rowLocked);
    }

    protected void applyConfigFromUI(KDTable tb) {
        this.helper.applyConfigFromData(tb, this.getItemDataByTB(), true);
        tb.reLayoutAndPaint();
    }

    protected void findRowButton_actionPerformed(ActionEvent e) {
        this.showFindNextDialog();
    }

    private void showFindNextDialog() {
        if (this.tableEdit == null || this.tableEdit.getRowCount() == 0) {
            return;
        }
        if (this.findDialog == null) {
            Window w = SwingUtilities.windowForComponent((Component)((Object)this));
            this.findDialog = w instanceof Dialog ? new KDComponentDialog((Dialog)w) : (w instanceof Frame ? new KDComponentDialog((Frame)w) : new KDComponentDialog());
            this.setFindDialogModal();
            this.findDialog.setLFStyle(2);
            this.findDialog.setTitle(EASResource.getString((String)commonTableRes, (String)"findProperty"));
            this.findNextBtn = new KDButton(EASResource.getString((String)commonTableRes, (String)"findNext"));
            this.findNextBtn.setLimitedSize(false);
            this.findNextBtn.setFocusable(false);
            this.closeBtn = new KDButton(EASResource.getString((String)commonTableRes, (String)"close"));
            this.closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TablePreferences.this.findDialog.dispose();
                }
            });
            this.findDialog.addButton(this.closeBtn);
            this.findDialog.addButton(this.findNextBtn);
            this.findNextLabel = new KDLabelContainer();
            this.findNextTxt = new KDTextField();
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.findNextTxt, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
            this.findNextLabel.setBoundLabelText(EASResource.getString((String)commonTableRes, (String)"findInput"));
            this.findNextLabel.setBoundEditor((JComponent)this.findNextTxt);
            this.findNextLabel.setPreferredSize(new Dimension(270, 21));
            this.findNextLabel.setBoundLabelUnderline(true);
            this.findDialog.setDialogComponent((Component)this.findNextLabel);
            this.findDialog.setSize(290, 118);
            this.findDialog.setResizable(false);
            this.findNextBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TablePreferences.this.findRow();
                }
            });
        }
        this.findDialog.getRootPane().setDefaultButton((JButton)this.findNextBtn);
        this.findDialog.setLocation(this.findButton.getLocationOnScreen());
        this.findDialog.show();
    }

    private void setFindDialogModal() {
        if (JVM.current().isOverOneDotFive() && this.findDialog != null) {
            this.findDialog.setModal(true);
        }
    }

    private void findRow() {
        String input = this.findNextTxt.getText().toLowerCase().trim();
        if (input != null && input.trim().length() > 0) {
            KDButton ok;
            if (!this.textToFound.equalsIgnoreCase(input)) {
                this.finishSearch = false;
                this.textToFound = input;
                this.foundIndex = -1;
                this.currentIndex = 0;
            }
            this.currentIndex = this.foundIndex + 1;
            if (this.tableEdit != null && this.tableEdit.getRowCount() > 0) {
                int i;
                for (i = this.currentIndex; i < this.tableEdit.getRowCount(); ++i) {
                    String propertyAlias;
                    if (this.tableEdit.getRow(i).getCell(1) == null || this.tableEdit.getRow(i).getCell(1).getValue() == null || (propertyAlias = this.tableEdit.getRow(i).getCell(1).getValue().toString()).toLowerCase().indexOf(this.textToFound) < 0) continue;
                    this.foundIndex = i;
                    this.tableEdit.getEditManager().editCellAt(i, 0);
                    break;
                }
                if (i == this.tableEdit.getRowCount()) {
                    this.finishSearch = true;
                }
            }
            if (this.foundIndex == -1) {
                if (this.notFoundDialog == null) {
                    this.notFoundDialog = new KDComponentDialog((Dialog)this.findDialog);
                    this.notFoundDialog.setLFStyle(2);
                    this.notFoundDialog.setTitle(EASResource.getString((String)commonTableRes, (String)"confirmMsg"));
                    ok = new KDButton(EASResource.getString((String)commonTableRes, (String)"confirm"));
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TablePreferences.this.notFoundDialog.dispose();
                        }
                    });
                    KDLabel notFoundLbl = new KDLabel(EASResource.getString((String)commonTableRes, (String)"nosuchresult"));
                    notFoundLbl.setHorizontalAlignment(0);
                    notFoundLbl.setPreferredSize(new Dimension(290, 21));
                    this.notFoundDialog.addButton(ok);
                    this.notFoundDialog.setDialogComponent((Component)notFoundLbl);
                }
                this.notFoundDialog.setLocation(this.findDialog.getLocation());
                this.notFoundDialog.setSize(290, 118);
                this.notFoundDialog.setModal(true);
                this.notFoundDialog.show();
            } else if (this.finishSearch) {
                this.textToFound = "";
                if (this.finishSearchDialog == null) {
                    this.finishSearchDialog = new KDComponentDialog((Dialog)this.findDialog);
                    this.finishSearchDialog.setLFStyle(2);
                    this.finishSearchDialog.setTitle(EASResource.getString((String)commonTableRes, (String)"confirmMsg"));
                    ok = new KDButton(EASResource.getString((String)commonTableRes, (String)"confirm"));
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TablePreferences.this.finishSearchDialog.dispose();
                        }
                    });
                    KDLabel notFoundLbl = new KDLabel(EASResource.getString((String)commonTableRes, (String)"finished"));
                    notFoundLbl.setHorizontalAlignment(0);
                    notFoundLbl.setPreferredSize(new Dimension(290, 21));
                    this.finishSearchDialog.addButton(ok);
                    this.finishSearchDialog.setDialogComponent((Component)notFoundLbl);
                }
                this.finishSearchDialog.setLocation(this.findDialog.getLocation());
                this.finishSearchDialog.setSize(290, 118);
                this.finishSearchDialog.setModal(true);
                this.finishSearchDialog.show();
            }
        }
    }

    public void initKdTableSum() {
        this.kDTableSum.setBounds(new Rectangle(5, 2, 470, 330));
        this.kDTableSum.checkParsed();
        this.kDTableSum.getSelectManager().setSelectMode(2);
        KDTSortManager sm1 = new KDTSortManager(this.kDTableSum);
        sm1.setSortAuto(true);
        this.kDTableSum.getColumn("fieldName").setWidth(225);
        this.kDTableSum.getColumn("isSum").setWidth(117);
        this.kDTableSum.getColumn("fieldName").getStyleAttributes().setLocked(true);
        this.kDTableSum.getColumn("isSum").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
    }

    public void fillSumData(UserCustomConfigItemData data) {
        Map fieldKeyMap = new HashMap();
        HashMap<String, String> keyFieldMap = new HashMap<String, String>();
        Map<Object, Object> fieldNameMap = new HashMap();
        if (this.owner != null) {
            if (this.owner instanceof ListUI) {
                fieldKeyMap = (Map)((ListUI)this.owner).getUIContext().get("innerFieldKeyMap");
                for (Map.Entry entry : fieldKeyMap.entrySet()) {
                    keyFieldMap.put((String)entry.getValue(), (String)entry.getKey());
                }
                fieldNameMap = (Map)((ListUI)this.owner).getUIContext().get("innerFieldNameMap");
                this.allFieldSumList = (List)((ListUI)this.owner).getUIContext().get("innerFieldSumList");
            } else if (this.owner instanceof EditUI) {
                this.allFieldSumList = ((EditUI)this.owner).getEditUIAllSumList(this.currentTable);
                fieldNameMap = ((EditUI)this.owner).getEditUIFieldNameMap(this.currentTable);
            }
        }
        if (this.kDTableSum.getRowCount() != 0) {
            this.fieldSumList = new ArrayList<String>();
            for (int i = 0; i < this.kDTableSum.getRowCount(); ++i) {
                if (!((Boolean)this.kDTableSum.getCell(i, "isSum").getValue()).booleanValue()) continue;
                if (this.owner instanceof ListUI) {
                    this.fieldSumList.add((String)keyFieldMap.get(this.kDTableSum.getCell(i, "field").getValue()));
                    continue;
                }
                this.fieldSumList.add((String)this.kDTableSum.getCell(i, "field").getValue());
            }
            this.kDTableSum.removeRows();
        }
        if (data != null) {
            if (data.getTotalColumns() != null) {
                if (this.owner instanceof ListUI) {
                    this.fieldSumList = new ArrayList<String>();
                    for (int i = 0; i < data.getTotalColumns().size(); ++i) {
                        if (!keyFieldMap.containsKey(data.getTotalColumns().get(i))) continue;
                        this.fieldSumList.add((String)keyFieldMap.get(data.getTotalColumns().get(i)));
                    }
                } else {
                    this.fieldSumList = data.getTotalColumns();
                }
            } else {
                this.fieldSumList = null;
            }
        }
        if (this.allFieldSumList == null) {
            return;
        }
        if (this.fieldSumList == null) {
            this.fieldSumList = new ArrayList<String>();
            this.fieldSumList.addAll(this.allFieldSumList);
        }
        if (this.owner instanceof ListUI) {
            ((ListUI)this.owner).setCurrentListUISumList(this.fieldSumList);
        } else {
            ((EditUI)this.owner).setCurrentEditUISumList(this.currentTable, this.fieldSumList);
        }
        if (this.allFieldSumList != null) {
            for (int i = 0; i < this.tableEdit.getRowCount(); ++i) {
                String fieldKey;
                String field = fieldKey = (String)this.tableEdit.getCell(i, 0).getValue();
                if (this.owner instanceof ListUI) {
                    if (!keyFieldMap.containsKey(fieldKey)) continue;
                    field = (String)keyFieldMap.get(fieldKey);
                }
                if (!this.allFieldSumList.contains(field) || ((Boolean)this.tableEdit.getCell(i, 5).getValue()).booleanValue()) continue;
                IRow row = this.kDTableSum.addRow();
                row.getCell("field").setValue((Object)fieldKey);
                row.getCell("fieldName").setValue(fieldNameMap.get(field));
                if (this.fieldSumList != null && this.fieldSumList.contains(field)) {
                    row.getCell("isSum").setValue((Object)true);
                    continue;
                }
                row.getCell("isSum").setValue((Object)false);
            }
        }
    }

    public List<String> getRtFieldSumList() {
        ArrayList<String> rtSum = new ArrayList<String>();
        for (int i = 0; i < this.kDTableSum.getRowCount(); ++i) {
            IRow row = this.kDTableSum.getRow(i);
            if (!Boolean.parseBoolean(row.getCell("isSum").getValue().toString())) continue;
            rtSum.add((String)row.getCell("field").getValue());
        }
        return rtSum;
    }

    protected ArrayList getHiddenRowsInTable() {
        ArrayList<ColumnItemData> alHiddenRows = new ArrayList<ColumnItemData>();
        Map columnDatas = this.getItemDataByTB().getColumnData();
        Iterator itr = columnDatas.keySet().iterator();
        while (itr.hasNext()) {
            String key = itr.next().toString();
            ColumnItemData columnData = (ColumnItemData)columnDatas.get(key);
            if (!columnData.isHidden()) continue;
            alHiddenRows.add(columnData);
        }
        return alHiddenRows;
    }

    private class TableRowModelComparator
    implements Comparator {
        private TableRowModelComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((TableRowModel)o1).index.compareTo(((TableRowModel)o2).index);
        }
    }

    private class TableRowModel {
        private String key;
        private String title;
        private String width;
        private String align;
        private Boolean sorted;
        private Boolean hidden;
        private Boolean locked;
        private Integer index;
        private boolean rowHided;
        private boolean rowLocked;

        private TableRowModel() {
        }
    }
}

