/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config.client;

import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.client.AbstractToolBarCustomerConfigUI;
import com.kingdee.eas.framework.config.client.CustomToolBar;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ToolBarCustomerConfigUI
extends AbstractToolBarCustomerConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(ToolBarCustomerConfigUI.class);
    private CustomToolBar customToolBar = null;
    private Component[] allow_btns = null;
    Component[] btns = null;

    public void onLoad() throws Exception {
        this.initComponents();
    }

    private void initComponents() throws Exception {
        CoreUI ui = (CoreUI)this.getUIContext().get("Owner");
        this.customToolBar = this.getUIContext().get("CusttomToolBar") != null ? (CustomToolBar)this.getUIContext().get("CusttomToolBar") : new CustomToolBar(ui);
        this.allow_btns = this.getUIContext().get("AllowCusttomBtns") != null ? (Component[])this.getUIContext().get("AllowCusttomBtns") : null;
        this.kdList_Default.setAutoscrolls(true);
        this.kdList_Default.setVisibleRowCount(20);
        this.kdList_Default.removeAllElements();
        this.kdList_Custom.setAutoscrolls(true);
        this.kdList_Custom.removeAllElements();
        KDToolBar toolbars = ui.getUIToolBar();
        this.btns = toolbars.getComponents();
        this.initKDList(this.kdList_Custom, this.btns, true);
        this.initKDList(this.kdList_Default, this.btns, false);
        this.initAllowInHideBtns(this.customToolBar.getHideBtns(), this.allow_btns);
        this.removeDefaultVisibleKDList(this.kdList_Default, this.customToolBar.getHideBtns());
    }

    private void restoreKDList(Component[] allow_btns) {
        int i;
        if (this.btns != null) {
            for (i = 0; i < this.btns.length; ++i) {
                if (!(this.btns[i] instanceof KDWorkButton)) continue;
                ((KDWorkButton)this.btns[i]).setVisible(true);
                for (int j = 0; j < this.customToolBar.getHideBtns().length; ++j) {
                    String hideName;
                    if (this.customToolBar.getHideBtns()[j] == null || (hideName = ((KDWorkButton)this.customToolBar.getHideBtns()[j]).getName()) == null || !hideName.equalsIgnoreCase(((KDWorkButton)this.btns[i]).getName())) continue;
                    ((KDWorkButton)this.btns[i]).setVisible(false);
                }
            }
        }
        if (allow_btns != null) {
            for (i = 0; i < allow_btns.length; ++i) {
                if (!(allow_btns[i] instanceof KDWorkButton)) continue;
                ((KDWorkButton)allow_btns[i]).setVisible(false);
            }
        }
        this.kdList_Custom.removeAllElements();
        this.kdList_Default.removeAllElements();
        this.initKDList(this.kdList_Custom, this.btns, true);
        this.initKDList(this.kdList_Default, this.btns, false);
        this.removeDefaultVisibleKDList(this.kdList_Default, this.customToolBar.getHideBtns());
    }

    private void initAllowInHideBtns(Component[] hidebtns, Component[] allowbtns) {
        int count = 0;
        for (int allow = 0; allow < (allowbtns != null ? allowbtns.length : 0); ++allow) {
            String allowText = ((KDWorkButton)allowbtns[allow]).getText();
            if (allowText == null || "".equals(allowText)) {
                allowText = ((KDWorkButton)allowbtns[allow]).getToolTipText();
            }
            for (int i = 0; i < (hidebtns != null ? hidebtns.length : 0); ++i) {
                if (!(hidebtns[i] instanceof KDWorkButton)) continue;
                String hideText = ((KDWorkButton)hidebtns[i]).getText();
                if (hideText == null || "".equals(hideText)) {
                    hideText = ((KDWorkButton)hidebtns[i]).getToolTipText();
                }
                if (!allowText.equalsIgnoreCase(hideText)) continue;
                hidebtns[i] = null;
                ++count;
            }
        }
    }

    private void removeDefaultVisibleKDList(KDList list, Component[] btns) {
        for (int i = list.getElementCount() - 1; i > -1; --i) {
            String text = list.getElement(i).toString();
            for (int j = 0; j < btns.length; ++j) {
                if (btns[j] == null) continue;
                String hideText = ((KDWorkButton)btns[j]).getText();
                if (hideText == null || hideText == "") {
                    hideText = ((KDWorkButton)btns[j]).getToolTipText();
                }
                if (!text.equalsIgnoreCase(hideText)) continue;
                list.removeElementAt(i);
            }
        }
    }

    private void initKDList(KDList list, Component[] btns, boolean isShow) {
        for (int j = 0; j < btns.length; ++j) {
            Icon icon = null;
            String text = null;
            if (!(btns[j] instanceof KDWorkButton) || btns[j].isVisible() != isShow) continue;
            icon = ((KDWorkButton)btns[j]).getIcon();
            text = ((KDWorkButton)btns[j]).getText();
            if (text == null || text == "") {
                text = ((KDWorkButton)btns[j]).getToolTipText();
            }
            list.addElement((Object)text);
            list.setElementIcon(icon, (Object)text);
            btns[j].setVisible(isShow);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAddCustomBtn_actionPerformed(ActionEvent e) throws Exception {
        this.exchangeSelectButton(this.kdList_Default, this.kdList_Custom, true);
        super.actionAddCustomBtn_actionPerformed(e);
    }

    @Override
    public void actionRemoveCustomBtn_actionPerformed(ActionEvent e) throws Exception {
        this.exchangeSelectButton(this.kdList_Custom, this.kdList_Default, false);
        super.actionRemoveCustomBtn_actionPerformed(e);
    }

    private void exchangeSelectButton(KDList source, KDList target, boolean isTargetCustom) {
        if (source.isSelectionEmpty()) {
            return;
        }
        Icon icon = null;
        String text = null;
        int[] selectCounts = source.getSelectedIndices();
        for (int i = 0; i < selectCounts.length; ++i) {
            text = source.getElement(selectCounts[i]).toString();
            icon = source.getElementIcon(selectCounts[i]);
            int targetSelectindex = target.getSelectedIndex();
            if (targetSelectindex >= 0) {
                target.insertElement((Object)text, targetSelectindex);
            } else {
                target.addElement((Object)text);
            }
            target.setElementIcon(icon, (Object)text);
        }
        for (int j = selectCounts.length - 1; j >= 0; --j) {
            source.removeElementAt(selectCounts[j]);
        }
    }

    private void saveToolBarStatus() {
        for (int j = 0; j < this.btns.length; ++j) {
            String text = null;
            if (!(this.btns[j] instanceof KDWorkButton)) continue;
            this.btns[j].setVisible(false);
            text = ((KDWorkButton)this.btns[j]).getText();
            if (text == null || text == "") {
                text = ((KDWorkButton)this.btns[j]).getToolTipText();
            }
            int count = this.kdList_Custom.getElementCount();
            for (int i = 0; i < count; ++i) {
                if (text != this.kdList_Custom.getElement(i)) continue;
                this.btns[j].setVisible(true);
            }
        }
    }

    @Override
    public void actionCustomConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.saveToolBarStatus();
        this.customToolBar.saveCustomToolBar();
        super.actionCustomConfirm_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionCustomDefault_actionPerformed(ActionEvent e) throws Exception {
        this.restoreKDList(this.allow_btns);
        super.actionCustomDefault_actionPerformed(e);
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.framework.config.Preferences.CustomToolBar");
    }
}

