/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.configuration.client;

import com.kingdee.eas.framework.configuration.ConfigurationAdapt;
import com.kingdee.eas.framework.configuration.IConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.log4j.Logger;

public class ClientConfiguationManager {
    private static Logger logger = Logger.getLogger(ClientConfiguationManager.class);
    private static HashMap config_items = new HashMap();
    private static ArrayList paths = new ArrayList();

    public static IConfiguration getConfiguation(String config_name) {
        if (config_items.containsKey(config_name)) {
            return (IConfiguration)config_items.get(config_name);
        }
        IConfiguration config = ClientConfiguationManager.getConfiguation(ClientConfiguationManager.getConfigPath(), config_name);
        config_items.put(config_name, config);
        return config;
    }

    protected static String getRuntimeConfigPath() {
        StringBuffer path = new StringBuffer();
        String user_dir = System.getProperty("user.dir");
        if (user_dir == null) {
            user_dir = "w:/eas";
        }
        path.append(user_dir);
        path.append(File.separator).append("config");
        return path.toString();
    }

    protected static String getConfigPath() {
        StringBuffer path = new StringBuffer();
        String sub_path = "config";
        if (System.getProperty("easclient.root") != null) {
            path.append(System.getProperty("easclient.root").toString());
        } else {
            path.append("w:/eas/deploy/client");
        }
        path.append(File.separator);
        path.append(sub_path);
        return path.toString();
    }

    private static synchronized IConfiguration getConfiguation(String path_name, String config_name) {
        ConfigurationFactory factory = new ConfigurationFactory();
        CompositeConfiguration config = new CompositeConfiguration();
        String file_name = "";
        for (int i = 0; i < paths.size(); ++i) {
            String real_path = path_name;
            if (paths.get(i).toString().equals("runtime")) {
                real_path = ClientConfiguationManager.getRuntimeConfigPath();
            }
            if (!new File(file_name = real_path + File.separator + paths.get(i) + File.separator + config_name + File.separator + config_name + ".xml").exists()) continue;
            factory.setConfigurationFileName(file_name);
            try {
                config.addConfiguration(factory.getConfiguration());
                continue;
            }
            catch (ConfigurationException e) {
                logger.error((Object)("fail when load config " + file_name));
                logger.error((Object)e.getCause());
            }
        }
        return new ConfigurationAdapt((Configuration)config);
    }

    static {
        paths.add("runtime");
        paths.add("cust");
        paths.add("dev");
        paths.add("system");
    }
}

