/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.expression;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RegularSizePosition {
    public static final int SIDE_LEFT = 0;
    public static final int SIDE_RIGHT = 1;
    private List fieldsRow = new ArrayList();
    private List containersRow = new ArrayList();
    private List containersList = new ArrayList();
    private Component[] components;

    public static void main(String[] args) {
    }

    public void regular(Container container) {
        if (container != null && this.isContainer(container)) {
            if (!this.isKDLayout(container)) {
                return;
            }
            Component[] cs = this.getChilds(container);
            if (cs == null || cs.length == 0) {
                return;
            }
            this.components = cs;
            for (Component c : cs) {
                if (!c.isVisible()) continue;
                if (this.isRegularAsField(c)) {
                    this.addRow(c, this.fieldsRow);
                    continue;
                }
                this.addRow(c, this.containersRow);
                if (!(c instanceof Container)) continue;
                this.containersList.add(c);
            }
            this.SortRowElements(this.fieldsRow);
            this.SortRowElements(this.containersRow);
            Collections.sort(this.fieldsRow, new RowComparator());
            Collections.sort(this.containersRow, new RowComparator());
            this.regularField();
            this.regularContainer();
            for (Container con : this.containersList) {
                RegularSizePosition rsp = new RegularSizePosition();
                rsp.regular(con);
            }
        }
    }

    private void regularField() {
        int rows = this.fieldsRow.size();
        int pos = 0;
        for (int j = 0; j < rows; ++j) {
            Row row = (Row)this.fieldsRow.get(j);
            pos = this.getFieldPosition(row.getY());
            List cs = row.getComponents();
            int columns = cs.size();
            for (int i = 0; i < columns; ++i) {
                int anchor = 0;
                Component c = (Component)cs.get(i);
                KDLayout.Constraints cons = this.getKDLayoutConstraints(c);
                if (cons == null) continue;
                if (pos == 0) {
                    ++anchor;
                }
                if (pos == 2) {
                    anchor += 2;
                }
                if (!(c instanceof JPanel)) {
                    anchor = i == 0 && this.isOnTheSide(c, 0) ? (anchor += 4) : (anchor += 128);
                    anchor += 256;
                } else {
                    anchor = i == 0 && this.isOnTheSide(c, 0) ? (anchor += 4) : (i == columns - 1 && this.isOnTheSide(c, 1) ? (anchor += 8) : (anchor += 16));
                }
                cons.anchor = anchor;
            }
        }
    }

    private void regularContainer() {
        int rows = this.containersRow.size();
        for (int j = 0; j < rows; ++j) {
            Row row = (Row)this.containersRow.get(j);
            List cs = row.getComponents();
            int columns = cs.size();
            for (int i = 0; i < columns; ++i) {
                int anchor = 0;
                Component c = (Component)cs.get(i);
                KDLayout.Constraints cons = this.getKDLayoutConstraints(c);
                if (cons == null) continue;
                if (c instanceof JPanel && !(c instanceof DetailPanel) && !(c instanceof KDContainer)) {
                    ++anchor;
                    if (i == 0) {
                        anchor += 4;
                    } else if (columns > 2 && i > 0 && i < columns - 1) {
                        anchor += 16;
                    } else if (i == columns - 1) {
                        anchor += 8;
                    }
                } else {
                    if (j == 0) {
                        ++anchor;
                    }
                    if (j == rows - 1) {
                        anchor += 2;
                    }
                    anchor = i == 0 ? (anchor += 4) : (anchor += 128);
                    anchor = i == columns - 1 ? (anchor += 8) : (anchor += 256);
                }
                cons.anchor = anchor;
            }
        }
    }

    private boolean isContainer(Component comp) {
        return comp instanceof JPanel || comp instanceof KDTabbedPane || comp instanceof KDTable || comp instanceof DetailPanel || comp instanceof KDContainer;
    }

    private boolean isRegularAsField(Component comp) {
        return !(comp instanceof KDTabbedPane) && !(comp instanceof KDTable) && !(comp instanceof DetailPanel) && !(comp instanceof KDContainer);
    }

    private boolean isOnTheSide(Component cur, int side) {
        if (this.components == null || cur == null) {
            return true;
        }
        Rectangle rect = cur.getBounds();
        if (rect == null) {
            return true;
        }
        for (Component c : this.components) {
            if (!c.isVisible() || cur == c) continue;
            Rectangle crect = c.getBounds();
            if (!(side == 0 ? rect.y >= crect.y && rect.y <= crect.y + crect.height && rect.x > crect.x : side == 1 && rect.y >= crect.y && rect.y <= crect.y + crect.height && rect.x < crect.x)) continue;
            return false;
        }
        return true;
    }

    private Component[] getChilds(Container container) {
        if (container instanceof KDTabbedPane) {
            KDTabbedPane kdp = (KDTabbedPane)container;
            Component[] cs = kdp.getComponents();
            int length = cs.length;
            for (int i = 0; i < length; ++i) {
                if (!(cs[i] instanceof Container)) continue;
                RegularSizePosition rsp = new RegularSizePosition();
                rsp.regular((Container)cs[i]);
            }
            return null;
        }
        if (container instanceof DetailPanel) {
            return null;
        }
        return container.getComponents();
    }

    private Row addRow(Component c, List rows) {
        if (c == null || rows == null) {
            return null;
        }
        int c_y = c.getY();
        boolean needNewRow = true;
        Row addRow = null;
        for (Row row : rows) {
            int y = row.getY();
            if (Math.abs(c_y - y) > 2) continue;
            row.add(c);
            needNewRow = false;
            addRow = row;
        }
        if (needNewRow) {
            Row row = new Row();
            row.add(c);
            rows.add(row);
            addRow = row;
        }
        return addRow;
    }

    private void SortRowElements(List list) {
        if (list != null) {
            for (Row row : list) {
                row.sort();
            }
        }
    }

    private boolean isKDLayout(Container component) {
        if (component == null) {
            return false;
        }
        if (component instanceof KDContainer) {
            component = ((KDContainer)component).getContentPane();
        }
        return component.getLayout() != null && component.getLayout() instanceof KDLayout;
    }

    private KDLayout.Constraints getKDLayoutConstraints(Component com) {
        JComponent jc;
        Object constraint;
        if (com == null) {
            return null;
        }
        if (com instanceof JComponent && (constraint = (jc = (JComponent)com).getClientProperty("KDLayoutConstraints")) != null && constraint instanceof KDLayout.Constraints) {
            return (KDLayout.Constraints)constraint;
        }
        return null;
    }

    private int getFieldPosition(int y) {
        if (this.containersRow.size() == 0) {
            return 0;
        }
        int top_y = ((Row)this.containersRow.get(0)).getY();
        if (y < top_y) {
            return 0;
        }
        int bottom_y = ((Row)this.containersRow.get(this.containersRow.size() - 1)).getY();
        if (y > bottom_y) {
            return 2;
        }
        return 1;
    }

    class RectangleComparator
    implements Comparator {
        RectangleComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            Component c1 = (Component)o1;
            Component c2 = (Component)o2;
            Rectangle i1 = c1.getBounds();
            Rectangle i2 = c2.getBounds();
            if (i1.x < i2.x) {
                return -1;
            }
            if (i1.x == i2.x) {
                return 0;
            }
            return 1;
        }
    }

    class RowComparator
    implements Comparator {
        RowComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            Row r1 = (Row)o1;
            Row r2 = (Row)o2;
            if (r1.getY() < r2.getY()) {
                return -1;
            }
            if (r1.getY() == r2.getY()) {
                return 0;
            }
            return 1;
        }
    }

    class Row {
        private int y = -1;
        private List components = new ArrayList();

        Row() {
        }

        public void add(Component component) {
            if (component != null) {
                this.components.add(component);
            }
            if (this.y == -1) {
                this.y = component.getY();
            }
        }

        public int getY() {
            return this.y;
        }

        public List sort() {
            Collections.sort(this.components, new RectangleComparator());
            return this.components;
        }

        public List getComponents() {
            return this.components;
        }

        public void clear() {
            this.components.clear();
        }
    }
}

