/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.print;

import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.framework.print.IMultiapproveDataFilter;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class STMultiapproveDataFilter
implements IMultiapproveDataFilter {
    private boolean isNewGeneration = false;

    public STMultiapproveDataFilter(boolean isNewGeneration) {
        this.isNewGeneration = isNewGeneration;
    }

    @Override
    public IRowSet filtrateMultiapproveData(IRowSet oldRowset) {
        if (oldRowset == null || oldRowset.size() == 0) {
            return oldRowset;
        }
        try {
            int i;
            ResultSetMetaData rowMetaData = oldRowset.getMetaData();
            HashMap<String, Timestamp> timestampMap = new HashMap<String, Timestamp>();
            HashMap<String, String> idMap = new HashMap<String, String>();
            HashMap<String, String> dynamicMap = new HashMap<String, String>();
            Object[] rows = oldRowset.toCollection().toArray();
            int length = rows.length;
            for (int i2 = 0; i2 < length; ++i2) {
                int type;
                List row = (List)rows[i2];
                String multiApproveId = (String)this.getFieldValue(rowMetaData, "MultiApprove.id", row);
                if (this.isNewGeneration && (type = TypeConversionUtils.objToInt((Object)this.getFieldValue(rowMetaData, "ftype", row))) != 9 && type != 10) {
                    dynamicMap.put(multiApproveId, multiApproveId);
                    continue;
                }
                String key = this.generateAgreeKey(rowMetaData, row);
                Timestamp createTime = (Timestamp)this.getFieldValue(rowMetaData, "MultiApprove.createTime", row);
                Timestamp last = (Timestamp)timestampMap.get(key);
                if (last != null && !createTime.after(last)) continue;
                timestampMap.put(key, createTime);
                idMap.put(key, multiApproveId);
            }
            int colCount = rowMetaData.getColumnCount();
            DynamicRowSet newRowSet = new DynamicRowSet(colCount);
            for (i = 0; i < colCount; ++i) {
                ColInfo colInfo = new ColInfo();
                colInfo.colType = rowMetaData.getColumnType(i + 1);
                colInfo.columnLabel = rowMetaData.getColumnLabel(i + 1);
                colInfo.columnName = rowMetaData.getColumnName(i + 1);
                colInfo.nullable = rowMetaData.isNullable(i + 1);
                newRowSet.setColInfo(i + 1, colInfo);
            }
            newRowSet.beforeFirst();
            int length2 = rows.length;
            for (i = 0; i < length2; ++i) {
                List row = (List)rows[i];
                String multiApproveId = (String)this.getFieldValue(rowMetaData, "MultiApprove.id", row);
                boolean show = false;
                if (this.isNewGeneration && dynamicMap.containsKey(multiApproveId)) {
                    show = true;
                } else {
                    for (Map.Entry entry : idMap.entrySet()) {
                        if (!multiApproveId.equals(entry.getValue())) continue;
                        show = true;
                        break;
                    }
                }
                if (!show) continue;
                newRowSet.moveToInsertRow();
                for (int j = 0; j < colCount; ++j) {
                    newRowSet.updateObject(j + 1, row.get(j));
                }
                newRowSet.insertRow();
            }
            return newRowSet;
        }
        catch (Exception e) {
            throw new RuntimeException("\u591a\u7ea7\u5ba1\u6279\u5957\u6253\u6570\u636e\u6e90\u53bb\u91cd\u8fc7\u6ee4\u5668\u51fa\u9519", e);
        }
    }

    private Object getFieldValue(ResultSetMetaData rowMetaData, String fieldName, List row) throws SQLException {
        int colCount = rowMetaData.getColumnCount();
        for (int j = 0; j < colCount; ++j) {
            String columnName = rowMetaData.getColumnName(j + 1);
            if (!fieldName.equalsIgnoreCase(columnName)) continue;
            return row.get(j);
        }
        return null;
    }

    private String generateAgreeKey(ResultSetMetaData rowMetaData, List row) throws SQLException {
        int count = rowMetaData.getColumnCount();
        String actName = null;
        String personName = null;
        for (int i = 0; i < count; ++i) {
            String columnName = rowMetaData.getColumnName(i + 1);
            if ("AssignDetail.actdefName".equalsIgnoreCase(columnName)) {
                actName = (String)row.get(i);
            }
            if ("personId.name".equalsIgnoreCase(columnName)) {
                personName = (String)row.get(i);
            }
            if (!"MultiApprove.isPass".equalsIgnoreCase(columnName)) continue;
            Object item = row.get(i);
            String isPass = null;
            if (item instanceof BizEnumValueInfo) {
                isPass = ((BizEnumValueInfo)item).getValue().toString();
            } else if (item instanceof String) {
                isPass = (String)item;
                if (this.isNewGeneration) {
                    isPass = "\u540c\u610f".equals(isPass) ? "true" : "false";
                }
                BizEnumValueInfo enumObj = new BizEnumValueInfo();
                ApproveResult approveResult = ApproveResult.getEnum((String)isPass);
                enumObj.setAlias(approveResult.getAlias());
                enumObj.setName(approveResult.getName());
                BizEnumValueDTO bizEnum = BizEnumValueDTO.createDTO((BizEnumValueInfo)enumObj);
                row.set(i, bizEnum);
            }
            if (!"false".equals(isPass)) continue;
            return actName + "_" + personName;
        }
        return actName + "_" + personName;
    }
}

