/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResTypeConvert;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.query.IFastFilter;
import com.kingdee.eas.framework.query.IFastQuery;
import com.kingdee.eas.framework.query.IQuickSearchQuery;
import com.kingdee.eas.framework.query.ISolutionChangedListener;
import com.kingdee.eas.framework.query.MySolutionList;
import com.kingdee.eas.framework.query.QuickFilteringPopupMenuManager;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.SolutionItem;
import com.kingdee.eas.framework.query.component.FixedPopupItem;
import com.kingdee.eas.framework.query.component.IBorderClip;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItemExecute;
import com.kingdee.eas.framework.query.component.IMouseOverIntention;
import com.kingdee.eas.framework.query.component.KDRoundRectBorder;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.eas.framework.util.BizOrgUtility;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class FastQueryOptionUI
extends KDPanel
implements ISolutionChangedListener,
IListPopupItemExecute,
IMouseOverIntention {
    private static final Logger logger = CoreUIObject.getLogger(FastQueryOptionUI.class);
    protected KDLabel lblPopup;
    protected KDLabel lblSolutionName;
    private FilterItemInfo orgFilterItemInfo;
    IFastFilter fastFilter;
    private String propertyOfMainBizOrg;
    private OrgUnitInfo mainOrgInfo;
    private IFastQuery fastQuery;
    private QuickFilteringSupportItems supportItems;
    private boolean isFocused = false;
    private IQuickSearchQuery quickSearchQuery;
    private QuickFilteringPopupMenuManager quickFilterPopupMenuManager;

    public FastQueryOptionUI(IQuickSearchQuery quickSearchQuery, IFastQuery fastQuery, QuickFilteringSupportItems supportItems) throws Exception {
        this.jbInit();
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FastQueryOptionUI.this.isFocused = true;
                FastQueryOptionUI.this.getParent().repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FastQueryOptionUI.this.isFocused = false;
                FastQueryOptionUI.this.getParent().repaint();
            }
        };
        this.addMouseListener(ml);
        this.lblSolutionName.addMouseListener((MouseListener)ml);
        this.lblPopup.addMouseListener((MouseListener)ml);
        this.quickSearchQuery = quickSearchQuery;
        this.fastQuery = fastQuery;
        this.supportItems = supportItems;
        this.propertyOfMainBizOrg = supportItems.getBizOrgPropertyName() == null ? quickSearchQuery.getPropertyOfMainBizOrg() : supportItems.getBizOrgPropertyName() + ".id";
        this.quickFilterPopupMenuManager = new QuickFilteringPopupMenuManager(this, fastQuery, supportItems);
        this.setBorder(new KDRoundRectBorder());
    }

    private void jbInit() throws Exception {
        this.lblPopup = new KDLabel();
        this.lblSolutionName = new KDLabel();
        this.setName("QueryOptionUI");
        this.lblPopup.setName("lblPopup");
        this.lblSolutionName.setName("lblSolutionName");
        this.lblSolutionName.setFont(ResTypeConvert.convertFont((String)"family=Dialog,name=Dialog,style=0,size=13"));
        this.setBorder(null);
        this.setPreferredSize(new Dimension(304, 30));
        this.initUIContentLayout();
    }

    private void initUIContentLayout() {
        this.setBounds(new Rectangle(0, 0, 306, 30));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 306, 30));
        this.lblPopup.setBounds(new Rectangle(290, 10, 10, 10));
        this.add((Component)this.lblPopup, new KDLayout.Constraints(290, 10, 10, 10, 385));
        this.lblSolutionName.setBounds(new Rectangle(2, 5, 288, 22));
        this.add((Component)this.lblSolutionName, new KDLayout.Constraints(2, 5, 288, 22, 261));
    }

    QuickFilteringPopupMenuManager getQuickFilterPopupMenuManager() {
        return this.quickFilterPopupMenuManager;
    }

    void initPopupValue() {
        this.quickFilterPopupMenuManager.initPopupValue(this.supportItems);
    }

    public void onLoad() throws Exception {
        this.fastFilter = new MySolutionList(this.quickSearchQuery, this.fastQuery, this, this.supportItems);
        this.lblPopup.setIcon((Icon)QuickFilterResources.icon_popup);
        this.lblPopup.setOpaque(true);
        if (StringUtils.isEmpty((String)this.propertyOfMainBizOrg)) {
            return;
        }
        if (!this.supportItems.isSupportOrgUnitFilter()) {
            return;
        }
        if (this.supportItems.isSupportMultipleMainOrgs) {
            this.switchAllOrg();
        } else {
            this.setToAMainOrgInfo(this.getDefaultMainOrgInfo());
        }
    }

    FilterItemInfo getOrgFilterItemInfo() {
        return this.orgFilterItemInfo;
    }

    List getMainOrgs() {
        ArrayList<String> mainOrgs = new ArrayList<String>();
        if (this.supportItems.isSupportMultipleMainOrgs) {
            OrgUnitCollection allOrgInfoCol = this.fastFilter.getAuthOrgsByType();
            if (allOrgInfoCol == null) {
                return mainOrgs;
            }
            Iterator iterator = allOrgInfoCol.iterator();
            while (iterator.hasNext()) {
                mainOrgs.add(((OrgUnitInfo)iterator.next()).getId().toString());
            }
        } else {
            OrgUnitInfo mainOrg = this.getDefaultMainOrgInfo();
            if (mainOrg != null) {
                mainOrgs.add(mainOrg.getId().toString());
            }
        }
        return mainOrgs;
    }

    private void switchAllOrg() {
        OrgUnitCollection allOrgInfoCol = this.fastFilter.getAuthOrgsByType();
        HashSet<String> orgUnits = new HashSet<String>();
        if (allOrgInfoCol != null) {
            for (OrgUnitInfo unit : allOrgInfoCol) {
                orgUnits.add(unit.getId().toString());
            }
        }
        this.initOrgFilterItemInfo(orgUnits);
    }

    private void setToAMainOrgInfo(OrgUnitInfo aMainOrgInfo) {
        if (aMainOrgInfo == null) {
            this.initOrgFilterWithoutOrg();
            return;
        }
        HashSet<String> orgUnits = new HashSet<String>();
        orgUnits.add(aMainOrgInfo.getId().toString());
        this.initOrgFilterItemInfo(orgUnits);
    }

    private void initOrgFilterItemInfo(Set<String> orgUnits) {
        if (orgUnits.size() == 0) {
            this.initOrgFilterWithoutOrg();
            return;
        }
        this.orgFilterItemInfo = new FilterItemInfo(this.propertyOfMainBizOrg, orgUnits, CompareType.INCLUDE);
        Iterator<String> iterator = orgUnits.iterator();
        ArrayList<String> arr = new ArrayList<String>();
        while (iterator.hasNext()) {
            arr.add(iterator.next());
        }
    }

    private void initOrgFilterWithoutOrg() {
        this.orgFilterItemInfo = new FilterItemInfo(this.propertyOfMainBizOrg, (Object)"", CompareType.EQUALS);
    }

    private OrgUnitInfo getDefaultMainOrgInfo() {
        if (this.supportItems.getDefaultMainOrgInfo() != null) {
            return this.supportItems.getDefaultMainOrgInfo();
        }
        if (this.mainOrgInfo == null) {
            this.mainOrgInfo = this.loadDefaultMainOrg();
        }
        return this.mainOrgInfo;
    }

    private OrgUnitInfo loadDefaultMainOrg() {
        OrgUnitCollection bizOrgs = this.fastFilter.getAuthOrgsByType();
        return BizOrgUtility.loadDefaultMainOrg(bizOrgs);
    }

    @Override
    public void solutionChanged(QuerySolutionInfo solutionInfo, boolean refreshList) {
        if (solutionInfo != null && !this.fastFilter.isBlankSolution()) {
            this.solutionNameChanged(SolutionItem.getSolutionName(solutionInfo));
        }
        if (refreshList) {
            this.quickFilterPopupMenuManager.initPopupValue(this.supportItems);
        }
        this.quickFilterPopupMenuManager.setSelectedSolutionItem(solutionInfo);
    }

    @Override
    public void executeItem(IListPopupItem item, boolean isOnRefresh) {
        if (item == null) {
            this.quickFilterPopupMenuManager.setSelectedPopupItem(item);
            this.solutionNameChanged("");
            return;
        }
        this.solutionNameChanged(item.toString());
        if (!(item instanceof FixedPopupItem) && !isOnRefresh) {
            this.quickFilterPopupMenuManager.initPopupValue(this.supportItems);
        }
        this.quickFilterPopupMenuManager.setSelectedPopupItem(item);
    }

    private void solutionNameChanged(String text) {
        this.lblSolutionName.setText("  " + text);
    }

    public void paint(Graphics g) {
        Border border = this.getBorder();
        if (border instanceof IBorderClip) {
            ((IBorderClip)((Object)border)).paintClip((Component)((Object)this), g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    @Override
    public boolean isMouseOver() {
        return this.isFocused;
    }
}

