/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.IQueryFieldSelection;
import com.kingdee.eas.framework.query.QueryTreeView;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.apache.log4j.Logger;

public class QueryTreePanel
extends KDPanel {
    private static final Logger logger = Logger.getLogger(QueryTreePanel.class);
    private QueryTreeView treeView;
    private KDTree tree;
    private MetaDataPK queryInfo;
    private KDScrollPane scpSelectedItem;
    private IQueryFieldSelection queryFieldSelection;

    public QueryTreePanel(MetaDataPK queryInfo, IQueryFieldSelection queryFieldSelection) {
        this.queryInfo = queryInfo;
        this.queryFieldSelection = queryFieldSelection;
        this.init();
    }

    private void init() {
        KDTreeNode root = null;
        try {
            root = Util.getQueryFilterTreeNode((MetaDataPK)this.queryInfo);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        this.tree = new KDTree((ITreeNode)root);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    QueryTreePanel.this.treeClickEvent(e);
                }
                catch (BOSException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.tree.setShowCheckBox(false);
        this.treeView = new QueryTreeView(this.tree);
        this.treeView.setSize(100, 95);
        this.treeView.setShowButton(false);
        this.treeView.setForeground(Color.YELLOW);
        this.setLayout(new BorderLayout());
        this.scpSelectedItem = new KDScrollPane();
        this.scpSelectedItem.setSize(100, 100);
        this.add((Component)this.scpSelectedItem, "Center");
        this.scpSelectedItem.setViewportView((Component)((Object)this.treeView));
    }

    public void treeClickEvent(MouseEvent e) throws BOSException {
        if (e.getButton() != 1 || e.getClickCount() != 2) {
            return;
        }
        this.itemSelected();
    }

    private void itemSelected() throws BOSException {
        if (this.tree.getSelectionPath() == null) {
            return;
        }
        KDTreeNode selectedNode = (KDTreeNode)((Object)this.tree.getSelectionPath().getLastPathComponent());
        if (!selectedNode.isLeaf() || !(selectedNode.getUserObject() instanceof DataObject)) {
            return;
        }
        DataObject dataObject = (DataObject)selectedNode.getUserObject();
        this.queryFieldSelection.aFieldSelected(dataObject.getValue());
    }
}

