/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class QueryTreeView
extends KDTreeView {
    private KDWorkButton findBtn;
    KDTextField searchText;
    private int foundIndex = 0;

    public QueryTreeView(KDTree tree) {
        super(tree);
        this.setShowFind(false);
        this.initSearch();
    }

    public Dimension preferredLayoutSize(Container Container2) {
        return new Dimension(225, 370);
    }

    private void initSearch() {
        this.findBtn = new KDWorkButton((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)this.getMLS("picFind", "tree_demand.png"))));
        this.findBtn.setActionCommand("findNode");
        this.findBtn.setToolTipText(this.getMLS("menuToolTipFind", QuickFilterResources.getMessage("FIND")));
        this.findBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryTreeView.this.findNode();
            }
        });
        this.getControlPane().removeAll();
        this.getControlPane().setLayout(null);
        this.searchText = new KDTextField();
        this.searchText.setBounds(5, 2, 190, 19);
        this.getControlPane().add((Component)this.searchText);
        this.findBtn.setBounds(200, 2, 20, 19);
        this.getControlPane().add((Component)this.findBtn);
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.swing.KDTreeView", (String)defaultValue);
    }

    private void findNode() {
        String nodeText = "";
        ArrayList nodeList = new ArrayList();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTree().getModel().getRoot();
        Enumeration e = root.preorderEnumeration();
        while (e.hasMoreElements()) {
            nodeList.add(e.nextElement());
        }
        int size = nodeList.size();
        String input = this.searchText.getText().toLowerCase().trim();
        if (!StringUtils.isEmpty((String)input) && this.foundIndex < size) {
            for (int i = this.foundIndex + 1; i < size; ++i) {
                Object node = nodeList.get(i);
                if (node instanceof DefaultKingdeeTreeNode) {
                    DefaultKingdeeTreeNode currentNode = (DefaultKingdeeTreeNode)nodeList.get(i);
                    nodeText = currentNode.getText();
                    String string = nodeText = StringUtils.isEmpty((String)nodeText) ? "" : nodeText.toLowerCase();
                    if (nodeText.indexOf(input) != -1) {
                        this.getTree().setSelectionNode(currentNode);
                        this.getTree().scrollPathToVisible(this.getTree().getSelectionPath());
                        this.foundIndex = i;
                        break;
                    }
                }
                if (i != size - 1) continue;
                this.foundIndex = -1;
            }
        }
    }
}

