/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query.component;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.event.PopupMenuAdapter;
import com.kingdee.eas.framework.query.component.IBorderClip;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IPopupInvoker;
import com.kingdee.eas.framework.query.component.KDRoundRectBorder;
import com.kingdee.eas.framework.query.component.ListPopupItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;
import org.apache.log4j.Logger;

public class ListPopup
extends KDPopupMenu
implements MouseInputListener,
KeyListener,
ListSelectionListener,
ComboPopup {
    private static final Logger logger = Logger.getLogger(ListPopup.class);
    private JList list;
    private ArrayList<ListSelectionListener> listeners = new ArrayList();
    private IListPopupItem selectedItem;
    private boolean selectedControl = true;
    public static final int DEFAULT_CELLHEIGHT = 25;
    static final Color COLOR_TITLE = new Color(241, 244, 249);
    public static final ListPopupItem SEPERATOR = new ListPopupItem(null){

        @Override
        public boolean isDisabled() {
            return true;
        }
    };
    private static final int ROUND = 6;
    private IPopupInvoker invoker;
    private Handler handler;
    private boolean popupIsVisible = false;

    public void addListSelectionListener(ListSelectionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void setSelectedIndex(int index) {
        if (index >= this.list.getModel().getSize()) {
            index = 0;
        }
        this.list.ensureIndexIsVisible(index);
        this.list.setSelectedIndex(index);
        this.selectedItem = index < 0 ? null : this.getSelectedValue();
    }

    public IListPopupItem getSelectedValue() {
        return (IListPopupItem)this.list.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public boolean isSelected() {
        return this.list.getSelectedIndex() != -1;
    }

    public void setLastOneSelected() {
        int count = this.list.getModel().getSize();
        if (count > 0) {
            this.list.ensureIndexIsVisible(count - 1);
            this.list.setSelectedIndex(count - 1);
        }
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    public void fireValueChanged(ListSelectionEvent e) {
        for (ListSelectionListener l : this.listeners) {
            l.valueChanged(e);
        }
    }

    public ListPopup(final IPopupInvoker invoker, boolean selectedControl) {
        this.invoker = invoker;
        this.selectedControl = selectedControl;
        this.setLayout(new BorderLayout());
        this.list = new SearchList();
        this.list.setBorder(new KDRoundRectBorder(6, 0));
        this.list.setSelectionMode(0);
        this.list.addMouseListener(this);
        this.list.addMouseMotionListener(this);
        this.list.setModel(new DefaultListModel());
        this.list.setCellRenderer(new SearchListCellRenderer());
        this.list.setFixedCellHeight(25);
        this.add(this.list, "Center");
        this.setOpaque(true);
        this.addListSelectionListener(this);
        this.addPopupMenuListener((PopupMenuListener)new PopupMenuAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (invoker.getOwner() == null) {
                    ListPopup.this.popupIsVisible = false;
                    return;
                }
                Point point = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(point, invoker.getOwner());
                Rectangle r = invoker.getFocusedBounds();
                if (r == null) {
                    r = invoker.getOwner().getBounds();
                }
                if (r.contains(point)) {
                    return;
                }
                ListPopup.this.popupIsVisible = false;
            }
        });
    }

    public ListPopup(IPopupInvoker invoker) {
        this(invoker, true);
    }

    public int getItemCount() {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        return model.getSize();
    }

    public IListPopupItem getItem(int index) {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        return (IListPopupItem)model.get(index);
    }

    public void addItem(IListPopupItem o) {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.addElement(o);
    }

    public void removeItem(IListPopupItem o) {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.removeElement(o);
        if (this.isSameItemSelected(o)) {
            this.selectedItem = null;
        }
    }

    public void setList(Iterable<IListPopupItem> iterable) {
        DefaultListModel<IListPopupItem> model = new DefaultListModel<IListPopupItem>();
        for (IListPopupItem o : iterable) {
            model.addElement(o);
        }
        this.updateModel(model);
    }

    private void updateModel(DefaultListModel model) {
        this.list.setModel(model);
        this.selectedItem = null;
    }

    public void setList(Enumeration e) {
        DefaultListModel model = new DefaultListModel();
        while (e.hasMoreElements()) {
            model.addElement(e.nextElement());
        }
        this.updateModel(model);
    }

    public void setList(IListPopupItem ... objects) {
        DefaultListModel<IListPopupItem> model = new DefaultListModel<IListPopupItem>();
        for (IListPopupItem o : objects) {
            model.addElement(o);
        }
        this.updateModel(model);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.list.getSelectedIndex() != -1) {
            this.fireValueChanged(new ListSelectionEvent(this.list, this.list.getSelectedIndex(), this.list.getSelectedIndex(), true));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent anEvent) {
        if (anEvent.getSource() == this.list) {
            Point location = anEvent.getPoint();
            Rectangle r = new Rectangle();
            this.list.computeVisibleRect(r);
            if (r.contains(location)) {
                this.updateListBoxSelectionForEvent(anEvent, false);
            }
        }
    }

    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
        Point location = anEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? this.getFirstEnabled() : this.getLastEnabled();
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.setSelectedIndex(index);
            if (shouldScroll) {
                this.list.ensureIndexIsVisible(index);
            }
        }
    }

    private int getFirstEnabled() {
        int size = this.list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            IListPopupItem item = (IListPopupItem)this.list.getModel().getElementAt(i);
            if (item.isDisabled()) continue;
            return i;
        }
        return -1;
    }

    private int getLastEnabled() {
        for (int i = this.list.getModel().getSize() - 1; i >= 0; --i) {
            IListPopupItem item = (IListPopupItem)this.list.getModel().getElementAt(i);
            if (item.isDisabled()) continue;
            return i;
        }
        return -1;
    }

    public JList getList() {
        return this.list;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public void paint(Graphics g) {
        Border border = this.list.getBorder();
        if (border instanceof IBorderClip) {
            ((IBorderClip)((Object)border)).paintClip((Component)((Object)this), g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    private void setNextSelectedValue(boolean isDown) {
        if (this.list.getModel().getSize() == 0) {
            return;
        }
        int index = this.getNextIndex(isDown);
        this.list.setSelectedIndex(index);
        if (this.getSelectedValue().isDisabled()) {
            this.setNextSelectedValue(isDown);
        }
    }

    private int getNextIndex(boolean isDown) {
        int index = 0;
        if (!this.isSelected()) {
            return index;
        }
        index = this.list.getSelectedIndex();
        index = isDown ? (index < this.list.getModel().getSize() - 1 ? ++index : 0) : (index > 0 ? --index : this.list.getModel().getSize() - 1);
        return index;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.processKeyPress(e);
    }

    private void processKeyPress(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 40: {
                if (!this.isVisible()) break;
                this.setNextSelectedValue(true);
                break;
            }
            case 38: {
                if (!this.isVisible()) break;
                this.setNextSelectedValue(false);
                break;
            }
            case 10: {
                if (!this.isVisible() || this.getSelectedValue() == null) break;
                this.valueChanged();
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.valueChanged();
    }

    private void valueChanged() {
        IListPopupItem item = this.getSelectedValue();
        if (item == null || item.isDisabled() || item.isTitle()) {
            return;
        }
        if (this.isSameItemSelected(item)) {
            this.setPopupVisible(false);
            return;
        }
        item.execute(false);
        this.setPopupVisible(false);
        this.selectedItem = item;
    }

    private void setPopupVisible(boolean b) {
        super.setVisible(b);
        this.popupIsVisible = false;
    }

    private boolean isSameItemSelected(IListPopupItem item) {
        return this.selectedControl && item == this.selectedItem;
    }

    @Override
    public boolean isVisible() {
        return this.popupIsVisible;
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    @Override
    public void show() {
        this.setPopupSize(this.invoker.getPopupSize());
        Point location = this.invoker.getPopupLocation();
        this.show(this.invoker.getOwner(), location.x, location.y);
        this.popupIsVisible = true;
    }

    @Override
    public void hide() {
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        MenuElement[] selection = manager.getSelectedPath();
        for (int i = 0; i < selection.length; ++i) {
            if (selection[i] != this) continue;
            manager.clearSelectedPath();
            break;
        }
        if (selection.length > 0) {
            this.invoker.getOwner().repaint();
        }
        this.popupIsVisible = false;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }

    @Override
    public MouseListener getMouseListener() {
        return this.getHandler();
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return null;
    }

    @Override
    public void uninstallingUI() {
    }

    private class Handler
    extends MouseAdapter {
        private Handler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == ListPopup.this.list) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            ListPopup.this.togglePopup();
        }
    }

    class SearchListCellRenderer
    extends KDLabel
    implements ListCellRenderer {
        private boolean isSeperator = false;

        public SearchListCellRenderer() {
            this.setOpaque(true);
            Rectangle r = this.getBounds();
            r.height = 30;
            this.setBounds(r);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            IListPopupItem item = (IListPopupItem)value;
            if (value == SEPERATOR) {
                this.setText("");
                this.isSeperator = true;
            } else if (value != null) {
                this.setText("    " + value.toString());
                this.isSeperator = false;
            }
            if (item != null && item.isDisabled()) {
                this.setEnabled(false);
                isSelected = false;
            } else {
                this.setEnabled(true);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (item != null && item.isTitle()) {
                String text = "<HTML><b><font size=3>&nbsp;" + value.toString() + "</font></b></HTML>";
                this.setText(text);
                isSelected = false;
                this.setBackground(COLOR_TITLE);
            }
            return this;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!this.isSeperator) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(new Color(180, 180, 180));
            g2d.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
        }
    }

    class SearchList
    extends JList
    implements MenuElement {
        SearchList() {
        }

        @Override
        public void paint(Graphics g) {
            Border border = this.getBorder();
            if (border instanceof IBorderClip) {
                ((IBorderClip)((Object)border)).paintClip(this, g, 0, 0, this.getWidth(), this.getHeight());
            }
            super.paint(g);
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public MenuElement[] getSubElements() {
            return new MenuElement[0];
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
        }

        @Override
        public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
            if (event.getID() != 401) {
                return;
            }
            ListPopup.this.processKeyPress(event);
        }

        @Override
        public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
        }
    }
}

