/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.billdigest.BillDigestUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.util.Serialization;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.ProcessDataRepair;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.ext.IWfUserAdapter;
import com.kingdee.bos.workflow.metas.IOption;
import com.kingdee.bos.workflow.metas.OptionFactory;
import com.kingdee.bos.workflow.metas.OptionInfo;
import com.kingdee.bos.workflow.metas.OptionType;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.monitor.ApproveAssignmentInfo;
import com.kingdee.bos.workflow.monitor.ApproveUtil;
import com.kingdee.bos.workflow.monitor.DynamicOperationInfo;
import com.kingdee.bos.workflow.monitor.DynamicOperationServiceFactory;
import com.kingdee.bos.workflow.monitor.IDynamicOperationService;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.Pair;
import com.kingdee.bos.workflow.monitor.WfProcDiagramEncoder;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.TableColumnLength;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WfUtil
extends AbstractBOSObject
implements IWfUtil {
    Context ctx;
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFMRWFUT");
    private static HashMap<String, String> dynamicOpL1 = new HashMap();
    private static HashMap<String, String> dynamicOpL2 = new HashMap();
    private static HashMap<String, String> dynamicOpL3 = new HashMap();

    public WfUtil() {
        this.ctx = this.getContext();
    }

    public WfUtil(Context ctx) {
        super(ctx);
        this.ctx = ctx;
    }

    @Override
    public byte[] getImageData(String id) throws Exception {
        WfProcDiagramEncoder encoder = new WfProcDiagramEncoder(id, this.ctx);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        encoder.outputImage(baos);
        return baos.toByteArray();
    }

    @Override
    public String getKpdlData(String id) throws Exception {
        ProcessInstInfo info;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        String hash = null;
        if (id.endsWith("WFPCINST")) {
            info = svc.getProcessInstInfo(id);
            hash = info.getProcDefHashValue();
        } else {
            info = svc.getProcessDefInfo(id);
            hash = info.getMd5HashValue();
        }
        StringBuffer sb = new StringBuffer();
        ProcessDef pDef = svc.getProcessDefByDefineHashValue(hash);
        if (pDef != null) {
            sb.append(pDef.toXml());
            try {
                sb.append(WfEngine.getFlowDescription((ProcessDef)pDef));
            }
            catch (Throwable error) {
                sb.append("\r\n\r\n<!--\r\n");
                sb.append(Serialization.dump((Throwable)error));
                sb.append("\r\n-->");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isMatch(String billId, String assignmentId) throws Exception {
        if (assignmentId == null || assignmentId.length() == 0) {
            return false;
        }
        if (billId == null || billId.length() == 0) {
            return false;
        }
        if (this.ctx.getCaller() == null) {
            return false;
        }
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo assign = svc.getAssignmentById(assignmentId);
        if (!billId.equals(assign.getBizObjectIds())) {
            return false;
        }
        String userId = this.ctx.getCaller().toString();
        if (userId == null) {
            return false;
        }
        return userId.equals(assign.getUserId());
    }

    @Override
    public String getBindProcessId(String billId, IObjectValue editData, String function, String operation) throws Exception {
        String procInstId = this.getProcInstId(billId);
        if (procInstId != null) {
            return procInstId;
        }
        if (editData == null) {
            return null;
        }
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        return svc.findSubmitProcDef(this.ctx.getCaller().toString(), editData, function, operation);
    }

    @Override
    public String getProcInstId(String billId) throws BOSException {
        if (billId == null) {
            return null;
        }
        String procInstId = null;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        ProcessInstInfo[] infos = svc.getProcessInstanceByHoldedObjectId(billId);
        if (infos != null && infos.length > 0) {
            Timestamp d = null;
            int n = infos.length;
            for (int i = 0; i < n; ++i) {
                Timestamp tmp = infos[i].getCreatedTime();
                if (d != null && !tmp.after((Date)d)) continue;
                d = tmp;
                procInstId = infos[i].getProcInstId();
            }
        } else {
            infos = svc.getAllProcessInstancesByBizobjId(billId);
            String procInstIdTemp = null;
            Timestamp d = null;
            for (int i = 0; i < infos.length; ++i) {
                if (infos[i].getParentProcInstId() != null) {
                    procInstIdTemp = infos[i].getProcInstId();
                    continue;
                }
                Timestamp tmp = infos[i].getCreatedTime();
                if (d != null && !tmp.after((Date)d)) continue;
                d = tmp;
                procInstId = infos[i].getProcInstId();
            }
            if (StringUtils.isEmpty(procInstId)) {
                procInstId = procInstIdTemp;
            }
        }
        return procInstId;
    }

    @Override
    public ProcessDef getProcessDef(String defId) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        ProcessDefInfo info = svc.getProcessDefInfo(defId);
        if (info == null) {
            return null;
        }
        return svc.getProcessDefByDefineHashValue(info.getMd5HashValue());
    }

    @Override
    public String[] getApproveAssignIds(String billId) throws Exception {
        return this.getApproveAssignIds(billId, "T_WFR_ASSIGNDETAIL", "t_wfr_procinst");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getApproveHstAssignIds(String billId) throws Exception {
        if (billId.endsWith("WFWKITEM")) {
            return this.getApproveAssignIds(billId, "T_WFR_AssignHst", "t_wfr_ProcInstHst");
        }
        if (billId.indexOf(39) >= 0) {
            throw new Exception("\u975e\u6cd5\u8bbf\u95ee!");
        }
        PreparedStatement smt = null;
        ResultSet rs = null;
        Connection cn = DbConnector.getConnection((Context)this.ctx);
        try {
            String sql = "SELECT fassignid FROM T_WFR_ASSIGNDETAIL WHERE fbizobjid=? AND fstate=? ";
            smt = cn.prepareStatement(sql);
            smt.setString(1, billId);
            smt.setInt(2, 16);
            rs = smt.executeQuery();
            ArrayList<String> assignIds = new ArrayList<String>();
            while (rs.next()) {
                assignIds.add(rs.getString(1));
            }
            try {
                rs.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sql = "SELECT fassignid FROM T_WFR_AssignHst WHERE fbizobjid= ? AND fstate= ? ";
            smt = cn.prepareStatement(sql);
            smt.setString(1, billId);
            smt.setInt(2, 16);
            rs = smt.executeQuery();
            while (rs.next()) {
                assignIds.add(rs.getString(1));
            }
            String[] curAssignIds = this.getApproveAssignIds(billId, "T_WFR_ASSIGNDETAIL", "t_wfr_procinst");
            if (curAssignIds != null) {
                for (int i = 0; i < curAssignIds.length; ++i) {
                    assignIds.remove(curAssignIds[i]);
                }
            }
            if (assignIds.size() == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = assignIds.toArray(new String[assignIds.size()]);
            return stringArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (smt != null) {
                try {
                    smt.close();
                }
                catch (Throwable throwable) {}
            }
            try {
                cn.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getApproveAssignIds(String billId, String assignTable, String procTable) throws Exception {
        ProcessInstInfo[] infos;
        IEnactmentService svc;
        if (billId == null) {
            throw new NullPointerException("\u5355\u636eID\u4e3a\u7a7a\uff01");
        }
        if (billId.indexOf(39) >= 0) {
            throw new Exception("\u975e\u6cd5\u8bbf\u95ee!");
        }
        String procInstId = null;
        if (billId.endsWith("WFWKITEM")) {
            svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assign = svc.getAssignmentById(billId);
            procInstId = assign.getProcInstId();
            billId = assign.getBizObjectIds();
        } else if (billId.endsWith("WFPCINST") && (billId = this.toBillId(procInstId = billId)) == null) {
            return null;
        }
        if (procTable.equals("t_wfr_procinst") && (infos = (svc = EnactmentServiceFactory.createEnactService((Context)this.ctx)).getProcessInstanceByHoldedObjectId(billId)) != null && infos.length > 0) {
            procInstId = infos[0].getProcInstId();
        }
        Statement smt = null;
        ResultSet rs = null;
        Connection cn = DbConnector.getConnection((Context)this.ctx);
        try {
            Iterator it;
            StringBuffer sb;
            String tmp;
            String sql;
            smt = cn.createStatement();
            if (procInstId == null) {
                sql = "select top 1 fprocinstid from " + assignTable + " where fbizobjid='" + billId + "' order by fcreatedtime desc";
                rs = this.executeQuery(smt, sql);
                if (!rs.next()) {
                    String[] stringArray = null;
                    return stringArray;
                }
                procInstId = rs.getString(1);
            }
            HashSet<String> accessed = new HashSet<String>();
            accessed.add(procInstId);
            while ((rs = this.executeQuery(smt, sql = "select fparentprocinstid from " + procTable + " where fprocinstid='" + procInstId + "'")).next() && (tmp = rs.getString(1)) != null) {
                if (accessed.contains(tmp)) {
                    throw new Exception(procInstId + "\u6d41\u7a0b\u5b9e\u4f8b\u7684\u7236\u5b9e\u4f8b\u5c42\u6b21\u5173\u7cfb\u9519\u8bef\uff1a\u4e92\u4e3a\u7236\u5b9e\u4f8b\uff01");
                }
                procInstId = tmp;
                accessed.add(procInstId);
            }
            String procInstIds = "'" + procInstId + "'";
            while (true) {
                sql = "select fprocinstid from " + procTable + " where fparentprocinstid in(" + procInstIds + ")";
                rs = this.executeQuery(smt, sql);
                sb = new StringBuffer();
                while (rs.next()) {
                    procInstId = rs.getString(1);
                    accessed.add(procInstId);
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append("'").append(procInstId).append("'");
                }
                if (sb.length() == 0) {
                    sb = new StringBuffer();
                    it = accessed.iterator();
                    break;
                }
                procInstIds = sb.toString();
            }
            while (it.hasNext()) {
                Object e = it.next();
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(e).append("'");
            }
            procInstIds = sb.toString();
            sql = "SELECT fassignid FROM " + assignTable + " WHERE fbizobjid='" + billId + "' AND FPROCINSTID IN(" + procInstIds + ") AND fstate=" + 16;
            rs = this.executeQuery(smt, sql);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (rs.next()) {
                arrayList.add(rs.getString(1));
            }
            if (arrayList.size() == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            return stringArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (smt != null) {
                try {
                    smt.close();
                }
                catch (Throwable throwable) {}
            }
            try {
                cn.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private ResultSet executeQuery(Statement smt, String sql) throws SQLException {
        return smt.executeQuery(sql);
    }

    @Override
    public IWfUtil.ApproveAssignIds getAllValidApproveAssignIds(String billId) throws Exception {
        boolean isHistory;
        String[] assignIds = this.getApproveAssignIds(billId);
        boolean bl = isHistory = assignIds == null;
        if (isHistory) {
            assignIds = this.getApproveHstAssignIds(billId);
        }
        IWfUtil.ApproveAssignIds r = new IWfUtil.ApproveAssignIds();
        r.isHistory = isHistory;
        r.AssignIds = assignIds;
        r.billId = billId;
        return r;
    }

    @Override
    public FilterInfo getApproveFilter(String billId) throws Exception {
        String[] assignIds = this.getApproveAssignIds(billId);
        return WfUtil.generateMultiApproveFilter(billId, assignIds);
    }

    @Override
    public FilterInfo getApproveHstFilter(String billId) throws Exception {
        String[] assignIds = this.getApproveHstAssignIds(billId);
        return WfUtil.generateMultiApproveFilter(billId, assignIds);
    }

    public static FilterInfo generateMultiApproveFilter(String billId, String[] assignIds) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(billId='" + billId + "')");
        buffer.append(" and (status=" + MultiApproveStatusEnum.SUBMIT.getValue() + ")");
        if (assignIds != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < assignIds.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("'").append(assignIds[i]).append("'");
            }
            buffer.append("and (assignment IN (" + sb.toString() + "))");
        } else {
            buffer.append("and (assignment=' ')");
        }
        String oqlFilter = buffer.toString();
        return new FilterInfo(oqlFilter);
    }

    @Override
    public String getApproveActPermissionMode(String assignmentId) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo info = svc.getAssignmentById(assignmentId);
        ProcessDef def = svc.getProcessDefByDefineHashValue(info.getProcDefHashValue());
        ActivityDef act = def.getActivityDef(info.getActDefId());
        ExtendedAttributeCollection eac = act.getActivityHeader().getExtendedAttributes();
        ExtendedAttributeDef ead = eac.get("attachMode");
        String mode = null;
        if (ead != null) {
            mode = ead.getValue();
        }
        if (mode == null || mode.length() == 0 || "0".equals(mode)) {
            mode = ParamManager.getParamValue((Context)this.ctx, null, (String)"MultiApproveAttachmentPermissionMode");
        }
        return mode;
    }

    @Override
    public Object getProcessContext(String assignmentId, String key) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo info = svc.getAssignmentById(assignmentId);
        return svc.getProcessContext(info.getProcInstId(), key);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    @Override
    public IWfUserAdapter.User getUser(String userId) throws Exception {
        IWfUserAdapter uf = ConfigLoader.getConfig4Server().getUserAdapter(this.ctx);
        return uf.getUser(userId);
    }

    @Override
    public ApproveAssignmentInfo getApproveConfig(String assignId) throws Exception {
        return ApproveUtil.getApproveConfig(this.ctx, assignId);
    }

    @Override
    public ApproveAssignmentInfo getApproveConfigFromProcessCenter(String assignId) throws Exception {
        return ApproveUtil.getApproveConfigFromProcessCenter(this.ctx, assignId);
    }

    @Override
    public String getDigest(String billId, String scene) throws Exception {
        return BillDigestUtil.getDigest((Context)this.ctx, (String)billId, (String)scene);
    }

    @Override
    public boolean isExistDigest(BOSObjectType bosType, String scene) throws Exception {
        return BillDigestUtil.isExistDigest((Context)this.ctx, (BOSObjectType)bosType, (String)scene);
    }

    @Override
    public int getApproveOpinionMaxLength() {
        return TableColumnLength.get((String)this.ctx.getAIS(), (String)"T_BAS_MULTIAPPROVE", (String)"FOPINION_L2");
    }

    @Override
    public List<Map<String, Object>> getPassComment(String id) throws Exception {
        if ((id = this.toBillId(id)) == null) {
            return Collections.emptyList();
        }
        Locale l = this.ctx.getLocale();
        String sql = "select c.fpassid, c.ftype, c.finitiator,c.fcreatetime, c.fcomment_" + l + " as fcomment, case when c.ftype is null then c.fcreatetime else c.fupdatetime end as ftime, isnull(c.fpersonname,u.fname_" + l + ") as ffeedbacker from t_wfr_passcomment c left join t_pm_user u on c.fuserid=u.fid where fbillid=? order by c.fcreatetime,c.fpassid,c.ftype desc,c.fupdatetime";
        ArrayList list = SQL.executeQuery((Context)this.ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{id});
        DateFormat df = BOSLocaleUtil.getDateTimeFormat((Locale)this.ctx.getLocale());
        for (Map map : list) {
            Date d = (Date)map.get("ftime");
            if (d != null) {
                map.put("ftime", df.format(d));
            }
            if ((d = (Date)map.get("fcreatetime")) == null) continue;
            map.put("fcreatetime", df.format(d));
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> postProcessPassComments(List<Map<String, Object>> counterSigns) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, Object> item = null;
        for (Map<String, Object> map : counterSigns) {
            Object fpassid = map.get("fpassid");
            if (fpassid == null) {
                list.add(map);
                continue;
            }
            if (item == null || !fpassid.equals(item.get("fpassid"))) {
                item = map;
                list.add(map);
                continue;
            }
            ArrayList<Map<String, Object>> repliers = (ArrayList<Map<String, Object>>)item.get("repliers");
            if (repliers == null) {
                repliers = new ArrayList<Map<String, Object>>();
                item.put("repliers", repliers);
            }
            repliers.add(map);
        }
        return list;
    }

    private String toBillId(String id) throws WfException, BOSException {
        if (id.endsWith("WFWKITEM")) {
            AssignmentInfo assign = EnactmentServiceFactory.createEnactService((Context)this.ctx).getAssignmentById(id);
            id = assign.getBizObjectIds();
        } else if (id.endsWith("WFPCINST")) {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo[] assigns = svc.getAssignmentByProcInstId(id);
            if (assigns == null || assigns.length == 0) {
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)" select fbizobjid from t_wfr_procinstbizobj   where fprocinstid  = ? ", (Object[])new Object[]{id});
                    if (rowSet.next()) {
                        id = rowSet.getString(1);
                        return id;
                    }
                }
                catch (SQLException e) {
                    return null;
                }
                return null;
            }
            id = assigns[0].getBizObjectIds();
        }
        return id;
    }

    @Override
    public List<Map<String, Object>> getApproveHistory(String id, boolean isCurrent) throws Exception {
        String[] assignIds;
        String[] stringArray = assignIds = isCurrent ? this.getApproveAssignIds(id) : this.getApproveHstAssignIds(id);
        if (assignIds == null || assignIds.length == 0) {
            return Collections.emptyList();
        }
        StringBuilder where = this.toWhere(assignIds);
        StringBuilder sql = new StringBuilder();
        Locale l = this.ctx.getLocale();
        sql.append("select m.fispass,m.fhandlercontent,m.fopinion_" + l + " as fopinion, a.fpersonusername_" + l + " as fpersonusername, a.factdefname_" + l + " as factdefname, m.flastupdatetime,m.fassignmentid, (SELECT t2.fattachmentid FROM T_BAS_MultiApprove t1,T_WFR_ESIGNATURE t2 where t1.FESIGNATUREID=t2.fid  AND t1.FASSIGNMENTID=m.FASSIGNMENTID and t2.fenable = '0') ESIGNATURE, t.fid as fileid,t.fname_" + l + " as filename");
        sql.append(" from ");
        if (isCurrent) {
            sql.append("t_bas_multiapprove m inner join t_wfr_assigndetail a on m.fassignmentid=a.fassignid and m.fstatus=1");
        } else {
            sql.append("t_bas_multiapprovehst m inner join t_wfr_assignhst a on m.fassignmentid=a.fassignid");
        }
        sql.append(" left join T_BAS_Attachment t on t.fbeizhu=m.fassignmentid");
        sql.append(" where m.fassignmentid in(").append((CharSequence)where).append(")");
        sql.append(" order by m.flastupdatetime");
        ArrayList list = SQL.executeQuery((Context)this.ctx, (String)sql.toString());
        this.processApproveResultAndDate(list);
        return list;
    }

    @Override
    public List<Map> postProcessApproveHistory(List<Map<String, Object>> approveHistory) {
        if (approveHistory.size() == 0) {
            return Collections.emptyList();
        }
        LinkedHashMap map = new LinkedHashMap();
        for (Map<String, Object> item : approveHistory) {
            Object assign = item.get("fassignmentid");
            HashMap<String, Object> processed = (HashMap<String, Object>)map.get(assign);
            if (processed == null) {
                processed = new HashMap<String, Object>();
                processed.putAll(item);
                map.put(assign, processed);
            }
            if (item.get("fileid") == null) continue;
            ArrayList<Map<String, Object>> files = (ArrayList<Map<String, Object>>)processed.get("files");
            if (files == null) {
                files = new ArrayList<Map<String, Object>>();
                processed.put("files", files);
            }
            files.add(item);
        }
        ArrayList<Map> result = new ArrayList<Map>(map.size());
        result.addAll(map.values());
        return result;
    }

    private void processApproveResultAndDate(List<Map<String, Object>> list) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
        BizEnumInfo approveResult = loader.getEnum((IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.base.multiapprove.ApproveResult"));
        DateFormat df = BOSLocaleUtil.getDateTimeFormat((Locale)this.ctx.getLocale());
        for (Map<String, Object> map : list) {
            Date d;
            String ispass = (String)map.get("fispass");
            if (ispass != null) {
                BizEnumValueInfo value = approveResult.getInnerEnumValue(ispass);
                map.put("fispass", value);
            }
            if ((d = (Date)map.get("flastupdatetime")) == null) continue;
            map.put("flastupdatetime", df.format(d));
        }
    }

    @Override
    public List<Map<String, Object>> getCounterSign(String id, boolean isCurrent) throws Exception {
        ArrayList list;
        StringBuilder sql;
        if ((id = this.toBillId(id)) == null) {
            return Collections.emptyList();
        }
        Locale l = this.ctx.getLocale();
        if (isCurrent) {
            sql = new StringBuilder();
            sql.append("select distinct c.fassignopinion_" + l + " as fassignopinion, c.finitiatorname_" + l + " as finitiatorname, c.fcreatedtime,a.fpersonusername_" + l + " as fpersonusername,a.factdefname_" + l + " as factdefname");
            sql.append(" from t_wfr_assign a inner join T_WFR_CounterSign c").append(" on a.fassignid=c.fassignid");
            sql.append(" where a.fbizobjid=? order by c.fcreatedtime");
            list = SQL.executeQuery((Context)this.ctx, (String)sql.toString(), (int[])new int[]{12}, (Object[])new Object[]{id});
            sql = new StringBuilder();
            sql.append("select distinct c.fassignopinion_" + l + " as fassignopinion, c.finitiatorname_" + l + " as finitiatorname, c.fcreatedtime,a.fpersonusername_" + l + " as fpersonusername,a.factdefname_" + l + " as factdefname,m.fispass,m.fhandlercontent,m.fopinion_" + l + " as fopinion,m.flastupdatetime");
            sql.append(" from t_wfr_assigndetail a inner join T_WFR_CounterSign c").append(" on a.fassignid=c.fassignid left join t_bas_multiapprove m").append(" on m.fassignmentid=a.fassignid and m.fstatus=1 and a.fstate=16");
            sql.append(" where a.fbizobjid=? order by c.fcreatedtime, m.flastupdatetime");
            ArrayList list2 = SQL.executeQuery((Context)this.ctx, (String)sql.toString(), (int[])new int[]{12}, (Object[])new Object[]{id});
            this.processApproveResultAndDate(list2);
            list.addAll(list2);
        } else {
            sql = new StringBuilder();
            sql.append("select distinct c.fassignopinion_" + l + " as fassignopinion, c.finitiatorname_" + l + " as finitiatorname, c.fcreatedtime,a.fpersonusername_" + l + " as fpersonusername,a.factdefname_" + l + " as factdefname,m.fispass,m.fhandlercontent,m.fopinion_" + l + " as fopinion,m.flastupdatetime");
            sql.append(" from t_wfr_assignhst a inner join T_WFR_CounterSignhst c").append(" on a.fassignid=c.fassignid left join t_bas_multiapprovehst m").append(" on m.fassignmentid=a.fassignid and m.fstatus=1 and a.fstate=16");
            sql.append(" where a.fbizobjid=? order by c.fcreatedtime, m.flastupdatetime");
            list = SQL.executeQuery((Context)this.ctx, (String)sql.toString(), (int[])new int[]{12}, (Object[])new Object[]{id});
            this.processApproveResultAndDate(list);
        }
        DateFormat df = BOSLocaleUtil.getDateTimeFormat((Locale)this.ctx.getLocale());
        for (Map map : list) {
            Date d = (Date)map.get("fcreatedtime");
            if (d == null) continue;
            map.put("fcreatedtime", df.format(d));
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> postProcessCounterSign(List<Map<String, Object>> counterSigns) {
        return WfUtil.counterSignList2Tree(counterSigns);
    }

    @Override
    public List<Map<String, Object>> getCounterSignAsTree(String id, boolean isCurrent) throws Exception {
        return WfUtil.counterSignList2Tree(this.getCounterSign(id, isCurrent));
    }

    private static List<Map<String, Object>> counterSignList2Tree(List<Map<String, Object>> counterSigns) {
        if (counterSigns.size() == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        LinkedHashMap map = new LinkedHashMap();
        for (Map<String, Object> item : counterSigns) {
            Pair<Object, Object> pair = new Pair<Object, Object>(item.get("fcreatedtime"), item.get("finitiatorname"));
            HashMap<String, Object> processed = (HashMap<String, Object>)map.get(pair);
            if (processed == null) {
                processed = new HashMap<String, Object>();
                processed.putAll(item);
                map.put(pair, processed);
                processed.put("entries", new LinkedHashMap());
            }
            Map entries = (Map)processed.get("entries");
            Object user = item.get("fpersonusername");
            entries.put(user, item);
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(counterSigns.size());
        result.addAll(map.values());
        for (Map map2 : result) {
            ArrayList values = new ArrayList();
            for (Object value : ((Map)map2.get("entries")).values()) {
                values.add(value);
            }
            map2.put("entries", values);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> getDynamicOp(String id) throws Exception {
        String procInstId = null;
        if (id.endsWith("WFWKITEM")) {
            AssignmentInfo assign = EnactmentServiceFactory.createEnactService((Context)this.ctx).getAssignmentById(id);
            procInstId = assign.getProcInstId();
        } else {
            procInstId = id.endsWith("WFPCINST") ? id : this.getProcInstId(id);
        }
        id = this.toBillId(id);
        if (id == null) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder();
        Locale l = this.ctx.getLocale();
        sql.append("select a.ftype,b.factdefname_" + l + " as factname,a.ftargetactname,a.fcreatorname,a.fcomment_" + l + " as fcomment, a.fcreatetime, a.fprocinstid, a.factinstid");
        sql.append(" from t_wfr_dynamicOp a join t_wfr_actinst b on a.factinstid=b.factinstid where a.fbillid=? ");
        if (procInstId != null) {
            sql.append(" or a.fprocinstid='" + procInstId + "'");
        }
        sql.append(" order by a.fcreatetime");
        ArrayList list = SQL.executeQuery((Context)this.ctx, (String)sql.toString(), (int[])new int[]{12}, (Object[])new Object[]{id});
        DateFormat df = BOSLocaleUtil.getDateTimeFormat((Locale)this.ctx.getLocale());
        for (Map map : list) {
            Date d = (Date)map.get("fcreatetime");
            if (d != null) {
                map.put("fcreatetime", df.format(d));
            }
            Object type = map.get("ftype");
            map.put("operation", this.getOpName(type));
        }
        return list;
    }

    private String getOpName(Object type) {
        Locale l = this.ctx.getLocale();
        if (LocaleUtils.locale_L2.equals(l)) {
            return dynamicOpL2.get(type);
        }
        if (LocaleUtils.locale_L3.equals(l)) {
            return dynamicOpL3.get(type);
        }
        if (LocaleUtils.locale_L1.equals(l)) {
            return dynamicOpL1.get(type);
        }
        return dynamicOpL2.get(type);
    }

    private StringBuilder toWhere(String[] assignIds) {
        StringBuilder where = new StringBuilder(assignIds.length * 47 + 20);
        for (String id : assignIds) {
            if (where.length() > 0) {
                where.append(",");
            }
            where.append("'").append(id).append("'");
        }
        return where;
    }

    @Override
    public void abort(String procInstId, String opinion) throws Exception {
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)this.ctx, (WorkflowLogItem)WorkflowLogItem.FLOW_CHART_STOP, (Object)procInstId);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        svc.abortProcessInst(procInstId);
        this.saveDynamicOperationInfo("abort", procInstId, null, null, null, null, null, opinion);
        String descrip = "\u7ec8\u6b62\u6d41\u7a0b";
        if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l1")) {
            descrip = " abort a process";
        } else if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l3")) {
            descrip = "\u7d42\u6b62\u6d41\u7a0b";
        }
        this.saveOperation(opinion, "", OptionType.ABORT, this.ctx.getCaller().toString(), null, "", "", null, null, descrip, procInstId);
        WorkflowLogUtil.endLogByLocal((Context)this.ctx, (IObjectPK)logPk);
    }

    @Override
    public void reassignToPerson(String actInstId, String[] personIds, String opinion) throws Exception {
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)this.ctx, (WorkflowLogItem)WorkflowLogItem.FLOW_CHART_REASSIGN_EXECUTOR, (Object)actInstId);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        svc.reassignToPerson(actInstId, personIds);
        ActivityInstInfo act = svc.getActivityInstByActInstId(actInstId);
        String procInstId = act.getProcInstId();
        String actName = act.getActDefName(this.ctx.getLocale());
        this.saveDynamicOperationInfo("change-performers", procInstId, actInstId, actName, null, null, null, opinion);
        for (int index = 0; index < personIds.length; ++index) {
            String personid = personIds[index];
            String userName = svc.getUserNumberByID(personid);
            if (StringUtils.isEmpty((CharSequence)userName)) {
                userName = svc.getPersonByPersonID(personid)[0].getUserName(this.ctx.getLocale());
            }
            String descrip = "\u91cd\u65b0\u6307\u5b9a\u4efb\u52a1\u7ed9\u7528\u6237";
            if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l1")) {
                descrip = " Reassign the task to the user";
            } else if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l3")) {
                descrip = "\u91cd\u65b0\u6307\u5b9a\u4efb\u52d9\u7d66\u7528\u6236";
            }
            String result = descrip + "\uff1a" + userName;
            this.saveOperation(opinion, "", OptionType.CHANGEPERFORMERS, this.ctx.getCaller().toString(), personid, "", "", act.getActInstId(), null, result, procInstId);
        }
        WorkflowLogUtil.endLogByLocal((Context)this.ctx, (IObjectPK)logPk);
    }

    @Override
    public void addAssignToActivity(String actInstId, String[] personIds, String opinion) throws Exception {
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)this.ctx, (WorkflowLogItem)WorkflowLogItem.FLOW_CHART_ADD_EXECUTOR, (Object)actInstId);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        svc.addAssignToActivity(actInstId, personIds);
        ActivityInstInfo act = svc.getActivityInstByActInstId(actInstId);
        String procInstId = act.getProcInstId();
        String actName = act.getActDefName(this.ctx.getLocale());
        this.saveDynamicOperationInfo("add-performers", procInstId, actInstId, actName, null, null, null, opinion);
        for (int index = 0; index < personIds.length; ++index) {
            String personid = personIds[index];
            String userName = svc.getUserNumberByID(personid);
            if (StringUtils.isEmpty((CharSequence)userName)) {
                userName = svc.getPersonByPersonID(personid)[0].getUserName(this.ctx.getLocale());
            }
            String descrip = "\u6dfb\u52a0\u6267\u884c\u4eba";
            if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l1")) {
                descrip = " add person";
            } else if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l3")) {
                descrip = "\u6dfb\u52a0\u57f7\u884c\u4eba";
            }
            String result = descrip + "\uff1a" + userName;
            this.saveOperation(opinion, "", OptionType.ADDPERFORMERS, this.ctx.getCaller().toString(), personid, "", "", act.getActInstId(), null, result, procInstId);
        }
        WorkflowLogUtil.endLogByLocal((Context)this.ctx, (IObjectPK)logPk);
    }

    public void saveOperation(String option, String billId, OptionType type, String personId, String nextPersonid, String assignId, String nextAssignId, String actinstId, String nextActinstId, String result, String procinstId) {
        try {
            IOption Wfoption = OptionFactory.getLocalInstance((Context)this.ctx);
            OptionInfo opinfo = new OptionInfo();
            opinfo.setOption(option);
            if (!StringUtils.isEmpty((CharSequence)billId)) {
                opinfo.setBillID(BOSUuid.read((String)billId));
            }
            opinfo.setType(type);
            if (!StringUtils.isEmpty((CharSequence)personId)) {
                opinfo.setPersonID(BOSUuid.read((String)personId));
            }
            if (!StringUtils.isEmpty((CharSequence)nextPersonid)) {
                opinfo.setNextHandlerPersonID(nextPersonid);
            }
            if (!StringUtils.isEmpty((CharSequence)assignId)) {
                opinfo.setAssignmentID(BOSUuid.read((String)assignId));
            }
            if (!StringUtils.isEmpty((CharSequence)nextAssignId)) {
                opinfo.setNextAssignid(BOSUuid.read((String)nextAssignId));
            }
            if (!StringUtils.isEmpty((CharSequence)actinstId)) {
                opinfo.setCurrentAcinstID(BOSUuid.read((String)actinstId));
            }
            if (!StringUtils.isEmpty((CharSequence)nextActinstId)) {
                opinfo.setActinstID(BOSUuid.read((String)nextActinstId));
            }
            opinfo.setResult(result);
            if (!StringUtils.isEmpty((CharSequence)procinstId)) {
                opinfo.setProcinstID(BOSUuid.read((String)procinstId));
            }
            Wfoption.addnew(opinfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void forward(String assignId, String toPersonId, Map<Locale, String> opinionMap, String opinion) throws Exception {
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)this.ctx, (WorkflowLogItem)WorkflowLogItem.TO_DO_LIST_DELIVER, (Object)assignId);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo assign = svc.getAssignmentById(assignId);
        WfAssignmentState state = assign.getState();
        if (state.equals((Object)WfAssignmentState.ACCEPTED) || state.equals((Object)WfAssignmentState.ASSIGNED)) {
            AssignmentInfo forwarAssignInfo = svc.forwardAssignment(assignId, toPersonId, opinionMap);
            String procInstId = assign.getProcInstId();
            String actInstId = assign.getActInstId();
            String actName = assign.getActDefName(this.ctx.getLocale());
            String billId = assign.getBizObjectIds();
            this.saveDynamicOperationInfo("forward", procInstId, actInstId, actName, billId, null, null, opinion);
            String userName = svc.getUserNumberByID(toPersonId);
            if (StringUtils.isEmpty((CharSequence)userName)) {
                userName = svc.getPersonByPersonID(toPersonId)[0].getUserName(this.ctx.getLocale());
            }
            String descrip = "\u8f6c\u4ea4\u4efb\u52a1\u7ed9";
            if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l1")) {
                descrip = " foward task to ";
            } else if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l3")) {
                descrip = "\u8f49\u4ea4\u4efb\u52d9\u7d66";
            }
            String result = descrip + "\uff1a" + userName;
            String forwarAssignid = "";
            String forwarActivityId = "";
            if (forwarAssignInfo != null) {
                forwarAssignid = forwarAssignInfo.getAssignmentId();
                forwarActivityId = forwarAssignInfo.getActInstId();
            }
            this.saveOperation(opinion, billId, OptionType.deliverAssignment, this.ctx.getCaller().toString(), toPersonId, assignId, forwarAssignid, actInstId, forwarActivityId, result, procInstId);
            WorkflowLogUtil.endLogByLocal((Context)this.ctx, (IObjectPK)logPk);
        }
    }

    @Override
    public void jumpTo(String procInstId, String actDefId, String opinion) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        String hash = svc.getProcessInstInfo(procInstId).getProcDefHashValue();
        ProcessDef def = svc.getProcessDefByDefineHashValue(hash);
        ActivityDef actDef = def.getActivityDef(actDefId);
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)this.ctx, (WorkflowLogItem)(opinion.indexOf("kickback") >= 0 ? WorkflowLogItem.TO_DO_LIST_BEAT_BACK : WorkflowLogItem.FLOW_CHART_JUMP), (Object)(svc.getProcessInstInfo(procInstId).getInstTopic() + ":" + actDef.getName()));
        String curActivity = null;
        String curActDefId = null;
        WfEngine engine = WfEngine.getEngine((Context)this.getContext());
        if (opinion.indexOf("&&") > 0) {
            WfAssignment assign;
            String[] opinions = opinion.split("&&");
            opinion = opinions[0];
            if (!StringUtils.isEmpty((CharSequence)opinions[1]) && opinions[1].endsWith("WFWKITEM") && null != (assign = engine.getAssignment(opinions[1]))) {
                curActivity = assign.getActInstId();
                curActDefId = assign.getActivity().getDefinition().getID();
            }
        }
        String op = opinion;
        if (curActDefId != null) {
            op = op + "&&" + curActDefId;
        }
        svc.jump(procInstId, actDef, op);
        String type = "redirect";
        if (opinion.endsWith("kickback")) {
            type = "kick-back";
        }
        this.saveDynamicOperationInfo(type, procInstId, curActivity, null, null, actDefId, actDef.getName(this.ctx.getLocale()), opinion.replace("kickback", "").replace("jumpto", ""));
        WorkflowLogUtil.endLogByLocal((Context)this.ctx, (IObjectPK)logPk);
    }

    @Override
    public void suspend(String procInstId, String opinion) throws Exception {
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)this.ctx, (WorkflowLogItem)WorkflowLogItem.FLOW_CHART_SUSPEND, (Object)procInstId);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        svc.suspendProcessInst(procInstId);
        this.saveDynamicOperationInfo("suspend", procInstId, null, null, null, null, null, opinion);
        String descrip = "\u6302\u8d77\u6d41\u7a0b";
        if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l1")) {
            descrip = " suspend a process ";
        } else if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l3")) {
            descrip = "\u639b\u8d77\u6d41\u7a0b";
        }
        this.saveOperation(opinion, "", OptionType.SUSPEND, this.ctx.getCaller().toString(), null, "", "", null, null, descrip, procInstId);
        WorkflowLogUtil.endLogByLocal((Context)this.ctx, (IObjectPK)logPk);
    }

    private void saveDynamicOperationInfo(String operType, String procInstId, String actInstId, String actName, String billId, String targetActDefId, String targetActDefName, String opinion) throws BOSException {
        IDynamicOperationService serivce = DynamicOperationServiceFactory.getLocalInstance(this.ctx);
        DynamicOperationInfo info = new DynamicOperationInfo();
        info.setType(operType);
        info.setBillId(billId);
        info.setProcInstId(procInstId);
        info.setActInstId(actInstId);
        info.setActName(actName);
        info.setTargetActId(targetActDefId);
        info.setTargetActName(targetActDefName);
        info.setComment(opinion, new Locale("l1"));
        info.setComment(opinion, new Locale("l2"));
        info.setComment(opinion, new Locale("l3"));
        info.setCreatorId(this.ctx.getCaller().toString());
        String userName = ContextUtil.getCurrentUserInfo((Context)this.ctx).getName(this.ctx.getLocale());
        info.setCreatorName(userName);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        serivce.addNewDynamicOperationInfo(info);
    }

    @Override
    public List<Map<String, Object>> getUnReadAssigns(int maxCount) throws Exception {
        String l = this.ctx.getLocale().toString();
        String sql = "SELECT top " + maxCount + " a.fassignid as fid, a.fsubject_" + l + " as fsubject, a.fcreatedtime as fcreatedtime, a.fpriorperformername_" + l + " as fsender, b.fid as fmsgid  from T_WFR_Assign a  inner join T_BAS_AssignRead b on a.FASSIGNID = b.FASSIGNID\t\t\t and a.FSTATE in(1,2) and a.FIsSendMsg=1 where  a.FPERSONUSERID = '" + this.ctx.getCaller() + "'  AND b.FStatus = 0  order by a.fcreatedtime desc ";
        return SQL.executeQuery((Context)this.ctx, (String)sql);
    }

    @Override
    public List<Map<String, Object>> getUnReadNotices(int maxCount) throws Exception {
        String l = this.ctx.getLocale().toString();
        String sql = "SELECT top " + maxCount + " fid, ftitle_" + l + " as ftitle, fsendtime, fsender_" + l + " as fsender FROM T_BAS_Message WHERE FType = 0 AND FStatus = 0 AND FSENDER_l2 <> '\u670d\u52a1\u5668' and ((FSOURCEIDS not like 'PASS%' or FSOURCEIDS is null) and (ftitle_l2 not like '\u4f20\u9605\u53cd\u9988%' or ftitle_l1 not like 'Reply%' or ftitle_l3 not like '\u50b3\u95b1\u53cd\u994b%') and not exists (select 'x' from t_wfr_assign where t_wfr_assign.FASSIGNID=T_BAS_Message.FSOURCEID) and not exists (select 'x' from t_wfr_AssignDetail where t_wfr_AssignDetail.FASSIGNID=T_BAS_Message.FSOURCEID)) and FReceiver = '" + this.ctx.getCaller() + "' order by fsendtime desc";
        return SQL.executeQuery((Context)this.ctx, (String)sql);
    }

    public List<Map<String, Object>> getUnReadOAMessage(int maxCount) throws Exception {
        String sql = "select top " + maxCount + " fid,ftitle,freceivetime from t_bas_messageyr where freceiver = '" + this.ctx.getCaller() + "' and fstatus = 0 order by freceivetime desc";
        return SQL.executeQuery((Context)this.ctx, (String)sql);
    }

    public List<Map<String, Object>> getOAMessageCount() throws Exception {
        String sql = "select count(fid) num from t_bas_messageyr where freceiver = '" + this.ctx.getCaller() + "' and fstatus = 0";
        return SQL.executeQuery((Context)this.ctx, (String)sql);
    }

    @Override
    public void dataRepair(String procInstId, int type) throws BOSException {
        ProcessDataRepair tProcessDataRepair = new ProcessDataRepair(this.ctx);
        tProcessDataRepair.dataRepair(procInstId, type);
    }

    @Override
    public void abort(String procInstId, String opinion, String opType) throws Exception {
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)this.ctx, (WorkflowLogItem)WorkflowLogItem.DOING_STOP, (Object)procInstId);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        svc.abortProcessInst(procInstId);
        this.saveDynamicOperationInfo("abort", procInstId, null, null, null, null, null, opinion);
        String descrip = "\u7ec8\u6b62\u6d41\u7a0b";
        if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l1")) {
            descrip = " abort a process";
        } else if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l3")) {
            descrip = "\u7d42\u6b62\u6d41\u7a0b";
        }
        this.saveOperation(opinion, "", OptionType.ABORT, this.ctx.getCaller().toString(), null, "", "", null, null, descrip, procInstId);
        WorkflowLogUtil.endLogByLocal((Context)this.ctx, (IObjectPK)logPk);
    }

    @Override
    public void abortForWfMonitor(String procInstId, String opinion) throws Exception {
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)this.ctx, (WorkflowLogItem)WorkflowLogItem.WORKFLOW_MONITORING_STOP, (Object)procInstId);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        svc.abortProcessInst(procInstId);
        this.saveDynamicOperationInfo("abort", procInstId, null, null, null, null, null, opinion);
        String descrip = "\u7ec8\u6b62\u6d41\u7a0b";
        if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l1")) {
            descrip = " abort a process";
        } else if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l3")) {
            descrip = "\u7d42\u6b62\u6d41\u7a0b";
        }
        this.saveOperation(opinion, "", OptionType.ABORT, this.ctx.getCaller().toString(), null, "", "", null, null, descrip, procInstId);
        WorkflowLogUtil.endLogByLocal((Context)this.ctx, (IObjectPK)logPk);
    }

    static {
        dynamicOpL2.put("jump-to", "\u8df3\u8f6c");
        dynamicOpL2.put("kick-back", "\u6253\u56de");
        dynamicOpL2.put("redirect", "\u8df3\u8f6c");
        dynamicOpL2.put("add-performers", "\u6dfb\u52a0\u5904\u7406\u4eba");
        dynamicOpL2.put("change-performers", "\u6539\u53d8\u5904\u7406\u4eba");
        dynamicOpL2.put("forward", "\u8f6c\u4ea4");
        dynamicOpL2.put("abort", "\u7ec8\u6b62");
        dynamicOpL2.put("suspend", "\u6302\u8d77");
        dynamicOpL3.put("jump-to", "\u8df3\u8f49");
        dynamicOpL3.put("kick-back", "\u6253\u56de");
        dynamicOpL3.put("redirect", "\u8df3\u8f49");
        dynamicOpL3.put("add-performers", "\u6dfb\u52a0\u8655\u7406\u4eba");
        dynamicOpL3.put("change-performers", "\u6539\u8b8a\u8655\u7406\u4eba");
        dynamicOpL3.put("forward", "\u8f49\u4ea4");
        dynamicOpL3.put("abort", "\u7d42\u6b62");
        dynamicOpL3.put("suspend", "\u639b\u8d77");
        dynamicOpL1.put("jump-to", "Jump To");
        dynamicOpL1.put("kick-back", "Kick Back");
        dynamicOpL1.put("redirect", "Redirect");
        dynamicOpL1.put("add-performers", "Add Performers");
        dynamicOpL1.put("change-performers", "Change Performers");
        dynamicOpL1.put("forward", "Forward");
        dynamicOpL1.put("abort", "Abort");
        dynamicOpL1.put("suspend", "Suspend");
    }
}

