/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.monitor.ActivityUiInfo;
import com.kingdee.bos.workflow.monitor.IActivityTableUIFacade;
import com.kingdee.bos.workflow.monitor.client.AbstractActivityTableUI;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ActivityTableUI
extends AbstractActivityTableUI {
    private static final long serialVersionUID = -8864320033749528735L;
    private static final Logger logger = CoreUIObject.getLogger(ActivityTableUI.class);
    private final String res = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource";
    ActivityInstInfo[] allActivityArrays = new ActivityInstInfo[0];
    Map allAssigments = new HashMap();
    Map allActivityDefPartialInfos = new HashMap();
    ProcessInstInfo procInstInfo;
    List activitiesUI = new ArrayList();
    AccountTreeRender treeRender;
    private boolean isOrder = false;
    private boolean isFromAToZ = true;

    public void onLoad() throws Exception {
        super.onLoad();
        logger.debug((Object)"Start onLoad()!");
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.enableExportExcel(this.tblMain);
        this.initColumn();
        String processInstId = (String)this.getUIContext().get("processInstId");
        this.procInstInfo = (ProcessInstInfo)this.getUIContext().get("processInstInfo");
        IActivityTableUIFacade facade = (IActivityTableUIFacade)RpcProxy.wrapNoSupport(IActivityTableUIFacade.class);
        HashMap map = facade.getData4Init(processInstId != null ? processInstId : this.procInstInfo.getProcInstId());
        this.allActivityArrays = (ActivityInstInfo[])map.get("allActivityArrays");
        this.activitiesUI = (List)map.get("activitiesUI");
        this.allActivityDefPartialInfos = (Map)map.get("allActivityDefPartialInfos");
        this.allAssigments = (Map)map.get("allAssigments");
        this.procInstInfo = (ProcessInstInfo)map.get("procInstInfo");
        this.fillTable(this.filterAutoActivities());
        this.btnClose.setEnabled(true);
        this.btnFilterPause.setEnabled(true);
        this.btnFilterAuto.setEnabled(true);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 1 && e.getType() == 0 && e.getColIndex() == 1) {
                    ActivityTableUI.this.isOrder = true;
                    if (ActivityTableUI.this.isFromAToZ) {
                        ActivityTableUI.this.isFromAToZ = false;
                    } else {
                        ActivityTableUI.this.isFromAToZ = true;
                    }
                    ActivityTableUI.this.stateChange();
                }
            }
        });
        this.tblMain.addKDTResizeListener(new KDTResizeListener(){

            public void tableColumnResize(KDTResizeEvent e) {
                ActivityTableUI.this.setTableScrollState(0);
            }

            public void tableRowResize(KDTResizeEvent e) {
                ActivityTableUI.this.setTableScrollState(0);
            }
        });
        this.setTableScrollState(0);
    }

    private void initColumn() {
        this.treeRender = new AccountTreeRender();
        this.tblMain.getColumn("column1").setRenderer((IBasicRender)this.treeRender);
        this.tblMain.getColumn("column13").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("column3").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("column8").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("column14").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("column15").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("column0").setWidth(0);
        this.tblMain.getColumn("column1").setWidth(140);
        this.tblMain.getColumn("column2").setWidth(100);
        this.tblMain.getColumn("column3").setWidth(150);
        this.tblMain.getColumn("column15").setWidth(150);
        this.tblMain.getColumn("column9").setWidth(150);
        this.tblMain.getColumn("column10").setWidth(100);
        this.btnFilterAuto.setSelected(true);
    }

    @Override
    public void actionFilterAutoActivity_actionPerformed(ActionEvent e) throws Exception {
        this.stateChange();
    }

    @Override
    public void actionFilterPauseActivy_actionPerformed(ActionEvent e) throws Exception {
        this.stateChange();
    }

    @Override
    public void actionFilterDetail_actionPerformed(ActionEvent e) throws Exception {
        this.showDetails();
        this.stateChange();
    }

    private void showDetails() {
        if (this.btnFilterDetail.isSelected()) {
            this.tblMain.getColumn("column13").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column3").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column8").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column14").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("column15").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("approveresult").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column14").setWidth(100);
            this.tblMain.getColumn("column15").setWidth(100);
            this.tblMain.getColumn("column4").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("column5").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("column6").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("column7").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("column0").setWidth(0);
            this.tblMain.getColumn("column1").setWidth(100);
            this.tblMain.getColumn("column2").setWidth(80);
            this.tblMain.getColumn("column13").setWidth(100);
            this.tblMain.getColumn("column3").setWidth(100);
            this.tblMain.getColumn("column4").setWidth(100);
            this.tblMain.getColumn("column5").setWidth(100);
            this.tblMain.getColumn("column6").setWidth(100);
            this.tblMain.getColumn("column7").setWidth(100);
            this.tblMain.getColumn("column9").setWidth(100);
            this.tblMain.getColumn("column10").setWidth(100);
        } else {
            this.tblMain.getColumn("column13").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column3").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column8").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column14").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("column15").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("approveresult").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column0").setWidth(0);
            this.tblMain.getColumn("column1").setWidth(140);
            this.tblMain.getColumn("column2").setWidth(100);
            this.tblMain.getColumn("column3").setWidth(150);
            this.tblMain.getColumn("column15").setWidth(150);
            this.tblMain.getColumn("column9").setWidth(150);
            this.tblMain.getColumn("column10").setWidth(100);
            this.tblMain.getColumn("column4").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column5").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column6").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("column7").getStyleAttributes().setHided(true);
        }
    }

    private void stateChange() {
        this.tblMain.removeRows(false);
        if (this.btnFilterAuto.isSelected() && this.btnFilterPause.isSelected()) {
            this.fillTable(this.filterAllActivities());
        } else if (this.btnFilterAuto.isSelected()) {
            this.fillTable(this.filterAutoActivities());
        } else if (this.btnFilterPause.isSelected()) {
            this.fillTable(this.filterPauseActivities());
        } else {
            this.fillTable(this.activitiesUI);
        }
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
        this.reLayout();
        this.setTableScrollState(0);
    }

    private void setTableScrollState(int state) {
        this.tblMain.setScrollStateHorizon(state);
        this.tblMain.setScrollStateVertical(state);
    }

    private List filterAutoActivities() {
        ArrayList<ActivityUiInfo> manActivities = new ArrayList<ActivityUiInfo>();
        for (int i = 0; i < this.activitiesUI.size(); ++i) {
            ActivityUiInfo info = (ActivityUiInfo)this.activitiesUI.get(i);
            if (info.getActivityType() != null && info.getActivityType().length() > 0 && (info.getActivityType().equals("ROUTER") || info.getActivityType().equals("TOOL"))) continue;
            manActivities.add(info);
        }
        return manActivities;
    }

    private List filterPauseActivities() {
        ArrayList<ActivityUiInfo> runActivities = new ArrayList<ActivityUiInfo>();
        for (int i = 0; i < this.activitiesUI.size(); ++i) {
            ActivityUiInfo info = (ActivityUiInfo)this.activitiesUI.get(i);
            if (info.getActivityState().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"activityTable_abort")) || info.getActivityState().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"activityTable_complement")) || info.getActivityState().indexOf(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"activityTable_complement")) >= 0 || info.getActivityState().equals(ApproveResult.PASS.toString()) || info.getActivityState().equals(ApproveResult.NOT_PASS.toString()) || info.getActivityState().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"approveState_done")) || info.getActivityState().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"activityTable_closed_aborted"))) continue;
            runActivities.add(info);
        }
        return runActivities;
    }

    private List filterAllActivities() {
        ArrayList<ActivityUiInfo> activities = new ArrayList<ActivityUiInfo>();
        for (int i = 0; i < this.activitiesUI.size(); ++i) {
            ActivityUiInfo info = (ActivityUiInfo)this.activitiesUI.get(i);
            if (info.getActivityState().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"activityTable_abort")) || info.getActivityState().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"activityTable_complement")) || info.getActivityState().indexOf(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"activityTable_complement")) >= 0 || info.getActivityType().equals("ROUTER") || info.getActivityType().equals("TOOL") || info.getActivityState().equals(ApproveResult.NOT_PASS.toString()) || info.getActivityState().equals(ApproveResult.PASS.toString()) || info.getActivityState().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"approveState_done")) || info.getActivityState().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"activityTable_closed_aborted"))) continue;
            activities.add(info);
        }
        return activities;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void reLayout() {
    }

    public void onShow() throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActivityTableUI.this.reLayout();
            }
        });
        super.onShow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private SubWFExpandInfo getActivityName(int i, ActivityUiInfo info, Map procInstLevelMap) {
        SubWFExpandInfo subWFExpandInfo = new SubWFExpandInfo();
        subWFExpandInfo.setId(i + 1 + "");
        subWFExpandInfo.setName(info.getActivityName());
        subWFExpandInfo.setExpandStatus(true);
        subWFExpandInfo.setProcInstId(info.getProcInstId());
        if (info.getActivityType() != null && info.getActivityType().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"activityTable_subflow"))) {
            subWFExpandInfo.setSubWF(true);
        } else {
            subWFExpandInfo.setSubWF(false);
        }
        if (procInstLevelMap.isEmpty() || !procInstLevelMap.containsValue(info.getProcInstId())) {
            procInstLevelMap.put(procInstLevelMap.size() + 1 + "", info.getProcInstId());
        }
        if (procInstLevelMap.get(procInstLevelMap.size() + "").equals(info.getProcInstId())) {
            subWFExpandInfo.setLevel(procInstLevelMap.size());
        } else if (procInstLevelMap.get(procInstLevelMap.size() - 1 + "").equals(info.getProcInstId())) {
            procInstLevelMap.remove(procInstLevelMap.size() + "");
            subWFExpandInfo.setLevel(procInstLevelMap.size());
        } else {
            subWFExpandInfo.setLevel(1);
        }
        return subWFExpandInfo;
    }

    public void fillTable(List uiActivitys) {
        logger.info((Object)("\"uiActivitys\"'s size is " + uiActivitys.size() + "!"));
        int count = uiActivitys.size();
        if (this.isOrder) {
            if (this.isFromAToZ) {
                Collections.sort(uiActivitys, new ComparatorUtil(true));
            } else {
                Collections.sort(uiActivitys, new ComparatorUtil(false));
            }
        }
        HashMap procInstLevelMap = new HashMap();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.addRow(i);
            ActivityUiInfo info = (ActivityUiInfo)uiActivitys.get(i);
            this.tblMain.getRow(i).setMergeable(info.isMergeRow());
            ICell cell = row.getCell("column1");
            SubWFExpandInfo subWFExpandInfo = this.getActivityName(i, info, procInstLevelMap);
            cell.setValue((Object)subWFExpandInfo);
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column2");
            cell.setValue((Object)info.getActivityState());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("approveresult");
            cell.setValue((Object)info.getApproveResult());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column13");
            cell.setValue((Object)info.getApproveOpinion());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column3");
            cell.setValue((Object)info.getPerformer());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column14");
            cell.setValue((Object)info.getPerformer());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column4");
            cell.setValue((Object)info.getPerformerPerson());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column5");
            cell.setValue((Object)info.getPreActInst());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column6");
            cell.setValue((Object)info.getPostActInst());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column7");
            cell.setValue((Object)info.getActivityType());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column8");
            cell.setValue((Object)info.getCreatedTime());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column15");
            cell.setValue((Object)info.getCreatedTime());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column9");
            cell.setValue((Object)info.getCompleteTime());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column10");
            cell.setValue((Object)info.getConsumeTime());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column11");
            if (info.getActivityType() != null && info.getActivityType().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"activityTable_subflow"))) {
                cell.setValue((Object)true);
            } else {
                cell.setValue((Object)false);
            }
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column12");
            cell.setValue((Object)info.getProcInstId());
            cell.getStyleAttributes().setLocked(true);
        }
        logger.info((Object)"End fillTable!");
        logger.info((Object)("Row count is " + this.tblMain.getRowCount() + "!"));
    }

    public void fillMergeData(List uiActivitys) {
        int count = this.tblMain.getRowCount();
        HashMap procInstLevelMap = new HashMap();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            ActivityUiInfo info = (ActivityUiInfo)uiActivitys.get(i);
            ICell cell = row.getCell("column1");
            SubWFExpandInfo subWFExpandInfo = this.getActivityName(i, info, procInstLevelMap);
            cell.setValue((Object)subWFExpandInfo);
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("approveresult");
            cell.setValue((Object)info.getApproveResult());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column2");
            cell.setValue((Object)info.getActivityState());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column7");
            cell.setValue((Object)info.getActivityType());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column5");
            cell.setValue((Object)info.getPreActInst());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column6");
            cell.setValue((Object)info.getPostActInst());
            cell.getStyleAttributes().setLocked(true);
            cell = row.getCell("column2");
            cell.setValue((Object)info.getActivityState());
            cell.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected String getKeyFieldName() {
        return "column1";
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    public String[] getMergeColumnKeys() {
        String[] columnKeys = new String[]{"column1", "column2", "column5", "column6", "column7", "approveresult"};
        return columnKeys;
    }

    public void setTheFirstFillData(boolean theFirstFillData) {
    }

    protected boolean isCanOrderTable() {
        return false;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                ActivityTableUI.this.setTreeDisplayStyle(start, end + 1);
            }
        });
    }

    private void setTreeDisplayStyle(int start, int end) {
        int count = end;
        for (int i = start; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            String id = (String)row.getCell("column0").getValue();
            Object subWF = row.getCell("column1").getValue();
            if (!(subWF instanceof String)) {
                return;
            }
            String subWFName = (String)subWF;
            boolean isSubWF = (Boolean)row.getCell("column11").getValue();
            SubWFExpandInfo subWFExpandInfo = new SubWFExpandInfo();
            subWFExpandInfo.setId(id);
            subWFExpandInfo.setName(subWFName);
            subWFExpandInfo.setSubWF(isSubWF);
            subWFExpandInfo.setExpandStatus(true);
            subWFExpandInfo.setProcInstId(row.getCell(12).getValue().toString());
            row.getCell("column1").setValue((Object)subWFExpandInfo);
        }
    }

    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int columnIndex;
        if (e.getClickCount() == 1 && (columnIndex = e.getColIndex()) == 1) {
            SubWFExpandInfo subWFExpandInfo;
            int rowIndex = e.getRowIndex();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null || row.getCell("column1") == null) {
                return;
            }
            if (row.getCell("column1").getValue() instanceof SubWFExpandInfo && this.treeRender.inRect(subWFExpandInfo = (SubWFExpandInfo)row.getCell("column1").getValue(), e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row);
            }
            return;
        }
        super.tblMain_tableClicked(e);
    }

    private void setTreeDisplayStyle(IRow row) {
        boolean isSubWF = (Boolean)row.getCell("column11").getValue();
        if (!isSubWF) {
            return;
        }
        this.expandAcct(row);
    }

    private void expandAcct(IRow row) {
        SubWFExpandInfo acctNumberExpandInfo = (SubWFExpandInfo)row.getCell("column1").getValue();
        String acctNumber = acctNumberExpandInfo.getProcInstId();
        boolean isExpandStatus = acctNumberExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            IRow child;
            String childNumber;
            acctNumberExpandInfo.setExpandStatus(false);
            this.tblMain.setRefresh(false);
            int count = this.tblMain.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && (childNumber = (child = this.tblMain.getRow(i)).getCell("column12").getValue().toString()).startsWith(acctNumber); ++i) {
                child.getStyleAttributes().setHided(true);
            }
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        } else {
            IRow child;
            String childNumber;
            acctNumberExpandInfo.setExpandStatus(true);
            int count = this.tblMain.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && (childNumber = (child = this.tblMain.getRow(i)).getCell("column12").getValue().toString()).startsWith(acctNumber); ++i) {
                child.getStyleAttributes().setHided(false);
                this.expandAcct(child);
            }
        }
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        if (postman != null) {
            RequestContext request = (RequestContext)postman.getRequestContext();
            String processInstId = (String)this.getUIContext().get("processInstId");
            this.procInstInfo = (ProcessInstInfo)this.getUIContext().get("processInstInfo");
            request.put("processInstId", (Object)processInstId);
            request.put("processInstInfo", (Object)this.procInstInfo);
            postman.setRequestContext((Serializable)request);
        }
        return postman;
    }

    public void hideBtnClose() {
        this.btnClose.setVisible(false);
    }

    @Override
    public boolean isPrepareactionFilterAutoActivity() {
        return super.isPrepareactionFilterAutoActivity();
    }

    @Override
    public boolean isPrepareactionFilterDetail() {
        return super.isPrepareactionFilterDetail();
    }

    @Override
    public boolean isPrepareactionFilterPauseActivy() {
        return super.isPrepareactionFilterPauseActivy();
    }

    @Override
    public RequestContext prepareactionFilterAutoActivity(IItemAction itemAction) throws Exception {
        return super.prepareactionFilterAutoActivity(itemAction);
    }

    @Override
    public RequestContext prepareactionFilterDetail(IItemAction itemAction) throws Exception {
        return super.prepareactionFilterDetail(itemAction);
    }

    @Override
    public RequestContext prepareactionFilterPauseActivy(IItemAction itemAction) throws Exception {
        return super.prepareactionFilterPauseActivy(itemAction);
    }

    public class ComparatorUtil
    implements Comparator {
        private boolean isFromAToZ = false;
        Collator collator = Collator.getInstance();

        public ComparatorUtil(boolean isFromAToZ) {
            this.isFromAToZ = isFromAToZ;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ActivityUiInfo && o2 instanceof ActivityUiInfo) {
                ActivityUiInfo info1 = (ActivityUiInfo)o1;
                ActivityUiInfo info2 = (ActivityUiInfo)o2;
                CollationKey key1 = this.collator.getCollationKey(info1.getActivityName());
                CollationKey key2 = this.collator.getCollationKey(info2.getActivityName());
                if (this.isFromAToZ) {
                    key2.compareTo(key1);
                    return key1.compareTo(key2);
                }
                key1.compareTo(key2);
                return key2.compareTo(key1);
            }
            if (this.isFromAToZ) {
                return o1.toString().compareTo(o2.toString());
            }
            return o2.toString().compareTo(o1.toString());
        }
    }

    private class AccountTreeRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        private AccountTreeRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
        }

        public boolean inRect(SubWFExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getId();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof SubWFExpandInfo) {
                SubWFExpandInfo numberExpandInfo = (SubWFExpandInfo)obj;
                if (numberExpandInfo.isSubWF()) {
                    int ident = (numberExpandInfo.getLevel() - 1) * this.TABSIZE;
                    Rectangle rect = clip.getBounds();
                    int x = rect.x + ident;
                    int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                    Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                    this.acctIdToPos.put(numberExpandInfo.getId(), iconRect);
                    this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getName(), style);
                    this.paintIcon(graphics, numberExpandInfo, iconRect);
                } else {
                    int ident = (numberExpandInfo.getLevel() - 1) * this.TABSIZE;
                    Rectangle rect = clip.getBounds();
                    int x = rect.x + ident;
                    int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                    Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                    this.acctIdToPos.put(numberExpandInfo.getId(), iconRect);
                    this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getName(), style);
                }
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, SubWFExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (!numberExpandInfo.isSubWF()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    class SubWFExpandInfo {
        private String procInstId;
        private String id;
        private String name;
        private boolean isExpandStatus;
        private int level;
        private boolean isSubWF;

        SubWFExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isSubWF() {
            return this.isSubWF;
        }

        public void setSubWF(boolean isSubWF) {
            this.isSubWF = isSubWF;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getProcInstId() {
            return this.procInstId;
        }

        public void setProcInstId(String procInstId) {
            this.procInstId = procInstId;
        }
    }
}

