/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.SameGridConstraints;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.ext.IWfMonitorExt;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.monitor.ActivityUiInfo;
import com.kingdee.bos.workflow.monitor.client.WfUtils;
import com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorPanel;
import com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorScrollPanel;
import com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorUI;
import com.kingdee.bos.workflow.service.ormrpc.struct.IProcessImage;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JViewport;
import org.apache.log4j.Logger;

public class BasicWorkFlowMonitorPanel
extends CoreUI {
    private static final long serialVersionUID = -7097768837449673178L;
    private String instID;
    private final String resourceClass = "com.kingdee.bos.workflow.monitor.client.WfMonitorResources";
    private final String resourceClass2 = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource";
    protected KDWorkButton flowpropertyButton;
    public static final String BTN_FLOW_PROPERTY = "btnFlowProperty";
    public static final String BTN_NODE_PROPERTY = "btnNodeProperty";
    public static final String BTN_TRACE = "btnTrace";
    public static final String BTN_SHOW_PARENT_WF = "btnShowParentWF";
    public static final String BTN_SHOW_INFO = "btnShowInfo";
    public static final String BTN_SHOW_TABLE = "btnShowTable";
    public static final String BTN_REFRESH = "btnRefresh";
    public static final String BTN_JUMP = "btnJump";
    public static final String BTN_SHOW_BILL = "btnShowBill";
    protected KDWorkButton nodepropertyButton;
    protected KDWorkButton traceButton;
    protected KDWorkButton showParentFlowButton;
    protected KDWorkButton showInfoButton;
    protected KDWorkButton showTableButton;
    protected KDWorkButton refreshButton;
    ProcessInstInfo processInstInfo;
    static Collator collator = Collator.getInstance(Locale.CHINA);
    private KDWorkButton jumpButton;
    private KDWorkButton showBillButton;
    private IProcessImage processImage;
    private WorkFlowMonitorScrollPanel scroll;
    private KDTable workflowTable;
    static KDLabel selectedLabel;
    HashMap activityMap = new HashMap();
    HashMap activityInfoMap = new HashMap();
    WorkFlowMonitorUI workflowMonitorUI;
    private static final Logger logger;

    public BasicWorkFlowMonitorPanel() throws Exception {
        this.setPreferredSize(new Dimension(800, 600));
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(290, 160));
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = (RequestContext)clientHanlder.getRequestContext();
            request.setClassName("com.kingdee.bos.workflow.monitor.app.BasicWorkFlowMonitorPanelUIHandler");
            this.instID = (String)this.getUIContext().get("id");
            request.put("proceInstId", (Object)this.instID);
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            request.put("userId", (Object)userId);
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public static void Show(Map ctx) throws UIException {
        String className = BasicWorkFlowMonitorPanel.class.getName();
        ctx.put("OpenAsNewWin", "");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, ctx);
        if (uiWindow instanceof UINewFrame) {
            UINewFrame frame = (UINewFrame)uiWindow;
            frame.getStatusBar().setVisible(false);
            frame.getJMenuBar().setVisible(false);
        } else if (uiWindow instanceof UIModelDialog) {
            UIModelDialog dialog = (UIModelDialog)uiWindow;
            dialog.setResizable(true);
        }
        uiWindow.show();
    }

    public void onLoad() throws Exception {
        this.setQueryPreference(false);
        super.onLoad();
        this.flowpropertyButton = new KDWorkButton();
        this.nodepropertyButton = new KDWorkButton();
        this.traceButton = new KDWorkButton();
        this.refreshButton = new KDWorkButton();
        String refreshText = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WfMonitorResources", (String)"refreshGraph");
        this.refreshButton.setText(refreshText);
        this.refreshButton.setToolTipText(refreshText);
        this.refreshButton.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.toolBar.add((Component)this.refreshButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        String flowpropertyText = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WfMonitorResources", (String)"processProperty");
        this.flowpropertyButton.setText(flowpropertyText);
        this.flowpropertyButton.setToolTipText(flowpropertyText);
        this.flowpropertyButton.setIcon(EASResource.getIcon((String)"imgTbtn_showprocinstprop"));
        String nodepropertyText = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WfMonitorResources", (String)"activityProperty");
        this.nodepropertyButton.setText(nodepropertyText);
        this.nodepropertyButton.setToolTipText(nodepropertyText);
        this.nodepropertyButton.setIcon(EASResource.getIcon((String)"imgTbtn_showactinstprop"));
        String traceButtonText = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"enableTrace");
        this.traceButton.setText(traceButtonText);
        this.traceButton.setToolTipText(traceButtonText);
        this.traceButton.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.toolBar.add((Component)this.flowpropertyButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        this.toolBar.add((Component)this.nodepropertyButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        this.showParentFlowButton = new KDWorkButton();
        String showParentFlowText = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WfMonitorResources", (String)"showParentFlow");
        this.showParentFlowButton.setText(showParentFlowText);
        this.showParentFlowButton.setToolTipText(showParentFlowText);
        this.showParentFlowButton.setIcon(EASResource.getIcon((String)"imgTbtn_showparent"));
        this.toolBar.add((Component)this.showParentFlowButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        this.showTableButton = new KDWorkButton();
        String btnText = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"ACTIVITY_LIST");
        this.showTableButton.setText(btnText);
        this.showTableButton.setToolTipText(btnText);
        this.showTableButton.setIcon(EASResource.getIcon((String)"imgTbtn_showactinstprop"));
        this.toolBar.add((Component)this.showTableButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        this.showInfoButton = new KDWorkButton();
        btnText = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"EXECUTE_LOG");
        this.showInfoButton.setText(btnText);
        this.showInfoButton.setToolTipText(btnText);
        this.showInfoButton.setIcon(EASResource.getIcon((String)"imgTbtn_showparent"));
        this.toolBar.add((Component)this.showInfoButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        this.jumpButton = new KDWorkButton();
        String txt = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WfMonitorResources", (String)"jump");
        this.jumpButton.setIcon(EASResource.getIcon((String)"imgTbtn_terminateinstance"));
        this.jumpButton.setText(txt);
        this.jumpButton.setToolTipText(txt);
        this.toolBar.add((Component)this.jumpButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        this.showBillButton = new KDWorkButton();
        String billText = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"bill");
        this.showBillButton.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.showBillButton.setText(billText);
        this.showBillButton.setToolTipText(billText);
        this.toolBar.add((Component)this.showBillButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        if ("true".equals(this.getUIContext().get("isOpenedByWfMonitorUI"))) {
            this.showBillButton.setEnabled(true);
            this.showBillButton.setVisible(true);
        } else {
            this.showBillButton.setEnabled(false);
            this.showBillButton.setVisible(false);
        }
        try {
            UserInfo userInfo;
            this.instID = (String)this.getUIContext().get("id");
            if (this.instID == null || this.instID.length() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"procInstNotCreated"));
                return;
            }
            HashMap uiContext = new HashMap();
            this.workflowMonitorUI = (WorkFlowMonitorUI)UIFactoryHelper.initUIObject((String)WorkFlowMonitorUI.class.getName(), uiContext, new HashMap(), null);
            this.setLayout(new BorderLayout());
            this.add((Component)this.workflowMonitorUI.getSplit(), "Center");
            this.scroll = new WorkFlowMonitorScrollPanel();
            this.workflowMonitorUI.getSplit().add((Component)((Object)this.scroll), (Object)"bottom");
            HashMap<String, KDWorkButton> buttonsMap = new HashMap<String, KDWorkButton>();
            buttonsMap.put(BTN_FLOW_PROPERTY, this.flowpropertyButton);
            buttonsMap.put(BTN_NODE_PROPERTY, this.nodepropertyButton);
            buttonsMap.put(BTN_TRACE, this.traceButton);
            buttonsMap.put(BTN_SHOW_PARENT_WF, this.showParentFlowButton);
            buttonsMap.put(BTN_SHOW_INFO, this.showInfoButton);
            buttonsMap.put(BTN_SHOW_TABLE, this.showTableButton);
            buttonsMap.put(BTN_REFRESH, this.refreshButton);
            buttonsMap.put(BTN_JUMP, this.jumpButton);
            buttonsMap.put(BTN_SHOW_BILL, this.showBillButton);
            this.scroll.onLoad(this.instID, buttonsMap, this);
            this.processImage = this.scroll.getWorkFlowMonitorPanel().image;
            this.setActivityInstInfo();
            this.workflowTable.addKDTMouseListener((KDTMouseListener)new WorkflowListener());
            this.initWorkflowTable(this.workflowTable, this.workflowMonitorUI);
            String defaultFileName = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WfMonitorResources", (String)"monitorWindowTitle");
            if (this.processInstInfo != null && this.processInstInfo.getCode() != null && !this.processInstInfo.getCode().equals("")) {
                defaultFileName = defaultFileName + "_" + this.processInstInfo.getCode();
            }
            String procInstId = this.processImage.getProcInstId();
            IWfMonitorExt ext = this.scroll.getWorkFlowMonitorPanel().wfMonitorExt;
            if (ext != null) {
                ext.setToolBar(this.toolBar);
            }
            WfUtils.addExportImgButton(this.toolBar, procInstId, defaultFileName, (Component)((Object)this));
            WfUtils.addExportKpdlButton(this.toolBar, procInstId, defaultFileName, (Component)((Object)this));
            if (ConfigLoader.getConfig4Client().getBoolean("wf.monitor.is.support.next.person", null, "false") && "administrator".equalsIgnoreCase((userInfo = SysContext.getSysContext().getCurrentUserInfo()).getNumber())) {
                WfUtils.addNextPersonButton(this.toolBar, procInstId, defaultFileName, (Component)((Object)this));
            }
            this.toolBar.add((Component)this.traceButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        }
        catch (Exception e) {
            if (!(e instanceof AbortException)) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.handleException(e);
            }
            this.abort();
        }
    }

    public void setActivityInstInfo() throws Exception {
        int i;
        this.processImage = this.scroll.getWorkFlowMonitorPanel().image;
        ActivityInstInfo[] activities = this.processImage.getActivityInstInfos();
        IProcessImage.Activity[] activity = this.processImage.getActivities();
        for (i = 0; i < activity.length; ++i) {
            String activityId = activity[i].getActDefId();
            this.activityMap.put(activityId, activity[i]);
        }
        for (i = 0; i < activities.length; ++i) {
            ActivityInstInfo info = activities[i];
            String actInstId = info.getActInstId();
            this.activityInfoMap.put(actInstId, info);
        }
        this.workflowMonitorUI.setActivitiesMap(this.activityMap);
        this.workflowMonitorUI.setActivityInfoMap(this.activityInfoMap);
        ArrayList activitiesList = this.sortProcessInstList(activities);
        ArrayList activityUiInfoList = this.convettoUiObject(activitiesList);
        this.workflowMonitorUI.setActivitiesUI(activityUiInfoList);
        this.workflowTable = this.workflowMonitorUI.getWorkFlowTable();
    }

    void refreshMoniterTable() throws Exception {
        this.setActivityInstInfo();
        this.workflowMonitorUI.refreshTable();
        this.workflowTable.updateUI();
    }

    public void initWorkflowTable(KDTable workflowTable, WorkFlowMonitorUI workflowMonitorUI) {
        List activityList = workflowMonitorUI.filterAutoActivities();
        workflowMonitorUI.fillTable(activityList);
        workflowMonitorUI.initColumn();
        workflowTable.updateUI();
    }

    private ArrayList sortProcessInstList(ActivityInstInfo[] activities) {
        int i;
        ArrayList<ActivityInstInfo> list = new ArrayList<ActivityInstInfo>();
        HashMap[] map = new HashMap[activities.length];
        for (i = 0; i < activities.length; ++i) {
            map[i] = new HashMap();
            map[i].put("createdTime", activities[i].getCreatedTime().toString());
            map[i].put("active", activities[i]);
        }
        Arrays.sort(map, new Comparator(){

            public int compare(Object o1, Object o2) {
                String n1 = (String)((HashMap)o1).get("createdTime");
                String n2 = (String)((HashMap)o2).get("createdTime");
                return collator.compare(n1, n2);
            }
        });
        for (i = 0; i < map.length; ++i) {
            list.add((ActivityInstInfo)map[i].get("active"));
        }
        return list;
    }

    public ArrayList convettoUiObject(ArrayList activitys) throws Exception {
        int count = activitys.size();
        ArrayList<ActivityUiInfo> activitiesUI = new ArrayList<ActivityUiInfo>();
        for (int i = 0; i < count; ++i) {
            ActivityUiInfo info = new ActivityUiInfo();
            ActivityInstInfo instInfo = (ActivityInstInfo)activitys.get(i);
            instInfo.getActInstInfo().setDefaultLocale(this.getCurrentLocale());
            info.setActivityName(StringUtils.cnulls((String)this.convertType(instInfo.getActInstInfo().getActDefName(this.getCurrentLocale()))));
            String[] prevInstanceIds = instInfo.getPreActInstList();
            String prevText = this.getInstanceNameByIds(prevInstanceIds);
            info.setPreActInst(prevText);
            String[] nextInstanceIds = instInfo.getPostActInstList();
            String nextText = this.getInstanceNameByIds(nextInstanceIds);
            info.setPostActInst(nextText);
            IProcessImage.Activity activity = (IProcessImage.Activity)this.activityMap.get(instInfo.getActDefId());
            String activityType = "";
            if (activity != null) {
                activityType = activity.getTypeName();
            }
            info.setActivityType(StringUtils.cnulls((String)this.convertType(activityType)));
            info.setCreatedTime(instInfo.getCreatedTime());
            info.setCompleteTime(instInfo.getCompleteTime());
            long consumeTime = 0L;
            if (instInfo.getCompleteTime() != null && instInfo.getCreatedTime() != null) {
                consumeTime = instInfo.getCompleteTime().getTime() - instInfo.getCreatedTime().getTime();
            }
            info.setConsumeTime(this.longToTime(consumeTime));
            if (info.getActivityType() != null && info.getActivityType().equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"subProcess"))) {
                info.setProcInstId(instInfo.getSubProcInstId());
            } else {
                info.setProcInstId(instInfo.getProcInstId());
            }
            info.setActivityInstId(instInfo.getActInstId());
            info.setActivityState(StringUtils.cnulls((String)this.convertState(instInfo)));
            activitiesUI.add(info);
        }
        return activitiesUI;
    }

    private String longToTime(long time) {
        long hour = time / 3600000L;
        long left = time % 3600000L;
        long minite = left / 60000L;
        long second = (left %= 60000L) / 1000L;
        String retVal = this.formatLong(hour) + ":" + this.formatLong(minite) + ":" + this.formatLong(second);
        if (retVal.charAt(0) == '0') {
            retVal = retVal.substring(1);
        }
        return retVal;
    }

    private String formatLong(long m) {
        String retVal = Long.toString(m);
        if ((double)m < 10.0) {
            retVal = "0" + Long.toString(m);
        }
        return retVal;
    }

    private String convertType(String type) {
        if (ActivityType.ROUTER.getName().equals(type)) {
            return ActivityType.ROUTER.getAlias(this.getLocale());
        }
        if (ActivityType.SUBFLOW.getName().equals(type)) {
            return ActivityType.SUBFLOW.getAlias(this.getLocale());
        }
        if (ActivityType.MANPOWER.getName().equals(type)) {
            return ActivityType.MANPOWER.getAlias(this.getLocale());
        }
        if (ActivityType.TOOL.getName().equals(type)) {
            return ActivityType.TOOL.getAlias(this.getLocale());
        }
        return type;
    }

    private String convertState(ActivityInstInfo activityInstInfo) throws BOSException {
        String state = activityInstInfo.getState();
        if (WfState.NOT_STARTED.getValue().equals(state)) {
            return WfState.NOT_STARTED.getAlias(this.getLocale());
        }
        if (WfState.SUSPENDED.getValue().equals(state)) {
            return WfState.SUSPENDED.getAlias(this.getLocale());
        }
        if (WfState.RUNNING.getValue().equals(state)) {
            return WfState.RUNNING.getAlias(this.getLocale());
        }
        if (WfState.COMPLETED.getValue().equals(state)) {
            return WfState.COMPLETED.getAlias(this.getLocale());
        }
        if (WfState.ABORTED.getValue().equals(state)) {
            return WfState.ABORTED.getAlias(this.getLocale());
        }
        if (WfState.TERMINATED.getValue().equals(state)) {
            return WfState.TERMINATED.getAlias(this.getLocale());
        }
        if (WfState.NOT_RUNNING.getValue().equals(state)) {
            return WfState.NOT_RUNNING.getAlias(this.getLocale());
        }
        if (WfState.BLOCKED.getValue().equals(state)) {
            return WfState.SUSPENDED.getAlias(this.getLocale());
        }
        if (WfState.ROLLBACKED.getValue().equals(state)) {
            return WfState.ROLLBACKED.getAlias(this.getLocale());
        }
        return state;
    }

    private String getInstanceNameByIds(String[] instanceIds) {
        StringBuffer str = new StringBuffer();
        String activeNames = null;
        if (instanceIds != null) {
            int m = instanceIds.length;
            for (int i = 0; i < m; ++i) {
                str.append(",");
                String tmpId = instanceIds[i];
                ActivityInstInfo info = (ActivityInstInfo)this.activityInfoMap.get(tmpId);
                if (info == null) continue;
                String name = info.getActInstInfo().getActDefName(this.getCurrentLocale());
                str.append(name);
            }
        }
        if (str.length() > 0) {
            activeNames = str.toString();
            activeNames = activeNames.substring(1);
        }
        return activeNames;
    }

    public String getUITitle() {
        String title = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WfMonitorResources", (String)"monitorWindowTitle");
        if (this.processInstInfo != null && this.processInstInfo.getCode() != null && !this.processInstInfo.getCode().equals("")) {
            title = title + "(" + this.processInstInfo.getCode() + ")";
        }
        return title;
    }

    public boolean isPrepareInit() {
        return false;
    }

    static {
        logger = Logger.getLogger(BasicWorkFlowMonitorPanel.class);
    }

    public class WorkflowListener
    implements KDTMouseListener {
        public void tableClicked(KDTMouseEvent e) {
            IProcessImage.Activity act = null;
            String actDefId = null;
            String actInstId = null;
            if (e.getType() == 1) {
                IRow row = BasicWorkFlowMonitorPanel.this.workflowTable.getRow(e.getRowIndex());
                if (row == null) {
                    return;
                }
                JViewport port = BasicWorkFlowMonitorPanel.this.scroll.getViewport();
                ActivityInstInfo instInfo = (ActivityInstInfo)row.getUserObject();
                actDefId = instInfo.getActDefId();
                actInstId = instInfo.getActInstId();
                IProcessImage.Activity[] activity = BasicWorkFlowMonitorPanel.this.processImage.getActivities();
                for (int i = 0; i < activity.length; ++i) {
                    KDLabel label;
                    if (!activity[i].getActDefId().equals(actDefId)) continue;
                    int p = BasicWorkFlowMonitorPanel.this.processImage.getOffsetX();
                    int q = BasicWorkFlowMonitorPanel.this.processImage.getOffsetY();
                    act = activity[i];
                    int x = act.getBound().x + p + act.getBound().width / 2;
                    int y = act.getBound().y + q + act.getBound().height / 2;
                    if (selectedLabel != null) {
                        selectedLabel.setBorder(BorderFactory.createEmptyBorder());
                    }
                    if (WorkFlowMonitorPanel.selectedLabel != null) {
                        WorkFlowMonitorPanel.selectedLabel.setBorder(BorderFactory.createEmptyBorder());
                    }
                    selectedLabel = label = BasicWorkFlowMonitorPanel.this.scroll.getWorkFlowMonitorPanel().getActLabel(actDefId);
                    label.setBorder(BorderFactory.createLineBorder(Color.black));
                    if (e.getClickCount() != 1) continue;
                    BasicWorkFlowMonitorPanel.this.scroll.getHorizontalScrollBar().setValue(x - port.getSize().width / 2);
                    BasicWorkFlowMonitorPanel.this.scroll.getVerticalScrollBar().setValue(y - port.getSize().height / 2);
                }
                if (e.getClickCount() == 2) {
                    if (act == null) {
                        return;
                    }
                    BasicWorkFlowMonitorPanel.this.scroll.getWorkFlowMonitorPanel().showPropertyDialog(act.actInstIds, actDefId, actInstId);
                }
            }
        }
    }
}

