/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.monitor.EditConfigCollection;
import com.kingdee.bos.workflow.monitor.EditConfigInfo;
import com.kingdee.bos.workflow.monitor.SummaryInfo;
import com.kingdee.bos.workflow.monitor.SummaryItemInfo;
import com.kingdee.bos.workflow.monitor.client.AbstractBillDigestEditConfigUI;
import com.kingdee.bos.workflow.monitor.client.ActSelectorDialogUI;
import com.kingdee.bos.workflow.monitor.client.BillDigestEditUI;
import com.kingdee.bos.workflow.monitor.util.BillDigestUtils;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BillDigestEditConfigUI
extends AbstractBillDigestEditConfigUI {
    private static final long serialVersionUID = -1391334316767694939L;
    private static final Logger logger = CoreUIObject.getLogger(BillDigestEditConfigUI.class);
    private SummaryInfo summaryInfobak = new SummaryInfo();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    @Override
    public void initUIContentLayout() {
        SummaryInfo summary = (SummaryInfo)this.getUIContext().get("summary");
        this.summaryInfobak = BillDigestUtils.deepClone(summary);
        super.initUIContentLayout();
        this.addBtnListener();
        this.initValueTree();
    }

    public void initValueTree() {
        this.valueTree.setModel((TreeModel)this.getUIContext().get("treemodel"));
        this.valueTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SummaryItemInfo item;
                BillDigestEditConfigUI.this.configTable.removeRows();
                TreePath path = BillDigestEditConfigUI.this.valueTree.getSelectionPath();
                if (path == null) {
                    return;
                }
                Object obj = path.getLastPathComponent();
                Object object = ((DefaultKingdeeTreeNode)obj).getUserObject();
                if (object instanceof SummaryItemInfo && (item = (SummaryItemInfo)object).getEditConfig().size() > 0) {
                    EditConfigCollection collection = item.getEditConfig();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        EditConfigInfo info = (EditConfigInfo)iterator.next();
                        try {
                            BillDigestEditConfigUI.this.addTableRow(info.getActdefid(), BillDigestEditConfigUI.this.getActDefNameByActDefID(info.getActdefid(), info.getProcDefId()), info.getProcDefId(), BillDigestEditConfigUI.this.getProcNameByProcDefId(info.getProcDefId()));
                        }
                        catch (BOSException e1) {
                            logger.error((Object)e1);
                        }
                    }
                }
            }
        });
    }

    public void addBtnListener() {
        this.btnAdd.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Object userObj;
                    TreePath path = BillDigestEditConfigUI.this.valueTree.getSelectionPath();
                    if (path == null) {
                        MsgBox.showError((String)BillDigestUtils.getResString("selectFieldInfo"));
                        return;
                    }
                    Object obj = path.getLastPathComponent();
                    if (obj instanceof DefaultKingdeeTreeNode && !((userObj = ((DefaultKingdeeTreeNode)obj).getUserObject()) instanceof SummaryItemInfo)) {
                        MsgBox.showError((String)BillDigestUtils.getResString("selectFieldInfo"));
                        return;
                    }
                    BillDigestEditConfigUI.this.openActSelectorUI();
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                    e1.printStackTrace();
                }
            }
        });
        this.btnDel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BillDigestEditConfigUI.this.deleteConfig();
            }
        });
        this.btnCancle.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BillDigestEditConfigUI.this.getUIContext().put("summary", BillDigestEditConfigUI.this.summaryInfobak);
                BillDigestEditUI parentUI = (BillDigestEditUI)((Object)BillDigestEditConfigUI.this.getUIContext().get("billDigestEditUI"));
                parentUI.summary = null;
                parentUI.summary = BillDigestEditConfigUI.this.summaryInfobak;
                parentUI.refreshSummaryTree(null, 2);
                BillDigestEditConfigUI.this.getUIWindow().close();
            }
        });
        this.btnConfirm.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BillDigestEditConfigUI.this.getUIWindow().close();
            }
        });
    }

    public void openActSelectorUI() throws Exception {
        IUIFactory uiFactory = null;
        try {
            this.getUIContext().put("parentUI", this);
            this.getUIContext().put("summary", this.summaryInfobak);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(ActSelectorDialogUI.class.getName(), this.getUIContext(), null, OprtState.VIEW);
            curDialog.show();
        }
        catch (UIException ex1) {
            logger.error((Object)ex1);
        }
    }

    public void refreshTable(Map acts) {
        if (acts == null) {
            return;
        }
        Set keySet = acts.keySet();
        if (keySet.size() == 0) {
            return;
        }
        String procDefName = (String)acts.get("procDefName");
        String procDefId = (String)acts.get("procDefId");
        for (String key : keySet) {
            String actName = (String)acts.get(key);
            if ("procDefId".equals(key) || "procDefName".equals(key)) continue;
            this.addTableRow(key, actName, procDefId, procDefName);
            this.refreshSummary(key, procDefId);
        }
        KDTableUtil.setSelectedRow((KDTable)this.configTable, (int)0);
    }

    public void refreshSummary(String actDefId, String procDefID) {
        Object userObj;
        Object obj;
        TreePath path = this.valueTree.getSelectionPath();
        if (path != null && (obj = path.getLastPathComponent()) instanceof DefaultKingdeeTreeNode && (userObj = ((DefaultKingdeeTreeNode)obj).getUserObject()) instanceof SummaryItemInfo) {
            SummaryItemInfo item = (SummaryItemInfo)userObj;
            EditConfigCollection tempCollection = new EditConfigCollection();
            if (item.getEditConfig() != null && item.getEditConfig().size() > 0) {
                EditConfigCollection editConfigCollection = item.getEditConfig();
                if (item.getName() != null) {
                    Boolean flag = true;
                    Iterator iterator = editConfigCollection.iterator();
                    while (iterator.hasNext()) {
                        EditConfigInfo editinfo = (EditConfigInfo)iterator.next();
                        if (!actDefId.equals(editinfo.getActdefid())) continue;
                        flag = false;
                        break;
                    }
                    if (flag.booleanValue()) {
                        EditConfigInfo tempeditinfo = new EditConfigInfo();
                        tempeditinfo.setActdefid(actDefId);
                        tempeditinfo.setProcDefId(procDefID);
                        tempCollection.add(tempeditinfo);
                    }
                }
            } else {
                EditConfigInfo info = new EditConfigInfo();
                info.setActdefid(actDefId);
                info.setProcDefId(procDefID);
                tempCollection.add(info);
            }
            item.getEditConfig().addCollection(tempCollection);
        }
    }

    public void refreshData(Map acts) {
        this.refreshTable(acts);
    }

    public void addTableRow(String actDefId, String actDefName, String procDefId, String procDefName) {
        IRow row;
        int rowNum = this.configTable.getRowCount();
        for (int i = 0; i < rowNum; ++i) {
            row = this.configTable.getRow(i);
            String tempActDefId = (String)row.getCell("actDefId").getValue();
            if (!actDefId.equals(tempActDefId)) continue;
            return;
        }
        row = this.configTable.addRow();
        ICell cell = row.getCell("actDefId");
        cell.setValue((Object)actDefId);
        cell = row.getCell("actDefName");
        cell.setValue((Object)actDefName);
        cell = row.getCell("procDefId");
        cell.setValue((Object)procDefId);
        cell = row.getCell("procDefName");
        cell.setValue((Object)procDefName);
    }

    public void deleteConfig() {
        int[] rowNumbers = KDTableUtil.getSelectedRows((KDTable)this.configTable);
        for (int j = rowNumbers.length - 1; j >= 0; --j) {
            IRow row = this.configTable.getRow(j);
            this.configTable.removeRow(rowNumbers[j]);
            this.innerDeleteCOnfig((String)row.getCell("actDefId").getValue());
        }
    }

    public void innerDeleteCOnfig(String actDefId) {
        TreePath path = this.valueTree.getSelectionPath();
        Object obj = path.getLastPathComponent();
        Object object = ((DefaultKingdeeTreeNode)obj).getUserObject();
        if (object instanceof SummaryItemInfo) {
            SummaryItemInfo item = (SummaryItemInfo)object;
            EditConfigCollection collection = item.getEditConfig();
            EditConfigCollection tempCollcetion = new EditConfigCollection();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                EditConfigInfo configinfo = (EditConfigInfo)iterator.next();
                if (StringUtils.isEmpty((String)actDefId) || actDefId.equals(configinfo.getActdefid())) continue;
                tempCollcetion.add(configinfo);
            }
            item.setEditConfig(tempCollcetion);
        }
    }

    private String getProcNameByProcDefId(String procDefId) throws BOSException {
        IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
        ProcessDefInfo procdefinfo = enactmentService.getProcessDefInfo(procDefId);
        return procdefinfo.getProcDefName(new Locale("L2"));
    }

    private String getActDefNameByActDefID(String actDefId, String procId) throws BOSException {
        IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
        ProcessDefInfo procdefinfo = enactmentService.getProcessDefInfo(procId);
        ProcessDef def = enactmentService.getProcessDefByDefineHashValue(procdefinfo.getMd5HashValue());
        ActivityCollection actColl = def.getActivitys();
        for (int i = 0; i < actColl.size(); ++i) {
            ActivityDef actdef = actColl.get(i);
            if (!(actdef instanceof ApproveActivityDef) || !actDefId.equals(actdef.getID())) continue;
            return actdef.getName(new Locale("L2"));
        }
        return null;
    }

    public Boolean modifyProc(String procDefId) throws BOSException, SQLException {
        String sql = "select top 1 FBILLENTITY from T_WFR_Assign where FPROCDEFID = '" + procDefId + "' union select top 1 FBILLENTITY from T_WFR_AssignDetail where FPROCDEFID = '" + procDefId + "'";
        SQLExecutor se = new SQLExecutor(sql);
        IRowSet rowSet = se.executeSQL();
        String tempMetaDataPK = null;
        while (rowSet.next()) {
            tempMetaDataPK = rowSet.getString("FBILLENTITY");
        }
        String metadataPK = this.summaryInfobak.getMetadataPK();
        if (metadataPK != null && metadataPK.equals(tempMetaDataPK)) {
            return true;
        }
        return false;
    }
}

