/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDColorChooser;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.monitor.BillDigestEnum;
import com.kingdee.bos.workflow.monitor.BillDigestFactory;
import com.kingdee.bos.workflow.monitor.BillDigestInfo;
import com.kingdee.bos.workflow.monitor.BillDigestSchemaEntryInfo;
import com.kingdee.bos.workflow.monitor.BillDigestSchemaFactory;
import com.kingdee.bos.workflow.monitor.BillDigestSchemaInfo;
import com.kingdee.bos.workflow.monitor.BillDigestScriptInfo;
import com.kingdee.bos.workflow.monitor.IBillDigest;
import com.kingdee.bos.workflow.monitor.IBillDigestSchema;
import com.kingdee.bos.workflow.monitor.IBillDigestUpdater;
import com.kingdee.bos.workflow.monitor.PropertyTypeEnum;
import com.kingdee.bos.workflow.monitor.SummaryInfo;
import com.kingdee.bos.workflow.monitor.SummaryItemInfo;
import com.kingdee.bos.workflow.monitor.client.AbstractBillDigestEditUI;
import com.kingdee.bos.workflow.monitor.client.AddUserDefineFieldDilog;
import com.kingdee.bos.workflow.monitor.client.BillDigestEditConfigUI;
import com.kingdee.bos.workflow.monitor.client.BillDigestPreviewDialog;
import com.kingdee.bos.workflow.monitor.client.BillDigestSchemaUI;
import com.kingdee.bos.workflow.monitor.client.EntityTreeBuilder;
import com.kingdee.bos.workflow.monitor.client.MutilanDialog;
import com.kingdee.bos.workflow.monitor.client.ScriptEditDialog;
import com.kingdee.bos.workflow.monitor.client.ValueMappingUI;
import com.kingdee.bos.workflow.monitor.util.BillDigestUtils;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BillDigestEditUI
extends AbstractBillDigestEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BillDigestEditUI.class);
    private EntityObjectInfo entity;
    public SummaryInfo summary;
    private KDPopupMenu popMenu = new KDPopupMenu();
    private JMenuItem mappingMenu;
    private UIContext uiContext = new UIContext((Object)this);
    private List<SummaryInfo> summarySchema;
    private KDWorkButton up;
    private KDWorkButton down;
    private KDWorkButton copy;
    private KDWorkButton del;
    private KDWorkButton distribute;
    private Object editObject;

    public BillDigestEditUI() throws Exception {
        this.checkPermission();
    }

    public void checkPermission() throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getRemoteInstance();
        permission.checkFunctionPermission(this.getUserPk(), this.getOrgPK(), "wf_Monitor_BillDigest");
    }

    public IObjectPK getUserPk() {
        ObjectUuidPK userPK = null;
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (userInfo != null) {
            userPK = new ObjectUuidPK(userInfo.getId());
        }
        return userPK;
    }

    public IObjectPK getOrgPK() {
        ObjectUuidPK orgPK = null;
        OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit();
        if (org != null) {
            orgPK = new ObjectUuidPK(org.getId());
        }
        return orgPK;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.buildEntityTree();
        this.buildPropertyTree();
        this.initValueTree();
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillDigestEditUI.this.addSummaryActionPerform();
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillDigestEditUI.this.removeSummaryActionPerform();
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BillDigestEditUI.this.saveActionPerform();
                }
                catch (Exception t) {
                    BillDigestEditUI.this.handUIException(t);
                }
            }
        });
        this.kDTreeView3.getControlPane().removeAll();
        this.initMoveUpButton();
        this.initMoveDownButton();
        this.initAddSchemaBtn();
        this.initDelSchemaBtn();
        this.initShowDistributeBtn();
        this.initCopyBtn();
        this.initKDTable();
        this.initAddUserDefineFieldBtn();
        this.regestkeyBorderListener();
    }

    private void initValueTree() {
        this.valueTree.setShowCheckBox(true);
        this.valueTree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
                Object obj = node.getUserObject();
                if (obj instanceof SummaryItemInfo) {
                    BillDigestEditUI.this.kDTreeView3.getControlPane();
                    TreeNode pnode = node.getParent();
                    DefaultKingdeeTreeNode parentnode = (DefaultKingdeeTreeNode)pnode;
                    Object pobj = parentnode.getUserObject();
                    int previewNum = 3;
                    if (pobj instanceof SummaryInfo) {
                        SummaryInfo info = (SummaryInfo)pobj;
                        previewNum = info.getPreviewNum();
                    }
                    int count = 0;
                    for (int i = 0; i < pnode.getChildCount(); ++i) {
                        DefaultKingdeeTreeNode cnode = (DefaultKingdeeTreeNode)pnode.getChildAt(i);
                        Object cobj = cnode.getUserObject();
                        if (cobj instanceof SummaryItemInfo && ((SummaryItemInfo)cobj).isPreview()) {
                            ++count;
                        }
                        if (count <= previewNum || !node.isChecked()) continue;
                        node.setChecked(false);
                        return;
                    }
                    ((SummaryItemInfo)obj).setPreview(node.isChecked());
                }
            }
        });
        this.refreshSummaryTree(this.summary, 2);
        this.valueTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 1) {
                    BillDigestEditUI.this.summary = BillDigestEditUI.this.getSummary();
                    BillDigestEditUI.this.refreshSummaryDetailTable();
                }
            }
        });
    }

    private void initShowDistributeBtn() {
        this.distribute = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_distributeuser"));
        this.distribute.setToolTipText(BillDigestUtils.getResString("ditributeschema"));
        this.kDTreeView3.getControlPane().add((Component)this.distribute);
        this.distribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoreBaseCollection cols = BillDigestEditUI.this.createSchema(BillDigestEditUI.this.summarySchema);
                boolean flag = BillDigestEditUI.this.canDistribute(cols);
                if (!flag) {
                    MsgBox.showInfo((String)BillDigestUtils.getResString("saveSchemaWarn"));
                    return;
                }
                BillDigestEditUI.this.uiContext.put((Object)"parent", (Object)this);
                BillDigestEditUI.this.uiContext.put((Object)"treemodel", (Object)BillDigestEditUI.this.valueTree.getModel());
                IUIFactory uiFactory = null;
                try {
                    uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                    IUIWindow curDialog = uiFactory.create(BillDigestSchemaUI.class.getName(), (Map)BillDigestEditUI.this.uiContext, null, OprtState.VIEW);
                    curDialog.show();
                }
                catch (UIException ex1) {
                    logger.error((Object)ex1);
                }
            }
        });
    }

    private void initKDTable() {
        this.kDTable1.addKDTEditListener(new KDTEditListener(){

            public void editCanceled(KDTEditEvent arg0) {
            }

            public void editStarted(KDTEditEvent arg0) {
            }

            public void editStarting(KDTEditEvent arg0) {
                TreePath path;
                Object obj;
                TreePath[] paths;
                if (arg0.getColIndex() == 1 && (paths = BillDigestEditUI.this.valueTree.getSelectionPaths()) != null && paths.length > 0 && (obj = (path = paths[0]).getLastPathComponent()) instanceof DefaultKingdeeTreeNode) {
                    Object userObj = ((DefaultKingdeeTreeNode)obj).getUserObject();
                    BillDigestEditUI.this.editObject = userObj;
                    IRow row = BillDigestEditUI.this.kDTable1.getRow(arg0.getRowIndex());
                    String pType = (String)row.getCell("propertyName").getValue();
                    if (userObj instanceof SummaryItemInfo) {
                        SummaryItemInfo item = (SummaryItemInfo)userObj;
                        if (PropertyTypeEnum.FONTCOLOR.getType().equals(pType)) {
                            item.setFontColor(BillDigestEditUI.this.getColor());
                        } else if (PropertyTypeEnum.EDITSCRIPT.getType().equals(pType)) {
                            BillDigestScriptInfo info = item.getScript().get(0);
                            if (info == null) {
                                info = new BillDigestScriptInfo();
                                item.setUserScript(info);
                            }
                            String script = ScriptEditDialog.getScript(info.getContent());
                            if (!BillDigestUtils.getResString("pleaseEditScript").equals(script)) {
                                info.setContent(script);
                            }
                        }
                        BillDigestEditUI.this.refreshSummaryTree(BillDigestEditUI.this.summary, 2);
                        BillDigestEditUI.this.refreshSummaryDetailTable();
                    }
                }
            }

            public void editStopped(KDTEditEvent arg0) {
                TreePath path;
                Object obj;
                TreePath[] paths;
                if (arg0.getColIndex() == 1 && (paths = BillDigestEditUI.this.valueTree.getSelectionPaths()) != null && paths.length > 0 && (obj = (path = paths[0]).getLastPathComponent()) instanceof DefaultKingdeeTreeNode) {
                    Object userObj = ((DefaultKingdeeTreeNode)obj).getUserObject();
                    if (!userObj.equals(BillDigestEditUI.this.editObject)) {
                        return;
                    }
                    BillDigestUtils.NodeType type = BillDigestEditUI.this.getNodeType((DefaultKingdeeTreeNode)obj);
                    IRow row = BillDigestEditUI.this.kDTable1.getRow(arg0.getRowIndex());
                    String pType = (String)row.getCell("propertyName").getValue();
                    if (BillDigestUtils.NodeType.ITEM == type) {
                        SummaryItemInfo item = (SummaryItemInfo)userObj;
                        if (PropertyTypeEnum.ALIAS.getType().equals(pType)) {
                            item.setAlias((String)arg0.getValue());
                        } else if (!PropertyTypeEnum.NAME.getType().equals(pType)) {
                            if (PropertyTypeEnum.FONTCOLOR.getType().equals(pType)) {
                                if (item.getFontColor() != null) {
                                    BillDigestEditUI.this.kDTable1.getCell(arg0.getRowIndex(), arg0.getColIndex()).setValue((Object)item.getFontColor());
                                }
                            } else if (PropertyTypeEnum.SHOWIFNULL.getType().equals(pType)) {
                                String str = (String)arg0.getValue();
                                if (BooleanEnum.YES.getTypeAlias().equals(str)) {
                                    item.setShowIfNull(true);
                                } else {
                                    item.setShowIfNull(false);
                                }
                            } else if (PropertyTypeEnum.DATEFORMATE.getType().equals(pType) || PropertyTypeEnum.NUMBERPRECISION.getType().equals(pType)) {
                                item.setShowFormate((String)arg0.getValue());
                            } else if (PropertyTypeEnum.ISSORTEDITEM.getType().equals(pType)) {
                                String str = (String)arg0.getValue();
                                if (BooleanEnum.YES.getTypeAlias().equals(str)) {
                                    item.setIsSortedItem(true);
                                } else {
                                    item.setIsSortedItem(false);
                                }
                            } else if (PropertyTypeEnum.CANSUMMARY.getType().equals(pType)) {
                                String str = (String)arg0.getValue();
                                if (BooleanEnum.YES.getTypeAlias().equals(str)) {
                                    item.setCanSummary(true);
                                } else {
                                    item.setCanSummary(false);
                                }
                            }
                        }
                        BillDigestEditUI.this.refreshSummaryTree(BillDigestEditUI.this.summary, 2);
                    } else if (BillDigestUtils.NodeType.SCHEMA == type) {
                        if (PropertyTypeEnum.ALIAS.getType().equals(pType)) {
                            BillDigestEditUI.this.summary.setAlias((String)arg0.getValue());
                        } else if (PropertyTypeEnum.ISMOBILEAPPROVE.getType().equals(pType)) {
                            String str = (String)arg0.getValue();
                            if (BooleanEnum.YES.getTypeAlias().equals(str)) {
                                BillDigestEditUI.this.summary.setIsMobileApprove(true);
                            } else {
                                BillDigestEditUI.this.summary.setIsMobileApprove(false);
                            }
                        } else if (PropertyTypeEnum.NEEDVALIDATE.getType().equals(pType)) {
                            String str = (String)arg0.getValue();
                            if (BooleanEnum.YES.getTypeAlias().equals(str)) {
                                BillDigestEditUI.this.summary.setNeedValidate(true);
                            } else {
                                BillDigestEditUI.this.summary.setNeedValidate(false);
                            }
                        } else if (PropertyTypeEnum.ISDEFAULTSCEHMA.getType().equals(pType)) {
                            String str = (String)arg0.getValue();
                            if (BooleanEnum.YES.getTypeAlias().equals(str)) {
                                BillDigestEditUI.this.changeDefalutSchema();
                            } else {
                                String alias = BillDigestEditUI.this.summary.getAlias();
                                String defaultSchemastr = BillDigestUtils.getResString("defaultshcema");
                                if (!StringUtils.isEmpty((String)alias) && alias.indexOf(defaultSchemastr) != -1) {
                                    int index1 = alias.indexOf(defaultSchemastr);
                                    alias = alias.substring(0, index1);
                                    BillDigestEditUI.this.summary.setAlias(alias);
                                }
                                BillDigestEditUI.this.summary.setdefault(false);
                            }
                        } else if (PropertyTypeEnum.DIGESTTYPE.getType().equals(pType)) {
                            BillDigestEnum benum = (BillDigestEnum)((Object)arg0.getValue());
                            BillDigestEditUI.this.summary.setDigType(benum);
                        }
                        BillDigestEditUI.this.refreshSummaryTree(null, 2);
                    } else if (BillDigestUtils.NodeType.ENTRY == type) {
                        SummaryInfo entry = (SummaryInfo)userObj;
                        if (PropertyTypeEnum.ALIAS.getType().equals(pType)) {
                            entry.setAlias((String)arg0.getValue());
                        } else if (PropertyTypeEnum.PREVIEWNUM.getType().equals(pType)) {
                            int value = (Integer)arg0.getValue();
                            entry.setPreviewNum(value - 1);
                        } else if (PropertyTypeEnum.SORTEDTYPE.getType().equals(pType)) {
                            if (PropertyTypeEnum.ITEMASC.getTypeAlias().equals(arg0.getValue())) {
                                entry.setSortedType("0");
                            } else if (PropertyTypeEnum.ITEMDESC.getTypeAlias().equals(arg0.getValue())) {
                                entry.setSortedType("1");
                            } else if (PropertyTypeEnum.NOSORTING.getTypeAlias().equals(arg0.getValue())) {
                                entry.setSortedType("");
                            }
                        }
                        BillDigestEditUI.this.refreshSummaryTree(BillDigestEditUI.this.summary, 2);
                    } else if (BillDigestUtils.NodeType.ROOT == type) {
                        String metaDataPk = BillDigestEditUI.this.entity.getFullName();
                        String str = (String)arg0.getValue();
                        if (BooleanEnum.YES.getTypeAlias().equals(str)) {
                            BillDigestEditUI.this.uiContext.put((Object)metaDataPk, (Object)"1");
                        } else {
                            BillDigestEditUI.this.uiContext.put((Object)metaDataPk, (Object)"0");
                        }
                        BillDigestEditUI.this.refreshSummaryTree(null, 2);
                    }
                    row.getCell("propertyValue").setValue(arg0.getValue());
                }
                BillDigestEditUI.this.refreshSummaryDetailTable();
            }

            public void editStopping(KDTEditEvent arg0) {
            }

            public void editValueChanged(KDTEditEvent arg0) {
            }
        });
    }

    public String getColor() {
        Color selectColor = KDColorChooser.showDialog((Component)((Object)this), (String)BillDigestUtils.getResString("chosecolor"), null);
        if (selectColor == null) {
            return null;
        }
        return this.convertValueToHex(selectColor);
    }

    private void initMoveUpButton() {
        this.up = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.up.setToolTipText(BillDigestUtils.getResString("btn_up_txt"));
        this.kDTreeView3.getControlPane().add((Component)this.up);
        this.up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = BillDigestEditUI.this.valueTree.getSelectionRows();
                for (int i = 0; i < rows.length; ++i) {
                    TreePath path = BillDigestEditUI.this.valueTree.getPathForRow(rows[i]);
                    Object obj = path.getLastPathComponent();
                    if (!(obj instanceof DefaultKingdeeTreeNode)) continue;
                    BillDigestUtils.NodeType type = BillDigestEditUI.this.getNodeType((DefaultKingdeeTreeNode)obj);
                    if (BillDigestUtils.NodeType.ITEM == type) {
                        SummaryItemInfo item = (SummaryItemInfo)((DefaultKingdeeTreeNode)obj).getUserObject();
                        String group = item.getGroup();
                        SummaryInfo entry = StringUtils.isEmpty((String)group) ? BillDigestEditUI.this.summary : BillDigestEditUI.this.summary.getEntry(group);
                        List<SummaryItemInfo> items2 = entry.getSummaryItems();
                        int index = items2.indexOf(item);
                        if (index <= 0) continue;
                        SummaryItemInfo first = items2.get(index - 1);
                        items2.set(index - 1, item);
                        items2.set(index, first);
                        rows[i] = rows[i] - 1;
                        continue;
                    }
                    if (BillDigestUtils.NodeType.ENTRY != type) continue;
                    SummaryInfo entry1 = (SummaryInfo)((DefaultKingdeeTreeNode)obj).getUserObject();
                    String name = entry1.getName();
                    List<SummaryInfo> entrys = BillDigestEditUI.this.summary.getEntrys();
                    int j = 0;
                    while (i < entrys.size()) {
                        SummaryInfo entry = entrys.get(j);
                        String name2 = entry.getName();
                        if (name.equals(name2)) {
                            if (j == 0) break;
                            entry = entrys.get(j - 1);
                            entry1.setIndex(j - 1);
                            entry.setIndex(j);
                            rows[i] = rows[i] - entry.getSummaryItems().size() - 1;
                            break;
                        }
                        ++j;
                    }
                    Collections.sort(entrys);
                }
                BillDigestEditUI.this.refreshSummaryTree(BillDigestEditUI.this.summary, 2);
                BillDigestEditUI.this.valueTree.setSelectionRows(rows);
            }
        });
    }

    private void initMoveDownButton() {
        this.down = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.down.setToolTipText(BillDigestUtils.getResString("btn_down_txt"));
        this.kDTreeView3.getControlPane().add((Component)this.down);
        this.down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = BillDigestEditUI.this.valueTree.getSelectionRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    TreePath path = BillDigestEditUI.this.valueTree.getPathForRow(rows[i]);
                    Object obj = path.getLastPathComponent();
                    if (!(obj instanceof DefaultKingdeeTreeNode)) continue;
                    BillDigestUtils.NodeType type = BillDigestEditUI.this.getNodeType((DefaultKingdeeTreeNode)obj);
                    if (BillDigestUtils.NodeType.ITEM == type) {
                        SummaryItemInfo item = (SummaryItemInfo)((DefaultKingdeeTreeNode)obj).getUserObject();
                        String group = item.getGroup();
                        SummaryInfo entry = StringUtils.isEmpty((String)group) ? BillDigestEditUI.this.summary : BillDigestEditUI.this.summary.getEntry(group);
                        List<SummaryItemInfo> items2 = entry.getSummaryItems();
                        int index = items2.indexOf(item);
                        if (index < 0 || index >= items2.size() - 1) continue;
                        SummaryItemInfo next = items2.get(index + 1);
                        items2.set(index + 1, item);
                        items2.set(index, next);
                        rows[i] = rows[i] + 1;
                        continue;
                    }
                    if (BillDigestUtils.NodeType.ENTRY != type) continue;
                    SummaryInfo entry1 = (SummaryInfo)((DefaultKingdeeTreeNode)obj).getUserObject();
                    String name = entry1.getName();
                    List<SummaryInfo> entrys = BillDigestEditUI.this.summary.getEntrys();
                    for (int j = 0; j < entrys.size(); ++j) {
                        SummaryInfo entry = entrys.get(j);
                        if (j == entrys.size() - 1) break;
                        if (!name.equals(entry.getName())) continue;
                        entry = entrys.get(j + 1);
                        entry.setIndex(j);
                        entry1.setIndex(j + 1);
                        rows[i] = rows[i] + entry.getSummaryItems().size() + 1;
                        break;
                    }
                    Collections.sort(entrys);
                }
                BillDigestEditUI.this.refreshSummaryTree(BillDigestEditUI.this.summary, 2);
                BillDigestEditUI.this.valueTree.setSelectionRows(rows);
            }
        });
    }

    private void initAddSchemaBtn() {
        KDWorkButton add = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_new"));
        add.setToolTipText(BillDigestUtils.getResString("addschema"));
        this.kDTreeView3.getControlPane().add((Component)add);
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryInfo summary = BillDigestEditUI.this.createNewSchema();
                BillDigestEditUI.this.summarySchema.add(summary);
                BillDigestEditUI.this.refreshSummaryTree(null, 2);
            }
        });
    }

    private void initDelSchemaBtn() {
        this.del = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_delete"));
        this.del.setToolTipText(BillDigestUtils.getResString("btn_del_txt"));
        this.kDTreeView3.getControlPane().add((Component)this.del);
        this.del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BillDigestEditUI.this.summarySchema.size() > 1 && BillDigestEditUI.this.summary.isdefault()) {
                    MsgBox.showInfo((String)BillDigestUtils.getResString("deleteschemawarn"));
                    return;
                }
                int value = MsgBox.showConfirm2((Component)BillDigestEditUI.this.valueTree, (String)BillDigestUtils.getResString("suredelschema"));
                if (value == 0) {
                    BillDigestEditUI.this.summarySchema.remove(BillDigestEditUI.this.summary);
                    if (BillDigestEditUI.this.summary.getShcemaId() != null) {
                        BillDigestEditUI.this.deleteSummaryByPk(BillDigestEditUI.this.summary.getShcemaId());
                    }
                    if (BillDigestEditUI.this.summarySchema.size() == 0) {
                        SummaryInfo summary = BillDigestEditUI.this.createNewSchema();
                        summary.setdefault(true);
                        BillDigestEditUI.this.summarySchema.add(summary);
                    }
                }
                BillDigestEditUI.this.refreshSummaryTree(null, 2);
                BillDigestEditUI.this.summary = BillDigestEditUI.this.getSummary();
            }
        });
    }

    private void initCopyBtn() {
        this.copy = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_copy"));
        this.copy.setToolTipText(BillDigestUtils.getResString("btn_copy_txt"));
        this.kDTreeView3.getControlPane().add((Component)this.copy);
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String alias;
                SummaryInfo info = BillDigestUtils.deepClone(BillDigestEditUI.this.summary);
                info.setShcemaId(null);
                if (BillDigestEditUI.this.summary.isdefault()) {
                    info.setdefault(false);
                    alias = info.getAlias();
                    if (!StringUtils.isEmpty((String)alias) && alias.indexOf(BillDigestUtils.getResString("defaultshcema")) != -1) {
                        int index1 = alias.indexOf(BillDigestUtils.getResString("defaultshcema"));
                        alias = alias.substring(0, index1);
                    }
                    info.setAlias(alias);
                }
                if (!StringUtils.isEmpty((String)(alias = info.getAlias()))) {
                    info.setAlias(alias + BillDigestUtils.getResString("copy"));
                }
                BillDigestEditUI.this.summarySchema.add(info);
                BillDigestEditUI.this.refreshSummaryTree(null, 2);
            }
        });
    }

    private void initAddUserDefineFieldBtn() {
        KDWorkButton btn_addUserDefine = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_addline"));
        btn_addUserDefine.setToolTipText(BillDigestUtils.getResString("btn_addFiled_txt"));
        this.kDTreeView3.getControlPane().add((Component)btn_addUserDefine);
        btn_addUserDefine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BillDigestUtils.NodeType nodeType = BillDigestEditUI.this.getCurNodeType();
                if (BillDigestUtils.NodeType.SCHEMA == nodeType || BillDigestUtils.NodeType.ENTRY == nodeType) {
                    SummaryItemInfo item = new SummaryItemInfo();
                    item.setName("name");
                    item.setAlias("alias");
                    item = AddUserDefineFieldDilog.getItem(item);
                    if (item == null) {
                        return;
                    }
                    if (item != null) {
                        item.setUserDefine(true);
                    }
                    if (BillDigestUtils.NodeType.SCHEMA == nodeType) {
                        BillDigestEditUI.this.summary = BillDigestEditUI.this.getSummary();
                        BillDigestEditUI.this.summary.addSummaryItem(item);
                    } else {
                        TreePath[] paths = BillDigestEditUI.this.valueTree.getSelectionPaths();
                        if (paths == null || paths.length == 0) {
                            return;
                        }
                        for (int i = 0; i < paths.length; ++i) {
                            Object object;
                            TreePath path = paths[i];
                            Object obj = path.getLastPathComponent();
                            if (!(obj instanceof DefaultKingdeeTreeNode) || !((object = ((DefaultKingdeeTreeNode)obj).getUserObject()) instanceof SummaryInfo)) continue;
                            SummaryInfo entry = (SummaryInfo)object;
                            item.setGroup(entry.getName());
                            entry.addSummaryItem(item);
                        }
                    }
                    BillDigestEditUI.this.refreshSummaryTree(BillDigestEditUI.this.summary, 2);
                } else {
                    MsgBox.showInfo((Component)((Object)BillDigestEditUI.this), (String)BillDigestUtils.getResString("selectItemErr"));
                }
            }
        });
    }

    private void regestkeyBorderListener() {
        AbstractAction f7Listener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int value = MsgBox.showConfirm3((String)BillDigestUtils.getResString("UpgradeInfo"));
                if (value != 0) {
                    return;
                }
                if (value == 0) {
                    IBillDigestUpdater updater = BillDigestEditUI.this.getUpdater();
                    try {
                        updater.update();
                        MsgBox.showInfo((Component)((Object)BillDigestEditUI.this), (String)BillDigestUtils.getResString("UpgradeScucess"));
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        MsgBox.showError((Component)((Object)BillDigestEditUI.this), (String)e.getMessage());
                    }
                }
            }
        };
        AbstractAction f8Listener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object uiFactory = null;
                try {
                    BillDigestPreviewDialog.preview();
                }
                catch (Exception ex1) {
                    logger.error((Object)ex1);
                }
            }
        };
        AbstractAction f9Listener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IUIFactory uiFactory = null;
                BillDigestEditUI.this.uiContext.put((Object)"summary", (Object)BillDigestEditUI.this.summary);
                BillDigestEditUI.this.uiContext.put((Object)"treemodel", (Object)BillDigestEditUI.this.valueTree.getModel());
                try {
                    uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                    IUIWindow curDialog = uiFactory.create(BillDigestEditConfigUI.class.getName(), (Map)BillDigestEditUI.this.uiContext, null, OprtState.VIEW);
                    curDialog.show();
                }
                catch (UIException ex1) {
                    logger.error((Object)ex1);
                }
            }
        };
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(2);
        actionMap.put("F7 Key Action", f7Listener);
        actionMap.put("F8 Key Action", f8Listener);
        actionMap.put("F9 Key Action", f9Listener);
        KeyStroke f7 = KeyStroke.getKeyStroke("F7");
        KeyStroke f9 = KeyStroke.getKeyStroke("F9");
        KeyStroke f8 = KeyStroke.getKeyStroke("F8");
        inputMap.put(f7, "F7 Key Action");
        inputMap.put(f9, "F9 Key Action");
        inputMap.put(f8, "F8 Key Action");
        this.uiContext.put((Object)"billDigestEditUI", (Object)this);
        AbstractAction f2Listener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] paths = BillDigestEditUI.this.valueTree.getSelectionPaths();
                if (paths.length > 0) {
                    TreePath path = paths[0];
                    Object obj = path.getLastPathComponent();
                    if (obj instanceof DefaultKingdeeTreeNode) {
                        Object userObj = ((DefaultKingdeeTreeNode)obj).getUserObject();
                        if (userObj instanceof SummaryItemInfo) {
                            SummaryItemInfo item = (SummaryItemInfo)userObj;
                            Map<Locale, String> read = MutilanDialog.read(item.getAllAlias());
                            item.setAlias(read);
                        } else if (userObj instanceof SummaryInfo) {
                            SummaryInfo summary = (SummaryInfo)userObj;
                            Map<Locale, String> read = MutilanDialog.read(summary.getAllAlias());
                            summary.setAlias(read);
                        }
                    }
                    BillDigestEditUI.this.refreshSummaryTree(null, 2);
                    BillDigestEditUI.this.refreshSummaryDetailTable();
                }
            }
        };
        AbstractAction valueMappingAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SummaryItemInfo item;
                Object userObj;
                TreePath path;
                Object obj;
                TreePath[] paths = BillDigestEditUI.this.valueTree.getSelectionPaths();
                if (paths.length > 0 && (obj = (path = paths[0]).getLastPathComponent()) instanceof DefaultKingdeeTreeNode && (userObj = ((DefaultKingdeeTreeNode)obj).getUserObject()) instanceof SummaryItemInfo && (item = (SummaryItemInfo)userObj).getName() != null) {
                    UIContext uiContext = new UIContext();
                    uiContext.put("editdata", userObj);
                    try {
                        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ValueMappingUI.class.getName(), (Map)uiContext);
                        uiWindow.show();
                    }
                    catch (UIException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        };
        this.valueTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object userObj;
                TreePath path;
                Object obj;
                TreePath[] paths;
                if (e.getButton() == 3 && (paths = BillDigestEditUI.this.valueTree.getSelectionPaths()).length > 0 && (obj = (path = paths[0]).getLastPathComponent()) instanceof DefaultKingdeeTreeNode && ((userObj = ((DefaultKingdeeTreeNode)obj).getUserObject()) instanceof SummaryItemInfo || userObj instanceof SummaryInfo)) {
                    BillDigestEditUI.this.mappingMenu.setVisible(userObj instanceof SummaryItemInfo);
                    BillDigestEditUI.this.popMenu.show((Component)BillDigestEditUI.this.valueTree, e.getX(), e.getY());
                }
            }
        });
        JMenuItem menu = this.popMenu.add((Action)f2Listener);
        menu.setText(BillDigestUtils.getResString("Modifiyalias"));
        this.mappingMenu = this.popMenu.add((Action)valueMappingAction);
        this.mappingMenu.setText(BillDigestUtils.getResString("Modifiyvaluemapping"));
    }

    private void removeSummaryActionPerform() {
        TreePath[] paths = this.valueTree.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            Object object;
            TreePath path = paths[i];
            Object obj = path.getLastPathComponent();
            if (!(obj instanceof DefaultKingdeeTreeNode) || !this.summary.contains(object = ((DefaultKingdeeTreeNode)obj).getUserObject())) continue;
            this.summary.remove(object);
            this.refreshSummaryTree(this.summary, 2);
            this.refreshSummaryDetailTable();
        }
    }

    private void addSummaryActionPerform() {
        TreePath[] paths = this.propertyTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            SummaryInfo entry;
            Object object;
            TreePath path = paths[i];
            Object obj = path.getLastPathComponent();
            if (!(obj instanceof DefaultKingdeeTreeNode) || !((object = ((DefaultKingdeeTreeNode)obj).getUserObject()) instanceof SummaryItemInfo) || this.summary.contains(object)) continue;
            SummaryItemInfo item = (SummaryItemInfo)object;
            String group = item.getGroup();
            if (!StringUtils.isEmpty((String)group) && (entry = this.summary.getEntry(group)) == null) {
                String[] strings = StringUtils.split((String)group, (String)".");
                SummaryInfo parent = this.summary;
                for (int j = 0; j < strings.length - 1; ++j) {
                    SummaryInfo subEntry = null;
                    subEntry = !StringUtils.isEmpty((String)parent.getName()) ? parent.getEntry(parent.getName() + "." + strings[j]) : parent.getEntry(strings[j]);
                    if (subEntry == null) {
                        MsgBox.showInfo((Component)this.valueTree, (String)BillDigestUtils.getResString("parentNodeEmptyErr"));
                        SysUtil.abort();
                    }
                    parent = subEntry;
                }
                entry = new SummaryInfo();
                entry.setName(group);
                entry.setIndex(this.summary.getEntrys().size() + 1);
                parent.addEntry(entry);
                DefaultKingdeeTreeNode pNode = (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)obj).getParent();
                if (pNode != null && !StringUtils.isEmpty((String)pNode.getText())) {
                    entry.setAlias(pNode.getText());
                }
            }
            this.summary.addSummaryItem((SummaryItemInfo)object);
            this.refreshSummaryTree(this.summary, 2);
        }
    }

    private void buildEntityTree() {
        IBriefViewTreeNode node = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_subsystemEntity", (BOSObjectType)MetaDataTypeList.ENTITY);
        node = SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)node);
        DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)node);
        ((KingdeeTreeModel)this.entityTree.getModel()).setRoot((TreeNode)root);
        this.entityTree.getSelectionModel().setSelectionMode(1);
        this.entityTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MetaDataBriefInfo brief = BillDigestEditUI.this.getMetaDataBrief();
                if (brief != null) {
                    IMetaDataPK pk = brief.getMetaDataPK();
                    BillDigestEditUI.this.entity = BillDigestEditUI.this.loadEntity(pk);
                    if (BillDigestEditUI.this.entity != null) {
                        DefaultKingdeeTreeNode root = EntityTreeBuilder.build(BillDigestEditUI.this.entity);
                        ((KingdeeTreeModel)BillDigestEditUI.this.propertyTree.getModel()).setRoot((TreeNode)root);
                        BillDigestEditUI.this.loadSummaryFromServer(pk.getFullName());
                        BillDigestEditUI.this.refreshSummaryTree(null, 2);
                        BillDigestEditUI.this.refreshSummaryDetailTable();
                    }
                }
            }
        });
    }

    private IBillDigestUpdater getUpdater() {
        String url = ORMRPCServiceLocator.getCurrentServiceURL();
        if (url == null) {
            url = "tcp://localhost";
        }
        String className = "com.kingdee.bos.workflow.monitor.app.BillDigestUpdater";
        return (IBillDigestUpdater)BOSObjectFactory.getRemoteBOSObjectFactory((String)url).getSession().createObject(className, IBillDigestUpdater.class);
    }

    private void loadSummaryFromServer(String pk) {
        try {
            IBillDigestSchema instance1 = BillDigestSchemaFactory.getRemoteInstance();
            this.summarySchema = instance1.getSummarysByPk(pk);
            if (this.summarySchema == null) {
                this.summarySchema = new ArrayList<SummaryInfo>();
                this.summary = this.createNewSchema();
                this.summary.setdefault(true);
                this.summarySchema.add(this.summary);
            } else {
                this.summary = this.summarySchema.get(0);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void buildPropertyTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)BillDigestUtils.getResString("EntityField"));
        ((KingdeeTreeModel)this.propertyTree.getModel()).setRoot((TreeNode)root);
        this.propertyTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    BillDigestEditUI.this.addSummaryActionPerform();
                }
            }
        });
    }

    public MetaDataBriefInfo getMetaDataBrief() {
        Object object;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.entityTree.getLastSelectedPathComponent();
        if (node != null && node.isLeaf() && (object = node.getUserObject()) instanceof MetaDataBriefInfo) {
            return (MetaDataBriefInfo)object;
        }
        return null;
    }

    private EntityObjectInfo loadEntity(IMetaDataPK pk) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity(pk);
    }

    public void refreshSummaryTree(SummaryInfo info, int level) {
        int[] rows = this.valueTree.getSelectionRows();
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)BillDigestUtils.getResString("Billdigestschema"));
        root.setCheckBoxVisible(false);
        ((KingdeeTreeModel)this.valueTree.getModel()).setRoot((TreeNode)root);
        DefaultKingdeeTreeNode curNode = null;
        if (this.summarySchema != null) {
            curNode = this.createSchemaNode(this.summarySchema, root, info);
            if (this.summarySchema.size() == 1) {
                this.valueTree.expandAllNodes(true, (TreeNode)curNode);
            } else if (info == null) {
                this.valueTree.expandOnLevel(level);
            } else if (info.getSummaryItems().size() == 0 && info.getEntrys().size() == 0) {
                this.valueTree.expandOnLevel(level);
            } else {
                this.valueTree.expandAllNodes(true, (TreeNode)curNode);
            }
        }
        int count = this.valueTree.getRowCount();
        if (rows == null || rows.length == 0 || count == rows[0]) {
            this.valueTree.setSelectionRow(count - 1);
        } else {
            this.valueTree.setSelectionRow(rows[0]);
        }
    }

    public BillDigestUtils.NodeType getNodeType(DefaultKingdeeTreeNode obj) {
        TreeNode root = obj.getRoot();
        TreeNode parent = obj.getParent();
        if (root.equals(obj)) {
            return BillDigestUtils.NodeType.ROOT;
        }
        Object userObj = obj.getUserObject();
        if (userObj instanceof SummaryItemInfo) {
            return BillDigestUtils.NodeType.ITEM;
        }
        if (userObj instanceof SummaryInfo) {
            if (root.equals(parent)) {
                return BillDigestUtils.NodeType.SCHEMA;
            }
            return BillDigestUtils.NodeType.ENTRY;
        }
        return BillDigestUtils.NodeType.ROOT;
    }

    private BillDigestUtils.NodeType getCurNodeType() {
        TreePath path;
        Object obj;
        TreePath[] paths = this.valueTree.getSelectionPaths();
        if (paths != null && paths.length > 0 && (obj = (path = paths[0]).getLastPathComponent()) instanceof DefaultKingdeeTreeNode) {
            BillDigestUtils.NodeType type = this.getNodeType((DefaultKingdeeTreeNode)obj);
            return type;
        }
        return BillDigestUtils.NodeType.ROOT;
    }

    private SummaryInfo getSummary() {
        TreePath path;
        Object obj;
        TreePath[] paths = this.valueTree.getSelectionPaths();
        if (paths != null && paths.length > 0 && (obj = (path = paths[0]).getLastPathComponent()) instanceof DefaultKingdeeTreeNode) {
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            this.getSelectSchemaNode((DefaultKingdeeTreeNode)obj, node);
            return this.summary;
        }
        return null;
    }

    private void getSelectSchemaNode(DefaultKingdeeTreeNode obj, DefaultKingdeeTreeNode selectNode) {
        Object userObj = obj.getUserObject();
        DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)obj.getParent();
        if (userObj instanceof SummaryInfo) {
            if (obj.getRoot().equals(parent)) {
                this.summary = (SummaryInfo)userObj;
                selectNode = obj;
            } else {
                this.getSelectSchemaNode(parent, selectNode);
            }
        } else if (userObj instanceof SummaryItemInfo) {
            this.getSelectSchemaNode(parent, selectNode);
        }
    }

    private DefaultKingdeeTreeNode createSchemaNode(List<SummaryInfo> summarys, DefaultKingdeeTreeNode node, SummaryInfo curInfo) {
        DefaultKingdeeTreeNode curNode = null;
        String defaultSchemastr = BillDigestUtils.getResString("defaultshcema");
        for (SummaryInfo info : summarys) {
            String defalutSchemaName;
            DefaultKingdeeTreeNode childnode = this.createNode(info);
            if (info.equals(curInfo)) {
                curNode = childnode;
            }
            if (info.isdefault() && !StringUtils.isEmpty((String)(defalutSchemaName = info.getAlias())) && defalutSchemaName.indexOf(defaultSchemastr) == -1) {
                info.setAlias(info.getAlias() + defaultSchemastr);
                childnode.setText(childnode.getText() + defaultSchemastr);
            }
            node.add((MutableTreeNode)childnode);
        }
        return curNode == null ? node : curNode;
    }

    private DefaultKingdeeTreeNode createNode(SummaryInfo summary) {
        String name = summary.getAlias();
        if (StringUtils.isEmpty((String)name)) {
            name = this.entity.getAlias();
        }
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)name);
        node.setCheckBoxVisible(false);
        node.setUserObject((Object)summary);
        List<SummaryItemInfo> items = summary.getSummaryItems();
        for (int i = 0; i < items.size(); ++i) {
            SummaryItemInfo info = items.get(i);
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode((Object)info);
            child.setText(info.getAlias() + "(" + info.getName() + ")");
            node.add((MutableTreeNode)child);
            child.setCheckBoxVisible(!StringUtils.isEmpty((String)summary.getName()));
            child.setChecked(info.isPreview());
            node.setUserObject((Object)summary);
        }
        List<SummaryInfo> entrys = summary.getEntrys();
        for (SummaryInfo entry : entrys) {
            DefaultKingdeeTreeNode child = this.createNode(entry);
            node.add((MutableTreeNode)child);
        }
        return node;
    }

    private void saveActionPerform() throws Exception {
        this.storeField();
        CoreBaseCollection cols = this.createSchema(this.summarySchema);
        boolean flag = this.checkExistDefaultSchema(cols);
        if (cols.isEmpty()) {
            MsgBox.showInfo((String)BillDigestUtils.getResString("emptyscheme"));
            return;
        }
        if (!flag) {
            MsgBox.showInfo((String)BillDigestUtils.getResString("nodefaultshemaerr"));
            return;
        }
        try {
            IBillDigestSchema schema = BillDigestSchemaFactory.getRemoteInstance();
            schema.save(cols);
            IBillDigest instance = BillDigestFactory.getRemoteInstance();
            String metaDataPk = this.entity.getFullName();
            String isShowInMobile = (String)this.uiContext.get((Object)metaDataPk);
            instance.saveBillAssign(metaDataPk, isShowInMobile);
            MsgBox.showInfo((String)BillDigestUtils.getResString("savesuccess"));
            this.loadSummaryFromServer(this.entity.getFullName());
            this.refreshSummaryTree(null, 2);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void storeField() throws Exception {
        ControlUtilities.checkFocusAndCommit();
    }

    private CoreBaseCollection createSchema(List<SummaryInfo> summarys) {
        CoreBaseCollection list = new CoreBaseCollection();
        for (SummaryInfo summary : summarys) {
            CoreBaseCollection col = this.createDigest(summary);
            if (col.size() <= 0) continue;
            BillDigestSchemaInfo schema = new BillDigestSchemaInfo();
            schema.setBillMetadataPk(summary.getMetadataPK());
            schema.setIsDefault(summary.isdefault());
            schema.setShcema_alias(summary.getAlias());
            if (!StringUtils.isEmpty((String)summary.getShcemaId())) {
                schema.setId(BOSUuid.read((String)summary.getShcemaId()));
            }
            schema.getBilldigest().addObjectCollection((IObjectCollection)col);
            ArrayList<String> propertyGroupList = new ArrayList<String>();
            for (int i = 0; i < col.size(); ++i) {
                BillDigestInfo info = (BillDigestInfo)col.get(i);
                String propertyGroup = info.getPropertyGroup();
                if (StringUtils.isEmpty((String)propertyGroup)) continue;
                PropertyInfo temp = this.entity.getPropertyByNameRuntime(propertyGroup);
                if (propertyGroupList.contains(propertyGroup) || !(temp instanceof LinkPropertyInfo)) continue;
                propertyGroupList.add(propertyGroup);
                LinkPropertyInfo entryProperty = (LinkPropertyInfo)temp;
                String entryMetadataPK = entryProperty.getRelationship().getSupplierObject().getFullName();
                BillDigestSchemaEntryInfo entrySchema = new BillDigestSchemaEntryInfo(schema, entryMetadataPK);
                schema.getBillDigestSchEntry().add(entrySchema);
            }
            list.add((CoreBaseInfo)schema);
        }
        return list;
    }

    private BillDigestInfo createDigest(SummaryItemInfo item) {
        BillDigestInfo digest = new BillDigestInfo();
        digest.setMetadataPK(this.entity.getFullName());
        digest.setPropertyName(item.getName());
        digest.setPropertyGroup(item.getGroup());
        digest.setPreview(item.isPreview());
        digest.setBillDigestType(BillDigestEnum.getEnum(item.getDigType()));
        digest.setEditable(item.isEditable());
        digest.setShowFormate(item.getShowFormate());
        digest.setFontColor(item.getFontColor());
        digest.setShowIfNull(item.getShowIfNull());
        digest.setCalculateField(item.isUserDefine());
        digest.setIsSortedItem(item.getIsSortedItem());
        digest.setCanSummary(item.isCanSummary());
        Map<Locale, String> allAlias = item.getAllAlias();
        for (Locale next : allAlias.keySet()) {
            String value = allAlias.get(next);
            if (StringUtils.isEmpty((String)value)) continue;
            digest.setAlias(value, next);
        }
        digest.getValuemapping().addCollection(item.getValueMapping());
        digest.getEditConfig().addCollection(item.getEditConfig());
        digest.getScript().addCollection(item.getScript());
        return digest;
    }

    private BillDigestInfo innserCreateDigest(SummaryInfo summary) {
        BillDigestInfo digest = new BillDigestInfo();
        digest.setMetadataPK(this.entity.getFullName());
        digest.setPropertyGroup(summary.getName());
        digest.setPreviewNum(summary.getPreviewNum());
        digest.setIsOABill(summary.isOABill());
        digest.setIsMobileApprove(summary.getIsMobileApprove());
        digest.setNeedValidate(summary.getNeedValidate());
        digest.setBillDigestType(summary.getDigType());
        digest.setSortedType(summary.getSortedType());
        digest.setIndex(summary.getIndex());
        Map<Locale, String> allAlias = summary.getAllAlias();
        for (Locale next : allAlias.keySet()) {
            String value = allAlias.get(next);
            if (StringUtils.isEmpty((String)value)) continue;
            digest.setAlias(value, next);
        }
        return digest;
    }

    private CoreBaseCollection createDigest(SummaryInfo summary) {
        CoreBaseCollection list = new CoreBaseCollection();
        if (!summary.isEmpty()) {
            List<SummaryItemInfo> items = summary.getSummaryItems();
            BillDigestInfo digest = this.innserCreateDigest(summary);
            BillDigestEnum Type2 = digest.getBillDigestType();
            list.add((CoreBaseInfo)digest);
            for (int i = 0; i < items.size(); ++i) {
                SummaryItemInfo item = items.get(i);
                digest = this.createDigest(item);
                digest.setIndex(i);
                digest.setBillDigestType(Type2);
                list.add((CoreBaseInfo)digest);
            }
            List<SummaryInfo> entrys = summary.getEntrys();
            for (SummaryInfo entry : entrys) {
                entry.setDigType(summary.getDigType());
                CoreBaseCollection list2 = this.createDigest(entry);
                list.addCollection(list2);
            }
        }
        return list;
    }

    public void refreshSummaryDetailTable() {
        TreePath path;
        Object obj;
        this.kDTable1.removeRows();
        TreePath[] paths = this.valueTree.getSelectionPaths();
        if (paths != null && paths.length > 0 && (obj = (path = paths[0]).getLastPathComponent()) instanceof DefaultKingdeeTreeNode) {
            Object userObj = ((DefaultKingdeeTreeNode)obj).getUserObject();
            BillDigestUtils.NodeType type = this.getNodeType((DefaultKingdeeTreeNode)obj);
            if (BillDigestUtils.NodeType.ITEM == type) {
                SummaryItemInfo item = (SummaryItemInfo)userObj;
                if (item.getName() != null) {
                    this.TableAddRow(PropertyTypeEnum.ALIAS, item.getAlias());
                    this.TableAddRow(PropertyTypeEnum.NAME, item.getName());
                    this.TableAddRow(PropertyTypeEnum.FONTCOLOR, item.getFontColor());
                    String group = item.getGroup();
                    if (!StringUtils.isEmpty((String)group)) {
                        if (!item.getName().contains(".")) {
                            String isSortedItem = BooleanEnum.YES.getTypeAlias();
                            if (!item.getIsSortedItem().booleanValue()) {
                                isSortedItem = BooleanEnum.NO.getTypeAlias();
                            }
                            this.TableAddRow(PropertyTypeEnum.ISSORTEDITEM, isSortedItem);
                        }
                        String canSummary = BooleanEnum.YES.getTypeAlias();
                        if (!item.isCanSummary().booleanValue()) {
                            canSummary = BooleanEnum.NO.getTypeAlias();
                        }
                        this.TableAddRow(PropertyTypeEnum.CANSUMMARY, canSummary);
                    }
                    String ShowIfNull = BooleanEnum.YES.getTypeAlias();
                    if (!item.getShowIfNull().booleanValue()) {
                        ShowIfNull = BooleanEnum.NO.getTypeAlias();
                    }
                    this.TableAddRow(PropertyTypeEnum.SHOWIFNULL, ShowIfNull);
                    if (item.getProperty() != null && item.getProperty().getDataType() != null) {
                        DataType dataType = item.getProperty().getDataType();
                        if (dataType.isDateTime()) {
                            this.TableAddRow(PropertyTypeEnum.DATEFORMATE, item.getShowFormate());
                        } else if (DataType.DECIMAL.equals((Object)dataType)) {
                            this.TableAddRow(PropertyTypeEnum.NUMBERPRECISION, item.getShowFormate());
                        }
                    }
                    if (item.isUserDefine()) {
                        String script = BillDigestUtils.getResString("pleaseEditScript");
                        BillDigestScriptInfo info = item.getScript().get(0);
                        if (info != null) {
                            script = info.getContent();
                        }
                        this.TableAddRow(PropertyTypeEnum.EDITSCRIPT, script);
                    }
                    KDTableHelper.setRowLocked((KDTable)this.kDTable1, (int)1, (boolean)true);
                }
            } else if (BillDigestUtils.NodeType.SCHEMA == type) {
                SummaryInfo info = (SummaryInfo)userObj;
                this.TableAddRow(PropertyTypeEnum.ALIAS, info.getAlias());
                String IsMobileApprove = this.translateBoolToCN(info.getIsMobileApprove());
                this.TableAddRow(PropertyTypeEnum.ISMOBILEAPPROVE, IsMobileApprove);
                String needvalidate = this.translateBoolToCN(info.getNeedValidate());
                this.TableAddRow(PropertyTypeEnum.NEEDVALIDATE, needvalidate);
                String isDefaultSchema = this.translateBoolToCN(info.isdefault());
                this.TableAddRow(PropertyTypeEnum.ISDEFAULTSCEHMA, isDefaultSchema);
                if (info.getDigType() != null) {
                    this.TableAddRow(PropertyTypeEnum.DIGESTTYPE, String.valueOf(info.getDigType().getValue()));
                }
            } else if (BillDigestUtils.NodeType.ENTRY == type) {
                SummaryInfo info = (SummaryInfo)userObj;
                this.TableAddRow(PropertyTypeEnum.ALIAS, info.getAlias());
                this.TableAddRow(PropertyTypeEnum.PREVIEWNUM, String.valueOf(info.getPreviewNum() + 1));
                if ("0".equals(info.getSortedType())) {
                    this.TableAddRow(PropertyTypeEnum.SORTEDTYPE, PropertyTypeEnum.ITEMASC.getTypeAlias());
                } else if ("1".equals(info.getSortedType())) {
                    this.TableAddRow(PropertyTypeEnum.SORTEDTYPE, PropertyTypeEnum.ITEMDESC.getTypeAlias());
                } else {
                    this.TableAddRow(PropertyTypeEnum.SORTEDTYPE, PropertyTypeEnum.NOSORTING.getTypeAlias());
                }
            } else if (BillDigestUtils.NodeType.ROOT == type) {
                String metaDataPk = this.entity.getFullName();
                boolean flag = this.getIsShowInMobile(metaDataPk);
                if (flag) {
                    this.uiContext.put((Object)metaDataPk, (Object)"1");
                } else {
                    this.uiContext.put((Object)metaDataPk, (Object)"0");
                }
                String isShowInMobile = this.translateBoolToCN(flag);
                this.TableAddRow(PropertyTypeEnum.ISSHOWINMOBILE, isShowInMobile);
            }
        }
    }

    private void TableAddRow(PropertyTypeEnum type, String propertyValue) {
        IRow row = this.kDTable1.addRow();
        row.getCell("propertyAlias").setValue((Object)type.getTypeAlias());
        row.getCell("propertyName").setValue((Object)type.getType());
        if (PropertyTypeEnum.DIGESTTYPE == type) {
            KDComboBox box = new KDComboBox();
            Vector<BillDigestEnum> vector = new Vector<BillDigestEnum>();
            List enums = BillDigestEnum.getEnumList();
            for (BillDigestEnum benum : enums) {
                vector.add(benum);
            }
            box.addItems(vector);
            row.getCell("propertyValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
            box.setSelectedItem((Object)BillDigestEnum.getEnum(Integer.parseInt(propertyValue)));
            row.getCell("propertyValue").setValue((Object)BillDigestEnum.getEnum(Integer.parseInt(propertyValue)));
        } else if (PropertyTypeEnum.SORTEDTYPE == type) {
            KDComboBox box = new KDComboBox();
            Vector<String> vector = new Vector<String>();
            vector.add(PropertyTypeEnum.NOSORTING.getTypeAlias());
            vector.add(PropertyTypeEnum.ITEMASC.getTypeAlias());
            vector.add(PropertyTypeEnum.ITEMDESC.getTypeAlias());
            box.addItems(vector);
            row.getCell("propertyValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
            if (StringUtils.isEmpty((String)propertyValue)) {
                row.getCell("propertyValue").setValue((Object)"");
                box.setSelectedItem((Object)"");
            } else {
                row.getCell("propertyValue").setValue((Object)propertyValue);
                box.setSelectedItem((Object)propertyValue);
            }
        } else if (PropertyTypeEnum.NUMBERPRECISION == type) {
            KDComboBox box = new KDComboBox();
            Vector<String> vector = new Vector<String>();
            vector.add("###,##0");
            vector.add("###,##0.0");
            vector.add("###,##0.00");
            vector.add("###,##0.000");
            vector.add("###,##0.0000");
            vector.add("###,##0.00000");
            box.addItems(vector);
            row.getCell("propertyValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
            if (propertyValue == null || propertyValue.length() == 0) {
                row.getCell("propertyValue").setValue((Object)"###,##0.0");
                box.setSelectedItem((Object)"###,##0.0");
            } else {
                row.getCell("propertyValue").setValue((Object)propertyValue);
                box.setSelectedItem((Object)propertyValue);
            }
        } else if (PropertyTypeEnum.DATEFORMATE == type) {
            KDComboBox box = new KDComboBox();
            Vector<String> vector = new Vector<String>();
            vector.add("yyyy-MM-dd");
            vector.add("yyyy-MM-dd hh");
            vector.add("yyyy-MM-dd HH");
            vector.add("yyyy-MM-dd hh:mm");
            vector.add("yyyy-MM-dd HH:mm");
            vector.add("yyyy-MM-dd hh:mm:ss");
            vector.add("yyyy-MM-dd HH:mm:ss");
            vector.add("HH:mm:ss");
            box.addItems(vector);
            row.getCell("propertyValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
            if (propertyValue == null || propertyValue.length() == 0) {
                row.getCell("propertyValue").setValue((Object)"yyyy-MM-dd");
                box.setSelectedItem((Object)"yyyy-MM-dd");
            } else {
                row.getCell("propertyValue").setValue((Object)propertyValue);
                box.setSelectedItem((Object)propertyValue);
            }
        } else if (PropertyTypeEnum.PREVIEWNUM == type) {
            KDFormattedTextField box = new KDFormattedTextField();
            box.setDataType(0);
            box.setDataVerifierType(12);
            row.getCell("propertyValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)box));
            row.getCell("propertyValue").setValue((Object)propertyValue);
        } else if (PropertyTypeEnum.NEEDVALIDATE == type || PropertyTypeEnum.ISMOBILEAPPROVE == type || PropertyTypeEnum.SHOWIFNULL == type || PropertyTypeEnum.ISSHOWINMOBILE == type || PropertyTypeEnum.ISDEFAULTSCEHMA == type || PropertyTypeEnum.ISSORTEDITEM == type || PropertyTypeEnum.CANSUMMARY == type) {
            KDComboBox box = new KDComboBox();
            Vector<String> vector = new Vector<String>();
            vector.add(BooleanEnum.YES.getTypeAlias());
            vector.add(BooleanEnum.NO.getTypeAlias());
            box.addItems(vector);
            row.getCell("propertyValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
            box.setSelectedItem((Object)propertyValue);
            row.getCell("propertyValue").setValue((Object)propertyValue);
        } else {
            row.getCell("propertyValue").setValue((Object)propertyValue);
        }
    }

    public String convertValueToHex(Color color) {
        String red = Integer.toHexString(color.getRed()).toUpperCase(Locale.ENGLISH);
        String green = Integer.toHexString(color.getGreen()).toUpperCase(Locale.ENGLISH);
        String blue = Integer.toHexString(color.getBlue()).toUpperCase(Locale.ENGLISH);
        if (red.equals("0")) {
            red = "00";
        }
        if (green.equals("0")) {
            green = "00";
        }
        if (blue.equals("0")) {
            blue = "00";
        }
        return "#" + red + green + blue;
    }

    private boolean getIsShowInMobile(String metaDatePK) {
        if (StringUtils.isEmpty((String)metaDatePK)) {
            return true;
        }
        if (this.uiContext.get((Object)metaDatePK) != null) {
            String isShow = (String)this.uiContext.get((Object)metaDatePK);
            if ("1".equals(isShow)) {
                return true;
            }
            if ("0".equals(isShow)) {
                return false;
            }
        }
        String querySql = "select FISSHOWINMOBILE from T_BILL_ASSIGN where FMETADATAPK='" + metaDatePK + "'";
        try {
            SQLExecutor se = new SQLExecutor(querySql);
            IRowSet rowSet = se.executeSQL();
            while (rowSet.next()) {
                if (rowSet.getInt(1) == 1) {
                    return true;
                }
                if (rowSet.getInt(1) != 0) continue;
                return false;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return true;
        }
        return true;
    }

    private String translateBoolToCN(boolean flag) {
        if (flag) {
            return BooleanEnum.YES.getTypeAlias();
        }
        return BooleanEnum.NO.getTypeAlias();
    }

    private boolean checkExistDefaultSchema(CoreBaseCollection cols) {
        if (cols == null || cols.size() == 0) {
            return true;
        }
        boolean flag = false;
        for (int i = 0; i < cols.size(); ++i) {
            BillDigestSchemaInfo info = (BillDigestSchemaInfo)cols.get(i);
            if (!info.isIsDefault()) continue;
            flag = true;
        }
        return flag;
    }

    private SummaryInfo getExistDefaultSchema(SummaryInfo summary) {
        for (SummaryInfo info : this.summarySchema) {
            if (summary.equals(info) || !info.isdefault()) continue;
            return info;
        }
        return null;
    }

    private boolean canDistribute(CoreBaseCollection cols) {
        if (cols == null || cols.size() == 0) {
            return false;
        }
        boolean flag = true;
        for (int i = 0; i < cols.size(); ++i) {
            BillDigestSchemaInfo info = (BillDigestSchemaInfo)cols.get(i);
            if (info.getId() != null && info.getBilldigest().size() != 0) continue;
            flag = false;
        }
        return flag;
    }

    private SummaryInfo createNewSchema() {
        String metaDataPk = this.entity.getFullName();
        String name = this.entity.getAlias();
        this.summary = new SummaryInfo();
        this.summary.setAlias(name);
        this.summary.setMetadataPK(metaDataPk);
        return this.summary;
    }

    private void deleteSummaryByPk(String schemaId) {
        try {
            IBillDigestSchema instance = BillDigestSchemaFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)schemaId));
            instance.delete(filter);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void changeDefalutSchema() {
        SummaryInfo defaultSchema = this.getExistDefaultSchema(this.summary);
        if (defaultSchema == null) {
            this.summary.setdefault(true);
        } else {
            int value = MsgBox.showConfirm3((String)BillDigestUtils.getResString("changeDefaultSchema"));
            if (value == 0) {
                this.summary.setdefault(true);
                defaultSchema.setdefault(false);
                String alias = defaultSchema.getAlias();
                String defaultSchemastr = BillDigestUtils.getResString("defaultshcema");
                if (!StringUtils.isEmpty((String)alias) || alias.indexOf(defaultSchemastr) != -1) {
                    int index1 = alias.indexOf(defaultSchemastr);
                    alias = alias.substring(0, index1);
                    defaultSchema.setAlias(alias);
                }
                int index = this.summarySchema.indexOf(this.summary);
                this.summarySchema.set(0, this.summary);
                this.summarySchema.set(index, defaultSchema);
            }
        }
    }

    private static enum BooleanEnum {
        YES("yes"),
        NO("no");

        private String type;

        private BooleanEnum(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getTypeAlias() {
            return BillDigestUtils.getResString(this.type);
        }
    }
}

