/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.workflow.monitor.SummaryItemInfo;
import com.kingdee.util.StringUtils;
import java.util.LinkedList;
import javax.swing.tree.MutableTreeNode;

public class EntityTreeBuilder {
    static DefaultKingdeeTreeNode build(EntityObjectInfo entity) {
        DefaultKingdeeTreeNode node;
        PropertyInfo property;
        int i;
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(EntityTreeBuilder.getAlias(entity));
        root.setUserObject((Object)entity);
        LinkedList<LinkPropertyInfo> F7 = new LinkedList<LinkPropertyInfo>();
        LinkedList<LinkPropertyInfo> entry = new LinkedList<LinkPropertyInfo>();
        PropertyCollection properties = entity.getInheritedProperties();
        for (i = 0; i < properties.size(); ++i) {
            property = properties.get(i);
            if (property instanceof OwnPropertyInfo) {
                String name = property.getName();
                String alias = property.getAlias() + "(" + property.getName() + ")";
                DefaultKingdeeTreeNode leaf = EntityTreeBuilder.createLeaf(null, name, property.getAlias(), (OwnPropertyInfo)property);
                leaf.setText(alias);
                root.add((MutableTreeNode)leaf);
                continue;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            if (EntityTreeBuilder.isEntry((LinkPropertyInfo)property)) {
                entry.add((LinkPropertyInfo)property);
                continue;
            }
            F7.add((LinkPropertyInfo)property);
        }
        for (i = 0; i < entry.size(); ++i) {
            property = (LinkPropertyInfo)entry.get(i);
            node = EntityTreeBuilder.createEntryNode(property.getName(), entity, (LinkPropertyInfo)property);
            root.add((MutableTreeNode)node);
        }
        for (i = 0; i < F7.size(); ++i) {
            property = (LinkPropertyInfo)F7.get(i);
            node = EntityTreeBuilder.createF7Node(null, (LinkPropertyInfo)property);
            root.add((MutableTreeNode)node);
        }
        return root;
    }

    private static String getAlias(EntityObjectInfo entity) {
        String alias = entity.getAlias();
        if (StringUtils.isEmpty((String)alias)) {
            alias = entity.getName();
        }
        return alias;
    }

    private static boolean isEntry(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && (CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()));
    }

    private static EntityObjectInfo getSupplyEntity(LinkPropertyInfo property) {
        RelationshipInfo relation = property.getRelationship();
        if (relation != null) {
            return relation.getSupplierObject();
        }
        return null;
    }

    private static DefaultKingdeeTreeNode createEntryNode(String group, EntityObjectInfo parentEntity, LinkPropertyInfo parent) {
        DefaultKingdeeTreeNode node;
        PropertyInfo property;
        int i;
        LinkedList<LinkPropertyInfo> F7 = new LinkedList<LinkPropertyInfo>();
        LinkedList<LinkPropertyInfo> entrys = new LinkedList<LinkPropertyInfo>();
        EntityObjectInfo entry = EntityTreeBuilder.getSupplyEntity(parent);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(EntityTreeBuilder.getAlias(entry));
        root.setUserObject((Object)entry);
        PropertyCollection properties = entry.getInheritedProperties();
        for (i = 0; i < properties.size(); ++i) {
            property = properties.get(i);
            if (property instanceof OwnPropertyInfo) {
                String name = property.getName();
                String alias = property.getAlias() + "(" + property.getName() + ")";
                DefaultKingdeeTreeNode leaf = EntityTreeBuilder.createLeaf(group, name, property.getAlias(), (OwnPropertyInfo)property);
                leaf.setText(alias);
                root.add((MutableTreeNode)leaf);
                continue;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            if (!EntityTreeBuilder.isEntry((LinkPropertyInfo)property)) {
                F7.add((LinkPropertyInfo)property);
                continue;
            }
            RelationshipInfo ship = ((LinkPropertyInfo)property).getRelationship();
            if (ship.getClientObject() != entry) continue;
            entrys.add((LinkPropertyInfo)property);
        }
        for (i = 0; i < F7.size(); ++i) {
            property = (LinkPropertyInfo)F7.get(i);
            node = EntityTreeBuilder.createF7Node(group, (LinkPropertyInfo)property);
            root.add((MutableTreeNode)node);
        }
        for (i = 0; i < entrys.size(); ++i) {
            property = (LinkPropertyInfo)entrys.get(i);
            node = EntityTreeBuilder.createEntryNode(group + "." + property.getName(), entry, (LinkPropertyInfo)property);
            root.add((MutableTreeNode)node);
        }
        return root;
    }

    private static DefaultKingdeeTreeNode createF7Node(String group, LinkPropertyInfo parent) {
        EntityObjectInfo entry = EntityTreeBuilder.getSupplyEntity(parent);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(parent.getAlias());
        root.setUserObject((Object)entry);
        PropertyCollection properties = entry.getInheritedProperties();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo property = properties.get(i);
            if (property instanceof OwnPropertyInfo) {
                String name = parent.getName() + "." + property.getName();
                String alias = parent.getAlias();
                DefaultKingdeeTreeNode leaf = EntityTreeBuilder.createLeaf(group, name, alias, (OwnPropertyInfo)property);
                String text = property.getAlias() + "(" + property.getName() + ")";
                leaf.setText(text);
                root.add((MutableTreeNode)leaf);
                continue;
            }
            if (!(property instanceof LinkPropertyInfo) || EntityTreeBuilder.isEntry((LinkPropertyInfo)property)) continue;
            DefaultKingdeeTreeNode leaf = EntityTreeBuilder.createSubF7Node(group, parent.getName(), (LinkPropertyInfo)property);
            root.add((MutableTreeNode)leaf);
        }
        return root;
    }

    private static DefaultKingdeeTreeNode createSubF7Node(String group, String parent, LinkPropertyInfo subProperty) {
        EntityObjectInfo entity = EntityTreeBuilder.getSupplyEntity(subProperty);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(subProperty.getAlias());
        root.setUserObject((Object)entity);
        PropertyCollection properties = entity.getInheritedProperties();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo property = properties.get(i);
            if (!(property instanceof OwnPropertyInfo)) continue;
            String name = parent + "." + subProperty.getName() + "." + property.getName();
            String alias = subProperty.getAlias();
            DefaultKingdeeTreeNode leaf = EntityTreeBuilder.createLeaf(group, name, alias, (OwnPropertyInfo)property);
            String text = property.getAlias() + "(" + property.getName() + ")";
            leaf.setText(text);
            root.add((MutableTreeNode)leaf);
        }
        return root;
    }

    private static DefaultKingdeeTreeNode createLeaf(String group, String name, String alias, OwnPropertyInfo property) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
        SummaryItemInfo summary = new SummaryItemInfo();
        DataType dataType = property.getDataType();
        if (dataType.isDateTime()) {
            summary.setShowFormate("yyyy-MM-dd");
        } else if (DataType.DECIMAL.equals((Object)dataType)) {
            summary.setShowFormate("###,##0.0");
        }
        summary.setGroup(group);
        summary.setName(name);
        summary.setAlias(alias);
        summary.setProperty(property);
        node.setUserObject((Object)summary);
        return node;
    }
}

