/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.shell.trace.ConnectionInfo;
import com.kingdee.bos.sql.shell.trace.StatementInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.WfLogConfig;
import com.kingdee.bos.workflow.monitor.client.AbstractMonitorCenterUI;
import com.kingdee.bos.workflow.service.IMonitorService;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ConfigurationItem;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class MonitorCenterUI
extends AbstractMonitorCenterUI {
    private static final long serialVersionUID = -3947037291430632386L;
    private static final Logger logger = CoreUIObject.getLogger(MonitorCenterUI.class);
    private final String RES = "com.kingdee.bos.workflow.monitor.client.MonitorCenter";
    private IMonitorService service = (IMonitorService)BOSObjectFactory.createRemoteBOSObject((String)"com.kingdee.bos.workflow.service.MonitorService", IMonitorService.class);
    private static final String WORKFLOW_ISENABLE_SCHEDULER = "isEnableScheduler";
    private static final String WORKFLOW_ISENABLEDAEMON = "isEnableDaemon";
    private static final String WORKFLOW_SCHEDULER_IDLE_WAITE_TIME = "schedulerIdleWaiteTime";
    private static final String WORKFLOW_CACHEMANAGER = "cacheManager";
    private static final String WORKFLOW_SCHEDULER_THREADPOOL_SIZE = "schedulerThreadPoolSize";
    private static final String WORKFLOW_TRANS_QUEUETIME = "workflowTransQueueTime";
    private static final String WORKFLOW_ISINIT_WFSERVICE = "isInitWfService";
    private static final String WORKFLOW_SERVER_KEY = "workflowServerKey";
    public static final String LOGCONFIG_LOGLEVEL = "LogLevel";
    public static final String LOGCONFIG_ENABLEENGINELOG = "EnableEngineLog";
    public static final String LOGCONFIG_ENABLEQUEUELOG = "EnableQueueLog";
    public static final String LOGCONFIG_ENABLEPROCESSDEFLOG = "EnableProcessDefLog";
    public static final String LOGCONFIG_ENABLEPROCESSINSTLOG = "EnableProcessInstLog";

    private String getRes(String key) {
        return EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.MonitorCenter", (String)key);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initButton();
        this.initTree();
    }

    public void initButton() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    private void initTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)this.getRes("MonitorCenter"));
        DefaultKingdeeTreeNode EnvNode = new DefaultKingdeeTreeNode((Object)this.getRes("EnvNode"));
        DefaultKingdeeTreeNode EngineNode = new DefaultKingdeeTreeNode((Object)this.getRes("EngineNode"));
        DefaultKingdeeTreeNode KSQLNode = new DefaultKingdeeTreeNode((Object)this.getRes("KSQLNode"));
        root.setCheckBoxVisible(false);
        EnvNode.setCheckBoxVisible(false);
        EngineNode.setCheckBoxVisible(false);
        KSQLNode.setCheckBoxVisible(false);
        this.treeCatalog = new KDTree((ITreeNode)root);
        this.treeCatalog.addNodeInto((MutableTreeNode)EnvNode, (MutableTreeNode)root);
        this.treeCatalog.addNodeInto((MutableTreeNode)EngineNode, (MutableTreeNode)root);
        this.treeCatalog.addNodeInto((MutableTreeNode)KSQLNode, (MutableTreeNode)root);
        this.tvCatalog.setTree(this.treeCatalog);
        this.treeCatalog.expandAllNodes(true, (TreeNode)root);
        this.treeCatalog.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() != null) {
                    MonitorCenterUI.this.treeSelectEvent(e);
                }
            }
        });
    }

    public void treeSelectEvent(TreeSelectionEvent e) {
        String nodeName = e.getNewLeadSelectionPath().getLastPathComponent().toString();
        if (nodeName.equalsIgnoreCase(this.getRes("EnvNode"))) {
            this.panelManager(nodeName);
        } else if (nodeName.equalsIgnoreCase(this.getRes("EngineNode"))) {
            this.panelManager(nodeName);
        } else if (nodeName.equalsIgnoreCase(this.getRes("KSQLNode"))) {
            this.panelManager(nodeName);
        }
    }

    public void panelManager(String nodeName) {
        this.pnlEngine.setVisible(false);
        this.pnlEnv.setVisible(false);
        this.pnlKSQL.setVisible(false);
        this.btnResetWorkderThread.setVisible(false);
        this.btnResetWorkderThread.setEnabled(false);
        if (nodeName.equalsIgnoreCase(this.getRes("EnvNode"))) {
            this.pnlEnv.setVisible(true);
            this.refreshEnvPanel();
        } else if (nodeName.equalsIgnoreCase(this.getRes("EngineNode"))) {
            this.pnlEngine.setVisible(true);
            this.refreshEnginePanel();
        } else if (nodeName.equalsIgnoreCase(this.getRes("KSQLNode"))) {
            this.pnlKSQL.setVisible(true);
            try {
                this.refreshKSQLPanel();
            }
            catch (Exception e) {
                logger.error((Object)"panelManager(String nodeName)", (Throwable)e);
            }
        }
    }

    private void refreshEnginePanel() {
        this.btnResetWorkderThread.setVisible(true);
        this.btnResetWorkderThread.setEnabled(true);
        this.tblEngine.getHeadRow(0).getCell(0).setValue((Object)this.getRes("tblEngine_Ais"));
        this.tblEngine.getHeadRow(0).getCell(1).setValue((Object)this.getRes("tblEngine_Solution"));
        this.tblEngine.getHeadRow(0).getCell(2).setValue((Object)this.getRes("tblEngine_CreateDate"));
        this.tblEngine.getHeadRow(0).getCell(3).setValue((Object)this.getRes("tblEngine_ThreadGroupCreateDate"));
        this.tblEngine.getHeadRow(0).getCell(4).setValue((Object)this.getRes("tblEngine_UserName"));
        int table_Width = this.pnlEngine.getWidth() - 30;
        this.tblEngine.getColumn(0).setWidth((int)((double)table_Width * 0.2));
        this.tblEngine.getColumn(1).setWidth((int)((double)table_Width * 0.2));
        this.tblEngine.getColumn(2).setWidth((int)((double)table_Width * 0.2));
        this.tblEngine.getColumn(3).setWidth((int)((double)table_Width * 0.2));
        this.tblEngine.getColumn(4).setWidth((int)((double)table_Width * 0.2));
        Map engineMap = this.getEngineProperty();
        int engineCount = engineMap.size();
        String[] keys = new String[engineCount];
        engineMap.keySet().toArray(keys);
        this.tblEngine.removeRows();
        this.tblCache.removeRows();
        this.SetRowSelectMode(this.tblEngine);
        for (int i = 0; i < engineCount; ++i) {
            this.tblEngine.addRow();
            HashMap property = (HashMap)engineMap.get(keys[i]);
            this.tblEngine.getCell(i, 0).setValue((Object)keys[i].substring(0, keys[i].indexOf(124)));
            this.tblEngine.getCell(i, 1).setValue((Object)keys[i].substring(keys[i].indexOf(124) + 1));
            this.tblEngine.getCell(i, 2).setValue((Object)((Date)property.get("CreatedDate")).toLocaleString());
            this.tblEngine.getCell(i, 3).setValue((Object)((Date)property.get("ThreadGroupCreateDate")).toLocaleString());
            this.tblEngine.getCell(i, 4).setValue(property.get("UserName"));
        }
        this.tblEngine.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                if (e.getClickCount() == 1 && e.getType() == 1) {
                    String ais = (String)MonitorCenterUI.this.tblEngine.getCell(rowIndex, 0).getValue();
                    String solution = (String)MonitorCenterUI.this.tblEngine.getCell(rowIndex, 1).getValue();
                    MonitorCenterUI.this.refreshCacheProperty(ais, solution);
                    MonitorCenterUI.this.refreshQueueProperty(ais, solution);
                }
            }
        });
        this.tblCache.getHeadRow(0).getCell(0).setValue((Object)this.getRes("tblCache_CacheName"));
        this.tblCache.getHeadRow(0).getCell(1).setValue((Object)this.getRes("tblCache_TimeOut"));
        this.tblCache.getHeadRow(0).getCell(2).setValue((Object)this.getRes("tblCache_LastVistTime"));
        this.tblCache.getHeadRow(0).getCell(3).setValue((Object)this.getRes("tblCache_LastClearTime"));
        this.tblCache.getHeadRow(0).getCell(4).setValue((Object)this.getRes("tblCache_Size"));
        this.tblCache.getHeadRow(0).getCell(5).setValue((Object)this.getRes("tblCache_TotalVisit"));
        this.tblCache.getHeadRow(0).getCell(6).setValue((Object)this.getRes("tblCache_HitRate"));
    }

    private void refreshCacheProperty(String ais, String solution) {
        Map propertyMap = new HashMap();
        try {
            propertyMap = this.service.getWfCacheProperty(ais, solution);
        }
        catch (WfException e) {
            logger.error((Object)"refreshCacheProperty", (Throwable)e);
        }
        this.tblCache.removeRows();
        this.SetRowSelectMode(this.tblCache);
        for (int i = 0; i < 5; ++i) {
            this.tblCache.addRow();
        }
        int table_Width = this.pnlEngine.getWidth() - 0;
        this.tblCache.getColumn(0).setWidth((int)((double)table_Width * 0.2));
        this.tblCache.getColumn(1).setWidth((int)((double)table_Width * 0.2));
        this.tblCache.getColumn(2).setWidth((int)((double)table_Width * 0.2));
        this.tblCache.getColumn(3).setWidth((int)((double)table_Width * 0.2));
        this.tblCache.getColumn(4).setWidth((int)((double)table_Width * 0.2));
        this.tblCache.getCell(0, 0).setValue((Object)this.getRes("tblCache_ProcInstCache"));
        this.tblCache.getCell(1, 0).setValue((Object)this.getRes("tblCache_ProcDefCache"));
        this.tblCache.getCell(2, 0).setValue((Object)this.getRes("tblCache_ActInstCache"));
        this.tblCache.getCell(3, 0).setValue((Object)this.getRes("tblCache_AssignmentCache"));
        this.tblCache.getCell(4, 0).setValue((Object)this.getRes("tblCache_ProcMgrCache"));
        long[] procInstCacheProperty = (long[])propertyMap.get("ProcInstCache");
        long[] procDefCacheProperty = (long[])propertyMap.get("ProcDefCache");
        long[] actInstCacheProperty = (long[])propertyMap.get("ActInstCache");
        long[] assignmentCacheProperty = (long[])propertyMap.get("AssignmentCache");
        long[] procMgrCacheProperty = (long[])propertyMap.get("ProcMgrCache");
        this.tblCache.getCell(0, 1).setValue((Object)this.getCastTime(procInstCacheProperty[0]));
        this.tblCache.getCell(0, 2).setValue((Object)this.getCastTime(procInstCacheProperty[1]));
        this.tblCache.getCell(0, 3).setValue((Object)new Date(procInstCacheProperty[2]).toLocaleString());
        this.tblCache.getCell(0, 4).setValue((Object)Long.toString(procInstCacheProperty[3]));
        this.tblCache.getCell(0, 5).setValue((Object)Long.toString(procInstCacheProperty[4]));
        this.tblCache.getCell(0, 6).setValue((Object)this.formatHitRate(procInstCacheProperty[5], procInstCacheProperty[4]));
        this.tblCache.getCell(1, 1).setValue((Object)this.getCastTime(procDefCacheProperty[0]));
        this.tblCache.getCell(1, 2).setValue((Object)this.getCastTime(procDefCacheProperty[1]));
        this.tblCache.getCell(1, 3).setValue((Object)new Date(procDefCacheProperty[2]).toLocaleString());
        this.tblCache.getCell(1, 4).setValue((Object)Long.toString(procDefCacheProperty[3]));
        this.tblCache.getCell(1, 5).setValue((Object)Long.toString(procDefCacheProperty[4]));
        this.tblCache.getCell(1, 6).setValue((Object)this.formatHitRate(procDefCacheProperty[5], procDefCacheProperty[4]));
        this.tblCache.getCell(2, 1).setValue((Object)this.getCastTime(actInstCacheProperty[0]));
        this.tblCache.getCell(2, 2).setValue((Object)this.getCastTime(actInstCacheProperty[1]));
        this.tblCache.getCell(2, 3).setValue((Object)new Date(actInstCacheProperty[2]).toLocaleString());
        this.tblCache.getCell(2, 4).setValue((Object)Long.toString(actInstCacheProperty[3]));
        this.tblCache.getCell(2, 5).setValue((Object)Long.toString(actInstCacheProperty[4]));
        this.tblCache.getCell(2, 6).setValue((Object)this.formatHitRate(actInstCacheProperty[5], actInstCacheProperty[4]));
        this.tblCache.getCell(3, 1).setValue((Object)this.getCastTime(assignmentCacheProperty[0]));
        this.tblCache.getCell(3, 2).setValue((Object)this.getCastTime(assignmentCacheProperty[1]));
        this.tblCache.getCell(3, 3).setValue((Object)new Date(assignmentCacheProperty[2]).toLocaleString());
        this.tblCache.getCell(3, 4).setValue((Object)Long.toString(assignmentCacheProperty[3]));
        this.tblCache.getCell(3, 5).setValue((Object)Long.toString(assignmentCacheProperty[4]));
        this.tblCache.getCell(3, 6).setValue((Object)this.formatHitRate(assignmentCacheProperty[5], assignmentCacheProperty[4]));
        this.tblCache.getCell(4, 1).setValue((Object)this.getCastTime(procMgrCacheProperty[0]));
        this.tblCache.getCell(4, 2).setValue((Object)this.getCastTime(procMgrCacheProperty[1]));
        this.tblCache.getCell(4, 3).setValue((Object)new Date(procMgrCacheProperty[2]).toLocaleString());
        this.tblCache.getCell(4, 4).setValue((Object)Long.toString(procMgrCacheProperty[3]));
        this.tblCache.getCell(4, 5).setValue((Object)Long.toString(procMgrCacheProperty[4]));
        this.tblCache.getCell(4, 6).setValue((Object)this.formatHitRate(procMgrCacheProperty[5], procMgrCacheProperty[4]));
    }

    private void refreshQueueProperty(String ais, String solution) {
        this.refreshBizEventQueueTable(ais, solution);
        this.refreshProcCrtQueueTable(ais, solution);
        this.refreshTransQueueTable(ais, solution);
    }

    private void refreshTransQueueTable(String ais, String solution) {
        String serverKey = null;
        try {
            serverKey = this.service.getServerKey(ais, solution);
        }
        catch (WfException e) {
            logger.error((Object)"refreshTransQueueTable", (Throwable)e);
        }
        this.tblTransQueue.removeRows();
        MetaDataPK transQuequeQueryPK = new MetaDataPK("com.kingdee.bos.workflow.metas", "TransQuequeQuery");
        EntityViewInfo transQuequeEntityView = new EntityViewInfo();
        FilterItemInfo serverKeyFilter = new FilterItemInfo("serverKey", (Object)serverKey, CompareType.EQUALS);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(serverKeyFilter);
        transQuequeEntityView.setFilter(filterInfo);
        IRowSet rowSet = null;
        try {
            rowSet = this.getQueryExecutor((IMetaDataPK)transQuequeQueryPK, transQuequeEntityView).executeQuery(0, 200);
            while (rowSet.next()) {
                IRow row = this.tblTransQueue.addRow();
                row.getCell(0).setValue((Object)rowSet.getString(1));
                row.getCell(1).setValue((Object)rowSet.getString(2));
                row.getCell(2).setValue((Object)rowSet.getString(3));
                row.getCell(3).setValue((Object)rowSet.getDate(4));
            }
        }
        catch (BOSException exp) {
            this.handleException((Exception)((Object)exp));
        }
        catch (SQLException exp1) {
            this.handleException(exp1);
        }
    }

    private void refreshProcCrtQueueTable(String ais, String solution) {
        String serverKey = null;
        try {
            serverKey = this.service.getServerKey(ais, solution);
        }
        catch (WfException e) {
            logger.error((Object)"refreshProcCrtQueueTable", (Throwable)e);
        }
        this.tblProcCrtQueue.removeRows();
        MetaDataPK procCrtQueueQueryPK = new MetaDataPK("com.kingdee.bos.workflow.metas", "ProCreQueueQuery");
        EntityViewInfo procCrtQueueEntityView = new EntityViewInfo();
        FilterItemInfo serverKeyFilter = new FilterItemInfo("serverKey", (Object)serverKey, CompareType.EQUALS);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(serverKeyFilter);
        procCrtQueueEntityView.setFilter(filterInfo);
        IRowSet rowSet = null;
        try {
            rowSet = this.getQueryExecutor((IMetaDataPK)procCrtQueueQueryPK, procCrtQueueEntityView).executeQuery(0, 200);
        }
        catch (BOSException exp) {
            this.handleException((Exception)((Object)exp));
        }
        try {
            while (rowSet.next()) {
                IRow row = this.tblProcCrtQueue.addRow();
                row.getCell(0).setValue((Object)rowSet.getString(1));
                row.getCell(1).setValue((Object)rowSet.getString(2));
                row.getCell(2).setValue((Object)rowSet.getString(3));
                row.getCell(3).setValue((Object)rowSet.getDate(4));
            }
        }
        catch (SQLException exp1) {
            this.handleException(exp1);
        }
    }

    private void refreshBizEventQueueTable(String ais, String solution) {
        String serverKey = null;
        try {
            serverKey = this.service.getServerKey(ais, solution);
        }
        catch (WfException e) {
            logger.error((Object)"refreshBizEventQueueTable", (Throwable)e);
        }
        this.tblBizEventQueue.removeRows();
        MetaDataPK bizEventQueueQueryPK = new MetaDataPK("com.kingdee.bos.workflow.metas", "BizEventQueueQuery");
        EntityViewInfo bizEventQueueEntityView = new EntityViewInfo();
        FilterItemInfo serverKeyFilter = new FilterItemInfo("serverKey", (Object)serverKey, CompareType.EQUALS);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(serverKeyFilter);
        bizEventQueueEntityView.setFilter(filterInfo);
        IRowSet rowSet = null;
        try {
            rowSet = this.getQueryExecutor((IMetaDataPK)bizEventQueueQueryPK, bizEventQueueEntityView).executeQuery(0, 200);
        }
        catch (BOSException exp) {
            this.handleException((Exception)((Object)exp));
        }
        try {
            while (rowSet.next()) {
                IRow row = this.tblBizEventQueue.addRow();
                row.getCell(0).setValue((Object)rowSet.getString(1));
                row.getCell(1).setValue((Object)rowSet.getString(2));
                row.getCell(2).setValue((Object)rowSet.getDate(3));
                row.getCell(3).setValue((Object)rowSet.getString(4));
                row.getCell(4).setValue((Object)rowSet.getString(5));
                row.getCell(5).setValue((Object)rowSet.getString(6));
                row.getCell(6).setValue((Object)Integer.toString(rowSet.getInt(7)));
            }
        }
        catch (SQLException exp1) {
            this.handleException(exp1);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private String formatHitRate(long totalHit, long totalVisit) {
        if (totalVisit == 0L) {
            return "0";
        }
        double hitRate = totalHit / totalVisit;
        NumberFormat formatter = NumberFormat.getPercentInstance(this.currentLocale);
        formatter.setMaximumFractionDigits(3);
        String hitRateString = formatter.format(hitRate);
        return hitRateString;
    }

    private Map getEngineProperty() {
        Map engineMap = new HashMap();
        try {
            engineMap = this.service.getEngineProperty();
        }
        catch (WfException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return engineMap;
    }

    private void refreshEnvPanel() {
        this.Init_tblEnv_BasicProperty();
        this.init_Tables(this.tblEnv_ServiceState, "tblEnv_ServiceState_RowHeadName", 4);
        this.SetRowSelectMode(this.tblEnv_ServiceState);
        this.tblEnv_ServiceState.getCell(0, 0).setValue((Object)this.getRes("tblEnv_ServiceState_Participant"));
        this.tblEnv_ServiceState.getCell(0, 1).setValue((Object)(this.checkProviderState("Participant") ? this.getRes("ServiceState_Normal") : this.getRes("ServiceState_Colse")));
        this.tblEnv_ServiceState.getCell(1, 0).setValue((Object)this.getRes("tblEnv_ServiceState_Permission"));
        this.tblEnv_ServiceState.getCell(1, 1).setValue((Object)(this.checkProviderState("Permission") ? this.getRes("ServiceState_Normal") : this.getRes("ServiceState_Colse")));
        this.tblEnv_ServiceState.getCell(2, 0).setValue((Object)this.getRes("tblEnv_ServiceState_Message"));
        this.tblEnv_ServiceState.getCell(2, 1).setValue((Object)(this.checkProviderState("Message") ? this.getRes("ServiceState_Normal") : this.getRes("ServiceState_Colse")));
        this.tblEnv_ServiceState.getCell(3, 0).setValue((Object)this.getRes("tblEnv_ServiceState_Timeliness"));
        this.tblEnv_ServiceState.getCell(3, 1).setValue((Object)(this.checkProviderState("Timeliness") ? this.getRes("ServiceState_Normal") : this.getRes("ServiceState_Colse")));
        this.Init_LogConfig();
    }

    private void Init_LogConfig() {
        WfLogConfig logConfig = this.getLogConfig();
        this.cmbLogLevel.setSelectedItem((Object)logConfig.logLevel);
        this.chkEnableEngineLog.setSelected(logConfig.enableEngineLog);
        this.chkEnableProcessDefLog.setSelected(logConfig.enableProcessDefLog);
        this.chkEnableProcessInstLog.setSelected(logConfig.enableProcessInstLog);
        this.chkEnableQueueLog.setSelected(logConfig.enableQueueLog);
    }

    @Override
    public void actionSaveLogConfig_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> logConfigMap = new HashMap<String, Object>();
        logConfigMap.put(LOGCONFIG_LOGLEVEL, Integer.toString(this.cmbLogLevel.getSelectedIndex()));
        logConfigMap.put(LOGCONFIG_ENABLEENGINELOG, this.chkEnableEngineLog.getSelected() == 32);
        logConfigMap.put(LOGCONFIG_ENABLEPROCESSDEFLOG, this.chkEnableProcessDefLog.getSelected() == 32);
        logConfigMap.put(LOGCONFIG_ENABLEPROCESSINSTLOG, this.chkEnableProcessInstLog.getSelected() == 32);
        logConfigMap.put(LOGCONFIG_ENABLEQUEUELOG, this.chkEnableQueueLog.getSelected() == 32);
        this.service.setLogConfig(logConfigMap);
    }

    private void Init_tblEnv_BasicProperty() {
        this.SetRowSelectMode(this.tblEnv_BasicProperty);
        this.tblEnv_BasicProperty.getHeadRow(0).getCell(0).setValue((Object)this.getRes("tblEnv_BasicProperty_RowHeadName"));
        this.tblEnv_BasicProperty.getHeadMergeManager().setMergeMode(1);
        KDTMergeManager tblEnv_BasicProperty_MergeManager = this.tblEnv_BasicProperty.getHeadMergeManager();
        tblEnv_BasicProperty_MergeManager.mergeBlock(0, 0, 0, 2, 4);
        int table_Width = this.pnlEnv.getWidth() - 30;
        this.tblEnv_BasicProperty.getColumn(0).setWidth((int)((double)table_Width * 0.2));
        this.tblEnv_BasicProperty.getColumn(1).setWidth((int)((double)table_Width * 0.3));
        this.tblEnv_BasicProperty.getColumn(2).setWidth((int)((double)table_Width * 0.5));
        this.tblEnv_BasicProperty.removeRows();
        for (int i = 0; i < 8; ++i) {
            this.tblEnv_BasicProperty.addRow();
        }
        this.tblEnv_BasicProperty.getCell(0, 0).setValue((Object)this.getRes("BasicProperty_isEnableDaemon"));
        this.tblEnv_BasicProperty.getCell(1, 0).setValue((Object)this.getRes("BasicProperty_cacheManager"));
        this.tblEnv_BasicProperty.getCell(2, 0).setValue((Object)this.getRes("BasicProperty_isEnableScheduler"));
        this.tblEnv_BasicProperty.getCell(3, 0).setValue((Object)this.getRes("BasicProperty_schedulerIdleWaiteTime"));
        this.tblEnv_BasicProperty.getCell(4, 0).setValue((Object)this.getRes("BasicProperty_schedulerThreadPoolSize"));
        this.tblEnv_BasicProperty.getCell(5, 0).setValue((Object)this.getRes("BasicProperty_workflowTransQueueTime"));
        this.tblEnv_BasicProperty.getCell(6, 0).setValue((Object)this.getRes("BasicProperty_isInitWfService"));
        this.tblEnv_BasicProperty.getCell(7, 0).setValue((Object)this.getRes("BasicProperty_workflowServerKey"));
        this.tblEnv_BasicProperty.getCell(0, 2).setValue((Object)this.getRes("BasicProperty_isEnableDaemon_Description"));
        this.tblEnv_BasicProperty.getCell(1, 2).setValue((Object)this.getRes("BasicProperty_cacheManager_Description"));
        this.tblEnv_BasicProperty.getCell(2, 2).setValue((Object)this.getRes("BasicProperty_isEnableScheduler_Description"));
        this.tblEnv_BasicProperty.getCell(3, 2).setValue((Object)this.getRes("BasicProperty_schedulerIdleWaiteTime_Description"));
        this.tblEnv_BasicProperty.getCell(4, 2).setValue((Object)this.getRes("BasicProperty_schedulerThreadPoolSize_Description"));
        this.tblEnv_BasicProperty.getCell(5, 2).setValue((Object)this.getRes("BasicProperty_workflowTransQueueTime_Description"));
        this.tblEnv_BasicProperty.getCell(6, 2).setValue((Object)this.getRes("BasicProperty_isInitWfService_Description"));
        this.tblEnv_BasicProperty.getCell(7, 2).setValue((Object)this.getRes("BasicProperty_workflowServerKey_Description"));
        ConfigurationItem wfItem = this.getwfItem();
        if (wfItem != null) {
            this.tblEnv_BasicProperty.getCell(0, 1).setValue((Object)wfItem.getProperty(WORKFLOW_ISENABLEDAEMON));
            this.tblEnv_BasicProperty.getCell(1, 1).setValue((Object)wfItem.getProperty(WORKFLOW_CACHEMANAGER));
            this.tblEnv_BasicProperty.getCell(2, 1).setValue((Object)wfItem.getProperty(WORKFLOW_ISENABLE_SCHEDULER));
            this.tblEnv_BasicProperty.getCell(3, 1).setValue((Object)(wfItem.getProperty(WORKFLOW_SCHEDULER_IDLE_WAITE_TIME) + "ms"));
            this.tblEnv_BasicProperty.getCell(4, 1).setValue((Object)wfItem.getProperty(WORKFLOW_SCHEDULER_THREADPOOL_SIZE));
            this.tblEnv_BasicProperty.getCell(5, 1).setValue((Object)(wfItem.getProperty(WORKFLOW_TRANS_QUEUETIME) + "ms"));
            this.tblEnv_BasicProperty.getCell(6, 1).setValue((Object)wfItem.getProperty(WORKFLOW_ISINIT_WFSERVICE));
            this.tblEnv_BasicProperty.getCell(7, 1).setValue((Object)wfItem.getProperty(WORKFLOW_SERVER_KEY));
        }
    }

    public ConfigurationItem getwfItem() {
        ConfigurationItem wfItem = this.service.getWfConfigItem();
        return wfItem;
    }

    public WfLogConfig getLogConfig() {
        WfLogConfig logConfig = this.service.getLogConfig();
        return logConfig;
    }

    public boolean checkProviderState(String providerName) {
        block9: {
            String checkName = "";
            try {
                if (providerName.equalsIgnoreCase("Participant")) {
                    checkName = this.service.checkParticipantProvider();
                    if (checkName.equals("com.kingdee.eas.basedata.person.app.PersonToWFAdapter")) {
                        return true;
                    }
                    break block9;
                }
                if (providerName.equalsIgnoreCase("Permission")) {
                    checkName = this.service.checkPermissionProvider();
                    if (checkName.equals("com.kingdee.eas.base.permission.app.adapter.WfPermissionProvider")) {
                        return true;
                    }
                    break block9;
                }
                if (providerName.equalsIgnoreCase("Message")) {
                    return this.service.checkMessageProvider(this.getUserPk().toString());
                }
                if (providerName.equalsIgnoreCase("Timeliness")) {
                    checkName = this.service.checkTimelinessProvider();
                    if (checkName.equals("com.kingdee.bos.workflow.timeliness.TimelinessProvider")) {
                        return true;
                    }
                    break block9;
                }
                throw new Exception("TODO");
            }
            catch (Exception exp) {
                this.handleException(exp);
            }
        }
        return false;
    }

    private void refreshKSQLPanel() {
        this.init_Tables(this.tblKSQL_BasicProperty, "tblKSQL_BasicProperty_RowHeadName", 3);
        this.tblKSQL_BasicProperty.getCell(1, 0).setValue((Object)this.getRes("tblKSQL_BasicProperty_CurConnCount"));
        this.tblKSQL_BasicProperty.getCell(2, 0).setValue((Object)this.getRes("tblKSQL_BasicProperty_DbType"));
        this.tblKSQL_SQLTrace.getHeadRow(0).getCell(0).setValue((Object)this.getRes("tblKSQL_SQLTrace_HeadName_0"));
        this.tblKSQL_SQLTrace.getHeadRow(0).getCell(1).setValue((Object)this.getRes("tblKSQL_SQLTrace_HeadName_1"));
        this.tblKSQL_SQLTrace.getHeadRow(0).getCell(2).setValue((Object)this.getRes("tblKSQL_SQLTrace_HeadName_2"));
        this.tblKSQL_SQLTrace.getHeadRow(0).getCell(3).setValue((Object)this.getRes("tblKSQL_SQLTrace_HeadName_3"));
        this.tblKSQL_SQLTrace.getHeadRow(0).getCell(4).setValue((Object)this.getRes("tblKSQL_SQLTrace_HeadName_4"));
        int tblKSQL_SQLTrace_Width = this.pnlEnv.getWidth() - 30;
        this.tblKSQL_SQLTrace.getColumn(0).setWidth(120);
        this.tblKSQL_SQLTrace.getColumn(1).setWidth(80);
        this.tblKSQL_SQLTrace.getColumn(2).setWidth(120);
        this.tblKSQL_SQLTrace.getColumn(3).setWidth(80);
        this.tblKSQL_SQLTrace.getColumn(4).setWidth(tblKSQL_SQLTrace_Width - 400);
        this.tblKSQL_SQLTrace.getColumn(5).setWidth(0);
        this.refreshTblKSQL();
    }

    private void refreshTblKSQL() {
        try {
            HashMap traceMap = null;
            if (this.service.getKSQLTraceInfo() != null) {
                traceMap = this.service.getKSQLTraceInfo();
                String connCount = Integer.toString(traceMap.values().size());
                this.tblKSQL_BasicProperty.getCell(1, 1).setValue((Object)connCount);
            }
            this.tblKSQL_SQLTrace.removeRows();
            this.tblKSQL_BasicProperty.getSelectManager().setSelectMode(2);
            this.tblKSQL_SQLTrace.getSelectManager().setSelectMode(2);
            Iterator iter = traceMap.values().iterator();
            while (iter.hasNext()) {
                IRow row = this.tblKSQL_SQLTrace.addRow();
                ConnectionInfo connInfo = (ConnectionInfo)iter.next();
                String stackTrace = this.getStackTrace(connInfo);
                ICell cell = row.getCell(0);
                cell.setValue((Object)new Date(connInfo.createdTime).toLocaleString());
                cell.getStyleAttributes().setLocked(true);
                if (connInfo.lastStmtInfo != null) {
                    cell = row.getCell(1);
                    String connCastTime = "";
                    connCastTime = this.getCastTime(System.currentTimeMillis() - connInfo.lastStmtInfo.createdTime);
                    cell.setValue((Object)connCastTime);
                    cell.getStyleAttributes().setLocked(true);
                    cell = row.getCell(2);
                    cell.setValue((Object)new Date(connInfo.lastStmtInfo.createdTime).toLocaleString());
                    cell.getStyleAttributes().setLocked(true);
                    cell = row.getCell(3);
                    String stmtCastTime = this.getCastTime(System.currentTimeMillis() - connInfo.lastStmtInfo.createdTime);
                    cell.setValue((Object)stmtCastTime);
                    cell.getStyleAttributes().setLocked(true);
                    cell = row.getCell(4);
                    cell.setValue((Object)connInfo.lastStmtInfo.sql);
                    cell.getStyleAttributes().setLocked(false);
                }
                cell = row.getCell(5);
                cell.setValue((Object)stackTrace);
            }
        }
        catch (Exception exp) {
            this.handleException(exp);
        }
        this.tblKSQL_SQLTrace.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int rowIndex = e.getRowIndex();
                if (e.getClickCount() == 1 && e.getType() == 1) {
                    String stackTrace = (String)MonitorCenterUI.this.tblKSQL_SQLTrace.getCell(rowIndex, 5).getValue();
                    MonitorCenterUI.this.txtKSQLStackTrace.setText(stackTrace);
                    MonitorCenterUI.this.txtKSQLStackTrace.setAutoscrolls(true);
                }
            }
        });
    }

    private String getStackTrace(ConnectionInfo connInfo) {
        int i;
        StackTraceElement[] elementArray;
        StatementInfo stmtInfo = connInfo.lastStmtInfo;
        StringBuffer buff = new StringBuffer();
        buff.append("stmt stackTrace : \n");
        if (stmtInfo != null) {
            if (stmtInfo.stackTrace instanceof StackTraceElement[]) {
                elementArray = (StackTraceElement[])stmtInfo.stackTrace;
                for (i = 0; i < elementArray.length; ++i) {
                    buff.append(elementArray[i].toString());
                    buff.append("\n");
                }
            } else if (stmtInfo.stackTrace == null) {
                buff.append("connection not close, but stackTrace is null");
            } else {
                buff.append(stmtInfo.stackTrace.toString());
            }
        } else {
            buff.append("connection not close, but stackTrace is null.\n");
        }
        buff.append("\nconnection stackTrace : \n");
        if (connInfo.stackTrace instanceof StackTraceElement[]) {
            elementArray = (StackTraceElement[])connInfo.stackTrace;
            for (i = 0; i < elementArray.length; ++i) {
                buff.append(elementArray[i].toString());
                buff.append("\n");
            }
        } else if (connInfo.stackTrace == null) {
            buff.append("connection not close, but stackTrace is null");
        } else {
            buff.append(connInfo.stackTrace.toString());
        }
        buff.append("\n");
        return buff.toString();
    }

    private String getCastTime(long connCastTime) {
        int hours = (int)(connCastTime / 3600000L);
        int mins = (int)((connCastTime - (long)(hours * 3600000)) / 60000L);
        int seconds = (int)((connCastTime - (long)(hours * 3600000) - (long)(mins * 60000)) / 1000L);
        int millseconds = (int)(connCastTime - (long)(hours * 3600000) - (long)(mins * 60000) - (long)(seconds * 1000));
        String time = hours + ":" + mins + "." + seconds + " " + millseconds;
        return time;
    }

    private void init_Tables(KDTable table, String headRowName, int rowNum) {
        table.getHeadRow(0).getCell(0).setValue((Object)this.getRes(headRowName));
        table.getHeadMergeManager().setMergeMode(1);
        KDTMergeManager table_MergeManager = table.getHeadMergeManager();
        table_MergeManager.mergeBlock(0, 0, 0, 2, 4);
        int table_Width = this.pnlEnv.getWidth() - 30;
        table.getColumn(0).setWidth((int)((double)table_Width * 0.2));
        table.getColumn(1).setWidth((int)((double)table_Width * 0.5));
        table.getColumn(2).setWidth((int)((double)table_Width * 0.3));
        table.removeRows();
        for (int i = 0; i < rowNum; ++i) {
            table.addRow();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void SetRowSelectMode(KDTable table) {
        table.getSelectManager().setSelectMode(2);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        String selectPathName = this.treeCatalog.getSelectionPath().getLastPathComponent().toString();
        if (selectPathName.equals(this.getRes("EnvNode"))) {
            this.refreshEnvPanel();
        } else if (selectPathName.equals(this.getRes("EngineNode"))) {
            this.refreshEnginePanel();
        } else if (selectPathName.equals(this.getRes("KSQLNode"))) {
            this.refreshKSQLPanel();
        }
    }

    @Override
    public void actionResetWorkderThread_actionPerformed(ActionEvent e) throws Exception {
        this.service.resetWorkerThread();
    }
}

