/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.monitor.client.AbstractProcessProperty;
import com.kingdee.bos.workflow.monitor.client.InputBox;
import com.kingdee.bos.workflow.monitor.client.PermissionUtil;
import com.kingdee.bos.workflow.monitor.client.ProcessPropertyCompartor;
import com.kingdee.bos.workflow.monitor.client.ProcessPropertyEditUI;
import com.kingdee.bos.workflow.monitor.client.ProcessPropertyUIObject;
import com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorPanel;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.IWfFacade;
import com.kingdee.bos.workflow.service.ormrpc.WfFacadeFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProcessProperty
extends AbstractProcessProperty {
    private static final Logger logger = CoreUIObject.getLogger(ProcessProperty.class);
    private static final long serialVersionUID = 3233948450581903630L;
    ProcessInstInfo pInfo;
    WorkFlowMonitorPanel panel;
    ProcessPropertyEditUI ui = new ProcessPropertyEditUI();
    PermissionUtil permissionUtil = new PermissionUtil();
    private final String resourceClass = "com.kingdee.bos.workflow.monitor.client.WfMonitorResources";
    private final String workflowResourceClass = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource";
    private final String res2 = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource";
    private boolean ascendingOrder = true;
    private int sortColIndex = 0;
    private Map processVarMap = new HashMap();
    private List processProperties = new ArrayList();
    private Map dataFields;
    private boolean isShowAllProcessVar = false;

    public ProcessProperty() throws Exception {
        String flowpropertyText;
        String resourceClass = "com.kingdee.bos.workflow.monitor.client.WfMonitorResources";
        this.windowTitle = flowpropertyText = EASResource.getString((String)resourceClass, (String)"processProperty");
        this.suspendBtn.setIcon(EASResource.getIcon((String)"imgTbtn_suspendinstance"));
        this.canSuspendBtn.setIcon(EASResource.getIcon((String)"imgTbtn_abolishsuspend"));
        this.abortBtn.setIcon(EASResource.getIcon((String)"imgTbtn_abortinstance"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        this.panel = (WorkFlowMonitorPanel)((Object)this.getUIContext().get("monitorPanel"));
        RequestContext request = (RequestContext)postman.getRequestContext();
        request.put("procInstId", (Object)this.panel.image.getProcInstId());
        postman.setRequestContext((Serializable)request);
        return postman;
    }

    private String getInstState(String procInstId) {
        try {
            String sql = "select fstate from t_wfr_procinst where fprocinstid = '" + procInstId + "'";
            SQLExecutor sqlExecutor = new SQLExecutor(sql);
            IRowSet rowset = sqlExecutor.executeSQL();
            if (rowset.next()) {
                return rowset.getString("fstate");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.panel == null) {
            this.panel = (WorkFlowMonitorPanel)((Object)this.getUIContext().get("monitorPanel"));
        }
        IEnactmentService svc = EnactmentServiceFactory.createRemoteEnactService();
        this.pInfo = svc.getProcessInstInfo(this.panel.image.getProcInstId());
        String state = this.getInstState(this.panel.image.getProcInstId());
        if (state != null && !state.equals(this.pInfo.getState())) {
            logger.error((Object)("-------------------------the procinst from cache hasn't been updated! : " + this.panel.image.getProcInstId()));
            this.pInfo.setState(state);
        }
        try {
            this.processVarMap = svc.getProcessContext(this.pInfo.getProcInstId(), true);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg.contains("ClassNotFoundException")) {
                int j = 0;
                int i = msg.indexOf("{#");
                if (i > 0 && (j = msg.indexOf("#}")) > 0) {
                    String info = msg.substring(i + 2, j);
                    String[] infos = info.split(",");
                    MsgBox.showError((String)("\u6d41\u7a0b\u53d8\u91cf\uff1a" + infos[0] + " , \u52a0\u8f7d\u51fa\u9519\u3002\u539f\u56e0\u662f\u5176\u5bf9\u5e94\u7684\u7c7b\u4e0d\u5b58\u5728\uff1a" + infos[1]));
                    SysUtil.abort();
                }
            }
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showError((String)"\u4e0d\u5b58\u5728\u6d41\u7a0b\u5c5e\u6027\u4fe1\u606f\u6216\u8be5\u4fe1\u606f\u5df2\u88ab\u5220\u9664\uff01");
            SysUtil.abort();
        }
        IWfFacade facade = WfFacadeFactory.getRemoteInstance();
        this.dataFields = facade.getProcessDataFieldsType(this.pInfo.getProcDefHashValue());
        this.initText();
        this.initButtonState();
        this.setTableStyle();
        this.initTableListener();
        this.getProcessPropertyUIObject(false);
        this.sortPerproties(this.sortColIndex, this.ascendingOrder);
        this.fillTable();
        this.refreshAbortButton();
    }

    private void getProcessPropertyUIObject(boolean refresh) {
        if (this.processVarMap == null || this.processVarMap.size() <= 0 || refresh) {
            this.processVarMap = this.getProcessVariables();
        }
        this.processProperties.clear();
        for (String key : this.processVarMap.keySet()) {
            ProcessPropertyUIObject obj = this.constructProcessProperty(key);
            if (obj == null) continue;
            this.processProperties.add(obj);
        }
    }

    private ProcessPropertyUIObject constructProcessProperty(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        ProcessPropertyUIObject processPropertyUIObject = new ProcessPropertyUIObject();
        processPropertyUIObject.setName(key);
        processPropertyUIObject.setObjectValue(null);
        processPropertyUIObject.setRValue(null);
        IObjectValue objVal = null;
        if (this.processVarMap.get(key) == null || this.processVarMap.get(key).toString() == null) {
            processPropertyUIObject.setValue(" ");
        } else {
            String value = this.processVarMap.get(key).toString();
            if (this.processVarMap.get(key) instanceof BigDecimal) {
                NumberFormat format = NumberFormat.getInstance();
                format.setMinimumFractionDigits(10);
                format.setMaximumFractionDigits(10);
                value = format.format(this.processVarMap.get(key));
            }
            processPropertyUIObject.setValue(value);
        }
        if (this.processVarMap.get(key) instanceof IObjectValue) {
            objVal = (IObjectValue)this.processVarMap.get(key);
        } else {
            processPropertyUIObject.setRValue(this.processVarMap.get(key));
        }
        String type = "";
        if (this.dataFields != null) {
            Object o = this.dataFields.get(key);
            if (o != null) {
                type = this.typeToString(o.toString());
                if (o.toString().equalsIgnoreCase("BIZOBJ") || o.toString().equalsIgnoreCase("APPROVERESULT")) {
                    processPropertyUIObject.setObjectValue(objVal);
                }
            }
            processPropertyUIObject.setDataType(type);
        }
        return processPropertyUIObject;
    }

    private void setTableStyle() {
        this.flowVariableTable.removeRows();
        this.flowVariableTable.checkParsed();
        this.flowVariableTable.getStyleAttributes().setLocked(true);
        this.flowVariableTable.getColumn(2).setWidth(120);
    }

    private void initTableListener() {
        this.flowVariableTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() == 0) {
                    ProcessProperty.this.handleShowAllProcessVar(e);
                } else if (e.getClickCount() == 1 && e.getType() == 0) {
                    ProcessProperty.this.handleSortColumns(e);
                } else if (e.getClickCount() == 2 && e.getType() != 0) {
                    ProcessProperty.this.handleProcessVarEdit(e);
                }
            }
        });
    }

    private void handleShowAllProcessVar(KDTMouseEvent e) {
        this.isShowAllProcessVar = !this.isShowAllProcessVar;
        this.fillTable();
    }

    private String getParentRowNameValue(IRow row, KDTable table) {
        String str = "";
        int currentRowNum = row.getRowIndex();
        IRow tempRow = null;
        int level = row.getTreeLevel();
        if (level > 0) {
            for (int i = currentRowNum; i >= 0; --i) {
                tempRow = table.getRow2(i);
                if (tempRow.getTreeLevel() != level - 1) continue;
                str = tempRow.getCell(0).getValue().toString() + "@@" + tempRow.getCell(1).getValue().toString();
                break;
            }
        }
        return str;
    }

    private void handleProcessVarEdit(KDTMouseEvent e) {
        if (this.flowVariableTable.getCell(e.getRowIndex(), 2) == null) {
            return;
        }
        String type = (String)this.flowVariableTable.getCell(e.getRowIndex(), 2).getValue();
        if (type.equals(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"approve_type"))) {
            type = "APPROVERESULT";
        }
        ObjectUuidPK pk = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        if (type.length() <= 0 || type.equalsIgnoreCase("Object") || type.equalsIgnoreCase(EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"biz_type"))) {
            return;
        }
        if (Administrator.isSuperCUAdmin((IObjectPK)pk) || this.pInfo.getState().startsWith("open.not_running")) {
            try {
                if (this.checkOperateProcessPermission("wf_report_Monitor_EditProcessProperty")) {
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"Name", this.flowVariableTable.getCell(e.getRowIndex(), 0).getValue());
                    uiContext.put((Object)"Type", (Object)type);
                    if (type.equals("APPROVERESULT_CHILD")) {
                        String approveResultStr = this.getParentRowNameValue(this.flowVariableTable.getRow2(e.getRowIndex()), this.flowVariableTable);
                        uiContext.put((Object)"approveResultStr", (Object)approveResultStr);
                    }
                    uiContext.put((Object)"OriginalValue", (Object)this.flowVariableTable.getCell(e.getRowIndex(), 1).getValue().toString());
                    uiContext.put((Object)"ProcessInstId", (Object)this.pInfo.getProcInstId());
                    String className = ProcessPropertyEditUI.class.getName();
                    try {
                        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
                        uiWindow.show();
                        this.getProcessPropertyUIObject(true);
                        this.fillTable();
                    }
                    catch (UIException ex) {
                        this.handUIException(ex);
                    }
                } else {
                    this.handleException("noPerm");
                }
            }
            catch (EASBizException e1) {
                logger.error((Object)"handleProcessVarEdit", (Throwable)e1);
            }
            catch (BOSException e1) {
                logger.error((Object)"handleProcessVarEdit", (Throwable)e1);
            }
        }
    }

    private void handleSortColumns(KDTMouseEvent e) {
        if (this.sortColIndex == e.getColIndex()) {
            this.ascendingOrder = !this.ascendingOrder;
        } else {
            this.sortColIndex = e.getColIndex();
            this.ascendingOrder = true;
        }
        this.sortPerproties(e.getColIndex(), this.ascendingOrder);
        this.fillTable();
    }

    private void sortPerproties(int colIndex, boolean order) {
        Collections.sort(this.processProperties, new ProcessPropertyCompartor(colIndex, order));
    }

    public void initButtonState() {
        this.suspendBtn.setEnabled(true);
        this.canSuspendBtn.setEnabled(true);
        this.abortBtn.setEnabled(true);
        if (this.pInfo.getState().equals(WfState.NOT_STARTED.getValue())) {
            this.suspendBtn.setEnabled(false);
            this.canSuspendBtn.setEnabled(false);
        } else if (this.pInfo.getState().equals(WfState.SUSPENDED.getValue())) {
            this.suspendBtn.setEnabled(false);
        } else if (this.pInfo.getState().equals(WfState.RUNNING.getValue())) {
            this.canSuspendBtn.setEnabled(false);
        } else if (this.pInfo.getState().equals(WfState.BLOCKED.getValue())) {
            this.suspendBtn.setEnabled(false);
        } else {
            this.suspendBtn.setEnabled(false);
            this.canSuspendBtn.setEnabled(false);
            this.abortBtn.setEnabled(false);
        }
    }

    public void initText() {
        if (this.pInfo.getCode() != null && !this.pInfo.getCode().equals("")) {
            this.windowTitle = EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"windowTitle") + this.pInfo.getCode() + ")";
        }
        Locale locale = SysContext.getSysContext().getLocale();
        String processName = (String)this.pInfo.getMeta().get("procdefName_" + locale.toString().toLowerCase());
        String processTopic = (String)this.pInfo.getMeta().get("procInstTopic_" + locale.toString().toLowerCase());
        String currentState = this.pInfo.getState();
        currentState = this.convertState(currentState);
        String initiator = this.pInfo.getInitiatorName(locale);
        String createTime = this.pInfo.getCreatedTime().toString();
        String completeTime = this.pInfo.getCompleteTime() == null ? "" : this.pInfo.getCompleteTime().toString();
        this.flowNameText.setText(processName);
        this.currentStatusText.setText(currentState);
        this.initiatorText.setText(initiator);
        this.createTimeText.setText(createTime);
        this.completeTimeText.setText(completeTime);
        this.procInstCodeTextField.setText(this.pInfo.getCode());
        this.kDTextProcinstId.setText(this.pInfo.getProcInstId());
        this.instTopicText.setText(processTopic);
        this.flowNameText.setEditable(false);
        this.currentStatusText.setEditable(false);
        this.initiatorText.setEditable(false);
        this.createTimeText.setEditable(false);
        this.completeTimeText.setEditable(false);
        this.procInstCodeTextField.setEditable(false);
        this.instTopicText.setEditable(false);
        this.kDTextProcinstId.setEditable(false);
    }

    private void fillTable() {
        this.flowVariableTable.refresh();
        this.flowVariableTable.getTreeColumn().setDepth(5);
        IRow row = null;
        ICell cell = null;
        ProcessPropertyUIObject uiObject = null;
        for (int i = 0; i < this.processProperties.size(); ++i) {
            uiObject = (ProcessPropertyUIObject)this.processProperties.get(i);
            String name = uiObject.getName();
            if (name == null || name.length() == 0 || !this.isShowAllProcessVar && (name.endsWith(".bizId$") || name.startsWith("MANUALDECISION") || name.startsWith("UIClassName") || name.startsWith("defaultOpinion") || name.startsWith("DP_") || name.endsWith("exceptionMessage") || name.endsWith("exceptionName") || name.startsWith("$"))) continue;
            row = this.flowVariableTable.addRow();
            row.setTreeLevel(0);
            cell = row.getCell(0);
            cell.setValue((Object)uiObject.getName());
            cell = row.getCell(1);
            cell.setValue((Object)uiObject.getValue());
            cell = row.getCell(2);
            cell.setValue((Object)uiObject.getDataType());
            row.setUserObject((Object)uiObject);
            if (uiObject.getObjectValue() != null) {
                this.fillObjectValue(1, uiObject.getObjectValue());
                continue;
            }
            if (uiObject.getRValue() == null || !uiObject.getRValue().getClass().isArray()) continue;
            this.fillArray(1, uiObject.getRValue());
        }
    }

    private void fillObjectValue(int deep, IObjectValue objectValue) {
        if (deep > 4) {
            return;
        }
        IRow row = null;
        boolean flag = objectValue instanceof MultiApproveInfo;
        ICell cell = null;
        Enumeration en = objectValue.keys();
        String pre = "";
        for (int i = 0; i < deep; ++i) {
            pre = pre + "    ";
        }
        while (en.hasMoreElements()) {
            Object value;
            Object key = en.nextElement();
            if (key == null || (value = objectValue.get(key.toString())) == null) continue;
            row = this.flowVariableTable.addRow();
            row.setTreeLevel(deep);
            cell = row.getCell(0);
            cell.setValue((Object)(pre + key.toString()));
            cell = row.getCell(1);
            cell.setValue((Object)value.toString());
            cell = row.getCell(2);
            if (flag) {
                cell.setValue((Object)"APPROVERESULT_CHILD");
            } else {
                cell.setValue((Object)"");
            }
            row.setUserObject(value);
            if (value instanceof IObjectValue) {
                this.fillObjectValue(deep + 1, (IObjectValue)value);
                continue;
            }
            if (!(value instanceof IObjectCollection)) continue;
            this.fillObjectCollection(deep + 1, (IObjectCollection)value);
        }
    }

    private void fillArray(int deep, Object array) {
        if (deep > 4) {
            return;
        }
        if (array == null) {
            return;
        }
        IRow row = null;
        ICell cell = null;
        String pre = "";
        for (int i = 0; i < deep; ++i) {
            pre = pre + "    ";
        }
        int len = 0;
        try {
            len = Array.getLength(array);
        }
        catch (Throwable e) {
            return;
        }
        row = this.flowVariableTable.addRow();
        row.setTreeLevel(deep);
        cell = row.getCell(0);
        cell.setValue((Object)(pre + "Length"));
        cell = row.getCell(1);
        cell.setValue((Object)("" + len));
        cell = row.getCell(2);
        cell.setValue((Object)"");
        row.setUserObject((Object)(pre + "Length"));
        for (int i = 0; i < len; ++i) {
            Object objVal = Array.get(array, i);
            row = this.flowVariableTable.addRow();
            row.setTreeLevel(deep);
            cell = row.getCell(0);
            cell.setValue((Object)(pre + (i + 1)));
            cell = row.getCell(1);
            cell.setValue(objVal == null ? "" : objVal);
            cell = row.getCell(2);
            cell.setValue((Object)"");
            row.setUserObject(objVal);
        }
    }

    private void fillObjectCollection(int deep, IObjectCollection objectCollection) {
        int i;
        if (deep > 4) {
            return;
        }
        IRow row = null;
        ICell cell = null;
        String pre = "";
        for (i = 0; i < deep; ++i) {
            pre = pre + "    ";
        }
        int len = objectCollection.size();
        for (i = 0; i < len; ++i) {
            IObjectValue objVal = objectCollection.getObject(i);
            if (objVal == null) continue;
            row = this.flowVariableTable.addRow();
            row.setTreeLevel(deep);
            cell = row.getCell(0);
            cell.setValue((Object)(pre + (i + 1)));
            cell = row.getCell(1);
            cell.setValue((Object)"");
            cell = row.getCell(2);
            cell.setValue((Object)"");
            row.setUserObject((Object)objVal);
            this.fillObjectValue(deep + 1, objVal);
        }
    }

    private String typeToString(String type) {
        String result = null;
        result = type.equalsIgnoreCase("BOID") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"boid_type") : (type.equalsIgnoreCase("STRING") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"string_type") : (type.equalsIgnoreCase("INTEGER") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"int_type") : (type.equalsIgnoreCase("FLOAT") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"float_type") : (type.equalsIgnoreCase("BOOLEAN") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"boolean_type") : (type.equalsIgnoreCase("PK") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"pk_type") : (type.equalsIgnoreCase("OBJECTVALUE") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"vo_type") : (type.equalsIgnoreCase("OBJECT") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"external_type") : (type.equalsIgnoreCase("ENUM") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"enum_type") : (type.equalsIgnoreCase("PERFORMER") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"performer_type") : (type.equalsIgnoreCase("DATETIME") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"date_type") : (type.equalsIgnoreCase("BIZOBJ") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"biz_type") : (type.equalsIgnoreCase("APPROVERESULT") ? EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"approve_type") : type))))))))))));
        return result;
    }

    private boolean checkOperateProcessPermission(String permissionName) throws EASBizException, BOSException {
        boolean perm = false;
        try {
            perm = this.permissionUtil.checkOperate(this.panel.image.getResponsibles(), permissionName);
        }
        catch (EASBizException e2) {
            this.handleException((Exception)((Object)e2));
        }
        catch (BOSException e2) {
            this.handleException((Exception)((Object)e2));
        }
        return perm;
    }

    private void handleException(String errMsgKey) {
        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WfMonitorResources", (String)errMsgKey));
    }

    @Override
    public void actionSuspendBtn_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkOperateProcessPermission("wf_report_Monitor_OperateSuspend")) {
            String reason = InputBox.read();
            if (reason == null) {
                return;
            }
            try {
                IWfUtil util = (IWfUtil)RpcProxy.wrapRequired(IWfUtil.class, (String)WfUtil.class.getName());
                util.suspend(this.pInfo.getProcInstId(), reason);
                this.getUIContext().put("force_refresh", Boolean.TRUE);
                this.getUIWindow().close();
            }
            catch (Exception e1) {
                logger.error((Object)"suspendProcessErrorMsg", (Throwable)e1);
                this.handleException("suspendProcessErrorMsg");
            }
        } else {
            this.handleException("noPerm");
        }
    }

    protected Map getProcessVariables() {
        try {
            IEnactmentService svc = EnactmentServiceFactory.createRemoteEnactService();
            return svc.getProcessContext(this.pInfo.getProcInstId(), true);
        }
        catch (Exception e1) {
            this.handUIException(e1);
            return new HashMap();
        }
    }

    @Override
    public void actionCanSuspendBtn_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkOperateProcessPermission("wf_report_Monitor_OperateSuspend")) {
            int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"WFMonitor_CONFIRM"));
            if (result != 0) {
                return;
            }
            try {
                EASWfServiceClient ormEsc = WorkFlowMonitorPanel.getServiceClient();
                ormEsc.resumeProcessInst(this.pInfo.getProcInstId());
                this.getUIContext().put("force_refresh", Boolean.TRUE);
                this.getUIWindow().close();
            }
            catch (Exception e1) {
                this.handleException("resumeProcessErrMSg");
            }
        } else {
            this.handleException("noPerm");
        }
    }

    @Override
    public void actionAbortBtn_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkOperateProcessPermission("wf_report_Monitor_OperateAbort")) {
            IEnactmentService ems = EnactmentServiceFactory.createRemoteEnactService();
            boolean isIgnoreShareCenter = ems.isIgnoreShareCenter(this.pInfo.getProcInstId());
            if (!isIgnoreShareCenter) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"ISSHARENOTABORT"));
                return;
            }
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"ABORT_CONFIRM")) == 0) {
                String reason = InputBox.read();
                if (reason == null) {
                    return;
                }
                try {
                    IWfUtil util = (IWfUtil)RpcProxy.wrapRequired(IWfUtil.class, (String)WfUtil.class.getName());
                    util.abort(this.pInfo.getProcInstId(), reason);
                    this.getUIContext().put("force_refresh", Boolean.TRUE);
                    this.getUIWindow().close();
                }
                catch (Exception e1) {
                    this.handleException("abortProcessErrMsg");
                }
            }
        } else {
            this.handleException("noPerm");
        }
    }

    protected void exitButton_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private String convertState(String state) {
        if (WfState.NOT_STARTED.getValue().equals(state)) {
            return WfState.NOT_STARTED.getAlias(this.getLocale());
        }
        if (WfState.SUSPENDED.getValue().equals(state)) {
            return WfState.SUSPENDED.getAlias(this.getLocale());
        }
        if (WfState.RUNNING.getValue().equals(state)) {
            return WfState.RUNNING.getAlias(this.getLocale());
        }
        if (WfState.COMPLETED.getValue().equals(state)) {
            return WfState.COMPLETED.getAlias(this.getLocale());
        }
        if (WfState.ABORTED.getValue().equals(state)) {
            return WfState.ABORTED.getAlias(this.getLocale());
        }
        if (WfState.TERMINATED.getValue().equals(state)) {
            return WfState.TERMINATED.getAlias(this.getLocale());
        }
        if (WfState.NOT_RUNNING.getValue().equals(state)) {
            return WfState.NOT_RUNNING.getAlias(this.getLocale());
        }
        if (WfState.BLOCKED.getValue().equals(state)) {
            return WfState.SUSPENDED.getAlias(this.getLocale());
        }
        if (WfState.ROLLBACKED.getValue().equals(state)) {
            return WfState.ROLLBACKED.getAlias(this.getLocale());
        }
        return state;
    }

    public void refreshAbortButton() {
        try {
            ProcessInstInfo procInst = this.pInfo;
            if (!procInst.getState().startsWith("open")) {
                this.abortBtn.setEnabled(false);
                this.suspendBtn.setEnabled(false);
            } else {
                this.abortBtn.setEnabled(true);
                if (procInst.getState().equalsIgnoreCase("open")) {
                    this.suspendBtn.setEnabled(true);
                    this.canSuspendBtn.setEnabled(false);
                } else if (procInst.getState().equalsIgnoreCase("open.not_running.suspended")) {
                    this.suspendBtn.setEnabled(false);
                    this.canSuspendBtn.setEnabled(true);
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

