/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.monitor.client.AbstractProcessRunningListUI;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProcessRunningListUI
extends AbstractProcessRunningListUI {
    private static final long serialVersionUID = -3137295680198413317L;
    private final String resourceClass = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource";
    static Collator collator = Collator.getInstance(Locale.CHINA);
    ProcessInstInfo[] procInsts;
    private static Logger log = Logger.getLogger(ProcessRunningListUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    private ProcessInstInfo[] sortProcessInstList(ProcessInstInfo[] procInsts) {
        int i;
        ProcessInstInfo[] processList = new ProcessInstInfo[procInsts.length];
        HashMap[] map = new HashMap[procInsts.length];
        for (i = 0; i < procInsts.length; ++i) {
            map[i] = new HashMap();
            map[i].put("createdTime", procInsts[i].getCreatedTime().toString());
            map[i].put("inst", procInsts[i]);
        }
        Arrays.sort(map, new Comparator(){

            public int compare(Object o1, Object o2) {
                String n1 = (String)((HashMap)o1).get("createdTime");
                String n2 = (String)((HashMap)o2).get("createdTime");
                return collator.compare(n1, n2);
            }
        });
        i = map.length - 1;
        int j = 0;
        while (i >= 0) {
            processList[j] = (ProcessInstInfo)map[i].get("inst");
            --i;
            ++j;
        }
        return processList;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.windowTitle = this.getResourceString("selectRunningProcess");
        this.processListTable.checkParsed();
        this.processListTable.removeRows();
        this.processListTable.setEditable(false);
        this.procInsts = (ProcessInstInfo[])this.getUIContext().get("procInsts");
        this.procInsts = this.sortProcessInstList(this.procInsts);
        IRow row = null;
        int n = this.procInsts.length;
        for (int i = 0; i < n; ++i) {
            ProcessInstInfo processInstInfo = this.procInsts[i];
            row = this.processListTable.addRow(i);
            ICell processID = row.getCell(0);
            processID.setValue((Object)processInstInfo.getProcDefName(SysContext.getSysContext().getLocale()));
            ICell processCreatedTime = row.getCell(1);
            processCreatedTime.setValue((Object)processInstInfo.getCreatedTime());
            ICell processState = row.getCell(2);
            processState.setValue((Object)processInstInfo.getMeta().getState().getAlias());
            row.setUserObject((Object)processInstInfo);
        }
        this.processListTable.getStyleAttributes().setLocked(true);
        this.processListTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProcessRunningListUI.this.talbeClicked(e);
                }
            }
        });
    }

    protected void talbeClicked(KDTMouseEvent e) {
        IRow row;
        if (e.getType() == 1 && (row = this.processListTable.getRow(e.getRowIndex())) != null) {
            ProcessInstInfo procInstInfo = (ProcessInstInfo)row.getUserObject();
            try {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"id", (Object)procInstInfo.getProcInstId());
                uiContext.put((Object)"processInstInfo", (Object)procInstInfo);
                BasicWorkFlowMonitorPanel.Show((Map)uiContext);
            }
            catch (UIException e1) {
                log.error((Object)("show process diagram failed! id=" + procInstInfo.getProcInstId()), (Throwable)e1);
            }
        }
    }

    public String getResourceString(String key) {
        return EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)key);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionViewProcessInst_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.processListTable.getRow(this.processListTable.getSelectManager().getActiveRowIndex());
        if (row == null) {
            MsgBox.showInfo((String)this.getResourceString("selectLeastOneProcess"));
            return;
        }
        ProcessInstInfo procInstInfo = (ProcessInstInfo)row.getUserObject();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"id", (Object)procInstInfo.getProcInstId());
        BasicWorkFlowMonitorPanel.Show((Map)uiContext);
    }
}

