/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.Pair;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.monitor.client.AbstractShowPropertyPanel;
import com.kingdee.bos.workflow.monitor.client.PermissionUtil;
import com.kingdee.bos.workflow.monitor.client.PersonAndOpinionBox;
import com.kingdee.bos.workflow.monitor.client.ShowAssignmentListUI;
import com.kingdee.bos.workflow.monitor.client.WfMonitorUtils;
import com.kingdee.bos.workflow.monitor.client.WfUtils;
import com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorPanel;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.struct.IProcessImage;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.eip.sso.SSOHandleFacadeFactory;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ShowPropertyPanel
extends AbstractShowPropertyPanel {
    private static final long serialVersionUID = 8700061124435158690L;
    private static final Logger logger = CoreUIObject.getLogger(ShowPropertyPanel.class);
    protected WorkFlowMonitorPanel monitorPanel;
    protected ActivityInstInfo currentActivityInstInfo;
    protected int index = 0;
    private CoreUI basicUI;
    private HashMap actInstId2ActivityMap = new HashMap();
    private List actInsts;
    private IProcessImage.Activity currentActivity;
    private boolean isPvmModel;
    private IEnactmentService service;
    PermissionUtil permissionUtil = new PermissionUtil();
    private final String resourceClass = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource";
    private final String res2 = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource";
    private final String workflowResourceClass = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource";
    private String showAppendDiagramUrl;

    public ShowPropertyPanel() throws Exception {
        String nodepropertyText;
        String resourceClass = "com.kingdee.bos.workflow.monitor.client.WfMonitorResources";
        this.windowTitle = nodepropertyText = EASResource.getString((String)resourceClass, (String)"activityProperty");
        this.reAppointCeoBtn.setIcon(EASResource.getIcon((String)"imgTbtn_reappperform"));
        this.suspendBtn.setIcon(EASResource.getIcon((String)"imgTbtn_suspendinstance"));
        this.canSuspendBtn.setIcon(EASResource.getIcon((String)"imgTbtn_abolishsuspend"));
        this.terminateBtn.setIcon(EASResource.getIcon((String)"imgTbtn_terminateinstance"));
        this.abortBtn.setIcon(EASResource.getIcon((String)"imgTbtn_abortinstance"));
        this.prevInstanceBtn.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.nextInstanceBtn.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.showSubflowBtn.setIcon(EASResource.getIcon((String)"imgTbtn_showsubflow"));
        this.virtualSubmitBtn.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        if (this.getLocale().equals(new Locale("L1"))) {
            this.kDLabel2.setVisible(false);
            this.kDScrollPane2.setVisible(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setQueryPreference(false);
        this.initTable();
        this.monitorPanel = (WorkFlowMonitorPanel)((Object)this.getUIContext().get("monitorPanel"));
        IProcessImage processImage = this.monitorPanel.image;
        IProcessImage.Activity[] activities = processImage.getActivities();
        for (int i = 0; i < activities.length; ++i) {
            IProcessImage.Activity act = activities[i];
            this.actInstId2ActivityMap.put(act.actDefId, act);
            if (act.actInstIds == null) continue;
            for (int j = 0; j < act.actInstIds.size(); ++j) {
                this.actInstId2ActivityMap.put(act.actInstIds.get(j), act);
            }
        }
        this.actInsts = (List)this.getUIContext().get("actInstIds");
        this.currentActivity = (IProcessImage.Activity)this.actInstId2ActivityMap.get(this.getUIContext().get("actDefId"));
        this.basicUI = (CoreUI)this.getUIContext().get("basicui");
        this.txtDigest.setText(this.currentActivity.actDigest);
        String currentActInstId = (String)this.getUIContext().get("currentActInstId");
        this.index = this.actInsts.size() - 1;
        if (currentActInstId != null) {
            for (int i = 0; i < this.actInsts.size(); ++i) {
                if (!currentActInstId.equals(this.actInsts.get(i))) continue;
                this.index = i;
            }
        }
        this.currentActivityInstInfo = EnactmentServiceFactory.createRemoteEnactService().getActivityInstByActInstId((String)this.actInsts.get(this.index));
        this.service = EnactmentServiceFactory.createRemoteEnactService();
        if (this.currentActivityInstInfo != null) {
            this.isPvmModel = true;
        }
        this.initButtonState();
        this.initText();
        this.btnComplete.setVisible(false);
        if (this.currentActivity.hasAppended) {
            String procInstId = this.currentActivityInstInfo.getProcInstId();
            String actDefId = this.currentActivityInstInfo.getActDefId();
            this.showAppendDiagramUrl = "/easweb/workflow/viewDiagram.jsf?procInstId=" + procInstId + "&actDefId=" + actDefId;
        }
    }

    private void refresh() throws Exception {
        this.onLoad();
    }

    public void initButtonState() {
        boolean isClosedState;
        String state;
        boolean isOpenedState;
        this.showSubflowBtn.setVisible(true);
        this.showSubflowBtn.setEnabled(true);
        if (!this.currentActivity.type.equals(SubflowActivityDef.class.getName())) {
            this.showSubflowBtn.setVisible(false);
        }
        boolean bl = isOpenedState = (state = this.currentActivityInstInfo.getState()).equals(WfState.NOT_STARTED.getValue()) || state.equals(WfState.RUNNING.getValue()) || state.equals(WfState.NOT_RUNNING.getValue()) || state.equals(WfState.OPEN.getValue()) || state.equals(WfState.BLOCKED.getValue()) || state.equals(WfState.ROLLBACKED.getValue());
        if (this.isPvmModel && isOpenedState && this.currentActivityInstInfo.getInited()) {
            this.btnComplete.setEnabled(true);
        } else {
            this.btnComplete.setEnabled(false);
        }
        boolean bl2 = isClosedState = state.equals(WfState.ABORTED.getValue()) || state.equals(WfState.COMPLETED.getValue()) || state.equals(WfState.TERMINATED.getValue()) || state.equals(WfState.CLOSED.getValue());
        if (!this.currentActivity.isManpower || isClosedState) {
            this.addAssignToActivity.setVisible(false);
            this.reAppointCeoBtn.setVisible(false);
        } else {
            this.addAssignToActivity.setVisible(true);
            this.reAppointCeoBtn.setVisible(true);
        }
        this.terminateBtn.setVisible(false);
        this.abortBtn.setVisible(false);
        this.suspendBtn.setVisible(false);
        this.canSuspendBtn.setVisible(false);
        this.virtualSubmitBtn.setVisible(false);
    }

    public void initText() {
        try {
            Locale currentLocale = SysContext.getSysContext().getLocale();
            this.actInstNameText.setText((String)this.currentActivityInstInfo.getActInstInfo().get("actDefName_" + currentLocale.toString().toLowerCase()));
            String state = this.convertState(this.currentActivityInstInfo.getState());
            this.currentStatusText.setText(state);
            this.actInstTypeText.setText(this.currentActivity.typeName);
            this.createTimeText.setText(this.currentActivityInstInfo.getCreatedTime().toString());
            String completeTime = this.currentActivityInstInfo.getCompleteTime() == null ? "" : this.currentActivityInstInfo.getCompleteTime().toString();
            this.completeTimeText.setText(completeTime);
            long consumeTime = 0L;
            if (this.currentActivityInstInfo.getCompleteTime() != null && this.currentActivityInstInfo.getCreatedTime() != null) {
                consumeTime = this.currentActivityInstInfo.getCompleteTime().getTime() - this.currentActivityInstInfo.getCreatedTime().getTime();
            }
            long hour = consumeTime / 3600000L;
            long left = consumeTime % 3600000L;
            long minite = left / 60000L;
            long second = (left %= 6000L) / 1000L;
            this.consumeTimeText.setText(Long.toString(hour) + ":" + Long.toString(minite) + ":" + Long.toString(second));
            String[] prevInstanceIds = this.currentActivityInstInfo.getPreActInstList();
            String prevText = this.getInstanceNameByIds(prevInstanceIds);
            String[] nextInstanceIds = this.currentActivityInstInfo.getPostActInstList();
            String nextText = this.getInstanceNameByIds(nextInstanceIds);
            this.prevInstanceText.setText(prevText);
            this.nextInstanceText.setText(nextText);
            this.actInstNameText.setEnabled(false);
            this.currentStatusText.setEnabled(false);
            this.actInstTypeText.setEnabled(false);
            this.createTimeText.setEnabled(false);
            this.completeTimeText.setEnabled(false);
            this.prevInstanceText.setEnabled(false);
            this.nextInstanceText.setEnabled(false);
            this.prevInstanceBtn.setEnabled(false);
            this.nextInstanceBtn.setEnabled(false);
            this.consumeTimeText.setEnabled(false);
            int size = this.actInsts.size();
            if (size > 1) {
                if (this.index < size - 1) {
                    this.nextInstanceBtn.setEnabled(true);
                    if (this.index > 0) {
                        this.prevInstanceBtn.setEnabled(true);
                    }
                } else {
                    this.prevInstanceBtn.setEnabled(true);
                    this.nextInstanceBtn.setEnabled(false);
                }
            }
            IEnactmentService esc = EnactmentServiceFactory.createRemoteEnactService();
            String actInstId = this.currentActivityInstInfo.getActInstId();
            AssignmentInfo[] assignments = esc.getAllAssignmentByActInstId(actInstId);
            this.setPerformerUserTable(assignments, esc, actInstId);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void setPerformerUserTable(AssignmentInfo[] assignments, IEnactmentService esc, String actInstId) throws BOSException, EASBizException {
        HashSet<String> userids = new HashSet<String>();
        HashMap assignMap = new HashMap();
        IUser u = UserFactory.getRemoteInstance();
        String messageActUserIdsSql = null;
        if (assignments == null || assignments.length == 0) {
            ActivityInstInfo actInst = esc.getActivityInstByActInstId(actInstId);
            ProcessDef processDef = esc.getProcessDefByDefineHashValue(actInst.getProcDefHashValue());
            ActivityDef actDef = processDef.getActivityDef(actInst.getActDefId());
            if (actDef instanceof MessageActivityDef) {
                messageActUserIdsSql = " select freceiver from t_bas_message where ftype = 0 AND fbizType = 0 and fsourceid ='" + actInst.getActInstId() + "' ";
            } else {
                if (actDef instanceof ApproveActivityDef) {
                    return;
                }
                ActivityCollection acts = actDef.getPreviousActivities();
                boolean isFirst = false;
                for (int i = 0; i < acts.size(); ++i) {
                    if (!(acts.get(i) instanceof StartActivityDef)) continue;
                    isFirst = true;
                }
                if (isFirst) {
                    ProcessInstInfo procInstInfo = esc.getProcessInstInfo(actInst.getProcInstId());
                    if (procInstInfo.getParentProcInstId() != null) {
                        // empty if block
                    }
                    String initiator = procInstInfo.getInitiatorId();
                    UserInfo user = u.getUserByID((IObjectPK)new ObjectUuidPK(initiator));
                    this.addPerformerRow(user, null);
                    return;
                }
            }
        } else {
            for (int i = 0; i < assignments.length; ++i) {
                String userid = assignments[i].getUserId();
                if (userids.contains(userid)) {
                    ArrayList templist = (ArrayList)assignMap.get(userid);
                    templist.add(assignments[i]);
                    assignMap.remove(userid);
                    assignMap.put(userid, templist);
                    continue;
                }
                userids.add(userid);
                ArrayList<AssignmentInfo> list = new ArrayList<AssignmentInfo>();
                list.add(assignments[i]);
                assignMap.put(userid, list);
            }
        }
        StringBuffer oql = new StringBuffer();
        if (messageActUserIdsSql != null) {
            oql.append(messageActUserIdsSql);
        } else {
            Iterator it = userids.iterator();
            while (it.hasNext()) {
                if (oql.length() > 0) {
                    oql.append(",");
                }
                oql.append("'");
                oql.append(it.next());
                oql.append("'");
            }
        }
        oql.insert(0, "select number, name where id in(");
        oql.append(")");
        UserCollection users = u.getUserCollection(oql.toString());
        for (int i = 0; i < users.size(); ++i) {
            if (messageActUserIdsSql != null) {
                this.addPerformerRow(users.get(i), null);
                continue;
            }
            String userId = users.get(i).getId().toString();
            ArrayList list = (ArrayList)assignMap.get(userId);
            for (int j = 0; j < list.size(); ++j) {
                AssignmentInfo assignInfo = (AssignmentInfo)list.get(j);
                this.addPerformerRow(users.get(i), assignInfo);
            }
        }
    }

    private String getInstanceNameByIds(String[] instanceIds) {
        StringBuffer name = new StringBuffer();
        if (instanceIds != null) {
            for (String tmpId : instanceIds) {
                IProcessImage.Activity act = (IProcessImage.Activity)this.actInstId2ActivityMap.get(tmpId);
                if (act == null) continue;
                if (name.length() > 0) {
                    name.append("; ");
                }
                name.append(act.name);
            }
        }
        return name.toString();
    }

    private boolean checkOperateActivityPermission(String permissionName) throws EASBizException, BOSException {
        boolean perm = false;
        try {
            perm = this.permissionUtil.checkOperate(this.monitorPanel.image.getResponsibles(), permissionName);
        }
        catch (EASBizException e2) {
            this.handleException((Exception)((Object)e2));
        }
        catch (BOSException e2) {
            this.handleException((Exception)((Object)e2));
        }
        return perm;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void handleException(String errMsgKey) {
        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)errMsgKey));
    }

    @Override
    public void actionReAppointCeoBtn_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkOperateActivityPermission("wf_report_Monitor_ActivityProperty_DesignatePerformer")) {
            this.handleException("noPerm");
            return;
        }
        IEnactmentService ems = EnactmentServiceFactory.createRemoteEnactService();
        boolean isShare = ems.isShareCenterAssign(this.currentActivityInstInfo.getProcInstId());
        if (isShare) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"ISSHAREREREPAET"));
            return;
        }
        String label = ((KDWorkButton)e.getSource()).getText();
        Pair<String, PersonInfo> results = PersonAndOpinionBox.read(label);
        if (results == null) {
            return;
        }
        try {
            PersonInfo personInfo = results.getB();
            String personId = personInfo.getId().toString();
            this.performerList.removeAll();
            if (!WfUtils.checkPersonHasUser(personId)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"msgPersonHasNoUser"));
                return;
            }
            this.performerList.insertElement((Object)personInfo.getName(), 0);
            String actInstId = this.currentActivityInstInfo.getActInstId();
            String[] personIdArray = new String[]{personId};
            IWfUtil util = (IWfUtil)RpcProxy.wrapRequired(IWfUtil.class, (String)WfUtil.class.getName());
            util.reassignToPerson(actInstId, personIdArray, results.getA());
            this.refresh();
        }
        catch (Exception ex) {
            logger.error((Object)"\u65e0\u6cd5\u91cd\u65b0\u6307\u5b9a\u53c2\u4e0e\u4eba\uff01", (Throwable)ex);
            System.out.println("\u65e0\u6cd5\u91cd\u65b0\u6307\u5b9a\u53c2\u4e0e\u4eba,\u539f\u56e0:");
            ex.printStackTrace();
            this.handleException("reAssignErrMsg");
        }
    }

    @Override
    public void actionAddAssignToActivity_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAssignToActivity_actionPerformed(e);
        if (!this.checkOperateActivityPermission("wf_report_Monitor_ActivityProperty_DesignatePerformer")) {
            this.handleException("noPerm");
            return;
        }
        IEnactmentService ems = EnactmentServiceFactory.createRemoteEnactService();
        boolean isShare = ems.isShareCenterAssign(this.currentActivityInstInfo.getProcInstId());
        if (isShare) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"ISSHAREADDPERSON"));
            return;
        }
        String label = ((KDWorkButton)e.getSource()).getText();
        Pair<String, PersonInfo> results = PersonAndOpinionBox.read(label);
        if (results == null) {
            return;
        }
        try {
            PersonInfo personInfo = results.getB();
            String personId = personInfo.getId().toString();
            this.performerList.removeAll();
            if (!WfUtils.checkPersonHasUser(personId)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"msgPersonHasNoUser"));
                return;
            }
            this.performerList.insertElement((Object)personInfo.getName(), 0);
            String actInstId = this.currentActivityInstInfo.getActInstId();
            String[] personIdArray = new String[]{personId};
            IWfUtil util = (IWfUtil)RpcProxy.wrapRequired(IWfUtil.class, (String)WfUtil.class.getName());
            util.addAssignToActivity(actInstId, personIdArray, results.getA());
            this.refresh();
        }
        catch (Exception ex) {
            this.handleException("addAssignErrMsg");
        }
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext request = (RequestContext)postman.getRequestContext();
        this.actInsts = (List)this.getUIContext().get("actInstIds");
        request.put("actInstId", this.actInsts.get(0));
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        request.put("userId", (Object)userId);
        request.put("permissionKey", (Object)"wf_report_Monitor_ViewActivityProperty");
        postman.setRequestContext((Serializable)request);
        return postman;
    }

    private void addPerformerRow(UserInfo user, AssignmentInfo assign) {
        IRow row = this.tblPerformerList.addRow(0);
        ICell cell = row.getCell(0);
        cell.setValue((Object)user.getNumber());
        cell.getStyleAttributes().setLocked(true);
        cell = row.getCell(1);
        cell.setValue((Object)user.getName());
        cell.getStyleAttributes().setLocked(true);
        cell = row.getCell(2);
        if (assign != null) {
            if (assign.getState().getAlias(this.getLocale()).equals("\u5df2\u53d6\u6d88")) {
                cell.setValue((Object)"\u5df2\u64a4\u9500");
            } else {
                cell.setValue((Object)assign.getState().getAlias(this.getLocale()));
            }
        } else {
            cell.setValue((Object)WfState.COMPLETED.getAlias(this.getLocale()));
        }
        cell.getStyleAttributes().setLocked(true);
    }

    protected void exitButton_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
        this.monitorPanel.isExit = true;
    }

    private String convertState(String state) {
        if (WfState.NOT_STARTED.getValue().equals(state)) {
            return WfState.NOT_STARTED.getAlias(this.getLocale());
        }
        if (WfState.SUSPENDED.getValue().equals(state)) {
            return WfState.SUSPENDED.getAlias(this.getLocale());
        }
        if (WfState.RUNNING.getValue().equals(state)) {
            return WfState.RUNNING.getAlias(this.getLocale());
        }
        if (WfState.COMPLETED.getValue().equals(state)) {
            return WfState.COMPLETED.getAlias(this.getLocale());
        }
        if (WfState.ABORTED.getValue().equals(state)) {
            return WfState.ABORTED.getAlias(this.getLocale());
        }
        if (WfState.TERMINATED.getValue().equals(state)) {
            return WfState.TERMINATED.getAlias(this.getLocale());
        }
        if (WfState.NOT_RUNNING.getValue().equals(state)) {
            return WfState.NOT_RUNNING.getAlias(this.getLocale());
        }
        if (WfState.BLOCKED.getValue().equals(state)) {
            return WfState.SUSPENDED.getAlias(this.getLocale());
        }
        if (WfState.ROLLBACKED.getValue().equals(state)) {
            return WfState.ROLLBACKED.getAlias(this.getLocale());
        }
        return state;
    }

    @Override
    public void actionPrevBtn_actionPerformed(ActionEvent e) throws Exception {
        this.performerList.removeAllElements();
        this.tblPerformerList.removeRows();
        --this.index;
        this.currentActivity = (IProcessImage.Activity)this.actInstId2ActivityMap.get(this.actInsts.get(this.index));
        this.currentActivityInstInfo = EnactmentServiceFactory.createRemoteEnactService().getActivityInstByActInstId((String)this.actInsts.get(this.index));
        this.initButtonState();
        this.initText();
    }

    @Override
    public void actionNextBtn_actionPerformed(ActionEvent e) throws Exception {
        ++this.index;
        this.performerList.removeAllElements();
        this.tblPerformerList.removeRows();
        this.currentActivity = (IProcessImage.Activity)this.actInstId2ActivityMap.get(this.actInsts.get(this.index));
        this.currentActivityInstInfo = EnactmentServiceFactory.createRemoteEnactService().getActivityInstByActInstId((String)this.actInsts.get(this.index));
        this.initButtonState();
        this.initText();
    }

    @Override
    public RequestContext prepareActionShowSubflowBtn(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionShowSubflowBtn(itemAction);
        ActivityInstInfo[] actInstInfos = (ActivityInstInfo[])this.getUIContext().get("actInstList");
        if (actInstInfos.length > 1) {
            String[] procInstIds = this.getProcinstIDs(actInstInfos);
            request.put("procInstIds", (Object)procInstIds);
        }
        request.put("proceInstId", (Object)this.currentActivityInstInfo.getSubProcInstId());
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        request.put("userId", (Object)userId);
        return request;
    }

    @Override
    public boolean isPrepareActionShowSubflowBtn() {
        return false;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public void actionShowSubflowBtn_actionPerformed(ActionEvent e) throws Exception {
        try {
            String subflowInstId = this.currentActivityInstInfo.getSubProcInstId();
            WfMonitorUtils.showWfDiagram((Component)((Object)this), subflowInstId);
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
        finally {
            this.afterActionPerformed(e);
        }
    }

    private String[] getProcinstIDs(ActivityInstInfo[] actInstInfos) {
        if (actInstInfos == null || actInstInfos.length <= 0) {
            return new String[0];
        }
        String[] procInstIds = new String[actInstInfos.length];
        for (int i = 0; i < actInstInfos.length; ++i) {
            procInstIds[i] = actInstInfos[i].getSubProcInstId();
        }
        return procInstIds;
    }

    @Override
    public void actionActivityComplete_actionPerformed(ActionEvent e) throws Exception {
        int result;
        String actInstId;
        if (this.currentActivityInstInfo != null && !StringUtils.isEmpty((String)(actInstId = this.currentActivityInstInfo.getActInstId())) && (result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"ConformSetCompleteState"))) == 0) {
            this.service.completeActivityInst(actInstId);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"refreshImageToCompleteActivity"));
            this.getUIWindow().close();
        }
    }

    private boolean checkActInstHasAssign(String actInstId) {
        boolean result = false;
        AssignmentInfo[] assignArray = null;
        try {
            assignArray = this.service.getAssignmentByActInstId(actInstId);
        }
        catch (WfException e) {
            logger.warn((Object)"get assignmetbyActInstId error!");
        }
        if (assignArray != null && assignArray.length > 0) {
            result = true;
        }
        return result;
    }

    private void showAssignmentListDialog(AssignmentInfo[] assignInfoArray) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"assignInfoArray", (Object)assignInfoArray);
        String className = ShowAssignmentListUI.class.getName();
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
            uiWindow.show();
            this.getUIWindow().close();
        }
        catch (UIException e) {
            this.handUIException(e);
        }
    }

    private void initTable() {
        this.performerList.setVisible(false);
        this.tblPerformerList.removeRows();
        this.tblPerformerList.removeHeadRows();
        this.tblPerformerList.removeColumns();
        IColumn col0 = this.tblPerformerList.addColumn(0);
        IColumn col1 = this.tblPerformerList.addColumn(1);
        IColumn col2 = this.tblPerformerList.addColumn(2);
        col0.setWidth(150);
        col1.setWidth(150);
        col2.setWidth(150);
        IRow row = this.tblPerformerList.addHeadRow(0);
        ICell cell = row.getCell(0);
        cell.setValue((Object)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"userColumn"));
        cell = row.getCell(1);
        cell.setValue((Object)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"employeeColunm"));
        cell = row.getCell(2);
        cell.setValue((Object)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"stateColunm"));
    }

    public static void gotoSite(String toUrl) throws BOSException {
        String serverURL = System.getProperty("UPDATE_SERVER_ADDR");
        serverURL = StringUtils.isEmpty((String)serverURL) ? "http://localhost:6888" : "http://" + serverURL;
        String url = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(toUrl, false, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
        url = serverURL + toUrl + url;
        url = ShowPropertyPanel.replaceAllStr(url, "&", "^&");
        try {
            Runtime.getRuntime().exec("cmd /c start iexplore " + url);
        }
        catch (Exception er) {
            try {
                Runtime.getRuntime().exec("start iexplore " + url);
            }
            catch (Exception err) {
                String command = "command.com /c start iexplore " + url;
                try {
                    Runtime.getRuntime().exec(command);
                }
                catch (Exception error) {
                    logger.error((Object)("exec command failed! " + command), (Throwable)error);
                }
            }
        }
    }

    private static String replaceAllStr(String strSource, String strFrom, String strTo) {
        int intPos;
        if (strFrom == null || strFrom.equals("")) {
            return strSource;
        }
        String strDest = "";
        int intFromLen = strFrom.length();
        while ((intPos = strSource.indexOf(strFrom)) != -1) {
            strDest = strDest + strSource.substring(0, intPos);
            strDest = strDest + strTo;
            strSource = strSource.substring(intPos + intFromLen);
        }
        strDest = strDest + strSource;
        return strDest;
    }
}

