/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.monitor.WFCacheManagerFacadeFactory;
import com.kingdee.bos.workflow.monitor.client.AbstractWFCacheClearUI;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WFCacheClearUI
extends AbstractWFCacheClearUI {
    private static final Logger logger = CoreUIObject.getLogger(WFCacheClearUI.class);

    private boolean isLogin() throws EASBizException {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return true;
        }
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userInfo.getId().toString())) {
            return true;
        }
        JPasswordField pwd = new JPasswordField();
        Object[] message = new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"49_FMIsqlUI"), pwd};
        int res = JOptionPane.showConfirmDialog((Component)((Object)this), message, " ", 2, 3);
        if (res != 0) {
            return false;
        }
        char[] p = pwd.getPassword();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < p.length; ++i) {
            sb.append(p[i]);
        }
        try {
            userInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
            boolean matchP = PermissionUtils.matchPasswordWithSecurity((UserInfo)userInfo, (String)sb.toString());
            Arrays.fill(p, ' ');
            if (matchP) {
                return true;
            }
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public void onLoad() throws Exception {
        boolean b = this.isLogin();
        if (!b) {
            SysUtil.abort();
        }
        super.onLoad();
        this.kDComboBox1.addItems(new Object[]{"\u6d41\u7a0b\u7f16\u7801", "\u4efb\u52a1\u4e3b\u9898"});
        this.kDRemoveByNumber.setSelected(true);
        this.change();
    }

    @Override
    protected void kDRemoveById_itemStateChanged(ItemEvent e) throws Exception {
        this.change();
    }

    @Override
    protected void kDRemoveByNumber_itemStateChanged(ItemEvent e) throws Exception {
        this.change();
    }

    private void change() {
        if (this.kDRemoveById.isSelected()) {
            this.kDTextField1.setEditable(true);
            this.kDTextField2.setEditable(false);
            this.kDComboBox1.setEditable(false);
            this.kDComboBox1.setEnabled(false);
        } else {
            this.kDTextField1.setEditable(false);
            this.kDTextField2.setEditable(true);
            this.kDComboBox1.setEditable(true);
            this.kDComboBox1.setEnabled(true);
        }
    }

    @Override
    public void actionSumbit_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDRemoveById.isSelected()) {
            if (StringUtils.isEmpty((String)this.kDTextField1.getText())) {
                MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6e05\u9664\u7684\u6570\u636eID");
                return;
            }
            if (0 != MsgBox.showConfirm2((String)"\u786e\u8ba4\u6e05\u9664\uff1f\uff1f")) {
                return;
            }
            String id = this.kDTextField1.getText();
            WFCacheManagerFacadeFactory.getRemoteInstance().removeProcessInst(id);
            String msg = this.getMessageById(id);
            MsgBox.showInfo((String)("\u5df2\u6267\u884c\u6e05\u9664\uff01" + msg));
        } else if (this.kDRemoveByNumber.isSelected()) {
            if (StringUtils.isEmpty((String)this.kDTextField2.getText())) {
                MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6e05\u9664\u7684\u6570\u636e\u7f16\u7801");
                return;
            }
            String cacheKey = "";
            if ("\u6d41\u7a0b\u7f16\u7801".equals(this.kDComboBox1.getSelectedItem())) {
                cacheKey = this.excuteSql("fprocinstid", "t_wfr_procinst", "fcode", this.kDTextField2.getText());
                if (StringUtils.isEmpty((String)cacheKey)) {
                    MsgBox.showWarning((String)"\u672a\u67e5\u5230\u8f93\u5165\u7684\u6d41\u7a0b\u5b9e\u4f8b\uff01");
                    return;
                }
            } else {
                cacheKey = this.excuteSql("fassignid", "t_wfr_assign", "fassignid", this.kDTextField2.getText());
                if (StringUtils.isEmpty((String)cacheKey) && StringUtils.isEmpty((String)(cacheKey = this.excuteSql("fassignid", "t_wfr_assigndetail", "fassignid", this.kDTextField2.getText())))) {
                    MsgBox.showWarning((String)"\u672a\u67e5\u5230\u8f93\u5165\u7684\u4efb\u52a1\uff01");
                    return;
                }
            }
            if (0 != MsgBox.showConfirm2((String)"\u786e\u8ba4\u6e05\u9664\uff1f\uff1f")) {
                return;
            }
            WFCacheManagerFacadeFactory.getRemoteInstance().removeProcessInst(cacheKey);
            MsgBox.showInfo((String)"\u5df2\u6267\u884c\u6e05\u9664\uff01");
        }
        this.getUIWindow().close();
    }

    private String getMessageById(String id) {
        if (id.indexOf("WFPCINST") > 0) {
            String code = this.excuteSql("fcode", "t_wfr_procinst", "fprocinstid", id);
            return "\u6d41\u7a0b\u5b9e\u4f8b \uff1a" + code;
        }
        if (id.indexOf("WFWKITEM") > 0) {
            String subject = this.excuteSql("fsubject_l2", "t_wfr_assign", "fassignid", id);
            if (StringUtils.isEmpty((String)subject)) {
                subject = this.excuteSql("fsubject_l2", "t_wfr_assigndetail", "fassignid", id);
            }
            return "\u4efb\u52a1 \uff1a" + subject;
        }
        if (id.indexOf("WFATINST") > 0) {
            return "\u6d3b\u52a8\u5b9e\u4f8b\uff1a" + id;
        }
        return "";
    }

    private String excuteSql(String selectValue, String tableName, String conditionName, String value) {
        try {
            String sql = "select " + selectValue + " from " + tableName + " where " + conditionName + " = '" + value + "'";
            SQLExecutor sqlExecutor = new SQLExecutor(sql);
            IRowSet rowset = sqlExecutor.executeSQL();
            if (rowset.next()) {
                return rowset.getString(selectValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void actionClean_actionPerformed(ActionEvent e) throws Exception {
        int i = MsgBox.showConfirm2((String)"\u786e\u8ba4\u6e05\u7a7a\u5168\u90e8\u5de5\u4f5c\u6d41\u7f13\u5b58\uff1f\uff1f");
        if (i == 0) {
            WFCacheManagerFacadeFactory.getRemoteInstance().cleanUp();
            MsgBox.showInfo((String)"\u6e05\u9664\u6210\u529f\uff01");
        }
    }

    @Override
    public void actionCleanPersonCache_actionPerformed(ActionEvent e) throws Exception {
        int i = MsgBox.showConfirm2((String)"\u786e\u8ba4\u6e05\u7a7a\u5de5\u4f5c\u6d41\u53c2\u4e0e\u4eba\u7f13\u5b58\uff1f\uff1f");
        if (i == 0) {
            WFCacheManagerFacadeFactory.getRemoteInstance().cleanParticipantCache();
            MsgBox.showInfo((String)"\u6e05\u9664\u6210\u529f\uff01");
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

