/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.SameGridConstraints;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.agent.AgentUtility;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.monitor.client.WfMonitorUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.client.DesignatePerformerUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.swing.filechooser.FileFilter;

public class WfUtils {
    private static final String resourceClass = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource";

    public static void addExportImgButton(KDToolBar toolBar, String id, String defaultFileName, Component owner) {
        KDWorkButton expertButton = new KDWorkButton();
        expertButton.setText(EASResource.getString((String)resourceClass, (String)"saveAsImage"));
        expertButton.setToolTipText(EASResource.getString((String)resourceClass, (String)"workflowDiagramSave"));
        expertButton.setIcon(EASResource.getIcon((String)"imgTbtn_archivesreturn"));
        toolBar.add((Component)expertButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        expertButton.addActionListener((ActionListener)new ExportWfImage(id, owner, defaultFileName));
    }

    public static void addExportKpdlButton(KDToolBar toolBar, String id, String defaultFileName, Component owner) {
        KDWorkButton expertButton = new KDWorkButton();
        expertButton.setText(EASResource.getString((String)resourceClass, (String)"exportProcess"));
        expertButton.setToolTipText(EASResource.getString((String)resourceClass, (String)"exportProcessDef"));
        expertButton.setIcon(EASResource.getIcon((String)"imgTbtn_outputmetadata"));
        toolBar.add((Component)expertButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        expertButton.addActionListener((ActionListener)new ExportWfKpdl(id, owner, defaultFileName));
    }

    public static void addNextPersonButton(KDToolBar toolBar, String id, String defaultFileName, Component owner) {
        KDWorkButton expertButton = new KDWorkButton();
        expertButton.setText(EASResource.getString((String)resourceClass, (String)"nextPerformer"));
        expertButton.setToolTipText(EASResource.getString((String)resourceClass, (String)"nextPerformerTips"));
        expertButton.setIcon(EASResource.getIcon((String)"imgTbtn_nextactor"));
        toolBar.add((Component)expertButton, (Object)new SameGridConstraints(10, 10, 30, 30));
        expertButton.addActionListener((ActionListener)new NextPerson(id, owner, defaultFileName));
    }

    public static String dump(Throwable t) {
        if (t == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter((OutputStream)baos);
        pw.print(EASResource.getString((String)resourceClass, (String)"errorInfo"));
        pw.print(t.getMessage());
        pw.print("\r\nStack trace:\r\n");
        t.printStackTrace(pw);
        pw.flush();
        return baos.toString();
    }

    public static boolean showWfImage(Component owner, CoreBillBaseInfo editData) throws Exception {
        String id = null;
        BOSUuid o = editData.getId();
        if (o != null) {
            id = o.toString();
        }
        return WfUtils.showWfImage(owner, id, (IObjectValue)editData);
    }

    public static boolean showWfImage(Component owner, String billId, IObjectValue editData) throws Exception {
        return WfUtils.showWfImage(owner, billId, editData, null, null);
    }

    public static boolean showWfImage(Component owner, String billId, IObjectValue editData, String function, String operation) throws Exception {
        String id = WfUtils.getProcessId(billId, editData, function, operation);
        if (id == null) {
            return false;
        }
        if (id.endsWith("WFPCINST")) {
            WfMonitorUtils.showWfDiagram(owner, id);
        } else {
            WfMonitorUtils.showWfDiagramDefine(owner, id);
        }
        return true;
    }

    private static String getProcessId(String billId, IObjectValue editData, String function, String operation) throws Exception {
        IObjectValue bizObj = AgentUtility.getNoAgentValue((IObjectValue)editData);
        IWfUtil util = (IWfUtil)RpcProxy.wrapNoSupport(IWfUtil.class, (String)WfUtil.class.getName());
        String id = util.getBindProcessId(billId, bizObj, function, operation);
        return id;
    }

    public static boolean nextPerson(CoreUIObject owner, CoreBillBaseInfo editData) throws Exception {
        String id = null;
        BOSUuid o = editData.getId();
        if (o != null) {
            id = o.toString();
        }
        return WfUtils.nextPerson(owner, id, (AbstractObjectValue)editData);
    }

    public static boolean nextPerson(CoreUIObject owner, String billId, AbstractObjectValue editData) throws Exception {
        return WfUtils.nextPerson(owner, billId, editData, null, null);
    }

    public static boolean nextPerson(CoreUIObject owner, String billId, AbstractObjectValue editData, String function, String operation) throws Exception {
        String id = WfUtils.getProcessId(billId, (IObjectValue)editData, function, operation);
        if (id == null) {
            return false;
        }
        if (id.endsWith("WFPCINST")) {
            DesignatePerformerUI.processByBussinessObjId((CoreUIObject)owner, (String)billId, null);
        } else {
            IWfUtil util = (IWfUtil)RpcProxy.wrapNoSupport(IWfUtil.class, (String)WfUtil.class.getName());
            ProcessDef procDef = util.getProcessDef(id);
            DesignatePerformerUI.process((CoreUIObject)owner, (AbstractObjectValue)editData, (ProcessDef)procDef, (String)function, (String)operation, null);
        }
        return true;
    }

    public static void showApproveHis(Component owner, String billId) {
        BOSUuid tmp = BOSUuid.read((String)billId);
        MultiApproveUtil.showApproveHis((BOSUuid)tmp, (String)UIModelDialogFactory.class.getName(), (Object)owner);
    }

    public static void showPassHis(Component owner, String billId) {
        BOSUuid tmp = BOSUuid.read((String)billId);
        MultiApproveUtil.showPassHis((BOSUuid)tmp, (String)UIModelDialogFactory.class.getName(), (Object)owner);
    }

    public static IWfUtil.ApproveAssignIds getAllValidApproveAssignIds(String billId) throws Exception {
        IWfUtil util = (IWfUtil)RpcProxy.wrapNoSupport(IWfUtil.class, (String)WfUtil.class.getName());
        return util.getAllValidApproveAssignIds(billId);
    }

    public static FilterInfo getApproveFilter(String billId) throws Exception {
        IWfUtil util = (IWfUtil)RpcProxy.wrapNoSupport(IWfUtil.class, (String)WfUtil.class.getName());
        return util.getApproveFilter(billId);
    }

    public static FilterInfo getApproveHstFilter(String billId) throws Exception {
        IWfUtil util = (IWfUtil)RpcProxy.wrapNoSupport(IWfUtil.class, (String)WfUtil.class.getName());
        return util.getApproveHstFilter(billId);
    }

    public static FilterInfo generateMultiApproveFilter(String billId, String[] assignIds) throws Exception {
        return WfUtil.generateMultiApproveFilter(billId, assignIds);
    }

    public static boolean checkPersonHasUser(String personId) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createRemoteEnactService();
        Person[] persons = svc.getPersonByPersonID(personId);
        return persons != null && persons.length != 0;
    }

    public static class ExportWfImage
    implements ActionListener {
        String id;
        String defaultFileName;
        Component owner;

        public ExportWfImage(String id, Component owner, String defaultFileName) {
            this.id = id;
            this.owner = owner;
            this.defaultFileName = defaultFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            FileOutputStream fos = null;
            try {
                File f;
                String path = this.getPath();
                if (path == null) {
                    return;
                }
                if (!path.endsWith(".png")) {
                    path = path + ".png";
                }
                if ((f = new File(path)).exists() && MsgBox.showConfirm2((String)EASResource.getString((String)WfUtils.resourceClass, (String)"fileExistWarn")) != 0) {
                    return;
                }
                IWfUtil util = (IWfUtil)RpcProxy.wrapNoSupport(IWfUtil.class, (String)WfUtil.class.getName());
                byte[] bytes = util.getImageData(this.id);
                fos = new FileOutputStream(path);
                fos.write(bytes);
                MsgBox.showInfo((String)(EASResource.getString((String)WfUtils.resourceClass, (String)"workflowDiagramExportSuccess") + path));
            }
            catch (Exception ex) {
                MsgBox.showConfirm3a((String)EASResource.getString((String)WfUtils.resourceClass, (String)"workflowDiagramExprotFailed"), (String)WfUtils.dump(ex));
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }

        private String getPath() {
            String defaultFileName = System.getProperty("user.home") + File.separator + this.defaultFileName + ".png";
            KDFileChooser fc = new KDFileChooser(System.getProperty("user.home"));
            SimpleFileFilter filter = new SimpleFileFilter();
            filter.addExtension("png");
            fc.setFileFilter((FileFilter)filter);
            fc.setSelectedFile(new File(defaultFileName));
            if (fc.showSaveDialog(this.owner) == 1) {
                return null;
            }
            return fc.getSelectedFile().getPath();
        }
    }

    public static class ExportWfKpdl
    implements ActionListener {
        String id;
        String defaultFileName;
        Component owner;

        public ExportWfKpdl(String id, Component owner, String defaultFileName) {
            this.id = id;
            this.owner = owner;
            this.defaultFileName = defaultFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            FileOutputStream fos = null;
            try {
                File f;
                String path = this.getPath();
                if (path == null) {
                    return;
                }
                if (!path.endsWith(".kdwf")) {
                    path = path + ".kdwf";
                }
                if ((f = new File(path)).exists() && MsgBox.showConfirm2((String)EASResource.getString((String)WfUtils.resourceClass, (String)"fileExistWarn")) != 0) {
                    return;
                }
                IWfUtil util = (IWfUtil)RpcProxy.wrapNoSupport(IWfUtil.class, (String)WfUtil.class.getName());
                String kpdl = util.getKpdlData(this.id);
                if (kpdl == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)WfUtils.resourceClass, (String)"processDefNotExist"));
                    return;
                }
                byte[] bytes = kpdl.getBytes("UTF-8");
                fos = new FileOutputStream(path);
                fos.write(bytes);
                MsgBox.showInfo((String)(EASResource.getString((String)WfUtils.resourceClass, (String)"processDefExportSuccess") + path));
            }
            catch (Exception ex) {
                MsgBox.showConfirm3a((String)EASResource.getString((String)WfUtils.resourceClass, (String)"processDefExprotFailed"), (String)WfUtils.dump(ex));
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }

        private String getPath() {
            String defaultFileName = System.getProperty("user.home") + File.separator + this.defaultFileName + ".kdwf";
            KDFileChooser fc = new KDFileChooser(System.getProperty("user.home"));
            SimpleFileFilter filter = new SimpleFileFilter();
            filter.addExtension("kdwf");
            fc.setFileFilter((FileFilter)filter);
            fc.setSelectedFile(new File(defaultFileName));
            if (fc.showSaveDialog(this.owner) == 1) {
                return null;
            }
            return fc.getSelectedFile().getPath();
        }
    }

    public static class NextPerson
    implements ActionListener {
        String id;
        String defaultFileName;
        Component owner;

        public NextPerson(String id, Component owner, String defaultFileName) {
            this.id = id;
            this.owner = owner;
            this.defaultFileName = defaultFileName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Class<?> cls = Class.forName("com.kingdee.eas.base.multiapprove.client.DesignatePerformerUI");
                Method m = cls.getMethod("process", CoreUIObject.class, String.class);
                m.invoke(null, null, this.id);
            }
            catch (Exception ex) {
                MsgBox.showConfirm3a((String)EASResource.getString((String)WfUtils.resourceClass, (String)"callNextPerformerFailed"), (String)WfUtils.dump(ex));
            }
        }
    }
}

