/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.client;

import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.monitor.ActivityUiInfo;
import com.kingdee.bos.workflow.monitor.client.AbstractWorkFlowMonitorUI;
import com.kingdee.bos.workflow.service.ormrpc.struct.IProcessImage;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class WorkFlowMonitorUI
extends AbstractWorkFlowMonitorUI {
    private static final Logger logger = CoreUIObject.getLogger(WorkFlowMonitorUI.class);
    private static final String resourceClass = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource";
    List activitiesUI = new ArrayList();
    HashMap activityInfoMap = new HashMap();
    HashMap activitiesMap = new HashMap();

    public HashMap getActivitiesMap() {
        return this.activitiesMap;
    }

    public void setActivitiesMap(HashMap activitiesMap) {
        this.activitiesMap = activitiesMap;
    }

    public HashMap getActivityInfoMap() {
        return this.activityInfoMap;
    }

    public void setActivityInfoMap(HashMap activityInfoMap) {
        this.activityInfoMap = activityInfoMap;
    }

    public List getActivitiesUI() {
        return this.activitiesUI;
    }

    public void setActivitiesUI(List activitiesUI) {
        this.activitiesUI = activitiesUI;
    }

    public KDTable getWorkFlowTable() {
        return this.wf_Table;
    }

    public WorkFlowMonitorUI() throws Exception {
        this.kDPanel1.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), EASResource.getString((String)resourceClass, (String)"workflowborder")));
    }

    public KDSplitPane getSplit() {
        return this.kDSplitPane1;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    @Override
    public void actionFilterFinishedActivity_actionPerformed(ActionEvent e) throws Exception {
        super.actionFilterFinishedActivity_actionPerformed(e);
        this.stateChange();
    }

    @Override
    public void actionFilterNotManpower_actionPerformed(ActionEvent e) throws Exception {
        super.actionFilterNotManpower_actionPerformed(e);
        this.stateChange();
    }

    @Override
    public void actionDetailInfo_actionPerformed(ActionEvent e) throws Exception {
        super.actionDetailInfo_actionPerformed(e);
        this.showDetail();
        this.stateChange();
    }

    private void stateChange() {
        if (this.filterNotManpowerCheckBox.isSelected() && this.filterfinishedActivityCheckBox.isSelected()) {
            this.fillTable(this.filterAllActivities());
        } else if (this.filterNotManpowerCheckBox.isSelected()) {
            this.fillTable(this.filterAutoActivities());
        } else if (this.filterfinishedActivityCheckBox.isSelected()) {
            this.fillTable(this.filterPauseActivities());
        } else {
            this.fillTable(this.activitiesUI);
        }
        this.wf_Table.setRefresh(true);
        this.wf_Table.repaint();
    }

    public void initColumn() {
        this.wf_Table.getSelectManager().setSelectMode(2);
        this.filterNotManpowerCheckBox.setFocusable(false);
        this.filterfinishedActivityCheckBox.setFocusable(false);
        this.showActiveDetailInfo.setFocusable(false);
        this.wf_Table.getColumn("preActive").getStyleAttributes().setHided(true);
        this.wf_Table.getColumn("postActive").getStyleAttributes().setHided(true);
        this.wf_Table.getColumn("activeType").getStyleAttributes().setHided(true);
        this.filterNotManpowerCheckBox.setSelected(true);
    }

    void refreshTable() {
        this.stateChange();
    }

    public void showDetail() {
        if (this.showActiveDetailInfo.isSelected()) {
            this.wf_Table.getColumn("preActive").getStyleAttributes().setHided(false);
            this.wf_Table.getColumn("postActive").getStyleAttributes().setHided(false);
            this.wf_Table.getColumn("activeType").getStyleAttributes().setHided(false);
        } else {
            this.wf_Table.getColumn("preActive").getStyleAttributes().setHided(true);
            this.wf_Table.getColumn("postActive").getStyleAttributes().setHided(true);
            this.wf_Table.getColumn("activeType").getStyleAttributes().setHided(true);
        }
        this.wf_Table.refresh();
    }

    public List filterAutoActivities() {
        ArrayList<ActivityUiInfo> manActivities = new ArrayList<ActivityUiInfo>();
        for (int i = 0; i < this.activitiesUI.size(); ++i) {
            IProcessImage.Activity act;
            ActivityUiInfo info = (ActivityUiInfo)this.activitiesUI.get(i);
            String activityInstId = info.getActivityInstId();
            ActivityInstInfo activityInfo = (ActivityInstInfo)this.activityInfoMap.get(activityInstId);
            if (activityInfo == null || (act = (IProcessImage.Activity)this.activitiesMap.get(activityInfo.getActDefId())) == null || !act.isManpower) continue;
            manActivities.add(info);
        }
        return manActivities;
    }

    public List filterPauseActivities() {
        ArrayList<ActivityUiInfo> runActivities = new ArrayList<ActivityUiInfo>();
        for (int i = 0; i < this.activitiesUI.size(); ++i) {
            ActivityUiInfo info = (ActivityUiInfo)this.activitiesUI.get(i);
            String activityInstId = info.getActivityInstId();
            ActivityInstInfo activityInfo = (ActivityInstInfo)this.activityInfoMap.get(activityInstId);
            if (activityInfo == null || activityInfo.getState().equals("closed.aborted") || activityInfo.getState().equals("closed.completed")) continue;
            runActivities.add(info);
        }
        return runActivities;
    }

    public List filterAllActivities() {
        ArrayList<ActivityUiInfo> activities = new ArrayList<ActivityUiInfo>();
        for (int i = 0; i < this.activitiesUI.size(); ++i) {
            IProcessImage.Activity act;
            ActivityUiInfo info = (ActivityUiInfo)this.activitiesUI.get(i);
            String activityInstId = info.getActivityInstId();
            ActivityInstInfo activityInfo = (ActivityInstInfo)this.activityInfoMap.get(activityInstId);
            if (activityInfo == null || (act = (IProcessImage.Activity)this.activitiesMap.get(activityInfo.getActDefId())) == null || !act.isManpower || activityInfo.getState().equals("closed.aborted") || activityInfo.getState().equals("closed.completed")) continue;
            activities.add(info);
        }
        return activities;
    }

    public void fillTable(List activityInfoList) {
        logger.info((Object)("\"uiActivitys\"'s size is " + activityInfoList.size() + "!"));
        this.wf_Table.checkParsed();
        this.wf_Table.removeRows();
        this.wf_Table.setEditable(false);
        IRow row = null;
        ICell cell = null;
        int count = activityInfoList.size();
        Map tRowMap = new HashMap();
        if (count > 0) {
            tRowMap = this.getTableRowMap(count, activityInfoList);
        }
        int countNumber = 0;
        for (int i = 0; i < count; ++i) {
            row = this.wf_Table.addRow(i + countNumber);
            ActivityUiInfo info = (ActivityUiInfo)activityInfoList.get(i);
            String uiInstId = info.getActivityInstId();
            ActivityInstInfo activityInstInfo = (ActivityInstInfo)this.activityInfoMap.get(uiInstId);
            row.setUserObject((Object)activityInstInfo);
            cell = row.getCell("activeName");
            cell.setValue((Object)info.getActivityName());
            cell = row.getCell("currentState");
            cell.setValue((Object)info.getActivityState());
            cell = row.getCell("preActive");
            cell.setValue((Object)info.getPreActInst());
            cell = row.getCell("postActive");
            cell.setValue((Object)info.getPostActInst());
            cell = row.getCell("activeType");
            cell.setValue((Object)info.getActivityType());
            cell = row.getCell("createTime");
            cell.setValue((Object)this.converTime(info.getCreatedTime()));
            cell = row.getCell("finishTime");
            cell.setValue((Object)this.converTime(info.getCompleteTime()));
            cell = row.getCell("costTime");
            cell.setValue((Object)info.getConsumeTime());
            List tList = (List)tRowMap.get(uiInstId);
            if (tList == null || tList.size() <= 0) continue;
            int startmerge = i + countNumber;
            for (int index = 0; index < tList.size(); ++index) {
                if (index != 0) {
                    row = this.wf_Table.addRow(i + ++countNumber, (IRow)row.clone());
                }
                Map tDataMap = (Map)tList.get(index);
                cell = row.getCell("approvePerson");
                cell.setValue(tDataMap.get("approvePerson"));
                cell = row.getCell("approvalResult");
                cell.setValue(tDataMap.get("approvalResult"));
                cell = row.getCell("approvalOpinion");
                cell.setValue(tDataMap.get("approvalOpinion"));
                if (index != tList.size() - 1) continue;
                this.wf_Table.getMergeManager().mergeBlock(startmerge, 0, startmerge + tList.size() - 1, 4, 1);
                this.wf_Table.getMergeManager().mergeBlock(startmerge, 8, startmerge + tList.size() - 1, 10, 1);
            }
        }
        this.wf_Table.getColumn("approvalOpinion").setWidth(220);
        for (int index = 0; index < this.wf_Table.getRowCount(); ++index) {
            KDTableHelper.autoFitRowHeight((KDTable)this.wf_Table, (int)index);
        }
        logger.info((Object)"End fillTable!");
        logger.info((Object)("Row count is " + this.wf_Table.getRowCount() + "!"));
    }

    public Map getTableRowMap(int count, List activityInfoList) {
        HashMap tResultMap = new HashMap();
        boolean isShowRollBack = WorkFlowMonitorUI.isShowRollBack();
        try {
            StringBuffer tStrActinstid = new StringBuffer();
            tStrActinstid.append(" in (");
            for (int index = 0; index < count; ++index) {
                ActivityUiInfo tActivityUiInfo = (ActivityUiInfo)activityInfoList.get(index);
                String tActivityInstId = tActivityUiInfo.getActivityInstId();
                if (index < count - 1) {
                    tStrActinstid.append("'" + tActivityInstId + "',");
                    continue;
                }
                tStrActinstid.append("'" + tActivityInstId + "' )");
            }
            Locale tLocale = ContextUtils.getLocaleFromEnv();
            String filterRollBack = "";
            if (isShowRollBack) {
                filterRollBack = " and a.ftype != 10 ";
            }
            StringBuffer tStrSql = new StringBuffer();
            tStrSql.append("select * from ( ");
            tStrSql.append(" select b.factinstid,c.fname_" + tLocale + ",a.FIsPass,a.FOpinion_" + tLocale + ",a.FHandlerContent  ");
            tStrSql.append(" from t_bas_multiapprove a ,t_wfr_assign b , T_PM_User c ");
            tStrSql.append(" where a.fassignmentid = b.fassignid and a.fcreatorid = c.fid  and a.fstatus<>0 ");
            tStrSql.append(filterRollBack);
            tStrSql.append(" and b.factinstid ");
            tStrSql.append(tStrActinstid);
            tStrSql.append("union all ");
            tStrSql.append(" select b.factinstid,c.fname_" + tLocale + ",a.FIsPass,a.FOpinion_" + tLocale + ",a.FHandlerContent  ");
            tStrSql.append(" from t_bas_multiapprove a ,t_wfr_assigndetail b , T_PM_User c ");
            tStrSql.append(" where a.fassignmentid = b.fassignid and a.fcreatorid = c.fid  and a.fstatus<>0 ");
            tStrSql.append(filterRollBack);
            tStrSql.append(" and b.factinstid ");
            tStrSql.append(tStrActinstid);
            tStrSql.append("union all ");
            tStrSql.append(" select b.factinstid,c.fname_" + tLocale + ",a.FIsPass,a.FOpinion_" + tLocale + ",a.FHandlerContent  ");
            tStrSql.append(" from t_bas_multiapprovehst a ,t_wfr_assignhst b , T_PM_User c ");
            tStrSql.append(" where a.fassignmentid = b.fassignid and a.fcreatorid = c.fid  and a.fstatus<>0 ");
            tStrSql.append(filterRollBack);
            tStrSql.append(" and b.factinstid ");
            tStrSql.append(tStrActinstid);
            tStrSql.append(" ) m order by m.factinstid ");
            SQLExecutor tSQLExecutor = new SQLExecutor(tStrSql.toString());
            IRowSet tIRowSet = null;
            tIRowSet = tSQLExecutor.executeSQL();
            if (tIRowSet != null) {
                ArrayList tList = null;
                String tconFactinstId = "";
                while (tIRowSet.next()) {
                    String tFactinstId = tIRowSet.getString(1);
                    if (!tconFactinstId.equals(tFactinstId)) {
                        tList = new ArrayList();
                        tconFactinstId = tFactinstId;
                    }
                    String tFname = tIRowSet.getString(2);
                    String tFIsPass = tIRowSet.getString(3);
                    tFIsPass = ApproveResult.getEnum((String)tFIsPass).getAlias();
                    String tFOpinion = tIRowSet.getString(4);
                    String tFHandlerContent = tIRowSet.getString(5);
                    HashMap<String, String> tDataMap = new HashMap<String, String>();
                    tDataMap.put("approvePerson", tFname);
                    if (tFHandlerContent == null || "null".equals(tFHandlerContent)) {
                        tDataMap.put("approvalResult", tFIsPass);
                    } else {
                        tDataMap.put("approvalResult", tFIsPass + "," + tFHandlerContent);
                    }
                    if (isShowRollBack && tFOpinion != null && tFOpinion.endsWith("rollback")) continue;
                    tDataMap.put("approvalOpinion", this.trim(tFOpinion));
                    tDataMap.put("approvalOpinion", this.trim(tFOpinion).replaceAll("rollback", ""));
                    tList.add(tDataMap);
                    tResultMap.put(tFactinstId, tList);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"WorkFlowMonitorUI: deal ApproveInfo error!");
        }
        return tResultMap;
    }

    public static boolean isShowRollBack() {
        try {
            String value = ParamManager.getParamValue(null, (String)"IS_SHOW_ROLLBACK_MUTIAPPROVEINFO");
            if ("TRUE".equalsIgnoreCase(value)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u7279\u6b8a\u6743\u9650\u8bbe\u7f6e\u51fa\u9519   " + e.getMessage()));
        }
        return true;
    }

    private String trim(String str) {
        if (str == null || "null".equals(str)) {
            return "";
        }
        return str;
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.wf_Table.checkParsed();
            this.wf_Table.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.wf_Table.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"activeName", "currentState", "preActive", "postActive", "activeType", "createTime", "finishTime", "costTime"};
        return columns;
    }

    private String converTime(Date tDate) {
        String tReturnDate;
        try {
            SimpleDateFormat tDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            tReturnDate = tDateFormat.format(tDate);
        }
        catch (Exception e) {
            return "";
        }
        return tReturnDate;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.wf_Table.getStyleAttributes().setWrapText(true);
    }
}

