/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastUtil;
import com.kingdee.eas.basedata.master.account.IAccountRefContrastProcess;
import com.kingdee.eas.basedata.master.account.app.AccountRefContrastProcess;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class AbstractAccountRefContrastProcess
implements IAccountRefContrastProcess {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.account.AbstractAccountRefContrastProcess");
    public BigDecimal zero = new BigDecimal(0);
    public BigDecimal one = new BigDecimal(1);
    public AccountRefContrastUtil util = new AccountRefContrastUtil();

    @Override
    public abstract boolean enable(Context var1, String var2, String var3) throws BOSException, EASBizException;

    @Override
    public abstract boolean disEnable(Context var1, String var2, String var3) throws BOSException, EASBizException;

    public String getCurrentPeriod(Context ctx, int systemEnum, String companyid) throws BOSException {
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        String curPeriodId = null;
        String sql = " select b.fCurrentPeriodid  from t_bd_systemstatus a ,t_bd_systemstatusctrol b where a.fname=" + systemEnum + " and a.fid=b.fsystemstatusid and b.fcompanyid='" + companyid + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (set.next()) {
                curPeriodId = set.getString("FCurrentPeriodID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return curPeriodId;
    }

    public boolean isStartSystem(Context ctx, int systemEnum, String companyid) throws BOSException {
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        boolean isStart = false;
        String sql = " select fisstart from t_bd_systemstatus a ,t_bd_systemstatusctrol b where a.fname=" + systemEnum + " and a.fid=b.fsystemstatusid and b.fcompanyid='" + companyid + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (set.next()) {
                isStart = set.getBoolean("fisstart");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isStart;
    }

    public String getOldAcctTableID(Context ctx, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FDisabledAcctTableID from T_BD_AcctRefContrast where Fid='" + acrefID + "'");
        String oldAcctTableID = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                oldAcctTableID = rs.getString("FDisabledAcctTableID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return oldAcctTableID;
    }

    public String getNewAcctTableID(Context ctx, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_BD_AcctRefContrast where Fid='" + acrefID + "'");
        String newAcctTableID = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                newAcctTableID = rs.getString("FEnabledAcctTableID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return newAcctTableID;
    }

    public String getVoucherType(Context ctx) throws BOSException, EASBizException {
        VoucherTypeInfo info;
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("adminCU.*");
        evi.setSelector(sic);
        IVoucherType v = VoucherTypeFactory.getLocalInstance((Context)ctx);
        String ctrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        ObjectUuidPK ctrlUnitPK = new ObjectUuidPK(ctrlUnit);
        filter = v.getDatabaseDFilter((IObjectPK)ctrlUnitPK, "id", "adminCU.id");
        evi.setFilter(filter);
        VoucherTypeCollection coll = VoucherTypeFactory.getLocalInstance((Context)ctx).getVoucherTypeCollection(evi);
        if (coll.size() == 0) {
            String msg = EASCommonResource.getString((String)"com.kingdee.eas.basedata.master.account.AccountResource", (String)"noVoucher_Type", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("", msg));
        }
        String msg = EASCommonResource.getString((String)"com.kingdee.eas.basedata.master.account.AccountResource", (String)"turn", (Locale)ctx.getLocale());
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!msg.equals(info.getName())) continue;
            return info.getId().toString();
        }
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!info.isPretermit()) continue;
            return info.getId().toString();
        }
        return coll.get(0).getId().toString();
    }

    public Object getAsstActObject(Context ctx, String value) throws BOSException {
        IObjectValue objectValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(BOSUuid.read((String)value).getType(), (IObjectPK)new ObjectUuidPK(value));
        return objectValue;
    }

    public String createTempleTable(Context ctx, String acrefID) throws BOSException {
        ITableManagerFacade mfa = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tempTable = mfa.getTemporaryTableName("templeName");
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table ");
        createSql.append(tempTable);
        createSql.append("(");
        createSql.append("FoldAcctID \tVARCHAR(44), ");
        createSql.append("FnewAcctID \tVARCHAR(44) ");
        createSql.append(")");
        mfa.createTempTable(createSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(tempTable);
        insertSql.append(" select min(en.foldAcctid),en.fnewAcctid ");
        insertSql.append(" from  T_BD_AcctRefContrastEntry en  ");
        insertSql.append(" where en.FAcctRefContrastID=? group by  en.fnewAcctid");
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{acrefID});
        return tempTable;
    }

    public String createDisableTempleTable(Context ctx, String acrefID) throws BOSException {
        ITableManagerFacade mfa = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tempTable = mfa.getTemporaryTableName("disableTempleName");
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table ");
        createSql.append(tempTable);
        createSql.append("(");
        createSql.append("FoldAcctID \tVARCHAR(44), ");
        createSql.append("FnewAcctID \tVARCHAR(44), ");
        createSql.append("FoldAcctTabID \tVARCHAR(44), ");
        createSql.append("FnewAcctTabID \tVARCHAR(44) ");
        createSql.append(")");
        mfa.createTempTable(createSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(tempTable);
        insertSql.append(" SELECT   En.Fnewacctid,     \r\n");
        insertSql.append("         En.Foldacctid,     \r\n");
        insertSql.append("         Head.Fenabledaccttableid,     \r\n");
        insertSql.append("         Head.Fdisabledaccttableid     \r\n");
        insertSql.append("FROM     T_bd_acctrefcontrastentry En     \r\n");
        insertSql.append("         INNER JOIN T_bd_acctrefcontrast Head     \r\n");
        insertSql.append("           ON En.Facctrefcontrastid = Head.Fid     \r\n");
        insertSql.append("WHERE    Head.Fid = '" + acrefID + "'     \r\n");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        return tempTable;
    }

    public String createEnableTempleTable(Context ctx, String acrefID) throws BOSException {
        ITableManagerFacade mfa = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tempTable = mfa.getTemporaryTableName("enableTempleName");
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table ");
        createSql.append(tempTable);
        createSql.append("(");
        createSql.append("FoldAcctID \tVARCHAR(44), ");
        createSql.append("FnewAcctID \tVARCHAR(44), ");
        createSql.append("FoldAcctTabID \tVARCHAR(44), ");
        createSql.append("FnewAcctTabID \tVARCHAR(44) ");
        createSql.append(")");
        mfa.createTempTable(createSql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(tempTable);
        insertSql.append(" SELECT   En.Foldacctid,     \r\n");
        insertSql.append("         En.Fnewacctid,     \r\n");
        insertSql.append("         Head.Fdisabledaccttableid,     \r\n");
        insertSql.append("         Head.Fenabledaccttableid     \r\n");
        insertSql.append("FROM     T_bd_acctrefcontrastentry En     \r\n");
        insertSql.append("         INNER JOIN T_bd_acctrefcontrast Head     \r\n");
        insertSql.append("           ON En.Facctrefcontrastid = Head.Fid     \r\n");
        insertSql.append("WHERE    Head.Fid = '" + acrefID + "'     \r\n");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        return tempTable;
    }

    protected void dropTable(String tableName, Context ctx) throws BOSException {
        if (tableName == null) {
            return;
        }
        ITableManagerFacade manager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        manager.releaseTableName(tableName);
    }

    public Date getEnableTime(Context ctx, String acrefid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_BD_AcctRefContrast where fid='" + acrefid + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Date enableTime = null;
        try {
            while (rs.next()) {
                enableTime = rs.getDate("fenabledtime");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return enableTime;
    }

    private void adjuestAccountBanks(Context ctx, String acctrefId, String companyid) throws BOSException {
        String sql = "update t_bd_accountbanks set (faccountid, fcompanyid )=  (select  fnewacctid, t_bd_accountbanks.fcompanyid from T_BD_AcctRefContrastentry where  foldacctid=faccountid and  FACCTREFCONTRASTID='" + acctrefId + "' and t_bd_accountbanks.fcompanyid='" + companyid + "')";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void unadjuestAccountBanks(Context ctx, String acctrefId, String companyid, String templeTable) throws BOSException {
        SQLUtil sb = new SQLUtil();
        sb.appendSql("update t_bd_accountbanks set (faccountid)=  (select tem.foldacctid from " + templeTable + " tem where  tem.fnewacctid=faccountid and t_bd_accountbanks.fcompanyid='" + companyid + "' and faccountid is not null)");
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    public void updateAccountBaseDate(Context ctx, String companyid, String templeTable) throws BOSException, EASBizException {
        try {
            String disableTab = null;
            String enableTab = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select top 1 * from " + templeTable));
            while (rs.next()) {
                disableTab = rs.getString("FoldAcctTabID");
                enableTab = rs.getString("FnewAcctTabID");
            }
            if (disableTab == null) {
                return;
            }
            AccountRefContrastProcess accountProc = new AccountRefContrastProcess();
            accountProc.changeAssistCustomizedProperty(ctx, companyid, templeTable);
            try {
                Class.forName("com.kingdee.eas.fi.ar.app.BadAccountRefContrastProcess");
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)"\u5904\u7406\u7c7b\uff08com.kingdee.eas.fi.ar.app.BadAccountRefContrastProcess\uff09\u672a\u627e\u5230\uff01\u542f\u7528/\u53cd\u542f\u7528\u79d1\u76ee\u5bf9\u7167\u8868\u6267\u884cid\u66ff\u6362\u53c2\u6570\u503c\u65f6\uff0c\u8d70\u65e7\u7684\u903b\u8f91", (Throwable)e);
                accountProc.changeParamItem(ctx, companyid, templeTable);
            }
            this.dropTable(templeTable, ctx);
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)e;
            }
            throw new BOSException((Throwable)e);
        }
    }
}

