/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountFacade;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountCopyUI;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AccountCopyUI
extends AbstractAccountCopyUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountCopyUI.class);
    private String companyId = null;
    private String accounttable = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
        this.initMyIcon();
    }

    private void initData() {
        AccountDataChangeListener srcDataChangeListener = new AccountDataChangeListener(0);
        AccountDataChangeListener objDataChangeListener = new AccountDataChangeListener(1);
        this.bizSrcAccount.addDataChangeListener((DataChangeListener)srcDataChangeListener);
        this.bizObjAccount.addDataChangeListener((DataChangeListener)objDataChangeListener);
        this.bizCompany.setDisplayFormat("$name$");
        this.bizAccountTable.setDisplayFormat("$name$");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getUIContext().get("Company");
        this.companyId = company.getId().toString();
        this.bizCompany.setValue((Object)company);
        AccountTableInfo table = (AccountTableInfo)this.getUIContext().get("tableInfo");
        this.accounttable = table.getId().toString();
        this.bizAccountTable.setValue((Object)table);
        this.bizSrcAccount.setEditable(true);
        this.bizSrcAccount.setEditFormat("$number$");
        this.bizSrcAccount.setDisplayFormat("$number$");
        this.bizSrcAccount.setCommitFormat("$helpCode$;$number$;$name$");
        this.bizSrcAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("isLeaf"));
        this.bizSrcAccount.setSelectorCollection(sic);
        this.bizObjAccount.setEditable(true);
        this.bizObjAccount.setEditFormat("$number$");
        this.bizObjAccount.setDisplayFormat("$number$");
        this.bizObjAccount.setCommitFormat("$helpCode$;$number$;$name$");
        this.bizObjAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.bizObjAccount.setSelectorCollection(sic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.companyId));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", null));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.accounttable));
        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND ( #4 or  #5)  AND #6");
        this.bizSrcAccount.setEntityViewInfo(view);
        EntityViewInfo objview = new EntityViewInfo();
        FilterInfo objfilter = new FilterInfo();
        objview.setFilter(objfilter);
        FilterItemCollection objfic = objfilter.getFilterItems();
        objfic.add(new FilterItemInfo("companyID.id", (Object)this.companyId));
        objfic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        objfic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        objfic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        objfic.add(new FilterItemInfo("control", (Object)new Integer(0)));
        objfic.add(new FilterItemInfo("control", null));
        objfic.add(new FilterItemInfo("accountTableID.id", (Object)this.accounttable));
        objfilter.setMaskString("#0 AND #1 AND #2 AND #3 AND ( #4 or  #5)  AND #6");
        this.bizObjAccount.setEntityViewInfo(objview);
        filter = new FilterInfo();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.companyId));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", null));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.accounttable));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(0)));
        filter.setMaskString("#0 AND #1 AND #2 AND ( #3 or  #4)  AND #5 AND #6 ");
        AccountPromptBox selector = new AccountPromptBox((IUIObject)this, null, table, filter, false, false);
        this.bizSrcAccount.setSelector((KDPromptSelector)selector);
        filter = new FilterInfo();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.companyId));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", null));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.accounttable));
        filter.setMaskString("#0 AND #1 AND #2 AND ( #3 or  #4)  AND #5  ");
        selector = new AccountPromptBox((IUIObject)this, null, table, filter, false, true);
        this.bizObjAccount.setSelector((KDPromptSelector)selector);
        this.tblMain.checkParsed();
        this.tblMain.getColumn("srcAccount").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("objAccount").getStyleAttributes().setLocked(true);
    }

    private void initMyIcon() {
        this.btnSelectAll.setEnabled(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClear.setEnabled(true);
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnCopy.setEnabled(true);
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnExist.setEnabled(true);
        this.btnExist.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
    }

    public void afterSelectAccount(int type, Object value) throws Exception {
        AccountViewInfo account = (AccountViewInfo)value;
        if (type == 0) {
            this.tblMain.removeRows();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("parent.id", (Object)account.getId().toString()));
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("number"));
            AccountViewCollection col = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
            int rowCount = col.size();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblMain.addRow();
                row.getCell("select").setValue((Object)Boolean.FALSE);
                row.getCell("srcAccount").setValue((Object)col.get(i).getNumber());
                row.setUserObject((Object)col.get(i));
            }
        } else {
            AccountViewInfo srcaccount = (AccountViewInfo)this.bizSrcAccount.getValue();
            if (account.getLevel() != srcaccount.getLevel()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"76_AccountCopyUI"));
                this.bizObjAccount.setValue(null);
                SysUtil.abort();
            }
            int rowCount = this.tblMain.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblMain.getRow(i);
                String srcNumber = (String)row.getCell("srcAccount").getValue();
                String objNumber = srcNumber.replaceAll(srcaccount.getNumber(), account.getNumber());
                row.getCell("objAccount").setValue((Object)objNumber);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(true);
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(false);
    }

    private void doSelect(boolean select) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            rowAss.getCell("select").setValue((Object)select);
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        AccountViewInfo srcaccount = (AccountViewInfo)this.bizSrcAccount.getValue();
        AccountViewInfo objaccount = (AccountViewInfo)this.bizSrcAccount.getValue();
        if (srcaccount == null || objaccount == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"77_AccountCopyUI"));
            SysUtil.abort();
        }
        String firstNumber = null;
        String parentid = objaccount.getId().toString();
        HashMap<String, Object> account = new HashMap<String, Object>();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            String objAccount = (String)row.getCell("objAccount").getValue();
            Object srcAccount = row.getUserObject();
            account.put(objAccount, srcAccount);
            if (i != 0) continue;
            firstNumber = objAccount;
        }
        this.getBizInterface().copyAccount(parentid, firstNumber, account);
    }

    @Override
    public void actionExist_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public IAccountFacade getBizInterface() throws Exception {
        return AccountFacadeFactory.getRemoteInstance();
    }

    class AccountDataChangeListener
    implements DataChangeListener {
        int type;

        public AccountDataChangeListener(int type) {
            this.type = type;
        }

        public void dataChanged(DataChangeEvent eventObj) {
            if (!(eventObj.getNewValue() instanceof AccountViewInfo)) {
                return;
            }
            try {
                AccountCopyUI.this.afterSelectAccount(this.type, eventObj.getNewValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

