/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fi.gl.GLUtilPorcessFactory;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountSetAsstDefaultUI;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountSetAsstDefaultUI
extends AbstractAccountSetAsstDefaultUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountSetAsstDefaultUI.class);
    private AccountViewInfo accountviewInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ObjectUuidPK accountPK = (ObjectUuidPK)this.getUIContext().get("accountPK");
        this.accountviewInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)accountPK, this.getSelectors());
        this.initBtnFields();
        AsstActGroupDetailCollection asstActDetailColl = this.getAsstActGroupDetailColl();
        if (asstActDetailColl != null && asstActDetailColl.size() > 0) {
            AssistantHGInfo assistantHGInfo = AccountFacadeFactory.getRemoteInstance().getDefaultAssistantHgInfo((IObjectPK)accountPK);
            for (int i = 0; i < asstActDetailColl.size(); ++i) {
                IRow row = this.tblMain.addRow();
                AsstActTypeInfo asstActInfo = asstActDetailColl.get(i).getAsstActType();
                String key = asstActInfo.getAsstHGAttribute();
                row.setUserObject((Object)asstActInfo);
                row.getCell("asstType").setValue((Object)asstActInfo.getName());
                if (assistantHGInfo != null) {
                    row.getCell("defaultValue").setValue(assistantHGInfo.get(key));
                }
                row.getCell("defaultValue").setEditor(GLUtilPorcessFactory.getGLUtilPorcess().getCellEditor(asstActInfo, (CoreUIObject)this));
            }
        }
    }

    private void initBtnFields() {
        this.tblMain.checkParsed();
        this.btnCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.accountNumber.setText(this.accountviewInfo.getNumber());
        this.accountName.setText(this.accountviewInfo.getName(this.getCurrentLocale()));
        if (this.accountviewInfo.getCAA() != null) {
            this.accountAsst.setText(this.accountviewInfo.getCAA().getName(this.getCurrentLocale()));
        }
    }

    private AsstActGroupDetailCollection getAsstActGroupDetailColl() throws BOSException {
        if (this.accountviewInfo.getCAA() == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("asstActType.id");
        evi.getSelector().add("asstActType.number");
        evi.getSelector().add("asstActType.name");
        evi.getSelector().add("asstActType.asstHGAttribute");
        evi.getSelector().add("asstActType.mappingFieldName");
        evi.getSelector().add("asstActType.defaultQueryName");
        evi.getSelector().add("asstActType.isForCompany");
        evi.getSelector().add("asstActType.defaultF7UI");
        evi.getSelector().add("asstActType.glAsstActTypeGrp.id");
        evi.getSelector().add("asstActType.isMultilevel");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)this.accountviewInfo.getCAA().getId().toString()));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        this.tblMain.removeRows();
        AsstActGroupDetailCollection newasstcol = AsstActGroupDetailFactory.getRemoteInstance().getAsstActGroupDetailCollection(evi);
        return newasstcol;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Map defaultValue = this.getDefaultVal();
        boolean flag = AccountFacadeFactory.getRemoteInstance().setAsstDefaultValue(this.accountviewInfo, defaultValue);
        if (flag) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AllAccountResource.saveSuccess"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AllAccountResource.saveFail"));
        }
    }

    protected Map getDefaultVal() {
        HashMap<Object, Object> defaultVal = new HashMap<Object, Object>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow tbrow = this.tblMain.getRow(i);
            Object value = tbrow.getCell("defaultValue").getValue();
            defaultVal.put(tbrow.getUserObject(), value);
        }
        return defaultVal;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("number"));
        coll.add(new SelectorItemInfo("name"));
        coll.add(new SelectorItemInfo("CAA.name"));
        return coll;
    }
}

