/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fi.gl.client.ClientHelper;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.master.account.client.AbstractAcctCtrlEditUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class AcctCtrlEditUI
extends AbstractAcctCtrlEditUI {
    private Account_ControlInfo acctCtrlInfoForRef;
    private Account_ControlInfo acctCtrlInfo;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTblAcctCtrl();
        this.loadCtx();
        this.loadFields();
    }

    private void loadCtx() throws BOSException {
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("Company");
        AccountTableInfo acctTable = (AccountTableInfo)this.getUIContext().get("AccountTable");
        this.acctCtrlInfoForRef = AccountTools.getAcctCtrlInfo(null, acctTable, currentCompany, true);
        if (this.acctCtrlInfoForRef == null) {
            this.acctCtrlInfoForRef = new Account_ControlInfo();
            this.acctCtrlInfoForRef.setAccountTableID(acctTable);
            this.acctCtrlInfoForRef.setSrcCompany(currentCompany);
            this.acctCtrlInfoForRef.setDestCompany(currentCompany);
            this.acctCtrlInfoForRef.setIsDefaultForRefer(true);
        }
        this.acctCtrlInfo = AccountTools.getAcctCtrlInfo(null, acctTable, currentCompany);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadAcctCtrlToTable();
    }

    private boolean checkCU() throws EASBizException, BOSException {
        CtrlUnitInfo currentCu = (CtrlUnitInfo)this.getUIContext().get("Cu");
        AccountTableInfo acctTable = (AccountTableInfo)this.getUIContext().get("AccountTable");
        CtrlUnitCollection ctrlunti = AccountTools.getChildCu(null, currentCu);
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer aer = new StringBuffer();
        int ctrlcount = ctrlunti.size();
        for (int i = 0; i < ctrlcount; ++i) {
            currentCu = ctrlunti.get(i);
            if (AccountTools.checkAccountTableCanAssign(null, currentCu)) continue;
            list.add(currentCu.getId().toString());
        }
        if (list != null) {
            int intcount = list.size();
            for (int ii = 0; ii < intcount; ++ii) {
                aer.append(list.get(ii) + ",");
                if (ii != intcount - 1) continue;
                aer.append(list.get(ii));
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTable.getId().toString()));
            if (aer.length() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("destCu", (Object)aer.toString(), CompareType.INCLUDE));
            }
            IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            acctCtrlCols.size();
            return acctCtrlCols == null || acctCtrlCols.size() <= 0;
        }
        return false;
    }

    private boolean checkCompany() throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("Company");
        AccountTableInfo acctTable = (AccountTableInfo)this.getUIContext().get("AccountTable");
        CompanyOrgUnitCollection companyOrgUnitCollection = AccountTools.getChildCompany(null, currentCompany, false, null);
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer aer = new StringBuffer();
        int ctrlcount = companyOrgUnitCollection.size();
        for (int i = 0; i < ctrlcount; ++i) {
            currentCompany = companyOrgUnitCollection.get(i);
            if (AccountTools.checkAccountTableCanAssign(null, currentCompany)) continue;
            list.add(currentCompany.getId().toString());
        }
        if (list != null && list.size() > 0) {
            int intcount = list.size();
            for (int ii = 0; ii < intcount; ++ii) {
                aer.append(list.get(ii) + ",");
                if (ii != intcount - 1) continue;
                aer.append(list.get(ii));
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTable.getId().toString()));
            if (aer.length() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)aer.toString(), CompareType.INCLUDE));
            }
            IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            acctCtrlCols.size();
            return acctCtrlCols == null || acctCtrlCols.size() <= 0;
        }
        return true;
    }

    private void loadAcctCtrlToTable() {
        if (this.acctCtrlInfoForRef == null) {
            return;
        }
        this.tblAcctCtrl.getRow(0).getCell(2).setValue((Object)(this.acctCtrlInfoForRef.getDc() == 1 ? 1 : 0));
        this.tblAcctCtrl.getRow(1).getCell(2).setValue((Object)(this.acctCtrlInfoForRef.getIsChangeCurrency() == 1 ? 1 : 0));
        this.tblAcctCtrl.getRow(2).getCell(2).setValue((Object)(this.acctCtrlInfoForRef.getCurrencyID() == 1 ? 1 : 0));
        this.tblAcctCtrl.getRow(3).getCell(2).setValue((Object)(this.acctCtrlInfoForRef.getAc() == 1 ? 1 : 0));
        this.tblAcctCtrl.getRow(4).getCell(2).setValue((Object)(this.acctCtrlInfoForRef.getAcNotice() == 1 ? 1 : 0));
        this.tblAcctCtrl.getRow(5).getCell(2).setValue((Object)(this.acctCtrlInfoForRef.getIsQty() == 1 ? 1 : 0));
        this.tblAcctCtrl.getRow(6).getCell(2).setValue((Object)(this.acctCtrlInfoForRef.getControl() == 1 ? 1 : 0));
        this.tblAcctCtrl.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblAcctCtrl.getRow(0).getCell(2).getStyleAttributes().setLocked(this.acctCtrlInfo.getDc() == 1);
        this.tblAcctCtrl.getRow(1).getCell(2).getStyleAttributes().setLocked(this.acctCtrlInfo.getIsChangeCurrency() == 1);
        this.tblAcctCtrl.getRow(2).getCell(2).getStyleAttributes().setLocked(this.acctCtrlInfo.getCurrencyID() == 1);
        this.tblAcctCtrl.getRow(3).getCell(2).getStyleAttributes().setLocked(this.acctCtrlInfo.getAc() == 1);
        this.tblAcctCtrl.getRow(4).getCell(2).getStyleAttributes().setLocked(this.acctCtrlInfo.getAcNotice() == 1);
        this.tblAcctCtrl.getRow(5).getCell(2).getStyleAttributes().setLocked(this.acctCtrlInfo.getIsQty() == 1);
        this.tblAcctCtrl.getRow(6).getCell(2).getStyleAttributes().setLocked(this.acctCtrlInfo.getControl() == 1);
        ClientHelper.setTableKeyBoardManager((KDTable)this.tblAcctCtrl);
    }

    private void initTblAcctCtrl() {
        IRow iRow;
        this.tblAcctCtrl.setFormatXml((String)null);
        int headRowCount = 1;
        String[] strHeaders = new String[]{EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"ID"), EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"property"), EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"blocControl")};
        for (int j = 0; j < strHeaders.length; ++j) {
            IColumn iCol = this.tblAcctCtrl.addColumn(j);
            if (j == 0) continue;
            iCol.setWidth(200);
        }
        for (int i = 0; i < headRowCount; ++i) {
            iRow = this.tblAcctCtrl.addHeadRow(i);
            for (int j = 0; j < strHeaders.length; ++j) {
                ICell iCell = iRow.getCell(j);
                iCell.setValue((Object)strHeaders[j]);
            }
        }
        for (int g = 0; g < 7; ++g) {
            iRow = this.tblAcctCtrl.addRow(g);
            String resName = "";
            switch (g) {
                case 0: {
                    resName = "dc";
                    break;
                }
                case 1: {
                    resName = "ChangeCurrency";
                    break;
                }
                case 2: {
                    resName = "currency";
                    break;
                }
                case 3: {
                    resName = "ac";
                    break;
                }
                case 4: {
                    resName = "acNotcie";
                    break;
                }
                case 5: {
                    resName = "Qty";
                    break;
                }
                case 6: {
                    resName = "control";
                    break;
                }
                case 7: {
                    resName = "bw";
                    break;
                }
                default: {
                    resName = "";
                }
            }
            String strName = EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)resName);
            iRow.getCell(0).setValue((Object)String.valueOf(g));
            iRow.getCell(1).setValue((Object)strName);
            iRow.getCell(2).setValue((Object)new Boolean(false));
        }
        this.tblAcctCtrl.getColumn(0).setWidth(0);
        this.tblAcctCtrl.getColumn(0).setResizeable(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeTableToAcctCtrl();
    }

    private void storeTableToAcctCtrl() {
        this.acctCtrlInfoForRef.setDc((Boolean)this.tblAcctCtrl.getRow(0).getCell(2).getValue() != false ? 1 : 0);
        this.acctCtrlInfoForRef.setIsChangeCurrency((Boolean)this.tblAcctCtrl.getRow(1).getCell(2).getValue() != false ? 1 : 0);
        this.acctCtrlInfoForRef.setCurrencyID((Boolean)this.tblAcctCtrl.getRow(2).getCell(2).getValue() != false ? 1 : 0);
        this.acctCtrlInfoForRef.setAc((Boolean)this.tblAcctCtrl.getRow(3).getCell(2).getValue() != false ? 1 : 0);
        this.acctCtrlInfoForRef.setAcNotice((Boolean)this.tblAcctCtrl.getRow(4).getCell(2).getValue() != false ? 1 : 0);
        this.acctCtrlInfoForRef.setIsQty((Boolean)this.tblAcctCtrl.getRow(5).getCell(2).getValue() != false ? 1 : 0);
        this.acctCtrlInfoForRef.setControl((Boolean)this.tblAcctCtrl.getRow(6).getCell(2).getValue() != false ? 1 : 0);
        this.acctCtrlInfoForRef.setBw(1);
    }

    @Override
    public void actionAcctCtrlSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkCompany()) {
            super.actionAcctCtrlSubmit_actionPerformed(e);
            boolean checkResult = false;
            if (this.acctCtrlInfoForRef.getId() != null) {
                checkResult = this.checkChanged();
            }
            this.storeFields();
            IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
            if (this.acctCtrlInfoForRef.getId() != null) {
                if (checkResult) {
                    acctCtrl.update((IObjectPK)new ObjectUuidPK(this.acctCtrlInfoForRef.getId()), (CoreBaseInfo)this.acctCtrlInfoForRef);
                }
            } else {
                acctCtrl.addnew((CoreBaseInfo)this.acctCtrlInfoForRef);
            }
            this.showSubmitSuccess();
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"cannotaddthis"));
        }
    }

    private boolean checkChanged() {
        boolean newValue;
        boolean checkResult = false;
        int oldValue = this.acctCtrlInfoForRef.getDc();
        if (this.isChanged(oldValue, newValue = ((Boolean)this.tblAcctCtrl.getRow(0).getCell(2).getValue()).booleanValue())) {
            checkResult = true;
            return checkResult;
        }
        oldValue = this.acctCtrlInfoForRef.getIsChangeCurrency();
        if (this.isChanged(oldValue, newValue = ((Boolean)this.tblAcctCtrl.getRow(1).getCell(2).getValue()).booleanValue())) {
            checkResult = true;
            return checkResult;
        }
        oldValue = this.acctCtrlInfoForRef.getCurrencyID();
        if (this.isChanged(oldValue, newValue = ((Boolean)this.tblAcctCtrl.getRow(2).getCell(2).getValue()).booleanValue())) {
            checkResult = true;
            return checkResult;
        }
        oldValue = this.acctCtrlInfoForRef.getAc();
        if (this.isChanged(oldValue, newValue = ((Boolean)this.tblAcctCtrl.getRow(3).getCell(2).getValue()).booleanValue())) {
            checkResult = true;
            return checkResult;
        }
        oldValue = this.acctCtrlInfoForRef.getAcNotice();
        if (this.isChanged(oldValue, newValue = ((Boolean)this.tblAcctCtrl.getRow(4).getCell(2).getValue()).booleanValue())) {
            checkResult = true;
            return checkResult;
        }
        oldValue = this.acctCtrlInfoForRef.getIsQty();
        if (this.isChanged(oldValue, newValue = ((Boolean)this.tblAcctCtrl.getRow(5).getCell(2).getValue()).booleanValue())) {
            checkResult = true;
            return checkResult;
        }
        oldValue = this.acctCtrlInfoForRef.getControl();
        if (this.isChanged(oldValue, newValue = ((Boolean)this.tblAcctCtrl.getRow(6).getCell(2).getValue()).booleanValue())) {
            checkResult = true;
            return checkResult;
        }
        return false;
    }

    private boolean isChanged(int oldValue, boolean newValue) {
        boolean isChanged = false;
        if (oldValue == 1 && !newValue) {
            isChanged = true;
            return isChanged;
        }
        if (oldValue == 0 && newValue) {
            isChanged = true;
            return isChanged;
        }
        return isChanged;
    }

    private void showSubmitSuccess() {
        String className = FrameWorkUtils.getClassAlias((CoreBaseInfo)this.acctCtrlInfoForRef);
        MsgBox.showInfo((String)(className + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK")));
    }

    public boolean destroyWindow() {
        this.tblAcctCtrl.getEditManager().editingStopped();
        if (this.checkChanged()) {
            String message = null;
            message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                try {
                    this.actionAcctCtrlSubmit_actionPerformed(null);
                }
                catch (Exception exception) {}
            } else if (result != 1) {
                return false;
            }
        }
        boolean b = super.destroyWindow();
        return b;
    }
}

