/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.batch.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.basedata.master.batch.client.IMetasLocator;
import com.kingdee.eas.basedata.master.batch.model.AbstractModelInfo;
import com.kingdee.eas.basedata.master.batch.model.EntityModelCollection;
import com.kingdee.eas.basedata.master.batch.model.EntityModelInfo;
import com.kingdee.eas.basedata.master.batch.model.ILoadMetasCommand;
import com.kingdee.eas.basedata.master.batch.model.ModelInfoFile;
import com.kingdee.eas.basedata.master.batch.model.PropertyModelInfo;
import com.kingdee.eas.basedata.master.batch.model.xml.IXMLBuilder;
import com.kingdee.eas.basedata.master.batch.model.xml.XMLBuilder;
import com.kingdee.eas.basedata.master.batch.model.xml.XMLParser;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public final class ModelFactory {
    private static ModelFactory factory = new ModelFactory();
    private static MetasPool pool = null;
    private IXMLBuilder builder = null;
    public static boolean isForcedLoad = false;

    private ModelFactory() {
    }

    public static ModelFactory getInstance() {
        return factory;
    }

    public Object getModel(String model) {
        ILoadMetasCommand md = null;
        EntityModelCollection ls = this.locator().locateEntityModelSet(model);
        if (ls != null) {
            md = ls.size() == 1 ? ls.get(0) : ls;
        }
        return md;
    }

    public IMetasLocator locator() {
        return pool.getLocator();
    }

    private void loadModel(String model) {
        Object product = null;
        if (this.load(model)) {
            product = this.builder.getProduct();
            if (product instanceof ILoadMetasCommand) {
                ((ILoadMetasCommand)product).loadMetasCommand();
            }
            if (product != null) {
                if (product instanceof EntityModelCollection) {
                    pool.putModel(model, (EntityModelCollection)product);
                } else if (product instanceof EntityModelInfo) {
                    EntityModelCollection ls = new EntityModelCollection();
                    ls.addObject((IObjectValue)((EntityModelInfo)product));
                    pool.putModel(model, ls);
                }
            }
        }
    }

    private boolean load(String model) {
        ModelInfoFile source = new ModelInfoFile(model);
        return source != null && source.open() && this.readSource(source) && source.close();
    }

    private boolean readSource(ModelInfoFile source) {
        boolean result = false;
        try {
            this.builder = new XMLBuilder();
            this.configParser().parse((InputSource)source, (DefaultHandler)new XMLParser(this.builder));
            result = this.builder.isAssembleFinished() && this.builder.getProduct() != null;
        }
        catch (Throwable e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return result;
    }

    private SAXParser configParser() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory.newSAXParser();
    }

    static {
        ModelFactory modelFactory = factory;
        modelFactory.getClass();
        pool = modelFactory.new MetasPool();
    }

    private final class MetasPool {
        private Map list = new HashMap();
        private Map modelList = new HashMap();
        private Map bosList = new HashMap();
        private IMetasLocator locator = null;

        private MetasPool() {
        }

        public void putModel(String model, EntityModelCollection models) {
            if (!this.list.containsKey(model)) {
                this.list.put(model, models);
                AbstractModelInfo info = null;
                Iterator itor = models.iterator();
                while (itor.hasNext()) {
                    info = (AbstractModelInfo)itor.next();
                    this.put(info.getBosId(), info);
                }
            }
        }

        public void removeModel(String model) {
            if (this.list.containsKey(model)) {
                EntityModelCollection models = (EntityModelCollection)this.list.get(model);
                AbstractModelInfo info = null;
                Iterator itor = models.iterator();
                while (itor.hasNext()) {
                    info = (AbstractModelInfo)itor.next();
                    this.remove(info.getBosId());
                }
                this.list.remove(model);
            }
        }

        private void put(String key, AbstractModelInfo info) {
            if (!this.modelList.containsKey(key)) {
                this.modelList.put(key, info);
                if (!this.bosList.containsKey(key)) {
                    this.bosList.put(key, info.getInfo());
                }
            }
        }

        private void remove(String key) {
            if (this.modelList.containsKey(key)) {
                this.modelList.remove(key);
                if (this.bosList.containsKey(key)) {
                    this.bosList.remove(key);
                }
            }
        }

        public IMetasLocator getLocator() {
            if (this.locator == null) {
                MetasPool metasPool = pool;
                metasPool.getClass();
                this.locator = metasPool.new ModelLocator();
            }
            return this.locator;
        }

        private final class ModelLocator
        implements IMetasLocator {
            private ModelLocator() {
            }

            @Override
            public EntityModelCollection locateEntityModelSet(String model) {
                if (!MetasPool.this.list.containsKey(model) || isForcedLoad) {
                    if (isForcedLoad) {
                        MetasPool.this.removeModel(model);
                    }
                    ModelFactory.this.loadModel(model);
                }
                return (EntityModelCollection)MetasPool.this.list.get(model);
            }

            @Override
            public EntityModelInfo locateEntityModel(String bosId) {
                return (EntityModelInfo)MetasPool.this.modelList.get(bosId);
            }

            @Override
            public EntityObjectInfo locateEntityInfo(String bosId) {
                return (EntityObjectInfo)MetasPool.this.bosList.get(bosId);
            }

            @Override
            public PropertyModelInfo locatePropertyModel(String entityId, String bosId) {
                EntityModelInfo model = this.locateEntityModel(entityId);
                PropertyModelInfo p = null;
                if (model != null && model.getProperties() != null) {
                    p = model.getProperties().get(bosId);
                }
                return p;
            }

            @Override
            public PropertyInfo locatePropertyInfo(String entityId, String bosId) {
                PropertyCollection ls;
                EntityObjectInfo entity = this.locateEntityInfo(entityId);
                PropertyInfo p = null;
                if (entity != null && (ls = entity.getProperties()) != null) {
                    p = ls.get(ls.indexOf((Object)bosId));
                }
                return p;
            }
        }
    }
}

