/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.batch.model;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.eas.basedata.master.batch.Helper;
import com.kingdee.eas.basedata.master.batch.IPropertyChecker;
import com.kingdee.eas.basedata.master.batch.app.ServerHelper;
import com.kingdee.eas.basedata.master.batch.client.ClientHelper;
import com.kingdee.eas.basedata.master.batch.model.AbstractModelInfo;
import com.kingdee.eas.basedata.master.batch.model.PropertyModelCollection;
import com.kingdee.eas.basedata.master.batch.model.PropertyModelInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Iterator;

public final class EntityModelInfo
extends AbstractModelInfo {
    private static final long serialVersionUID = 580151640404334068L;
    private IPropertyChecker checker = null;
    private transient PropertyCollection bosProperties = null;
    private transient StringBuffer updateScript = null;

    public PropertyModelCollection getActiveProperties() {
        return (PropertyModelCollection)this.get("activeProperties");
    }

    public void setActiveProperties(PropertyModelCollection item) {
        this.put("activeProperties", item);
    }

    public IPropertyChecker getChecker() {
        return this.innerChecker();
    }

    public void setChecker(String item) {
        this.put("checker", item);
        this.innerChecker();
    }

    public PropertyModelCollection getProperties() {
        return (PropertyModelCollection)this.get("properties");
    }

    public void setProperties(PropertyModelCollection item) {
        this.put("properties", item);
    }

    protected PropertyCollection getBosProperties() {
        return this.bosProperties;
    }

    public EntityObjectInfo getEntityObjectInfo() {
        return (EntityObjectInfo)this.getInfo();
    }

    @Override
    public void loadMetasCommand() {
        this.setInfo((IObjectValue)ClientHelper.loadBosEntity(this.getBosId()));
        this.bosProperties = this.getEntityObjectInfo().getInheritedNoDuplicatedPropertiesRuntime();
        this.getProperties().entityModelInfo = this;
        this.getProperties().loadMetasCommand();
    }

    private IPropertyChecker innerChecker() {
        String checkerClass;
        if (this.checker == null && (checkerClass = this.get("checker").toString()) != null && checkerClass.trim().length() != 0) {
            Object o = null;
            try {
                o = Helper.getObject(checkerClass);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (o != null && o instanceof IPropertyChecker) {
                this.checker = (IPropertyChecker)o;
            }
        }
        return this.checker;
    }

    public String toString() {
        EntityObjectInfo entity = this.getEntityObjectInfo();
        if (entity != null) {
            return entity.getAlias(SysContext.getSysContext().getOriginLocale());
        }
        return super.toString();
    }

    @Override
    public String createUpdateSQlCommand() {
        this.updateScript = new StringBuffer();
        EntityObjectInfo entity = this.getEntityObjectInfo();
        if (entity != null && entity.getTable() != null) {
            this.updateScript.append("Update ").append(entity.getTable().get("name").toString()).append(" Set ");
            PropertyModelInfo property = null;
            Iterator itor = this.getActiveProperties().iterator();
            while (itor.hasNext()) {
                property = (PropertyModelInfo)itor.next();
                if (property == null) continue;
                this.updateScript.append(property.createUpdateSQlCommand());
            }
        }
        return this.updateScript.toString();
    }

    @Override
    public void loadServerMetasCommand(Context ctx) {
        this.setInfo((IObjectValue)ServerHelper.loadBosEntity((Context)ctx, (String)this.getBosId()));
        this.bosProperties = this.getEntityObjectInfo().getInheritedNoDuplicatedPropertiesRuntime();
        this.getProperties().entityModelInfo = this;
        if (this.getActiveProperties() != null) {
            this.getActiveProperties().entityModelInfo = this;
            this.getActiveProperties().loadServerMetasCommand(ctx);
        }
        this.getProperties().loadServerMetasCommand(ctx);
    }
}

