/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionEntryCollection;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionEntryInfo;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionFactory;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionInfo;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionOperationTypeEnum;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionSchedulInfo;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionStatusEnum;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionTarCUCollection;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionTarCUInfo;
import com.kingdee.eas.basedata.master.cssp.IAutoAssignSolution;
import com.kingdee.eas.basedata.master.cssp.client.AbstractAutoAssignSolutionEditUI;
import com.kingdee.eas.basedata.master.cssp.client.CSClientUtils;
import com.kingdee.eas.basedata.master.cssp.util.AutoAssignSolutionUtil;
import com.kingdee.eas.basedata.master.util.CsspMaterialUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AutoAssignSolutionEditUI
extends AbstractAutoAssignSolutionEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoAssignSolutionEditUI.class);
    private static final ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.basedata.master.cssp.CSSPAutoAssignResource");
    private KDWorkButton btnAddSolutionRow;
    private KDWorkButton btnDeleteSolutionRow;
    KDTEditAdapter entryTableChange = null;
    protected IMetaDataPK queryQueryPK;
    protected Map oldDataValue = new HashMap();
    private AutoAssignSolutionOperationTypeEnum oldOperationType;
    KDBizPromptBox kdBizPromptBoxSourceCU = null;
    KDBizPromptBox kdBizPromptBoxTargetCU = null;
    NewCtrlF7 ctrlSourceF7 = null;
    NewCtrlF7 ctrlTargetF7 = null;
    protected CommonQueryDialog cqd;
    boolean isOk = false;
    private EASWfServiceClient workflowClient;

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.ADDNEW)) {
            IRow row = this.kdtEntries.addRow();
            row.getCell("isAssignAllCU").setValue((Object)false);
            row.getCell("isAssignAssistData").setValue((Object)false);
        }
    }

    public void onLoad() throws Exception {
        this.setInnerLoadFields(true);
        this.kdtEntries.checkParsed();
        this.getUIContext().put("InitDataObject", this.editData);
        super.onLoad();
        this.initVariables();
        if ("ADDNEW".equals(this.getOprtState())) {
            // empty if block
        }
        this.initComponentStyle();
        this.initHead();
        this.initEntry();
        this.initOldValues();
    }

    private void initOldValues() {
        if (this.oldDataValue.size() > 0) {
            this.oldDataValue.clear();
        }
        this.oldDataValue.put("number", this.editData.getNumber());
        this.oldDataValue.put("name", this.editData.getName());
        this.oldDataValue.put("operationType", this.comboOperationType.getSelectedItem());
        this.oldDataValue.put("remark", this.editData.getRemark());
        this.oldDataValue.put("processDefID", this.editData.getProcessDefID());
        AutoAssignSolutionEntryCollection editBeforeEntries = this.editData.getEntries();
        if (editBeforeEntries != null && editBeforeEntries.size() > 0) {
            AutoAssignSolutionEntryCollection oldEntries = new AutoAssignSolutionEntryCollection();
            for (int i = 0; i < editBeforeEntries.size(); ++i) {
                oldEntries.add(editBeforeEntries.get(i));
            }
            this.oldDataValue.put("oldEntries", oldEntries);
        }
    }

    private void initVariables() {
        if (this.queryQueryPK == null) {
            this.queryQueryPK = new MetaDataPK("com.kingdee.eas.basedata.master.material.app.MaterialQuery");
        }
        if (this.cqd == null) {
            this.cqd = new CommonQueryDialog();
        }
    }

    private void initComponentStyle() throws Exception {
        this.btnSave.setVisible(false);
        this.btnSchedule.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.setEnableAndDisableBtn();
    }

    private void setEnableAndDisableBtn() throws Exception {
        if (this.getOprtState().equals(OprtState.EDIT) && this.editData.getId() != null) {
            IAutoAssignSolution iAutoAssignSolution = (IAutoAssignSolution)this.getBizInterface();
            AutoAssignSolutionInfo autoAssignSolutionInfo = iAutoAssignSolution.getAutoAssignSolutionInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            if (autoAssignSolutionInfo != null && AutoAssignSolutionStatusEnum.ENABLE.equals((Object)autoAssignSolutionInfo.getStatus())) {
                this.btnCancel.setEnabled(true);
                this.btnCancelCancel.setEnabled(false);
            } else if (autoAssignSolutionInfo != null && AutoAssignSolutionStatusEnum.DISENABLE.equals((Object)autoAssignSolutionInfo.getStatus())) {
                this.btnCancel.setEnabled(false);
                this.btnCancelCancel.setEnabled(true);
            }
        }
    }

    private void initEntry() throws Exception {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            IRow row = this.kdtEntries.addRow();
            row.getCell("isAssignAllCU").setValue((Object)false);
            row.getCell("isAssignAssistData").setValue((Object)false);
        }
        this.initEntryF7();
        this.initCommonQueryDialog();
        this.initEntryListener();
    }

    private void initHead() {
        this.mltName.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        if ("ADDNEW".equals(this.getOprtState())) {
            this.comboOperationType.setSelectedIndex(0);
            this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
            this.createDatePicker.setValue((Object)new Date());
        } else {
            this.setComboOperationType();
        }
        this.oldOperationType = (AutoAssignSolutionOperationTypeEnum)((Object)this.comboOperationType.getSelectedItem());
        this.comboOperationType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AutoAssignSolutionEditUI.this.setComboOperationType();
                if (!AutoAssignSolutionEditUI.this.oldOperationType.equals(AutoAssignSolutionEditUI.this.comboOperationType.getSelectedItem()) && AutoAssignSolutionEditUI.this.kdtEntries.getRowCount() > 0) {
                    AutoAssignSolutionEditUI.this.kdtEntries.refresh();
                    IRow row = AutoAssignSolutionEditUI.this.kdtEntries.addRow();
                    row.getCell("isAssignAllCU").setValue((Object)false);
                    row.getCell("isAssignAssistData").setValue((Object)false);
                    AutoAssignSolutionEditUI.this.oldOperationType = (AutoAssignSolutionOperationTypeEnum)((Object)AutoAssignSolutionEditUI.this.comboOperationType.getSelectedItem());
                }
            }
        });
    }

    private void setComboOperationType() {
        this.queryQueryPK = AutoAssignSolutionOperationTypeEnum.CUSTOMER.equals(this.comboOperationType.getSelectedItem()) ? new MetaDataPK("com.kingdee.eas.basedata.master.cssp.app.CustomerInfoQuery") : (AutoAssignSolutionOperationTypeEnum.SUPPLIER.equals(this.comboOperationType.getSelectedItem()) ? new MetaDataPK("com.kingdee.eas.basedata.master.cssp.app.PSupplierQuery") : new MetaDataPK("com.kingdee.eas.basedata.master.material.app.MaterialQuery"));
        this.cqd.setQueryObjectPK(this.queryQueryPK);
    }

    private void initEntryF7() throws ParserException {
        if (this.kdBizPromptBoxSourceCU == null) {
            this.kdBizPromptBoxSourceCU = new KDBizPromptBox();
        }
        this.kdBizPromptBoxSourceCU.setEditFormat("$number$ $name$");
        this.kdBizPromptBoxSourceCU.setDisplayFormat("$number$ $name$");
        this.kdBizPromptBoxSourceCU.setCommitFormat("$number$;$name$");
        this.kdBizPromptBoxSourceCU.setEditable(false);
        if (this.ctrlSourceF7 == null) {
            this.ctrlSourceF7 = new NewCtrlF7((IUIObject)this);
        }
        this.ctrlSourceF7.setNeedConsiderFaultTree(true);
        this.ctrlSourceF7.setNeedAddOrgRange(false);
        NewOrgUnitFilterInfoProducer producerSource = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)this.ctrlSourceF7);
        this.kdBizPromptBoxSourceCU.setFilterInfoProducer((IFilterInfoProducer)producerSource);
        this.kdBizPromptBoxSourceCU.setSelector((KDPromptSelector)this.ctrlSourceF7);
        this.kdtEntries.getColumn("sourceCU").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kdBizPromptBoxSourceCU));
        if (this.kdBizPromptBoxTargetCU == null) {
            this.kdBizPromptBoxTargetCU = new KDBizPromptBox();
        }
        this.kdBizPromptBoxTargetCU.setEditFormat("$number$ $name$");
        this.kdBizPromptBoxTargetCU.setDisplayFormat("$number$ $name$");
        this.kdBizPromptBoxTargetCU.setCommitFormat("$number$;$name$");
        this.kdBizPromptBoxTargetCU.setEditable(true);
        if (this.ctrlTargetF7 == null) {
            this.ctrlTargetF7 = new NewCtrlF7((IUIObject)this);
        }
        this.ctrlTargetF7.setNeedAddOrgRange(false);
        this.ctrlTargetF7.setNeedConsiderFaultTree(true);
        this.ctrlTargetF7.setMultiSelect(true);
        NewOrgUnitFilterInfoProducer producerTarget = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)this.ctrlTargetF7);
        this.kdBizPromptBoxTargetCU.setFilterInfoProducer((IFilterInfoProducer)producerTarget);
        this.kdBizPromptBoxTargetCU.setSelector((KDPromptSelector)this.ctrlTargetF7);
        this.kdBizPromptBoxTargetCU.addSelectorListener((SelectorListener)new MySelectorListener());
        this.kdtEntries.getColumn("targetCU").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.kdBizPromptBoxTargetCU));
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn("targetCU").setRenderer((IBasicRender)render);
        KDTextField assignFilterRule_text = new KDTextField();
        assignFilterRule_text.setEditable(false);
        KDTDefaultCellEditor assignFilterRule_editor = new KDTDefaultCellEditor((JTextField)assignFilterRule_text);
        this.kdtEntries.getColumn("assignFilterRule").setEditor((ICellEditor)assignFilterRule_editor);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    public boolean isModify() {
        boolean flag = false;
        try {
            if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
                flag = this.isValueChange();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return flag;
    }

    private boolean isValueChange() {
        String remark;
        Object typeSelectedItem;
        String number;
        String string = number = "".equals(this.txtNumber.getText()) ? null : this.txtNumber.getText();
        if (!AutoAssignSolutionUtil.StrEquals(number, this.oldDataValue.get("number"))) {
            return true;
        }
        for (int i = 0; i < this.mltName.getSelectedObjects().length; ++i) {
            Object mltName;
            MultiLangItem multiLangItem = (MultiLangItem)this.mltName.getSelectedObjects()[i];
            Object object = mltName = "".equals(multiLangItem.getData()) ? null : multiLangItem.getData();
            if (AutoAssignSolutionUtil.StrEquals(mltName, this.oldDataValue.get("name"))) continue;
            return true;
        }
        Object object = typeSelectedItem = "".equals(this.comboOperationType.getSelectedItem()) ? null : this.comboOperationType.getSelectedItem();
        if (!AutoAssignSolutionUtil.StrEquals(typeSelectedItem, this.oldDataValue.get("operationType"))) {
            return true;
        }
        String string2 = remark = "".equals(this.txtRemark.getText()) ? null : this.txtRemark.getText();
        if (!AutoAssignSolutionUtil.StrEquals(remark, this.oldDataValue.get("remark"))) {
            return true;
        }
        AutoAssignSolutionEntryCollection oldEntries = (AutoAssignSolutionEntryCollection)((Object)this.oldDataValue.get("oldEntries"));
        if (oldEntries == null) {
            return false;
        }
        int step = this.kdtEntries.getRowCount();
        if (oldEntries.size() != step) {
            return true;
        }
        for (int i = 0; i < step; ++i) {
            AutoAssignSolutionEntryInfo oldEntryInfo = oldEntries.get(i);
            ICell sourceCUCell = this.kdtEntries.getRow(i).getCell("sourceCU");
            if (sourceCUCell == null) continue;
            CtrlUnitInfo sourceCtrlUnitInfo = (CtrlUnitInfo)sourceCUCell.getValue();
            if (sourceCtrlUnitInfo == null) {
                sourceCtrlUnitInfo = new CtrlUnitInfo();
            }
            if (sourceCtrlUnitInfo.getId().equals((Object)oldEntryInfo.getSourceCU().getId())) continue;
            return true;
        }
        return false;
    }

    private void initCommonQueryDialog() {
        this.cqd.setOwner((Component)((Object)this));
        this.cqd.setQueryObjectPK(this.queryQueryPK);
        this.cqd.setShowToolbar(true);
        this.cqd.setShowFilter(true);
        this.cqd.setShowSorter(true);
        this.cqd.setWidth(640);
        this.cqd.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.cqd.setTitle(resHelper.getString("AutoAssignMsg001"));
        this.cqd.setShowSorter(false);
    }

    public void actionCommonQuery(KDTEditEvent e) throws Exception {
        String oldOql = null;
        try {
            oldOql = this.cqd.getEntityViewInfoResult().toString();
            this.cqd.refreshTableParams();
        }
        catch (Exception ex) {
            oldOql = "";
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        ICell icell = this.kdtEntries.getCell(rowIndex, colIndex);
        if (this.cqd != null && this.editData.getEntries().get(rowIndex).getAssignFilterRule() != null) {
            try {
                BOSUuid.read((String)this.editData.getEntries().get(rowIndex).getAssignFilterRule());
                QuerySolutionInfo querySolutionInfo = QuerySolutionFactory.getRemoteInstance().getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(this.editData.getEntries().get(rowIndex).getAssignFilterRule()));
                this.cqd.setCurrentSolutionInfo(querySolutionInfo);
                icell.setValue((Object)querySolutionInfo);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (this.cqd.show()) {
            String newOql = this.cqd.getEntityViewInfoResult().toString();
            QuerySolutionInfo currentSolutionInfo = this.cqd.getCurrentSolutionInfo();
            icell.setValue((Object)currentSolutionInfo);
            this.editData.getEntries().get(rowIndex).put("solutionId", currentSolutionInfo.getId().toString());
            this.editData.getEntries().get(rowIndex).setAssignFilterRule(currentSolutionInfo.getId().toString());
            this.isOk = true;
        } else {
            this.isOk = false;
        }
    }

    protected QuerySolutionInfo getSolutionInfoById(String solutionId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)solutionId) || "null".equalsIgnoreCase(solutionId)) {
            return null;
        }
        return QuerySolutionFactory.getRemoteInstance().getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
    }

    protected List getUserSolutionList(Context ctx, String parentUIName) throws BOSException, EASBizException {
        ArrayList<QuerySolutionInfo> solutions = new ArrayList<QuerySolutionInfo>();
        try {
            EntityViewInfo viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName, false);
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
            for (int i = 0; i < solutionCol.size(); ++i) {
                QuerySolutionInfo info = solutionCol.get(i);
                solutions.add(info);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutions;
    }

    public EntityViewInfo getQuerySolutionViewInfo(Context ctx, String parentUIName, boolean isShare) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUIName));
        filter.getFilterItems().add(new FilterItemInfo("owner", (Object)ctx.getCaller().toString()));
        if (!isShare) {
            filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
        }
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getSelectorItemCollection());
        return viewInfo;
    }

    public SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    private void initEntryListener() throws Exception {
        if (this.entryTableChange != null) {
            this.kdtEntries.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
        this.entryTableChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                KDTable table = (KDTable)e.getSource();
                String colName = table.getColumnKey(e.getColIndex());
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                ICell icell = AutoAssignSolutionEditUI.this.kdtEntries.getCell(rowIndex, colIndex);
                if ("sourceCU".equals(colName) && icell.getValue() == null) {
                    MsgBox.showInfo((String)resHelper.getString("AutoAssignMsg002"));
                    return;
                }
                if ("sourceCU".equals(colName) && icell.getValue() != null) {
                    AutoAssignSolutionEditUI.this.kdtEntries.getCell(rowIndex, 2).setValue(null);
                }
                if ("targetCU".equals(colName) && icell.getValue() != null) {
                    AutoAssignSolutionEditUI.this.editData.getEntries().get(rowIndex).put("targetCU", icell.getValue());
                    AutoAssignSolutionEditUI.this.formatTargetCu(icell, colName, rowIndex);
                }
                if ("sourceCU".equals(colName) && icell.getValue() != null) {
                    AutoAssignSolutionEditUI.this.buildCtrlTargetF7FilterSql(icell, true);
                }
                if ("assignFilterRule".equals(colName)) {
                    try {
                        QuerySolutionInfo currentSolutionInfo = AutoAssignSolutionEditUI.this.cqd.getCurrentSolutionInfo();
                        if (currentSolutionInfo != null && AutoAssignSolutionEditUI.this.isOk) {
                            if (SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)currentSolutionInfo.getSolutionType())) {
                                MsgBox.showInfo((String)resHelper.getString("AutoAssignMsg003"));
                                return;
                            }
                            AutoAssignSolutionEditUI.this.editData.getEntries().get(rowIndex).put("solutionId", currentSolutionInfo.getId().toString());
                            AutoAssignSolutionEditUI.this.editData.getEntries().get(rowIndex).setAssignFilterRule(currentSolutionInfo.getId().toString());
                            icell.setValue((Object)currentSolutionInfo);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }

            public void editStarting(KDTEditEvent e) {
                KDTable table = (KDTable)e.getSource();
                String colName = table.getColumnKey(e.getColIndex());
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                if ("assignFilterRule".equals(colName)) {
                    try {
                        AutoAssignSolutionEditUI.this.actionCommonQuery(e);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if ("targetCU".equals(colName)) {
                    ICell sourceCell = AutoAssignSolutionEditUI.this.kdtEntries.getCell(rowIndex, 1);
                    AutoAssignSolutionEditUI.this.buildCtrlTargetF7FilterSql(sourceCell, false);
                }
            }

            public void editValueChanged(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                ICell icell = AutoAssignSolutionEditUI.this.kdtEntries.getCell(rowIndex, 2);
                if (colIndex == AutoAssignSolutionEditUI.this.kdtEntries.getColumnIndex("isAssignAllCU")) {
                    boolean flag = (Boolean)e.getValue();
                    if (flag) {
                        icell.setValue(null);
                        StyleAttributes styleAttributes = icell.getStyleAttributes();
                        styleAttributes.setLocked(true);
                        icell.setStyleAttributes(styleAttributes);
                    } else {
                        StyleAttributes styleAttributes = icell.getStyleAttributes();
                        styleAttributes.setLocked(false);
                        icell.setStyleAttributes(styleAttributes);
                    }
                }
            }
        };
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    private void buildCtrlTargetF7FilterSql(ICell icell, boolean isFirstFlag) {
        try {
            StringBuilder sqlBuilder = null;
            CtrlUnitInfo sourceCtrlUnitInfo = (CtrlUnitInfo)icell.getValue();
            List canBeAssignedCUs = this.getCanBeAssignedCUs(sourceCtrlUnitInfo);
            if (sourceCtrlUnitInfo.getLongNumber() != null && sourceCtrlUnitInfo.getLongNumber().contains("!")) {
                sqlBuilder = new StringBuilder("unit.number not in (");
                String[] longNumbers = sourceCtrlUnitInfo.getLongNumber().split("!");
                for (int i = 0; i < longNumbers.length && !longNumbers[i].equals(sourceCtrlUnitInfo.getNumber()); ++i) {
                    sqlBuilder.append("'");
                    sqlBuilder.append(longNumbers[i]);
                    sqlBuilder.append("'");
                    sqlBuilder.append(",");
                }
                sqlBuilder.append("'");
                sqlBuilder.append(sourceCtrlUnitInfo.getNumber());
                sqlBuilder.append("'");
                sqlBuilder.append(")");
                this.appendCanBeAssignedCus(sqlBuilder, canBeAssignedCUs);
            } else {
                sqlBuilder = new StringBuilder("unit.number not in ('" + sourceCtrlUnitInfo.getNumber() + "')");
                this.appendCanBeAssignedCus(sqlBuilder, canBeAssignedCUs);
            }
            if (!isFirstFlag) {
                this.ctrlTargetF7 = new NewCtrlF7();
                this.ctrlTargetF7.setNeedAddOrgRange(false);
                this.ctrlTargetF7.setNeedConsiderFaultTree(true);
                this.ctrlTargetF7.setMultiSelect(true);
                NewOrgUnitFilterInfoProducer producerTarget = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)this.ctrlTargetF7);
                this.kdBizPromptBoxTargetCU.setFilterInfoProducer((IFilterInfoProducer)producerTarget);
                this.kdBizPromptBoxTargetCU.setSelector((KDPromptSelector)this.ctrlTargetF7);
            }
            this.ctrlTargetF7.setOuterFilterInfo(new FilterInfo(sqlBuilder.toString()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void appendCanBeAssignedCus(StringBuilder sqlBuilder, List canBeAssignedCUs) {
        if (CsspMaterialUtils.isNotEmptyCollection(canBeAssignedCUs)) {
            sqlBuilder.append(" and unit.id in (");
            for (int i = 0; i < canBeAssignedCUs.size(); ++i) {
                sqlBuilder.append("'");
                sqlBuilder.append(canBeAssignedCUs.get(i));
                sqlBuilder.append("'");
                if (i == canBeAssignedCUs.size() - 1) break;
                sqlBuilder.append(",");
            }
            sqlBuilder.append(")");
        }
    }

    private List getCanBeAssignedCUs(CtrlUnitInfo sourceCtrlUnitInfo) throws Exception {
        IAutoAssignSolution iAutoAssignSolution = (IAutoAssignSolution)this.getBizInterface();
        BOSObjectType bosObjectType = this.getBosObjectType();
        List canBeAssignedCUs = iAutoAssignSolution.canBeAssignedCUs(bosObjectType, (IObjectPK)new ObjectUuidPK(sourceCtrlUnitInfo.getId()));
        return canBeAssignedCUs;
    }

    private BOSObjectType getBosObjectType() {
        BOSObjectType bosObjectType = null;
        if (AutoAssignSolutionOperationTypeEnum.CUSTOMER.equals(this.comboOperationType.getSelectedItem())) {
            bosObjectType = new BOSObjectType("BF0C040E");
        } else if (AutoAssignSolutionOperationTypeEnum.SUPPLIER.equals(this.comboOperationType.getSelectedItem())) {
            bosObjectType = new BOSObjectType("37C67DFC");
        } else if (AutoAssignSolutionOperationTypeEnum.MATERIAL.equals(this.comboOperationType.getSelectedItem())) {
            bosObjectType = new BOSObjectType("4409E7F0");
        }
        return bosObjectType;
    }

    public void formatTargetCu(ICell icell, String colName, int rowIndex) {
        if ("targetCU".equals(colName) && icell.getValue() != null) {
            this.editData.getEntries().get(rowIndex).put("targetCU", icell.getValue());
            if (icell.getValue() instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] orgUnitInfos = (OrgUnitInfo[])icell.getValue();
                AutoAssignSolutionTarCUCollection cuCollection = new AutoAssignSolutionTarCUCollection();
                for (int i = 0; i < orgUnitInfos.length; ++i) {
                    OrgUnitInfo org = orgUnitInfos[i];
                    CtrlUnitInfo cu = new CtrlUnitInfo();
                    cu.setId(org.getId());
                    cu.setNumber(org.getNumber());
                    cu.setName(org.getName());
                    AutoAssignSolutionTarCUInfo cuinfo = new AutoAssignSolutionTarCUInfo();
                    cuinfo.setCtrlUnit(cu);
                    cuCollection.add(cuinfo);
                }
                this.editData.getEntries().get(rowIndex).put("targetCU", (Object)cuCollection);
            } else if (icell.getValue() instanceof AutoAssignSolutionTarCUCollection) {
                AutoAssignSolutionTarCUCollection cuCollection = (AutoAssignSolutionTarCUCollection)((Object)icell.getValue());
                OrgUnitInfo[] orgUnitInfos = new OrgUnitInfo[cuCollection.size()];
                HashSet<String> orgIds = new HashSet<String>();
                for (int i = 0; i < cuCollection.size(); ++i) {
                    OrgUnitInfo org = new OrgUnitInfo();
                    org.setId(cuCollection.get(i).getCtrlUnit().getId());
                    orgIds.add(org.getId().toString());
                    orgUnitInfos[i] = org;
                }
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("name"));
                view.getSelector().add(new SelectorItemInfo("number"));
                view.getSelector().add(new SelectorItemInfo("id"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", orgIds, CompareType.INCLUDE));
                view.setFilter(filter);
                try {
                    OrgUnitCollection orgUnitCollection = FullOrgUnitFactory.getRemoteInstance().getOrgUnitCollection(view);
                    if (orgUnitCollection.size() > 0) {
                        for (int i = 0; i < orgUnitInfos.length; ++i) {
                            orgUnitInfos[i].setName(orgUnitCollection.get(i).getName());
                            orgUnitInfos[i].setNumber(orgUnitCollection.get(i).getNumber());
                        }
                    }
                }
                catch (BOSException bosException) {
                    bosException.printStackTrace();
                }
                icell.setValue((Object)orgUnitInfos);
            }
        }
    }

    private void tblEntryInfo_Changed(int rowIndex, int colIndex, KDTEditEvent e) {
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            CSClientUtils.removeLine((Component)((Object)this), this.kdtEntries);
        }
    }

    @Override
    public void actionSchedule_actionPerformed(ActionEvent e) throws Exception {
        String tempSchedule;
        String schedule = "";
        if (this.editData.getId() != null) {
            AutoAssignSolutionInfo autoAssignSolutionInfo = AutoAssignSolutionFactory.getRemoteInstance().getAutoAssignSolutionInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            schedule = autoAssignSolutionInfo.getSchedule().getContent();
        }
        boolean readonly = false;
        if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
            readonly = true;
        }
        if (!StringUtils.isEmpty((String)(tempSchedule = ProcessSchedulePlan.open((Object)((Object)this), (String)schedule, (boolean)readonly)))) {
            schedule = tempSchedule;
            if (this.editData.getSchedule() != null) {
                this.editData.getSchedule().setContent(schedule);
                if (this.editData.getSchedule().getCU() == null) {
                    this.editData.getSchedule().setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                }
            } else {
                AutoAssignSolutionSchedulInfo scheduleInfo = new AutoAssignSolutionSchedulInfo();
                scheduleInfo.setContent(schedule);
                scheduleInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                this.editData.setSchedule(scheduleInfo);
            }
        }
    }

    @Override
    public void loadFields() {
        if (this.btnAddSolutionRow == null) {
            this.btnAddSolutionRow = new KDWorkButton();
            this.actionAddRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
            this.btnAddSolutionRow = (KDWorkButton)this.solutionEntry.add((Action)((Object)this.actionAddRow));
            this.btnAddSolutionRow.setText(null);
            this.btnAddSolutionRow.setSize(new Dimension(22, 19));
            this.btnAddSolutionRow.setEnabled(true);
        }
        if (this.btnDeleteSolutionRow == null) {
            this.btnDeleteSolutionRow = new KDWorkButton();
            this.actionDelRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
            this.btnDeleteSolutionRow = (KDWorkButton)this.solutionEntry.add((Action)((Object)this.actionDelRow));
            this.btnDeleteSolutionRow.setText(null);
            this.btnDeleteSolutionRow.setSize(new Dimension(22, 19));
            this.btnDeleteSolutionRow.setEnabled(true);
        }
        super.loadFields();
        int rouCount = this.kdtEntries.getRowCount();
        if (rouCount > 0) {
            for (int i = 0; i < rouCount; ++i) {
                ICell tarCuCell = this.kdtEntries.getRow(i).getCell("targetCU");
                this.formatTargetCu(tarCuCell, "targetCU", i);
                ICell solutionCell = this.kdtEntries.getRow(i).getCell("assignFilterRule");
                if (solutionCell.getValue() == null) continue;
                try {
                    QuerySolutionInfo info = this.getSolutionInfoById((String)solutionCell.getValue());
                    if (info == null) continue;
                    if (info.getId().toString().equals(solutionCell.getValue())) {
                        solutionCell.setValue((Object)info);
                        this.editData.getEntries().get(i).put("solutionId", info.getId().toString());
                        continue;
                    }
                    if (!(solutionCell.getValue() instanceof QuerySolutionInfo) || !info.equals(solutionCell.getValue())) continue;
                    solutionCell.setValue((Object)info);
                    QuerySolutionInfo querySolutionInfo = (QuerySolutionInfo)solutionCell.getValue();
                    this.editData.getEntries().get(i).put("solutionId", info.getId().toString());
                    this.editData.getEntries().get(i).setAssignFilterRule(querySolutionInfo.getId().toString());
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void doBeforeSubmit(ActionEvent e) throws Exception {
        super.doBeforeSubmit(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        AutoAssignSolutionInfo tempEditData = this.editData;
        this.checkBeforeSubmit();
        if (this.editData.getId() == null) {
            this.editData.setStatus(AutoAssignSolutionStatusEnum.ENABLE);
        }
        super.actionSubmit_actionPerformed(e);
        this.scheduleFwEnable(tempEditData);
        if ("ADDNEW".equals(this.getOprtState()) && this.oldDataValue.size() > 0) {
            this.oldDataValue.clear();
        } else if ("EDIT".equals(this.getOprtState()) && this.oldDataValue.size() > 0) {
            this.initOldValues();
        }
    }

    private void checkBeforeSubmit() {
        int rowCount;
        int i;
        AutoAssignSolutionSchedulInfo schedule = this.editData.getSchedule();
        if (this.editData.getId() == null) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showWarning((Component)((Object)this), (String)resHelper.getString("AutoAssignMsg021"));
                SysUtil.abort();
            }
            boolean needNameFlag = true;
            for (i = 0; i < this.mltName.getSelectedObjects().length; ++i) {
                MultiLangItem multiLangItem = (MultiLangItem)this.mltName.getSelectedObjects()[i];
                if (multiLangItem.getData() == null || StringUtils.isEmpty((String)multiLangItem.getData().toString().trim())) continue;
                needNameFlag = false;
                break;
            }
            if (needNameFlag) {
                MsgBox.showWarning((Component)((Object)this), (String)resHelper.getString("AutoAssignMsg004"));
                SysUtil.abort();
            }
            if (schedule == null || StringUtils.isEmpty((String)schedule.getContent())) {
                MsgBox.showWarning((Component)((Object)this), (String)resHelper.getString("AutoAssignMsg005"));
                SysUtil.abort();
            }
        }
        if ((rowCount = this.kdtEntries.getRowCount()) < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)resHelper.getString("AutoAssignMsg006"));
            SysUtil.abort();
        }
        for (i = 0; i < rowCount; ++i) {
            ICell tarCuCell;
            ICell isAssignAllCUCell;
            ICell sourceCUCell = this.kdtEntries.getRow(i).getCell("sourceCU");
            if (sourceCUCell == null || sourceCUCell.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)AutoAssignSolutionUtil.convertStr(resHelper.getString("AutoAssignMsg007"), String.valueOf(i + 1)));
                SysUtil.abort();
            }
            if ((isAssignAllCUCell = this.kdtEntries.getRow(i).getCell("isAssignAllCU")) == null || ((Boolean)isAssignAllCUCell.getValue()).booleanValue() || (tarCuCell = this.kdtEntries.getRow(i).getCell("targetCU")) != null && tarCuCell.getValue() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)AutoAssignSolutionUtil.convertStr(resHelper.getString("AutoAssignMsg008"), String.valueOf(i + 1)));
            SysUtil.abort();
        }
    }

    private void scheduleFwEnable(AutoAssignSolutionInfo tempEditData) throws Exception {
        IAutoAssignSolution instance = AutoAssignSolutionFactory.getRemoteInstance();
        AutoAssignSolutionInfo autoAssignSolutionInfo = instance.getAutoAssignSolutionInfo("where number = '" + tempEditData.getNumber() + "'");
        if (autoAssignSolutionInfo == null) {
            return;
        }
        BOSUuid jobProcessDefID = autoAssignSolutionInfo.getProcessDefID();
        if (jobProcessDefID != null && !StringUtils.isEmpty((String)tempEditData.getSchedule().getContent())) {
            this.getWorkflowClient().updateProcessSchedule(jobProcessDefID.toString(), tempEditData.getSchedule().getContent());
            this.getWorkflowClient().setProcessDefEnable(jobProcessDefID.toString(), true);
        } else if (jobProcessDefID == null) {
            FunctionObjectInfo function = this.getAutoAssignSolutionRunTimeFunction();
            OperationCollection operCol = function.getOperation();
            OperationInfo operation = null;
            int length = operCol.size();
            for (int i = 0; i < length; ++i) {
                if (!operCol.get(i).getName().equalsIgnoreCase("execAutoAssignSolution")) continue;
                operation = operCol.get(i);
                break;
            }
            if (operation == null) {
                throw new Exception("Cannot found METHOD: execAutoAssignSolution");
            }
            HashMap<String, String> jobContext = new HashMap<String, String>();
            jobContext.put("autoAssignSolutionID", autoAssignSolutionInfo.getId().toString());
            if (tempEditData.getSchedule() == null) {
                return;
            }
            jobProcessDefID = BOSUuid.read((String)this.getWorkflowClient().createJobProcessDef("AutoAssignSolution_" + tempEditData.getNumber(), function, operation, jobContext, tempEditData.getSchedule().getContent(), SysContext.getSysContext().getLocale()));
            autoAssignSolutionInfo.setProcessDefID(jobProcessDefID);
            instance.update((IObjectPK)new ObjectUuidPK(autoAssignSolutionInfo.getId()), autoAssignSolutionInfo);
        }
    }

    private FunctionObjectInfo getAutoAssignSolutionRunTimeFunction() {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionRunTimeFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }

    private EASWfServiceClient getWorkflowClient() throws BOSException {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
            this.workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        }
        return this.workflowClient;
    }

    protected IObjectValue createNewData() {
        return new AutoAssignSolutionInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AutoAssignSolutionFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected void loadData() throws Exception {
        super.loadData();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null || this.editData.getId() == null) {
            return;
        }
        IAutoAssignSolution iAutoAssignSolution = (IAutoAssignSolution)this.getBizInterface();
        String msg = iAutoAssignSolution.batchDisable(new IObjectPK[]{new ObjectUuidPK(this.editData.getId())});
        if (!StringUtils.isEmpty((String)msg)) {
            MsgBox.showError((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setEnabled(false);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null || this.editData.getId() == null) {
            return;
        }
        IAutoAssignSolution iAutoAssignSolution = (IAutoAssignSolution)this.getBizInterface();
        String msg = iAutoAssignSolution.batchEnable(new IObjectPK[]{new ObjectUuidPK(this.editData.getId())});
        if (!StringUtils.isEmpty((String)msg)) {
            MsgBox.showError((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        this.btnCancelCancel.setEnabled(false);
        this.btnCancel.setEnabled(true);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.initOldValues();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.initOldValues();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.initOldValues();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.initOldValues();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setEnableAndDisableBtn();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    protected class MySelectorListener
    implements SelectorListener {
        protected MySelectorListener() {
        }

        public void willShow(SelectorEvent e) {
        }
    }
}

