/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.client.CustomerEditUI;
import com.kingdee.eas.basedata.master.cssp.client.CustomerTaxUI;
import com.kingdee.eas.basedata.master.cssp.client.SupplierEditUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JSpinner;

public class CSClientUtils {
    public static final int CUSTOMER_TO_SUPPLIER = 0;
    public static final int SUPPLIER_TO_CUSTOMER = 1;
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_VIEW = "VIEW";
    public static final String EASCommonResource = "com.kingdee.eas.common.EASCommonResource.";

    public static CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    public static String getUserCompanyOrgIDString() {
        CompanyOrgUnitInfo curCompany = CSClientUtils.getCurrentCompany();
        if (curCompany == null) {
            return null;
        }
        return curCompany.getId().toString();
    }

    public static IObjectPK getUserCompanyOrgPK(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        if (SysContext.getSysContext().getCurrentFIUnit() != null && SysContext.getSysContext().getCurrentFIUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        } else if (curCtrlUnitInfo.isIsCompanyOrgUnit()) {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
        if (company == null) {
            return null;
        }
        return new ObjectUuidPK(company.getId());
    }

    public static IObjectPK getUserSaleOrgPK(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        SaleOrgUnitInfo saleOrg = null;
        if (SysContext.getSysContext().getCurrentSaleUnit() != null && SysContext.getSysContext().getCurrentSaleUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            saleOrg = SysContext.getSysContext().getCurrentSaleUnit();
        } else if (curCtrlUnitInfo.isIsSaleOrgUnit()) {
            saleOrg = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
        if (saleOrg == null) {
            return null;
        }
        return new ObjectUuidPK(saleOrg.getId());
    }

    public static IObjectPK getUserPurchaseOrgPK(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        PurchaseOrgUnitInfo purOrg = null;
        if (SysContext.getSysContext().getCurrentPurchaseUnit() != null && SysContext.getSysContext().getCurrentPurchaseUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            purOrg = SysContext.getSysContext().getCurrentPurchaseUnit();
        } else if (curCtrlUnitInfo.isIsPurchaseOrgUnit()) {
            purOrg = PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
        if (purOrg == null) {
            return null;
        }
        return new ObjectUuidPK(purOrg.getId());
    }

    public static CompanyOrgUnitInfo getCurrentCompany() {
        CompanyOrgUnitInfo currentCompany = null;
        currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        return currentCompany;
    }

    public static SaleOrgUnitInfo getCurrentSaleOrg() {
        SaleOrgUnitInfo saleOrgUnit = null;
        saleOrgUnit = SysContext.getSysContext().getCurrentSaleUnit();
        return saleOrgUnit;
    }

    public static PurchaseOrgUnitInfo getCurrentPurchase() {
        PurchaseOrgUnitInfo purchaseOrgUnit = null;
        purchaseOrgUnit = SysContext.getSysContext().getCurrentPurchaseUnit();
        return purchaseOrgUnit;
    }

    public static void checkIsMaintainCU(DataBaseDInfo dataDaseDInfo, Component comp) {
        if (!dataDaseDInfo.getAdminCU().getId().equals((Object)SysContext.getSysContext().getCurrentCtrlUnit().getId())) {
            MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"maintainCU_Forbidden"));
            SysUtil.abort();
        }
    }

    public static void checkIsMaintainCU(DataBaseDInfo dataDaseDInfo, Component comp, String cuId) {
        if (!dataDaseDInfo.getAdminCU().getId().toString().equals(cuId)) {
            MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"maintainCU_Forbidden"));
            SysUtil.abort();
        }
    }

    public static void setFreezeColumn(KDTable tbl, String[] name) {
        int c = name.length;
        for (int i = 0; i < c; ++i) {
            int colIndex = tbl.getColumnIndex(name[i]) + 1;
            tbl.getViewManager().setFreezeView(0, colIndex);
        }
    }

    public static void verifyCSSPGroup(KDTable table, Component comp) throws Exception {
        CSSPGroupStandardInfo standardInfo = null;
        CSSPGroupInfo groupInfo = null;
        if (table.getRowCount() == 0 || table.getRow(0) == null) {
            MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"standardNotNull"));
            SysUtil.abort();
        }
        standardInfo = (CSSPGroupStandardInfo)table.getRow(0).getCell(0).getValue();
        groupInfo = (CSSPGroupInfo)table.getRow(0).getCell(1).getValue();
        if (standardInfo.getIsBasic().equals((Object)StandardTypeEnum.basicStandard)) {
            if (groupInfo == null) {
                MsgBox.showInfo((Component)comp, (String)(standardInfo.getName() + EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"baseGroupIsNotNull")));
                table.getEditManager().editCellAt(0, 1);
                SysUtil.abort();
            }
        } else {
            MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"baseGroupStandardNotNull"));
            SysUtil.abort();
        }
        int c = table.getRowCount();
        for (int i = 1; i < c; ++i) {
            if (!(table.getRow(i).getCell(0).getValue() instanceof CSSPGroupStandardInfo)) continue;
            standardInfo = (CSSPGroupStandardInfo)table.getRow(i).getCell(0).getValue();
            groupInfo = (CSSPGroupInfo)table.getRow(i).getCell(1).getValue();
            if (!standardInfo.getIsBasic().equals((Object)StandardTypeEnum.basicStandard) || groupInfo != null) continue;
            MsgBox.showInfo((Component)comp, (String)(standardInfo.getName() + EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"baseGroupIsNotNull")));
            table.getEditManager().editCellAt(i, 1);
            SysUtil.abort();
        }
    }

    public void _activeCellChanged(int rowIndex, KDTable table) {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        promptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierGroupQuery");
        IRow rowSupplier = table.getRow(rowIndex);
        CSSPGroupStandardInfo std = (CSSPGroupStandardInfo)rowSupplier.getCell(0).getValue();
        filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)std.getId().toString(), CompareType.EQUALS));
        view.setFilter(filterInfo);
        promptBox.setEntityViewInfo(view);
        promptBox.setEditable(true);
        promptBox.setDisplayFormat("$name$");
        promptBox.setEditFormat("$name$");
        promptBox.setCommitFormat("$number$");
        table.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public static KAClassficationInfo getDefaultAccountClass(String type, String comID, String accountTableId) throws Exception {
        String typeID = "";
        if (comID == null) {
            comID = "";
        }
        if (accountTableId == null) {
            accountTableId = "";
        }
        if (type.equals("customer")) {
            typeID = "7ac99937-00fb-2000-e000-0002c0a81345B999CA39";
        } else if (type.equals("supplier")) {
            typeID = "7ac99937-00fb-3000-e000-0002c0a81345B999CA39";
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("typelink.objectType.id", (Object)typeID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("currencyCompany.id", (Object)comID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableId.id", (Object)accountTableId, CompareType.EQUALS));
        StringBuffer sql = new StringBuffer(100);
        sql.append("select min(k.fnumber) from t_bd_kaclassfication k inner join t_bd_kaclassficationtype kt on k.ftypelink=kt.fid where ");
        sql.append(" kt.fobjecttypeid='").append(typeID).append("'");
        sql.append(" and k.fcurrencycompany='").append(comID).append("'");
        sql.append(" and k.faccounttableid='").append(accountTableId).append("'");
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)sql.toString(), CompareType.INNER));
        filterInfo.setMaskString("#0 and #1 and #2 and #3");
        evi.setFilter(filterInfo);
        KAClassficationInfo kaClassficationInfo = null;
        KAClassficationCollection collection = KAClassficationFactory.getRemoteInstance().getKAClassficationCollection(evi);
        if (collection.size() > 0) {
            kaClassficationInfo = collection.get(0);
        }
        return kaClassficationInfo;
    }

    public static KAClassficationInfo getDefaultAccountClass(String type, String comID) throws Exception {
        String typeID = "";
        if (type.equals("customer")) {
            typeID = "7ac99937-00fb-2000-e000-0002c0a81345B999CA39";
        } else if (type.equals("supplier")) {
            typeID = "7ac99937-00fb-3000-e000-0002c0a81345B999CA39";
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("typelink.objectType.id", (Object)typeID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("currencyCompany.id", (Object)comID, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        evi.setFilter(filterInfo);
        KAClassficationInfo kaClassficationInfo = null;
        KAClassficationCollection collection = KAClassficationFactory.getRemoteInstance().getKAClassficationCollection(evi);
        if (collection.size() > 0) {
            kaClassficationInfo = collection.get(0);
        }
        return kaClassficationInfo;
    }

    public static CurrencyInfo getDefaultCurrencyInfo(CompanyOrgUnitInfo orgInfo) {
        CurrencyInfo currency = null;
        if (orgInfo != null) {
            try {
                CompanyOrgUnitInfo org = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()), CSClientUtils.getSelectorByCurrency());
                currency = org.getBaseCurrency();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return currency;
    }

    private static SelectorItemCollection getSelectorByCurrency() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(""));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        return sic;
    }

    public static boolean actionCommon(boolean state) {
        if (state) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"saveCurrentPageFirst"));
            return false;
        }
        return true;
    }

    public static IObjectValue importInfoForCSSP(IObjectPK iObjectPK, int type, SelectorItemCollection collection) {
        CustomerInfo customerInfo = new CustomerInfo();
        SupplierInfo supplierInfo = new SupplierInfo();
        CSSPGroupStandardInfo standardInfo = null;
        CSSPGroupInfo groupInfo = null;
        int csspType = 0;
        if (type == 0) {
            try {
                ICustomer iCustomer = CustomerFactory.getRemoteInstance();
                CustomerInfo voInfo = iCustomer.getCustomerInfo(iObjectPK, collection);
                supplierInfo.setName(voInfo.getName());
                supplierInfo.setNumber(voInfo.getNumber());
                supplierInfo.setSimpleName(voInfo.getSimpleName());
                supplierInfo.setForeignName(voInfo.getForeignName());
                supplierInfo.setMnemonicCode(voInfo.getMnemonicCode());
                supplierInfo.setIsInternalCompany(voInfo.isIsInternalCompany());
                supplierInfo.setInternalCompany(voInfo.getInternalCompany());
                supplierInfo.setBizAnalysisCode(voInfo.getBizAnalysisCode());
                supplierInfo.setIndustry(voInfo.getIndustry());
                supplierInfo.setAddress(voInfo.getAddress());
                supplierInfo.setCountry(voInfo.getCountry());
                supplierInfo.setProvince(voInfo.getProvince());
                supplierInfo.setRegion(voInfo.getRegion());
                supplierInfo.setCity(voInfo.getCity());
                supplierInfo.setTaxRegisterNo(voInfo.getTaxRegisterNo());
                supplierInfo.setBizRegisterNo(voInfo.getBizRegisterNo());
                supplierInfo.setTaxData(voInfo.getTaxData());
                supplierInfo.setTaxRate(voInfo.getTaxRate());
                supplierInfo.setArtificialPerson(voInfo.getArtificialPerson());
                supplierInfo.setBusiLicence(voInfo.getBusiLicence());
                supplierInfo.setBusiExequatur(voInfo.getBusiExequatur());
                supplierInfo.setGSPAuthentication(voInfo.getGSPAuthentication());
                supplierInfo.setBarCode(voInfo.getBarCode());
                int c = voInfo.getCustomerGroupDetails().size();
                for (int i = 0; i < c; ++i) {
                    SupplierGroupDetailInfo supplierGroupDetailInfo = new SupplierGroupDetailInfo();
                    standardInfo = voInfo.getCustomerGroupDetails().get(i).getCustomerGroupStandard();
                    groupInfo = voInfo.getCustomerGroupDetails().get(i).getCustomerGroup();
                    if (standardInfo.getType() != csspType) continue;
                    supplierGroupDetailInfo.setSupplierGroup(groupInfo);
                    supplierGroupDetailInfo.setSupplierGroupStandard(standardInfo);
                    supplierGroupDetailInfo.setSupplier(supplierInfo);
                    supplierInfo.getSupplierGroupDetails().add(supplierGroupDetailInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return supplierInfo;
        }
        try {
            ISupplier iSupplier = SupplierFactory.getRemoteInstance();
            SupplierInfo voInfo = iSupplier.getSupplierInfo(iObjectPK, collection);
            customerInfo.setName(voInfo.getName());
            customerInfo.setNumber(voInfo.getNumber());
            customerInfo.setSimpleName(voInfo.getSimpleName());
            customerInfo.setForeignName(voInfo.getForeignName());
            customerInfo.setMnemonicCode(voInfo.getMnemonicCode());
            customerInfo.setIsInternalCompany(voInfo.isIsInternalCompany());
            customerInfo.setInternalCompany(voInfo.getInternalCompany());
            customerInfo.setBizAnalysisCode(voInfo.getBizAnalysisCode());
            customerInfo.setIndustry(voInfo.getIndustry());
            customerInfo.setAddress(voInfo.getAddress());
            customerInfo.setCountry(voInfo.getCountry());
            customerInfo.setProvince(voInfo.getProvince());
            customerInfo.setRegion(voInfo.getRegion());
            customerInfo.setCity(voInfo.getCity());
            customerInfo.setTaxRegisterNo(voInfo.getTaxRegisterNo());
            customerInfo.setBizRegisterNo(voInfo.getBizRegisterNo());
            customerInfo.setTaxData(voInfo.getTaxData());
            customerInfo.setTaxRate(voInfo.getTaxRate());
            customerInfo.setArtificialPerson(voInfo.getArtificialPerson());
            customerInfo.setBusiLicence(voInfo.getBusiLicence());
            customerInfo.setBusiExequatur(voInfo.getBusiExequatur());
            customerInfo.setGSPAuthentication(voInfo.getGSPAuthentication());
            customerInfo.setBarCode(voInfo.getBarCode());
            int c = voInfo.getSupplierGroupDetails().size();
            for (int i = 0; i < c; ++i) {
                CustomerGroupDetailInfo customerGroupDetailInfo = new CustomerGroupDetailInfo();
                standardInfo = voInfo.getSupplierGroupDetails().get(i).getSupplierGroupStandard();
                groupInfo = voInfo.getSupplierGroupDetails().get(i).getSupplierGroup();
                if (standardInfo == null || standardInfo.getType() != csspType) continue;
                customerGroupDetailInfo.setCustomerGroup(groupInfo);
                customerGroupDetailInfo.setCustomerGroupStandard(standardInfo);
                customerGroupDetailInfo.setCustomer(customerInfo);
                customerInfo.getCustomerGroupDetails().add(customerGroupDetailInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return customerInfo;
    }

    public static void setSpinner(JSpinner sp, int min, int max, Object value) {
        if (value instanceof Integer) {
            int currentValue = (Integer)value;
            if (currentValue <= min) {
                sp.setValue(new Integer(min));
            }
            if (currentValue >= max) {
                sp.setValue(new Integer(max));
            }
        }
    }

    public static void showHintDupInfo(Component comp, String msg) {
        if (MsgBox.isCancel((int)MsgBox.showConfirm2((Component)comp, (String)msg))) {
            SysUtil.abort();
        }
    }

    public static void setUITitle(EditUI ui, String state, String title) {
        if (STATUS_ADDNEW.equals(state)) {
            ui.setUITitle(title + " - " + EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"addnew"));
        } else if (STATUS_EDIT.equals(state)) {
            ui.setUITitle(title + " - " + EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"edit"));
        } else if (STATUS_VIEW.equals(state)) {
            ui.setUITitle(title + " - " + EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"view"));
        }
    }

    public static void removeLine(Component comp, KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || CSClientUtils.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (CSClientUtils.confirmRemove(comp)) {
            int top = table.getSelectManager().get().getBeginRow();
            int bottom = table.getSelectManager().get().getEndRow();
            for (int i = top; i <= bottom; ++i) {
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                IObjectValue detailData = (IObjectValue)table.getRow(top).getUserObject();
                table.removeRow(top);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null || detailData == null) continue;
                collection.removeObject(detailData);
            }
        }
    }

    private static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    private static boolean confirmRemove(Component comp) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    public static void CustomerView(String customerId, Component ui) {
        if (customerId == null || customerId.equals("")) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"ID", (Object)customerId);
        try {
            IUIWindow customerViewWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.master.cssp.client.CustomerEditUI", (Map)uiContext, null, OprtState.VIEW);
            ((CustomerEditUI)customerViewWindow.getUIObject()).hideAddEditBtn();
            customerViewWindow.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void SupplierView(String supplierId, Component ui) {
        if (supplierId == null || supplierId.equals("")) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"ID", (Object)supplierId);
        try {
            IUIWindow supplierViewWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.master.cssp.client.SupplierEditUI", (Map)uiContext, null, OprtState.VIEW);
            ((SupplierEditUI)supplierViewWindow.getUIObject()).hideAddEditBtn();
            supplierViewWindow.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void logUIOperation(String key, BOSObjectType bizType) {
        String operName = EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)bizType, null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public static String[] getSelectRowFieldValue(KDTable kdtTable, String fieldname) {
        if (!CSClientUtils.isSelectRow(kdtTable)) {
            return null;
        }
        KDTSelectManager sm = kdtTable.getSelectManager();
        int blockCount = sm.size();
        int keyField = kdtTable.getColumnIndex(fieldname);
        ArrayList<String> retList = new ArrayList<String>();
        Object value = null;
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                IRow row = kdtTable.getRow(j);
                value = row.getCell(keyField).getValue();
                if (value == null || value.toString().trim().length() == 0) continue;
                String retStr = value.toString();
                retList.add(retStr);
            }
        }
        retList.trimToSize();
        if (retList.size() == 0) {
            return null;
        }
        String[] retStrs = new String[retList.size()];
        retStrs = retList.toArray(retStrs);
        return retStrs;
    }

    public static boolean isSelectRow(KDTable kdtTable) {
        KDTSelectManager sm = kdtTable.getSelectManager();
        return sm.size() > 0;
    }

    public static void removeLineWithCheckIsRefence(CustomerTaxUI comp, KDTable table, ICoreBase obj) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || CSClientUtils.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)comp), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (CSClientUtils.confirmRemove((Component)((Object)comp))) {
            int top = table.getSelectManager().get().getBeginRow();
            int bottom = table.getSelectManager().get().getEndRow();
            for (int i = top; i <= bottom; ++i) {
                BOSUuid id;
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)comp), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                IObjectValue detailData = (IObjectValue)table.getRow(top).getUserObject();
                if (detailData != null && (id = (BOSUuid)detailData.get("id")) != null) {
                    try {
                        obj.isReferenced((IObjectPK)new ObjectUuidPK(id));
                    }
                    catch (Exception e) {
                        MsgBox.showInfo((Component)((Object)comp), (String)(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"TaxIsRefence") + detailData.getString("billToCompanyName")));
                        return;
                    }
                }
                table.removeRow(top);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null || detailData == null) continue;
                collection.removeObject(detailData);
            }
        }
    }
}

