/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyData;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleData;
import com.kingdee.eas.basedata.master.cssp.CustomerTabPageEnum;
import com.kingdee.eas.basedata.master.cssp.IAssistantData;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyData;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierTabPageEnum;
import com.kingdee.eas.basedata.master.cssp.client.AbstractCSSPNoAsstDataListUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewPurchaseF7;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class CSSPNoAsstDataListUI
extends AbstractCSSPNoAsstDataListUI {
    private static final Logger logger = CoreUIObject.getLogger(CSSPNoAsstDataListUI.class);
    public static final String RESOURCE = "com.kingdee.eas.basedata.master.cssp.CSSPResource";
    private static final String CUSTOMER = "1";
    private static final String SUPPLIER = "2";
    private ActionHandler actionHandler = null;
    private static final int companyPage = 10;
    private static final int purchasePage = 20;
    private static final int salePage = 20;
    private static String type;
    protected CommonQueryDialog cqd;
    private CtrlUnitInfo curCtrlUnitInfo = null;

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        if (this.actionHandler == null) {
            this.actionHandler = new ActionHandler();
        }
        this.cmbPropertySelect.addItemListener((ItemListener)this.actionHandler);
        this.prmptBizOrgUnit.addDataChangeListener((DataChangeListener)this.actionHandler);
        this.prmptBizOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.initData();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setOrgUnitF7(KDBizPromptBox box, int page) {
        NewCompanyF7 comF7;
        box.setEnabled(true);
        box.setEditable(true);
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        if (type.equals(CUSTOMER)) {
            page = Integer.valueOf(((CustomerTabPageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue());
            switch (page) {
                case 10: {
                    comF7 = new NewCompanyF7();
                    comF7.setMultiSelect(false);
                    comF7.setIsCUFilter(true);
                    comF7.setNeedAddOrgRange(true);
                    box.setSelector((KDPromptSelector)comF7);
                    box.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
                    box.setFilterInfoProducer((IFilterInfoProducer)new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)comF7));
                    break;
                }
                case 20: {
                    NewSaleF7 saleOrgF7 = new NewSaleF7();
                    saleOrgF7.setMultiSelect(false);
                    saleOrgF7.setIsCUFilter(true);
                    saleOrgF7.setNeedAddOrgRange(true);
                    box.setSelector((KDPromptSelector)saleOrgF7);
                    box.setQueryInfo("com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery");
                    box.setFilterInfoProducer((IFilterInfoProducer)new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)saleOrgF7));
                }
            }
        }
        if (type.equals(SUPPLIER)) {
            page = Integer.valueOf(((SupplierTabPageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue());
            switch (page) {
                case 10: {
                    comF7 = new NewCompanyF7();
                    comF7.setMultiSelect(false);
                    comF7.setIsCUFilter(true);
                    comF7.setNeedAddOrgRange(true);
                    box.setSelector((KDPromptSelector)comF7);
                    box.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
                    box.setFilterInfoProducer((IFilterInfoProducer)new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)comF7));
                    break;
                }
                case 20: {
                    NewPurchaseF7 purOrgF7 = new NewPurchaseF7();
                    purOrgF7.setMultiSelect(false);
                    purOrgF7.setIsCUFilter(true);
                    purOrgF7.setNeedAddOrgRange(true);
                    box.setSelector((KDPromptSelector)purOrgF7);
                    box.setQueryInfo("com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery");
                    box.setFilterInfoProducer((IFilterInfoProducer)new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)purOrgF7));
                }
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CustomerFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void initData() {
        int page;
        type = this.getUIContext().get("viewType").toString();
        this.cmbPropertySelect.removeItemListener((ItemListener)this.actionHandler);
        if (type.equals(SUPPLIER)) {
            this.setUITitle(EASResource.getString((String)RESOURCE, (String)"SUP_NOASST_UI_TITLE"));
            this.cmbPropertySelect.addItems(SupplierTabPageEnum.getEnumList().toArray());
            page = Integer.valueOf(((SupplierTabPageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue());
            this.setOrgUnitF7(this.prmptBizOrgUnit, page);
        }
        if (type.equals(CUSTOMER)) {
            this.setUITitle(EASResource.getString((String)RESOURCE, (String)"CUS_NOASST_UI_TITLE"));
            this.cmbPropertySelect.addItems(CustomerTabPageEnum.getEnumList().toArray());
            page = Integer.valueOf(((CustomerTabPageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue());
            this.setOrgUnitF7(this.prmptBizOrgUnit, page);
        }
        this.cmbPropertySelect.addItemListener((ItemListener)this.actionHandler);
    }

    private FilterInfo getNoAsstDataFilter() {
        StringBuffer sb;
        IAssistantData curAsstData;
        FilterInfo filter = new FilterInfo();
        int page = 0;
        OrgUnitInfo org = (OrgUnitInfo)this.prmptBizOrgUnit.getValue();
        if (org == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)""));
        }
        if (type.equals(CUSTOMER)) {
            page = Integer.valueOf(((CustomerTabPageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue());
            curAsstData = this.getAssistantData(page, type);
            sb = new StringBuffer();
            sb.append(" select FCustomerID from ").append(curAsstData.getTableName());
            sb.append(" where ").append(curAsstData.getOrgFieldName()).append(" ='").append(org.getId().toString()).append("'");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.NOTINNER));
        }
        if (type.equals(SUPPLIER)) {
            page = Integer.valueOf(((SupplierTabPageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue());
            curAsstData = this.getAssistantData(page, type);
            sb = new StringBuffer();
            sb.append(" select FSupplierID from ").append(curAsstData.getTableName());
            sb.append(" where ").append(curAsstData.getOrgFieldName()).append(" ='").append(org.getId().toString()).append("'");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.NOTINNER));
        }
        return filter;
    }

    public IAssistantData getAssistantData(int page, String type) {
        if (CUSTOMER.equals(type)) {
            switch (page) {
                case 10: {
                    return CustomerCompanyData.getInstance();
                }
                case 20: {
                    return CustomerSaleData.getInstance();
                }
            }
        } else if (SUPPLIER.equals(type)) {
            switch (page) {
                case 10: {
                    return SupplierCompanyData.getInstance();
                }
                case 20: {
                    try {
                        Class<?> clz = Class.forName("com.kingdee.eas.basedata.master.cssp.SupplierPurData");
                        Method method = clz.getMethod("getInstance", null);
                        return (IAssistantData)method.invoke(null, null);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
            }
        }
        return null;
    }

    private void switchQueryAndRefreshTable() {
        String queryName = "";
        ObjectUuidPK controlUnitPK = null;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = null;
        FilterInfo filterDInfo = null;
        controlUnitPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
        if (this.prmptBizOrgUnit.getData() == null) {
            this.table.removeRows();
            return;
        }
        filter = this.getNoAsstDataFilter();
        if (type.equals(CUSTOMER)) {
            queryName = "com.kingdee.eas.basedata.master.cssp.app.CustomerNoAsstDataQuery";
            try {
                ICustomer iCustomer = CustomerFactory.getRemoteInstance();
                filterDInfo = iCustomer.getDatabaseDFilter((IObjectPK)controlUnitPK, "id", "adminCU.id");
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (type.equals(SUPPLIER)) {
            queryName = "com.kingdee.eas.basedata.master.cssp.app.SupplierNoAsstDataQuery";
            try {
                ISupplier iSupplier = SupplierFactory.getRemoteInstance();
                filterDInfo = iSupplier.getDatabaseDFilter((IObjectPK)controlUnitPK, "id", "adminCU.id");
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (filterDInfo != null && filterDInfo.getFilterItems().size() > 0) {
            try {
                filter.mergeFilter(filterDInfo, "and");
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        env.setFilter(filter);
        this.setEntityViewInfo(env);
        this.setQueryInfo(queryName);
        this.refresh();
    }

    protected void dataFilter() {
        if (this.queryInfo == null) {
            return;
        }
        Object tempViewInfo = null;
        if (this.cqd == null) {
            this.cqd = new CommonQueryDialog();
            this.cqd.setOwner((Component)((Object)this));
            this.cqd.setQueryObjectPK((IMetaDataPK)new MetaDataPK(this.queryInfo.getPackage(), this.queryInfo.getName()));
            this.cqd.setWidth(480);
            this.cqd.setParentUIClassName("CommonF7_" + this.queryInfo.getFullName());
            if (this.innerFilter != null) {
                this.cqd.setEntityViewInfo(this.innerFilter);
            }
        }
        if (this.cqd.show()) {
            this.innerFilter = this.cqd.getEntityViewInfoResult();
            this.rowSet = null;
            this.refreshData(true);
        }
    }

    class ActionHandler
    implements DataChangeListener,
    ItemListener {
        ActionHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e1) {
            if (e1.getSource() == CSSPNoAsstDataListUI.this.cmbPropertySelect) {
                int page = 0;
                if (type.equals(CSSPNoAsstDataListUI.SUPPLIER)) {
                    page = Integer.valueOf(((SupplierTabPageEnum)((Object)CSSPNoAsstDataListUI.this.cmbPropertySelect.getSelectedItem())).getValue());
                }
                if (type.equals(CSSPNoAsstDataListUI.CUSTOMER)) {
                    page = Integer.valueOf(((CustomerTabPageEnum)((Object)CSSPNoAsstDataListUI.this.cmbPropertySelect.getSelectedItem())).getValue());
                }
                CSSPNoAsstDataListUI.this.setOrgUnitF7(CSSPNoAsstDataListUI.this.prmptBizOrgUnit, page);
                CSSPNoAsstDataListUI.this.prmptBizOrgUnit.setValue(null);
            }
        }

        public void dataChanged(DataChangeEvent e2) {
            if (e2.getSource() == CSSPNoAsstDataListUI.this.prmptBizOrgUnit) {
                CSSPNoAsstDataListUI.this.switchQueryAndRefreshTable();
            }
        }
    }
}

