/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.common.BasedataSysException;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.client.AbstractCustomerGroupStandardEditUI;
import com.kingdee.eas.basedata.master.cssp.client.CSUtils;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import org.apache.log4j.Logger;

public class CustomerGroupStandardEditUI
extends AbstractCustomerGroupStandardEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomerGroupStandardEditUI.class);
    private static final int defaultType = 0;
    private static final int customerType = 1;
    private CtrlUnitInfo curCtrlUnitInfo;
    private static final String CTRL_UNIT = "CurrentCtrlUnit";
    private static final String defaultCU = "00000000-0000-0000-0000-000000000000CCE7AED4";

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
        this.ccStrategy.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTRL_UNIT);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        this.setUpTitle();
        this.initInterface();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.oprtControl();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void oprtControl() {
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.standardTypeEnum.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.VIEW) && !this.curCtrlUnitInfo.getId().toString().equals(this.editData.getCU().getId().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    private void initInterface() {
        if (!SysContext.getSysContext().getCurrentCtrlUnit().getId().toString().equals(defaultCU) && !this.getOprtState().equals(OprtState.VIEW)) {
            this.standardTypeEnum.removeItem((Object)StandardTypeEnum.basicStandard);
        }
    }

    private void setUpTitle() {
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"customerGroupStandard"));
    }

    protected void hideUnuseableButtons() {
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.hideUnuseableButtons();
        if (this.editData.getType() == 0) {
            this.kdBoxCustomer.setSelected(true);
        } else {
            this.kdBoxCustomer.setSelected(false);
        }
        this.initBaseStandard();
        super.initOldData((IObjectValue)this.editData);
    }

    private void initBaseStandard() {
        if (this.editData.getIsBasic().equals((Object)StandardTypeEnum.basicStandard) && this.editData.getType() == 0) {
            if (this.editData.getId() != null) {
                this.kdBoxIsBasic.setEnabled(CSUtils.isExistCSSPGroup(this.editData.getId().toString(), 0));
            } else {
                this.kdBoxIsBasic.setEnabled(false);
            }
        } else if (this.editData.getIsBasic().equals((Object)StandardTypeEnum.basicStandard) && this.editData.getType() == 1) {
            if (this.editData.getId() != null) {
                this.kdBoxIsBasic.setEnabled(CSUtils.isExistCSSPGroup(this.editData.getId().toString(), 1));
            } else {
                this.kdBoxIsBasic.setEnabled(false);
            }
        }
    }

    @Override
    public void storeFields() {
        if (this.kdBoxCustomer.isSelected()) {
            this.editData.setType(0);
        } else {
            this.editData.setType(1);
        }
        super.storeFields();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ((CSSPGroupStandardInfo)newData).setNumber(null);
        ((CSSPGroupStandardInfo)newData).setIsBasic(StandardTypeEnum.defaultStandard);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BasedataSysException baseException = null;
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().equals("")) {
            baseException = new BasedataSysException(BasedataSysException.NUMBER_IS_EMPTY);
            MsgBox.showInfo((String)baseException.getMessage());
            SysUtil.abort();
        }
        if (AssistantClientUtils.isMultiLangBoxInputNameEmpty((KDBizMultiLangBox)this.mltName, (IObjectValue)new CSSPGroupStandardInfo(), (String)"name")) {
            baseException = new BasedataSysException(BasedataSysException.NAME_IS_EMPTY);
            MsgBox.showInfo((String)baseException.getMessage());
            SysUtil.abort();
        }
        if (this.mltDescription.getSelectedItem() != null && this.mltDescription.getSelectedItem().toString().length() > 255) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"msgDescription_Long"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        CSSPGroupStandardInfo vo = new CSSPGroupStandardInfo();
        vo.setType(1);
        vo.setIsBasic(StandardTypeEnum.defaultStandard);
        return vo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CSSPGroupStandardFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void showSubmitSuccess() {
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    protected void kdBoxCustomer_itemStateChanged(ItemEvent e) throws Exception {
    }

    @Override
    protected void kdBoxIsBasic_itemStateChanged(ItemEvent e) throws Exception {
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setDataObject(this.createNewData());
        this.loadFields();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.btnRemove.setEnabled(false);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getIsBasic().equals((Object)StandardTypeEnum.basicStandard)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"msg_BaseStandard_NotDel"));
        } else {
            if (this.editData.getId() == null) {
                return;
            }
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Customergroupstd_Delete");
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Customergroupstd_AddNew");
        this.editData.setCU(this.curCtrlUnitInfo);
        super.actionCopy_actionPerformed(e);
        super.initOldData((IObjectValue)this.editData);
        this.initInterface();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Customergroupstd_AddNew");
        super.actionAddNew_actionPerformed(e);
        this.standardTypeEnum.setEnabled(true);
        this.initInterface();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Customergroupstd_Update");
        super.actionEdit_actionPerformed(e);
        this.standardTypeEnum.setEnabled(false);
        this.initInterface();
    }

    protected String getCurrentCUID() {
        String currentCUID = null;
        if (this.curCtrlUnitInfo != null) {
            currentCUID = this.curCtrlUnitInfo.getId().toString();
        }
        if (currentCUID == null) {
            currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        return currentCUID;
    }
}

