/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.client.AbstractCustomerGroupStandardListUI;
import com.kingdee.eas.basedata.master.cssp.client.CustomerGroupListUI;
import com.kingdee.eas.basedata.master.cssp.client.CustomerGroupStandardEditUI;
import com.kingdee.eas.basedata.master.cssp.client.SupplierGroupListUI;
import com.kingdee.eas.basedata.master.cssp.client.SupplierGroupStandardListUI;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CustomerGroupStandardListUI
extends AbstractCustomerGroupStandardListUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomerGroupStandardListUI.class);
    private CtrlUnitInfo curCtrlUnitInfo = null;
    private static final String CTRL_UNIT = "CurrentCtrlUnit";
    protected static final String FILTERFIELD_CUID = "CU.id";
    protected static final String FILTERFIELD_CULONGNUMBER = "CU.longNumber";

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
        this.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)CTRL_UNIT, (Object)this.curCtrlUnitInfo);
        super.prepareUIContext(uiContext, e);
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTRL_UNIT);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"customerGroupStandard"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return CustomerGroupStandardEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CSSPGroupStandardFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public static void main(String[] args) throws Exception {
        AssistantClientUtils.login();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", null);
        Object uiFactory = null;
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CustomerGroupStandardListUI.class.getName(), ctx, null, OprtState.EDIT);
        uiWindow.show();
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CustomerGroupListUI.class.getName(), ctx, null, OprtState.EDIT);
        uiWindow.show();
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SupplierGroupStandardListUI.class.getName(), ctx, null, OprtState.EDIT);
        uiWindow.show();
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SupplierGroupListUI.class.getName(), ctx, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = null;
        fi = this.getControlType() != null && !this.getControlType().equals("") ? this.getDefaultFilterForControlType() : super.getDefaultFilterForQuery();
        return fi;
    }

    public FilterInfo getDefaultFilterForControlType() {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo(FILTERFIELD_CUID, (Object)this.curCtrlUnitInfo.getId().toString()));
        CtrlUnitInfo cui = this.curCtrlUnitInfo;
        String ln = cui.getLongNumber();
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            if (i != 0) {
                sb.append("!");
            }
            sb.append(lnSecs[i]);
            lnUps.add(sb.toString());
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo(FILTERFIELD_CULONGNUMBER, lnUps, CompareType.INCLUDE));
            fi.setMaskString("#0 or #1");
        }
        return fi;
    }

    private CSSPGroupStandardInfo getCSSPGroupStandard() {
        String id = this.getSelectedKeyValue();
        CSSPGroupStandardInfo cSSPGroupStandardInfo = null;
        if (id != null) {
            try {
                ObjectStringPK pk = new ObjectStringPK(id);
                ICSSPGroupStandard iCSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
                cSSPGroupStandardInfo = iCSSPGroupStandard.getCSSPGroupStandardInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cSSPGroupStandardInfo;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Customergroupstd_AddNew");
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CSSPGroupStandardInfo standardInfo = this.getCSSPGroupStandard();
        if (standardInfo != null && !standardInfo.getCU().getId().toString().equals(this.curCtrlUnitInfo.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CannotEditStandardAtShiUnit"));
            return;
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Customergroupstd_Update");
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Customergroupstd_Delete");
        super.actionRemove_actionPerformed(e);
    }

    protected void checkPermission(String action, String cuID) throws Exception {
    }
}

