/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryParam;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.client.BDLongTimeDialog;
import com.kingdee.eas.basedata.framework.util.BDUtil;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.client.AbstractOneSupplierAssignmentUI;
import com.kingdee.eas.basedata.org.CUBDControlCollection;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class OneSupplierAssignmentUI
extends AbstractOneSupplierAssignmentUI {
    private static final Logger logger = CoreUIObject.getLogger(OneSupplierAssignmentUI.class);
    private String oldCUSearchCondition = "";
    private static final String RB_SHOW_ALL_CU = "RB_SHOWALLCU";
    private static final String RB_SHOW_DETAIL_CU = "RB_SHOWDETAILCU";
    private static final String CU_ORG_RANGE_PARAM = "AssignByOrgRange";
    private CommonQueryDialog cuCqd;
    private final Set<String> hsSelectedCUIDs = new HashSet<String>();
    private Map<String, String> hsSelectedCUNames = new HashMap<String, String>();
    BDLongTimeDialog ltd = null;
    private final HashSet<String> hsCheckedCUIDs = new HashSet();
    private CtrlUnitInfo curCtrlUnitInfo;
    private boolean isQueryAssignByOrgRangeCU = false;
    private boolean isAssignByOrgRangeCU = false;
    protected SorterItemInfo sort4CU;
    private boolean isOrderCU;
    private IRowSet rsDetailCU;
    private IRowSet rsAllCU;
    private int cuSort = 0;
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.basedata.framework.DataBaseDResources";

    public OneSupplierAssignmentUI() throws Exception {
        this.initCtrl();
    }

    public void onLoad() throws Exception {
        this.fillFilterFields();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        this.initStatus();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    protected void tblCU_doRequestRowSet(RequestRowSetEvent e) {
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        try {
            IRowSet rowSet = this.getRowSetForCUTable(start, length);
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    private void initCtrl() {
        this.btnCUQuery.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnQuery.setVisible(false);
        this.btnCUQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneSupplierAssignmentUI.this.onClickForBtnCUQuery();
            }
        });
        this.btnCUSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneSupplierAssignmentUI.this.onClickForBtnCUSearch();
            }
        });
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnCUSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneSupplierAssignmentUI.this.onClickForBtnSave();
            }
        });
        this.rbgCU.add((AbstractButton)this.rbShowAllCU);
        this.rbgCU.add((AbstractButton)this.rbShowDetailCU);
        this.rbgCU.setSelected(this.rbShowAllCU.getModel(), true);
        this.rbShowAllCU.setActionCommand(RB_SHOW_ALL_CU);
        this.rbShowDetailCU.setActionCommand(RB_SHOW_DETAIL_CU);
        this.rbShowAllCU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneSupplierAssignmentUI.this.onClickForRbShowAllCUs();
            }
        });
        this.rbShowDetailCU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneSupplierAssignmentUI.this.onClickForRbShowDetailCUs();
            }
        });
        this.btnCUAllSlt.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnCUAllClr.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnCUAllSlt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneSupplierAssignmentUI.this.onClickForBtnCUAllSel();
            }
        });
        this.btnCUAllClr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OneSupplierAssignmentUI.this.onClickForBtnCUAllClr();
            }
        });
        this.tblCU.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                OneSupplierAssignmentUI.this.onAfterDataFillForCUTable(e.getFirstRow(), e.getLastRow());
            }
        });
        this.tblCU.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                OneSupplierAssignmentUI.this.onEditValueChangedForCUTable(e);
            }
        });
        this.tblCU.getIndexColumn().getStyleAttributes().setHided(false);
        this.tblCU.getStyleAttributes().setLocked(true);
        this.tblCU.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    OneSupplierAssignmentUI.this.tblCU_tableClicked(e);
                }
                catch (Exception exc) {
                    OneSupplierAssignmentUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblCU_tableClicked(KDTMouseEvent e) {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.orderByForCUTable(e);
        }
    }

    private void orderByForCUTable(KDTMouseEvent e) {
        KDTSortManager sm = this.tblCU.getSortMange();
        if (e.getType() == 0) {
            String columnName;
            if (sm == null) {
                sm = new KDTSortManager(this.tblCU);
            }
            if ((columnName = this.tblCU.getColumn(e.getColIndex()).getFieldName()) == null) {
                return;
            }
            this.cuSort = this.cuSort == 0 ? 1 : 0;
            sm.sort(e.getColIndex(), this.cuSort);
            this.sort4CU = new SorterItemInfo();
            this.sort4CU.setPropertyName(this.tblCU.getColumn(e.getColIndex()).getFieldName());
            switch (this.cuSort) {
                case 0: {
                    this.sort4CU.setSortType(SortType.ASCEND);
                    break;
                }
                case 1: {
                    this.sort4CU.setSortType(SortType.DESCEND);
                }
            }
            this.refillCUTable();
        }
    }

    private void onClickForBtnCUQuery() {
        String oldOql;
        try {
            oldOql = this.cuCqd.getEntityViewInfoResult().toString();
        }
        catch (Exception e) {
            oldOql = "";
        }
        this.cuCqd.show();
        CommonQueryParam commonQueryParam = new CommonQueryParam();
        commonQueryParam.setEntityViewInfo(this.cuCqd.getEntityViewInfoResult());
        this.cuCqd.setCommonQueryParam(commonQueryParam);
        String newOql = this.cuCqd.getEntityViewInfoResult().toString();
        if (newOql.trim().length() <= 0 || !newOql.equals(oldOql)) {
            this.refillCUTable();
        }
    }

    private void onClickForBtnCUSearch() {
        String text = this.cuTextField.getText();
        String newCondition = "";
        if (this.cuSearchField.getSelectedItem() != null) {
            newCondition = String.valueOf(this.cuSearchField.getSelectedItem().toString()) + text;
        }
        if (!newCondition.equals(this.oldCUSearchCondition)) {
            this.oldCUSearchCondition = newCondition;
            this.refillCUTable();
        }
    }

    protected void onClickForBtnSave() {
        this.ltd = new BDLongTimeDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        this.ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() {
                try {
                    long assignBeginTime = System.currentTimeMillis();
                    boolean hasAssigned = OneSupplierAssignmentUI.this.doAssigning();
                    long assignEndTime = System.currentTimeMillis();
                    logger.info((Object)("-----DataBaseDAssignMentUI doAssigning cost:" + (assignEndTime - assignBeginTime) + "ms." + hasAssigned));
                    return hasAssigned;
                }
                catch (Exception e) {
                    OneSupplierAssignmentUI.this.setCursorOfDefault();
                    ExceptionHandler.handle((Component)((Object)OneSupplierAssignmentUI.this), (Throwable)e);
                    return false;
                }
            }

            public void afterExec(Object arg0) {
                if (arg0 instanceof Boolean && ((Boolean)arg0).booleanValue()) {
                    MsgBox.showInfo((Component)((Object)OneSupplierAssignmentUI.this), (String)OneSupplierAssignmentUI.this.getMultiLangString("assignSuccess"));
                }
            }
        });
        this.ltd.show();
    }

    private void onClickForRbShowAllCUs() {
        if (this.cuCqd.getWindow() != null) {
            this.cuCqd.getCommonFilterPanel().setDefalutFilterInfo((FilterInfo)null);
            this.cuCqd.getCommonFilterPanel().clear();
        }
        this.refillCUTable();
    }

    private void refillCUTable() {
        this.tblCU.removeRows();
        this.hsSelectedCUIDs.clear();
    }

    protected void onClickForRbShowDetailCUs() {
        if (this.cuCqd.getWindow() != null) {
            this.cuCqd.getCommonFilterPanel().setDefalutFilterInfo((FilterInfo)null);
            this.cuCqd.getCommonFilterPanel().clear();
        }
        this.refillCUTable();
    }

    protected boolean doAssigning() throws Exception {
        ArrayList<String> cuIdList = new ArrayList<String>();
        IDataBase iCtrl = this.getCtrlBizInterfaceFromUIContext();
        StringBuilder errorDetail = new StringBuilder();
        if (this.getUIContext().get("assignChosenIds") == null) {
            return false;
        }
        List dataIdList = (List)this.getUIContext().get("assignChosenIds");
        String[] cuIds = this.hsSelectedCUIDs.toArray(new String[0]);
        String[] dataIds = new String[dataIdList.size()];
        for (int i = 0; i < dataIdList.size(); ++i) {
            dataIds[i] = (String)dataIdList.get(i);
        }
        String[] array = cuIds;
        int length = cuIds.length;
        for (int k = 0; k < length; ++k) {
            String cuId = array[k];
            if (!this.rbShowDetailCU.isSelected()) continue;
            CtrlUnitInfo ctrlInfo = (CtrlUnitInfo)iCtrl.getDataBaseInfo((IObjectPK)new ObjectUuidPK(cuId));
            Map<String, String> map = this.checkGroupVisible(ctrlInfo.getLongNumber(), dataIds);
            if (!map.isEmpty()) {
                Set<String> keys = map.keySet();
                for (String key : keys) {
                    String value = map.get(key);
                    String[] str = value.split("@@@");
                    String assignFail = this.getMultiLangString("AssignError2");
                    MessageFormat mf = new MessageFormat(assignFail);
                    errorDetail.append(mf.format(new String[]{"[" + str[0] + "]", "[" + str[1] + "]"})).append("\n");
                }
                continue;
            }
            cuIdList.add(cuId);
        }
        if (!StringUtils.isEmpty((String)errorDetail.toString()) && !this.confirmAssign((Component)((Object)this), this.getMultiLangString("PartDataAssignError"), errorDetail.toString())) {
            this.hsSelectedCUIDs.clear();
            this.hsCheckedCUIDs.clear();
            this.refillCUTable();
            return false;
        }
        String[] cuarry = new String[cuIdList.toArray().length];
        for (int j = 0; j < cuIdList.toArray().length; ++j) {
            cuarry[j] = (String)cuIdList.toArray()[j];
            this.hsCheckedCUIDs.add((String)cuIdList.get(j));
        }
        if (this.rbShowDetailCU.isSelected() && cuarry.length == 0) {
            this.hsSelectedCUIDs.clear();
            this.hsCheckedCUIDs.clear();
            this.refillCUTable();
            this.setCursorOfDefault();
            MsgBox.showInfo((Component)((Object)this), (String)this.getMultiLangString("AssignError"));
            return false;
        }
        this.setCursorOfWair();
        long beginTime = System.currentTimeMillis();
        if (this.rbShowDetailCU.isSelected()) {
            this.callBatchAssign(this.getIDFromCurrentCU(), cuarry, dataIds);
            long endTime = System.currentTimeMillis();
            logger.info((Object)("-----DataBaseDAssignMentUI callBatchAssign(allClrFlagForUnassigned is true) cost:" + (endTime - beginTime) + "ms."));
        } else {
            this.callBatchAssign(this.getIDFromCurrentCU(), cuIds, dataIds);
        }
        this.setCursorOfDefault();
        return true;
    }

    private void onClickForBtnCUAllSel() {
        this.CUTableChanged(this.getSltOrUnSltCUIds(true), this.getSltOrUnSltCUNames(true), true);
    }

    private void onClickForBtnCUAllClr() {
        this.CUTableChanged(this.getSltOrUnSltCUIds(false), this.getSltOrUnSltCUNames(false), false);
    }

    private void fillFilterFields() {
        this.cuSearchField.removeAllItems();
        this.cuSearchField.addItems((Object[])this.getCUFilterFields());
    }

    protected OneAssignFilterFieldItem[] getCUFilterFields() {
        OneAssignFilterFieldItem[] ffis = new OneAssignFilterFieldItem[]{new OneAssignFilterFieldItem("number", EASResource.getString((String)RESOURCE_FULLNAME, (String)"number"), ConstDataType.STRING), new OneAssignFilterFieldItem("name", EASResource.getString((String)RESOURCE_FULLNAME, (String)"name"), ConstDataType.STRING)};
        return ffis;
    }

    private String getIDFromCurrentCU() {
        return this.curCtrlUnitInfo.getId().toString();
    }

    private void onAfterDataFillForCUTable(int r1, int r2) {
        if (this.tblCU.getRowCount() == 0) {
            return;
        }
        this.tblCU.getColumn(0).getStyleAttributes().setLocked(false);
        for (int i = r1; i <= r2; ++i) {
            this.tblCU.getCell(i, 0).setValue((Object)false);
        }
    }

    private void onEditValueChangedForCUTable(KDTEditEvent e) {
        String cuid = this.tblCU.getCell(e.getRowIndex(), "id").getValue().toString();
        String cuName = this.tblCU.getCell(e.getRowIndex(), "name").getValue().toString();
        String[] CUs = new String[]{cuid};
        String[] CUNames = new String[]{cuName};
        this.CUTableChanged(CUs, CUNames, (Boolean)e.getValue());
    }

    private void CUTableChanged(String[] CUs, String[] CUNames, boolean isSelect) {
        if (isSelect) {
            for (int i = 0; i < CUs.length; ++i) {
                this.hsSelectedCUIDs.add(CUs[i]);
                this.hsSelectedCUNames.put(String.valueOf(CUs[i]), CUNames[i]);
            }
        } else {
            for (String cUs : CUs) {
                this.hsSelectedCUIDs.remove(cUs);
                this.hsSelectedCUNames.remove(String.valueOf(cUs));
            }
        }
    }

    private String[] getSltOrUnSltCUIds(boolean isAllSlt) {
        int rowCount = this.tblCU.getRowCount();
        ArrayList<String> listCuIds = new ArrayList<String>();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblCU.getRow(i);
            if (isAllSlt && !((Boolean)row.getCell(0).getValue()).booleanValue()) {
                listCuIds.add(row.getCell("id").getValue().toString());
                continue;
            }
            if (isAllSlt || !((Boolean)row.getCell(0).getValue()).booleanValue()) continue;
            listCuIds.add(row.getCell("id").getValue().toString());
        }
        return listCuIds.toArray(new String[0]);
    }

    private String[] getSltOrUnSltCUNames(boolean isAllSlt) {
        int rowCount = this.tblCU.getRowCount();
        ArrayList<String> listCuNames = new ArrayList<String>();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblCU.getRow(i);
            if (isAllSlt && !((Boolean)row.getCell(0).getValue()).booleanValue()) {
                row.getCell(0).setValue((Object)Boolean.TRUE);
                listCuNames.add(StringUtils.cnulls((Object)row.getCell("name").getValue()));
                continue;
            }
            if (isAllSlt || !((Boolean)row.getCell(0).getValue()).booleanValue()) continue;
            row.getCell(0).setValue((Object)Boolean.FALSE);
            listCuNames.add(StringUtils.cnulls((Object)row.getCell("name").getValue()));
        }
        return listCuNames.toArray(new String[0]);
    }

    private Map<String, String> checkGroupVisible(String cuLongNumber, String[] dataBaseIds) {
        String strLocale = SysContext.getSysContext().getLocale().toString();
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder();
        String tableName = "";
        tableName = this.getQueryInfoFromUIContext().toString().contains("Customer") ? "t_bd_customer" : (this.getQueryInfoFromUIContext().toString().contains("Supplier") ? "t_bd_supplier" : "t_bd_customer");
        sql.append(" select a.fnumber,b.fname_").append(strLocale).append(",b.fid,c.flongNumber from ").append(tableName).append("  a");
        sql.append(" inner join ").append("t_bd_csspGroup").append(" b on a.FBrowseGroupID = b.fid");
        sql.append(" inner join t_org_ctrlunit c on b.fcontrolunitid = c.fid");
        sql.append(" where  charindex(c.flongnumber,'").append(cuLongNumber).append("')<=0 and a.fid in (");
        for (int j = 0; j < dataBaseIds.length; ++j) {
            sql.append("'").append(dataBaseIds[j]).append("'");
            if (j == dataBaseIds.length - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        try {
            ISQLExecutor srs = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            IRowSet rs = srs.executeSQL();
            while (rs.next()) {
                String number = rs.getString(1);
                String groupName = rs.getString(2);
                String id = rs.getString(3);
                String longNUmber = rs.getString(4);
                map.put(id, String.valueOf(number) + "@@@" + groupName + "@@@" + longNUmber);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return map;
    }

    private QueryInfo getQueryInfoFromUIContext() {
        Object o = this.getUIContext().get("QueryInfo");
        assert (o != null);
        return (QueryInfo)o;
    }

    protected IDataBase getCtrlBizInterfaceFromUIContext() {
        Object o = this.getUIContext().get("CtrlBizInterface");
        assert (o != null);
        return (IDataBase)o;
    }

    private String getMultiLangString(String key) {
        return EASResource.getString((String)RESOURCE_FULLNAME, (String)key);
    }

    protected boolean confirmAssign(Component comp, String error, String errorDetail) {
        return MsgBox.isYes((int)MsgBox.showConfirm3a((Component)comp, (String)error, (String)errorDetail));
    }

    protected void callBatchAssign(String cuId, String[] sCuIds, String[] sObjs) throws BOSException, EASBizException {
        if (this.chkIncAssignAssist.isSelected()) {
            if (this.getQueryInfoFromUIContext().toString().contains("Customer")) {
                ((ICustomer)this.getBizInterfaceFromUIContext()).batchAssign2(cuId, sObjs, sCuIds, new HashSet());
            } else {
                ((ISupplier)this.getBizInterfaceFromUIContext()).batchAssign2(cuId, sObjs, sCuIds, new HashSet());
            }
        } else {
            this.getBizInterfaceFromUIContext().batchAssign(cuId, sObjs, sCuIds);
        }
        BDUtil.memoIsAssignAsst((boolean)this.chkIncAssignAssist.isSelected());
    }

    protected IDataBaseD getBizInterfaceFromUIContext() {
        Object o = this.getUIContext().get("BizInterface");
        assert (o != null);
        return (IDataBaseD)o;
    }

    private IRowSet getRowSetForCUTable(int start, int length) throws Exception {
        IRowSet rs = this.rbgCU.getSelection().getActionCommand().equals(RB_SHOW_DETAIL_CU) ? (this.rsDetailCU = this.getRowSetForCUTableInner(start, length)) : (this.rsAllCU = this.getRowSetForCUTableInner(start, length));
        return rs;
    }

    private IRowSet getRowSetForCUTableInner(int start, int length) throws Exception {
        IQueryExecutor exec = this.getQueryExecutor(this.ctrlUnitQueryPK, this.getEntityViewInfoForCUTable());
        exec.option().isIgnoreOrder = this.isOrderCU;
        String sqlForCUTable = exec.getSQL();
        logger.info((Object)("sqlForCUTable is:" + sqlForCUTable));
        IRowSet rowSet = exec.executeQuery(start, length);
        int rowCount = exec.getRowCount();
        this.tblCU.setRowCount(rowCount);
        return rowSet;
    }

    protected EntityViewInfo getEntityViewInfoForCUTable() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        if (evi.getSorter() != null && this.sort4CU != null) {
            evi.getSorter().clear();
            evi.getSorter().add((SorterItemInfo)this.sort4CU.clone());
        }
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        FilterItemCollection fic = fi.getFilterItems();
        if (this.isDisplayCUByOrgRange()) {
            fic.add(new FilterItemInfo("id", (Object)this.getSqlOfCurrentCUOrgRange(), CompareType.INNER));
        }
        if (this.rbgCU.getSelection().getActionCommand().equals(RB_SHOW_ALL_CU)) {
            fic.add(new FilterItemInfo("longNumber", (Object)(String.valueOf(this.getLongNumberFromCurrentCU()) + "!%"), CompareType.LIKE));
        } else if (this.rbgCU.getSelection().getActionCommand().equals(RB_SHOW_DETAIL_CU)) {
            String ln = this.getLongNumberFromCurrentCU();
            String[] lnSec = ln.split("!");
            HashSet<String> upLns = new HashSet<String>();
            StringBuilder upLn = new StringBuilder();
            for (int i = 0; i < lnSec.length - 1; ++i) {
                if (i != 0) {
                    upLn.append("!");
                }
                upLn.append(lnSec[i]);
                upLns.add(new String(upLn));
            }
            upLns.add(ln);
            fic.add(new FilterItemInfo("id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.NOTEQUALS));
            fic.add(new FilterItemInfo("longNumber", upLns, CompareType.NOTINCLUDE));
            fic.add(new FilterItemInfo("longNumber", (Object)(String.valueOf(ln) + "!%"), CompareType.NOTLIKE));
        }
        Set<String> cu4NotRef = this.getCU4NotRef();
        if (cu4NotRef != null && !cu4NotRef.isEmpty()) {
            fic.add(new FilterItemInfo("id", cu4NotRef, CompareType.NOTINCLUDE));
        }
        FilterInfo fii = null;
        String cuText = this.cuTextField.getText();
        String filterField = "";
        if (this.cuSearchField.getSelectedItem() != null) {
            filterField = ((OneAssignFilterFieldItem)this.cuSearchField.getSelectedItem()).ffiName;
        }
        if (!"".equals(cuText)) {
            FilterInfo searchFilter = new FilterInfo();
            searchFilter.getFilterItems().add(new FilterItemInfo(filterField, (Object)("%" + cuText + "%"), CompareType.LIKE));
            fi.mergeFilter(searchFilter, "and");
        } else {
            if (this.cuCqd.getEntityViewInfoResult() != null) {
                fii = this.cuCqd.getEntityViewInfoResult().getFilter();
            }
            if (fii == null || fii.getFilterItems().size() == 0) {
                evi.setFilter(fi);
            } else {
                fi.mergeFilter(fii, "and");
            }
        }
        if (evi.getSorter() != null && evi.getSorter().size() > 0) {
            this.isOrderCU = true;
        }
        return evi;
    }

    private String getSqlOfCurrentCUOrgRange() {
        return "select distinct ctrl.fid from T_Org_CtrlUnit as ctrl left outer join t_pm_orgrange as range  on ctrl.fid = range.forgid where ftype =10 and range.fuserid= '" + SysContext.getSysContext().getCurrentUserInfo().getId().toString() + "'";
    }

    private String getLongNumberFromCurrentCU() {
        return this.curCtrlUnitInfo.getLongNumber();
    }

    protected Set<String> getCU4NotRef() throws BOSException {
        ICUBDControl icubdC = CUBDControlFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("DISPATCHPATTERN", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("BDBOSTYPE", (Object)"37C67DFC", CompareType.EQUALS));
        view.setFilter(filter);
        CUBDControlCollection cuBdC = icubdC.getCUBDControlCollection(view);
        Iterator iterator = cuBdC.iterator();
        HashSet<String> cuSet = new HashSet<String>();
        while (iterator.hasNext()) {
            CUBDControlInfo o = (CUBDControlInfo)iterator.next();
            if (o == null || o.getCU() == null) continue;
            cuSet.add(o.getCU().getId().toString());
        }
        return cuSet;
    }

    private boolean isDisplayCUByOrgRange() {
        if (!this.isQueryAssignByOrgRangeCU) {
            String strOrgRange = ParamHelper.getMatchType((String)"0000", (String)CU_ORG_RANGE_PARAM);
            this.isAssignByOrgRangeCU = Boolean.parseBoolean(strOrgRange);
            this.isQueryAssignByOrgRangeCU = true;
        }
        return this.isAssignByOrgRangeCU;
    }

    private void initStatus() {
        this.cuCqd = new CommonQueryDialog();
        this.cuCqd.setOwner((Component)((Object)this));
        this.cuCqd.setQueryObjectPK(this.ctrlUnitQueryPK);
        this.cuCqd.setShowToolbar(false);
        this.cuCqd.setWidth(640);
        this.cuCqd.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        this.cuCqd.setTitle(this.getMultiLangString("CUQuery"));
        this.cuCqd.setShowSorter(false);
        this.oldCUSearchCondition = this.cuSearchField.getSelectedItem() + this.cuTextField.getText();
    }

    public static class OneAssignFilterFieldItem {
        private final String ffiName;
        private final String ffiDisplayName;
        private final ConstDataType ffiCdt;

        public OneAssignFilterFieldItem(String name, String displayName, ConstDataType cdt) {
            this.ffiName = name;
            this.ffiDisplayName = displayName;
            this.ffiCdt = cdt;
        }

        public String toString() {
            return this.ffiDisplayName;
        }

        public String getName() {
            return this.ffiName;
        }

        public ConstDataType getType() {
            return this.ffiCdt;
        }
    }
}

