/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.master.cssp.AssistantDataAdaptor;
import com.kingdee.eas.basedata.master.cssp.CSSPFacadeFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPFacade;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierAssitDataEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierAttributeDataEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyData;
import com.kingdee.eas.basedata.master.cssp.client.AbstractSupplierAssignmentAssistUI;
import com.kingdee.eas.basedata.master.util.CsspMaterialUtils;
import com.kingdee.eas.common.EASBizException;
import java.awt.event.ItemEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SupplierAssignmentAssistUI
extends AbstractSupplierAssignmentAssistUI {
    private static final Logger logger = CoreUIObject.getLogger(SupplierAssignmentAssistUI.class);

    public SupplierAssignmentAssistUI() throws Exception {
        this.comboAsstDataType.addItem((Object)SupplierAttributeDataEnum.COMPANY);
        this.comboAsstDataType.addItem((Object)SupplierAttributeDataEnum.PURCHASE);
        this.comboAsstDataType.setSelectedItem((Object)SupplierAttributeDataEnum.COMPANY);
        this.curAsstData = SupplierCompanyData.getInstance();
    }

    @Override
    protected void comboAsstDataType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboAsstDataType_itemStateChanged(e);
        if (SupplierAttributeDataEnum.COMPANY == this.comboAsstDataType.getSelectedItem()) {
            this.curAsstData = SupplierCompanyData.getInstance();
        } else if (SupplierAttributeDataEnum.PURCHASE == this.comboAsstDataType.getSelectedItem()) {
            Class<?> clz = Class.forName("com.kingdee.eas.basedata.master.cssp.SupplierPurData");
            Method method = clz.getMethod("getInstance", null);
            this.curAsstData = (AssistantDataAdaptor)method.invoke(null, null);
        }
        this.refillOrgTable();
    }

    @Override
    protected FilterInfo getDataFilter() throws Exception {
        FilterInfo filter = new FilterInfo();
        List orgList = this.getSelectOrgIds();
        orgList.add(this.curCtrlUnitInfo.getId().toString());
        StringBuffer orgIdSql = this.buildOrgSql(orgList);
        if (this.btnAssigned.isSelected()) {
            StringBuffer sb = new StringBuffer();
            sb.append(" select FSupplierID from ").append(this.curAsstData.getTableName() + " as tempSupplier");
            sb.append("   where ").append(orgIdSql);
            sb.append("   group by FSupplierID having count(FSupplierID)=").append(orgList.size());
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        } else if (this.btnNotAssigned.isSelected()) {
            StringBuffer sb = new StringBuffer();
            sb.append(" select m.FSupplierID  from ").append(this.curAsstData.getTableName()).append(" as m  left outer join ");
            sb.append(" (select FSupplierID  from ").append(this.curAsstData.getTableName() + " as tempSupplier ");
            sb.append("   where ").append(orgIdSql);
            sb.append("   group by FSupplierID having count(FSupplierID)=").append(orgList.size());
            sb.append(" ) assigned on m.FSupplierID = assigned.fSupplierid ");
            sb.append(" where assigned.fSupplierid is null ");
            sb.append(" and m.FUSINGSTATUS = 0   and  m.").append(this.curAsstData.getOrgFieldName()).append(" ='").append(this.curCtrlUnitInfo.getId().toString()).append("'");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        }
        return filter;
    }

    private StringBuffer buildOrgSql(List orgList) throws Exception {
        StringBuffer orgIdSql = new StringBuffer();
        String field = this.curAsstData.getOrgFieldName();
        String tempTable = null;
        ICSSPFacade cssp = CSSPFacadeFactory.getRemoteInstance();
        tempTable = cssp.createAndFillTempTable(orgList);
        if (tempTable == null) {
            return orgIdSql.append(" 1=2 ");
        }
        orgIdSql.append(" exists (select 1 from " + tempTable + " as tempTable ");
        orgIdSql.append(" where tempTable.forgid = tempSupplier." + field + ")");
        return orgIdSql;
    }

    @Override
    protected void callBatchAssign(String cuId, String[] cuIds, String[] dataIds, boolean lastFlag, boolean firstFlag) throws BOSException, EASBizException {
        HashSet hashSet = this.getAsstDataSet();
        Map returnMap = null;
        returnMap = this.isSelectDataAll ? ((ISupplier)this.getBizImp()).batchAssignAssist(cuId, this.templateSqlAssigned, this.notSelectedDataSet, SupplierAssignmentAssistUI.asSet(cuIds), hashSet) : ((ISupplier)this.getBizImp()).batchAssignAssist(cuId, dataIds, cuIds, hashSet);
        CsspMaterialUtils.getMsg(firstFlag, returnMap, this.result, "com.kingdee.eas.basedata.master.material.MaterialResource", "supplier");
        if (lastFlag) {
            this.setUnAssignResult(this.result);
        }
    }

    @Override
    protected HashSet getAsstDataSet() {
        HashSet<SupplierAssitDataEnum> hashSet;
        if (this.cbxOtherAssitData.isSelected()) {
            hashSet = AssistantDataAdaptor.getSupplierAssitDataEnumSet();
        } else {
            hashSet = new HashSet<SupplierAssitDataEnum>();
            hashSet.add(this.curAsstData.getSupplierAssitDataEnum());
        }
        return hashSet;
    }

    @Override
    protected void callBatchUnAssign(String cuId, String[] orgIds, String[] dataIds) throws BOSException, EASBizException {
        HashSet asstDataSet = this.getAsstDataSet();
        ArrayList notSelectDataList = new ArrayList(this.notSelectedDataSet);
        String[] notSelectDataListIds = notSelectDataList.toArray(new String[notSelectDataList.size()]);
        Map result = null;
        result = this.isSelectDataAll ? ((ISupplier)this.getBizImp()).batchUnAssignAssistReturnFail(cuId, orgIds, this.templateSqlAssigned, notSelectDataListIds, asstDataSet) : ((ISupplier)this.getBizImp()).batchUnAssignAssistReturnFail(cuId, orgIds, dataIds, asstDataSet);
        this.setUnAssignResult(result);
    }

    @Override
    protected IDataBaseD getBizImp() {
        Object o = this.getUIContext().get("BizInterface");
        return (ISupplier)o;
    }

    @Override
    protected boolean isNewImp() {
        return true;
    }
}

