/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.client.AbstractSupplierAttributeUIHelper;
import com.kingdee.eas.basedata.master.cssp.client.CSClientUtils;
import com.kingdee.eas.basedata.master.cssp.client.ICSSPAttributeUIHelper;
import com.kingdee.eas.basedata.master.cssp.client.SupplierCompanyUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Map;

public class SupplierCompanyEditUIHelper
extends AbstractSupplierAttributeUIHelper {
    protected CtrlUnitInfo curCtrlUnitInfo;
    private CompanyOrgUnitInfo company;

    public SupplierCompanyEditUIHelper(ICSSPAttributeUIHelper baseUIHelper) {
        super(baseUIHelper);
        baseUIHelper.registerAttachedUIHelper(this);
    }

    private void initDefaultOrgUnit(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        if (SysContext.getSysContext().getCurrentFIUnit() != null && SysContext.getSysContext().getCurrentFIUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
        } else if (curCtrlUnitInfo.isIsCompanyOrgUnit()) {
            this.company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
    }

    @Override
    public boolean checkBeforeWindowClosing() {
        return ((SupplierCompanyUI)this.currentUI).checkBeforeWindowClosing();
    }

    @Override
    public ICoreBase getBizInterface() throws Exception {
        return SupplierCompanyInfoFactory.getRemoteInstance();
    }

    @Override
    public void necessaryFieldsVerify() {
        SupplierCompanyUI ui = (SupplierCompanyUI)this.currentUI;
        if ((CompanyOrgUnitInfo)ui.prmtCompanyOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CSCompanyOUNotExist"));
            SysUtil.abort();
        }
    }

    @Override
    public EditUI createEditUI() throws Exception {
        this.currentUI = new SupplierCompanyUI();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.currentUI.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.initDefaultOrgUnit(this.curCtrlUnitInfo);
        return this.currentUI;
    }

    @Override
    public EditUI createEditUI(Map uicontext, Map dataObjects, String operate) throws Exception {
        this.currentUI = (EditUI)UIFactoryHelper.initUIObject((String)SupplierCompanyUI.class.getName(), (Map)uicontext, (Map)dataObjects, (String)operate);
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.currentUI.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.initDefaultOrgUnit(this.curCtrlUnitInfo);
        ((SupplierCompanyUI)this.currentUI).setUiHelper(this);
        return this.currentUI;
    }

    @Override
    public IObjectValue getObjectValue(CtrlUnitInfo curCtrlUnitInfo, BOSUuid id) throws Exception {
        SupplierCompanyInfoInfo companyInfo = null;
        companyInfo = this.getDefaultCompanyInfo(curCtrlUnitInfo, id);
        if (companyInfo == null) {
            companyInfo = new SupplierCompanyInfoInfo();
        }
        return companyInfo;
    }

    protected SupplierCompanyInfoInfo getDefaultCompanyInfo(CtrlUnitInfo curCtrlUnitInfo, BOSUuid id) throws Exception {
        SupplierCompanyInfoInfo vo = null;
        if (CSClientUtils.getUserCompanyOrgPK(curCtrlUnitInfo) != null) {
            ISupplier iSupplier = (ISupplier)this.baseUIHelper.getBizInterface();
            vo = iSupplier.getCompanyInfo((IObjectPK)new ObjectUuidPK(id), CSClientUtils.getUserCompanyOrgPK(curCtrlUnitInfo), this.getSupplierCompanyInfoSelector());
        }
        return vo;
    }

    private SelectorItemCollection getSupplierCompanyInfoSelector() throws Exception {
        SelectorItemCollection selectorItems = null;
        selectorItems = this.currentUI != null ? this.currentUI.getMergedSelector() : new SupplierCompanyUI().getMergedSelector();
        return selectorItems;
    }

    @Override
    public String getClassAlise() {
        return ((SupplierCompanyUI)this.currentUI).getClassAlise();
    }

    @Override
    public boolean saveDefaultOtherInfo(SupplierInfo item, StringBuffer errStr) {
        try {
            this.initDefaultOrgUnit(item.getCU());
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        boolean isSaveSuccess = true;
        if (this.company != null) {
            SupplierCompanyInfoInfo vo = new SupplierCompanyInfoInfo();
            vo.setCompanyOrgUnit(this.company);
            vo.setSupplier(item);
            vo.setCU(this.company.getCU());
            vo.setIsFreezePayment(false);
            vo.setCreateTime(TimeStampUtility.getTime());
            vo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            vo.setLastUpdateTime(null);
            vo.setLastUpdateUser(null);
            try {
                this.checkIsOUSealUp(this.company.getId().toString(), 1);
                String accountTableId = null;
                if (this.company != null) {
                    if (this.company.getAccountTable() != null) {
                        accountTableId = this.company.getAccountTable().getId().toString();
                        String companyOrgId = this.company.getId().toString();
                        try {
                            KAClassficationInfo kaClassficationInfo = CSClientUtils.getDefaultAccountClass("supplier", companyOrgId, accountTableId);
                            vo.setAccountingClassification(kaClassficationInfo);
                        }
                        catch (PermissionServiceException e) {
                            e.printStackTrace();
                            vo.setAccountingClassification(null);
                        }
                    } else {
                        vo.setAccountingClassification(null);
                    }
                }
                vo.setSettlementCurrency(this.company.getBaseCurrency());
                this.getBizInterface().submit((CoreBaseInfo)vo);
                errStr.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
                errStr.append("\r\n\r\n,");
            }
            catch (EASBizException e) {
                isSaveSuccess = false;
                errStr.append(e.getMessage() + "  " + EASResource.getString((String)"saveFailed"));
                errStr.append("\r\n\r\n,");
            }
            catch (BOSException e) {
                isSaveSuccess = false;
                errStr.append(e.getMessage() + "  " + EASResource.getString((String)"saveFailed"));
                errStr.append("\r\n\r\n,");
            }
            catch (Exception e) {
                isSaveSuccess = false;
                errStr.append(ExceptionUtil.getExcLinkStackTrace((Throwable)e) + "  " + EASResource.getString((String)"saveFailed"));
                errStr.append("\r\n\r\n,");
            }
        } else {
            isSaveSuccess = false;
            errStr.append(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"isNotCompany"));
            errStr.append(EASResource.getString((String)"saveFailed"));
            errStr.append("\r\n\r\n,");
        }
        return isSaveSuccess;
    }

    @Override
    public boolean saveOtherInfoByCopy(SupplierInfo oldSupplierInfo, SupplierInfo item, StringBuffer errStr) {
        boolean isSaveSuccess = true;
        boolean isCompanyError = true;
        if (this.company != null) {
            SupplierCompanyInfoInfo vo = null;
            try {
                this.checkIsOUSealUp(this.company.getId().toString(), 1);
                vo = this.getDefaultCompanyInfo(this.curCtrlUnitInfo, oldSupplierInfo.getId());
                if (vo != null) {
                    vo.setSupplier(item);
                    vo.setId(null);
                    vo.setCreateTime(TimeStampUtility.getTime());
                    vo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                    vo.setLastUpdateTime(null);
                    vo.setLastUpdateUser(null);
                    SupplierCompanyBankCollection supplierBanks = vo.getSupplierBank();
                    for (int i = 0; i < supplierBanks.size(); ++i) {
                        supplierBanks.get(i).setId(null);
                    }
                    isCompanyError = false;
                } else {
                    errStr.append(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"oldCompanyInfoNull"));
                    isCompanyError = true;
                }
                if (!isCompanyError) {
                    this.getBizInterface().submit((CoreBaseInfo)vo);
                    errStr.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
                } else {
                    isSaveSuccess = false;
                    errStr.append(EASResource.getString((String)"saveFailed"));
                }
                errStr.append("\r\n\r\n,");
            }
            catch (Exception e) {
                isSaveSuccess = false;
                errStr.append(e.getMessage() + "  " + EASResource.getString((String)"saveFailed"));
                errStr.append("\r\n\r\n,");
            }
        } else {
            isSaveSuccess = false;
            errStr.append(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"isNotCompany"));
            errStr.append(EASResource.getString((String)"saveFailed"));
            errStr.append("\r\n\r\n,");
        }
        return isSaveSuccess;
    }
}

