/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fi.gl.client.ClientHelper;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.common.BasedataSysException;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupException;
import com.kingdee.eas.basedata.master.cssp.client.AbstractSupplierGroupEditUI;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class SupplierGroupEditUI
extends AbstractSupplierGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SupplierGroupEditUI.class);
    private static final String defaultType = "0";
    private static final String typeForSupplier = "2";
    private CSSPGroupInfo groupInfo = null;
    private CSSPGroupStandardInfo groupStandardInfo = null;
    private CSSPGroupInfo defaultGroupInfo = null;
    private CSSPGroupStandardInfo defaultGroupStandardInfo = null;
    private ItemListener groupStandardListener;
    private static final String defaultCU = "00000000-0000-0000-0000-000000000000CCE7AED4";
    private CtrlUnitInfo curCtrlUnitInfo;

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.prmtParent.setDisplayFormat("$number$($name$)");
        this.prmtParent.setCommitFormat("$number$");
        this.prmtParent.setEditFormat("$number$");
        super.onLoad();
        this.setUpTitle();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.comboSupplierGroupStandard.setEnabled(true);
        this.txtNumber.setMaxLength(80);
        this.mltName.setMaxLength(80);
        this.mltDescription.setMaxLength(80);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Suppliergroup_AddNew");
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Suppliergroup_Update");
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Suppliergroup_Delete");
        super.actionRemove_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setSaved(true);
        this.setOprtState(OprtState.ADDNEW);
        this.setDataObject(this.createNewData());
        this.loadFields();
    }

    private void loadGroupStandard() throws Exception {
        ICSSPGroupStandard iSupplierGroupStandard = CSSPGroupStandardFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        CSSPGroupStandardCollection stds = null;
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.getUIContext().containsKey("supplierCSSPStandard")) {
            this.defaultGroupStandardInfo = (CSSPGroupStandardInfo)this.getUIContext().get("supplierCSSPStandard");
        }
        stds = iSupplierGroupStandard.getCSSPGroupStandard(typeForSupplier, false);
        if (this.groupStandardListener == null) {
            this.groupStandardListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SupplierGroupEditUI.this.itemChanaged(e);
                }
            };
        }
        this.comboSupplierGroupStandard.removeAllItems();
        if (stds != null) {
            this.comboSupplierGroupStandard.addItems(stds.toArray());
        }
        if (this.editData.getGroupStandard() != null) {
            SupplierGroupEditUI.setSelectedById(this.comboSupplierGroupStandard, this.editData.getGroupStandard());
        }
        this.groupStandardInfo = this.editData.getGroupStandard();
    }

    protected void itemChanaged(ItemEvent e) {
        this.groupStandardInfo = (CSSPGroupStandardInfo)this.comboSupplierGroupStandard.getSelectedItem();
        this.prmtParent.setData(null);
        this.groupInfo = null;
        this.loadParentData();
    }

    private void setUpTitle() {
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"supplierGroup"));
    }

    @Override
    public void loadFields() {
        if (this.groupStandardListener != null) {
            this.comboSupplierGroupStandard.removeItemListener(this.groupStandardListener);
        }
        super.loadFields();
        ClientHelper.setComboBoxSelectByUUid((JComboBox)this.comboSupplierGroupStandard, (ObjectBaseInfo)this.editData.getGroupStandard());
        this.prmtParent.setSelectorCollection(this.getSelectors());
        this.initInterface();
        try {
            this.loadGroupStandard();
            this.loadParentData();
        }
        catch (Exception er) {
            super.handUIException((Throwable)er);
        }
        this.comboSupplierGroupStandard.addItemListener(this.groupStandardListener);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        AssistantClientUtils.setFieldsNull((IObjectValue)newData);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BasedataSysException baseException = null;
        SupplierGroupException supplierException = null;
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().equals("")) {
            baseException = new BasedataSysException(BasedataSysException.NUMBER_IS_EMPTY);
            MsgBox.showInfo((String)baseException.getMessage());
            SysUtil.abort();
        }
        if (AssistantClientUtils.isMultiLangBoxInputNameEmpty((KDBizMultiLangBox)this.mltName, (IObjectValue)new CSSPGroupInfo(), (String)"name")) {
            baseException = new BasedataSysException(BasedataSysException.NAME_IS_EMPTY);
            MsgBox.showInfo((String)baseException.getMessage());
            SysUtil.abort();
        }
        if (this.comboSupplierGroupStandard.getSelectedItem() == null) {
            supplierException = new SupplierGroupException(SupplierGroupException.SUPPLIER_GROUP_STANDARD_IS_EMPTY);
            MsgBox.showInfo((String)supplierException.getMessage());
            SysUtil.abort();
        }
        if (this.mltDescription.getSelectedItem() != null && this.mltDescription.getSelectedItem().toString().length() > 255) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"msgDescription_Long"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        CSSPGroupInfo vo = new CSSPGroupInfo();
        this.prmtParent.setData(null);
        this.defaultGroupStandardInfo = (CSSPGroupStandardInfo)this.getUIContext().get("supplierCSSPStandard");
        try {
            try {
                if (this.getUIContext().get("supplierBrowseGroup") != null && ((CSSPGroupInfo)this.getUIContext().get("supplierBrowseGroup")).getId() != null) {
                    ICSSPGroup igroup = CSSPGroupFactory.getRemoteInstance();
                    this.defaultGroupInfo = (CSSPGroupInfo)igroup.getValue("select *,groupStandard.* where id='" + ((CSSPGroupInfo)this.getUIContext().get("supplierBrowseGroup")).getId().toString() + "'");
                    this.defaultGroupStandardInfo = this.defaultGroupInfo == null ? this.defaultGroupStandardInfo : this.defaultGroupInfo.getGroupStandard();
                }
            }
            catch (ObjectNotFoundException e) {
                this.defaultGroupInfo = (CSSPGroupInfo)this.getUIContext().get("supplierBrowseGroup");
            }
            vo.setParent(this.defaultGroupInfo);
            vo.setGroupStandard(this.defaultGroupStandardInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return vo;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("groupStandard.number"));
        sic.add(new SelectorItemInfo("groupStandard.name"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        return sic;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CSSPGroupFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected void prmtParent_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW) && this.prmtParent.getData() instanceof CSSPGroupInfo) {
            CSSPGroupInfo supplierInfoVO = (CSSPGroupInfo)this.prmtParent.getData();
            CSSPGroupStandardInfo tmpStandardInfoVO = supplierInfoVO.getGroupStandard();
            SupplierGroupEditUI.setSelectedById(this.comboSupplierGroupStandard, tmpStandardInfoVO);
        }
    }

    protected void loadParentData() {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("level"));
        view.getSelector().add(new SelectorItemInfo("description"));
        view.getSelector().add(new SelectorItemInfo("groupStandard.id"));
        view.getSelector().add(new SelectorItemInfo("groupStandard.name"));
        view.getSelector().add(new SelectorItemInfo("groupStandard.number"));
        view.getSelector().add(new SelectorItemInfo("parent.number"));
        view.getSelector().add(new SelectorItemInfo("parent.name"));
        view.getSelector().add(new SelectorItemInfo("deletedStatus"));
        this.prmtParent.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.SupplierGroupQuery");
        if (this.comboSupplierGroupStandard.getSelectedItem() != null) {
            CSSPGroupStandardInfo standardInfo = (CSSPGroupStandardInfo)this.comboSupplierGroupStandard.getSelectedItem();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)standardInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)String.valueOf(2), CompareType.NOTEQUALS));
            if (this.editData.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(this.editData.getLongNumber() + "!%"), CompareType.NOTLIKE));
            }
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            try {
                filterInfo.mergeFilter(filterInfoCU, "and");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            view.setFilter(filterInfo);
        }
        if (this.groupInfo != null) {
            this.comboSupplierGroupStandard.setEnabled(false);
        } else {
            this.comboSupplierGroupStandard.setEnabled(true);
        }
        this.prmtParent.setEntityViewInfo(view);
        this.prmtParent.setFilterInfoProducer(new IFilterInfoProducer(){

            public FilterInfo getFilterInfo() {
                return null;
            }

            public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
            }

            public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
            }
        });
    }

    public static void setSelectedById(KDComboBox list, Object v) {
        if (v == null || list.getItemCount() == 0) {
            return;
        }
        String srcId = null;
        String targId = null;
        CoreBaseInfo coreObject = null;
        if (v instanceof CoreBaseInfo) {
            coreObject = (CoreBaseInfo)v;
            srcId = coreObject.getId().toString();
        } else {
            srcId = v.toString();
        }
        Object o = null;
        int count = list.getItemCount();
        for (int i = 0; i < count; ++i) {
            o = list.getItemAt(i);
            if (o == null) continue;
            if (o instanceof CoreBaseInfo) {
                coreObject = (CoreBaseInfo)o;
                targId = coreObject.getId().toString();
            } else {
                targId = o.toString();
            }
            if (!srcId.equalsIgnoreCase(targId)) continue;
            list.setSelectedIndex(i);
        }
    }

    public boolean isModify() {
        boolean isModify = false;
        if (this.getOprtState().equals("ADDNEW")) {
            if (this.txtNumber.getText().trim().length() > 0 || this.mltName.getSelectedItem() != null && this.mltName.getSelectedItem().toString().trim().length() > 0 || this.defaultGroupStandardInfo != null && !this.defaultGroupStandardInfo.getId().toString().equals(((CSSPGroupStandardInfo)this.comboSupplierGroupStandard.getSelectedItem()).getId().toString()) || this.defaultGroupInfo != null && this.groupInfo != null && !this.defaultGroupInfo.getId().toString().equals(((CSSPGroupInfo)this.prmtParent.getData()).getId().toString()) || this.mltDescription.getSelectedItem() != null && this.mltDescription.getSelectedItem().toString().trim().length() > 0) {
                isModify = true;
            }
            return isModify;
        }
        return super.isModify();
    }

    private void initInterface() {
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
    }

    protected void showSubmitSuccess() {
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    protected String getCurrentCUID() {
        if (this.curCtrlUnitInfo == null) {
            this.handUIException(new BOSException("curCtrlUnitInfo cannot be null here"));
            SysUtil.abort();
        }
        return this.curCtrlUnitInfo.getId().toString();
    }
}

