/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.cssp.client.AbstractSupplierAttributeUIHelper;
import com.kingdee.eas.basedata.master.cssp.client.CSClientUtils;
import com.kingdee.eas.basedata.master.cssp.client.ICSSPAttributeUIHelper;
import com.kingdee.eas.basedata.master.cssp.client.SupplierPurchaseUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Map;

public class SupplierPurchaseEditUIHelper
extends AbstractSupplierAttributeUIHelper {
    protected CtrlUnitInfo curCtrlUnitInfo;
    private PurchaseOrgUnitInfo purOrg;

    private void initDefaultOrgUnit(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        if (SysContext.getSysContext().getCurrentPurchaseUnit() != null && SysContext.getSysContext().getCurrentPurchaseUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            this.purOrg = SysContext.getSysContext().getCurrentPurchaseUnit();
        } else if (curCtrlUnitInfo.isIsPurchaseOrgUnit()) {
            this.purOrg = PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
    }

    public SupplierPurchaseEditUIHelper(ICSSPAttributeUIHelper baseUIHelper) {
        super(baseUIHelper);
        baseUIHelper.registerAttachedUIHelper((ICSSPAttributeUIHelper)this);
    }

    public boolean checkBeforeWindowClosing() {
        return ((SupplierPurchaseUI)this.currentUI).checkBeforeWindowClosing();
    }

    public ICoreBase getBizInterface() throws Exception {
        return SupplierPurchaseInfoFactory.getRemoteInstance();
    }

    public void necessaryFieldsVerify() {
        SupplierPurchaseUI ui = (SupplierPurchaseUI)this.currentUI;
        if (ui.prmtPurchaseOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CSCompanyOUNotExist"));
            SysUtil.abort();
        }
    }

    public EditUI createEditUI() throws Exception {
        this.currentUI = new SupplierPurchaseUI();
        return this.currentUI;
    }

    public IObjectValue getObjectValue(CtrlUnitInfo curCtrlUnitInfo, BOSUuid id) throws Exception {
        SupplierPurchaseInfoInfo purchaseInfo = null;
        purchaseInfo = this.getDefaultPurchaseInfo(curCtrlUnitInfo, id);
        if (purchaseInfo == null) {
            purchaseInfo = new SupplierPurchaseInfoInfo();
            purchaseInfo.setGrade("0");
        }
        return purchaseInfo;
    }

    public String getClassAlise() {
        return ((SupplierPurchaseUI)this.currentUI).getClassAlise();
    }

    protected SupplierPurchaseInfoInfo getDefaultPurchaseInfo(CtrlUnitInfo curCtrlUnitInfo, BOSUuid id) throws Exception {
        SupplierPurchaseInfoInfo vo = null;
        if (CSClientUtils.getUserPurchaseOrgPK((CtrlUnitInfo)curCtrlUnitInfo) != null) {
            ISupplierPurchaseInfo iSupplierPurchase = (ISupplierPurchaseInfo)this.getBizInterface();
            vo = iSupplierPurchase.getPurChaseInfo((IObjectPK)new ObjectUuidPK(id), CSClientUtils.getUserPurchaseOrgPK((CtrlUnitInfo)curCtrlUnitInfo), this.getSupplierPurchaseInfoSelector());
        }
        return vo;
    }

    protected SelectorItemCollection getSupplierPurchaseInfoSelector() throws Exception {
        SelectorItemCollection selectorItems = this.currentUI != null ? this.currentUI.getMergedSelector() : new SupplierPurchaseUI().getMergedSelector();
        return selectorItems;
    }

    public boolean saveDefaultOtherInfo(SupplierInfo item, StringBuffer errStr) {
        try {
            this.initDefaultOrgUnit(item.getCU());
        }
        catch (EASBizException e1) {
            Logger.error((Throwable)e1);
        }
        catch (BOSException e1) {
            Logger.error((Throwable)e1);
        }
        boolean isSaveSuccess = true;
        if (this.purOrg != null) {
            SupplierPurchaseInfoInfo purchaseInfo = new SupplierPurchaseInfoInfo();
            purchaseInfo.setPurchaseOrgUnit(this.purOrg);
            purchaseInfo.setDeliverOrgUnit(item);
            purchaseInfo.setBillingOrgUnit(item);
            purchaseInfo.setSupplier(item);
            purchaseInfo.setGrade("0");
            purchaseInfo.setCU(this.purOrg.getCU());
            purchaseInfo.setIsFreezeMakeOrder(false);
            purchaseInfo.setCreateTime(TimeStampUtility.getTime());
            purchaseInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            purchaseInfo.setLastUpdateTime(null);
            purchaseInfo.setLastUpdateUser(null);
            try {
                this.checkIsOUSealUp(this.purOrg.getId().toString(), 3);
                this.getBizInterface().submit((CoreBaseInfo)purchaseInfo);
                errStr.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
            }
            catch (Exception e) {
                isSaveSuccess = false;
                errStr.append(e.getMessage() + "  " + EASResource.getString((String)"saveFailed"));
            }
        } else {
            isSaveSuccess = false;
            errStr.append(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"isNotPurchase"));
            errStr.append(EASResource.getString((String)"saveFailed"));
        }
        return isSaveSuccess;
    }

    public boolean saveOtherInfoByCopy(SupplierInfo oldSupplierInfo, SupplierInfo item, StringBuffer errStr) {
        boolean isSaveSuccess;
        block8: {
            isSaveSuccess = true;
            boolean isPurchaseError = true;
            if (this.purOrg != null) {
                SupplierPurchaseInfoInfo purchaseInfo = null;
                try {
                    this.checkIsOUSealUp(this.purOrg.getId().toString(), 3);
                    purchaseInfo = this.getDefaultPurchaseInfo(this.curCtrlUnitInfo, oldSupplierInfo.getId());
                    if (purchaseInfo != null) {
                        purchaseInfo.setSupplier(item);
                        purchaseInfo.setDeliverOrgUnit(item);
                        purchaseInfo.setBillingOrgUnit(item);
                        purchaseInfo.setId(null);
                        purchaseInfo.setCreateTime(TimeStampUtility.getTime());
                        purchaseInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                        purchaseInfo.setLastUpdateTime(null);
                        purchaseInfo.setLastUpdateUser(null);
                        purchaseInfo.setCU(this.purOrg.getCU());
                        int c = purchaseInfo.getSupplierLinkMan().size();
                        for (int i = 0; i < c; ++i) {
                            purchaseInfo.getSupplierLinkMan().get(i).setSupplierPurchase(purchaseInfo);
                            purchaseInfo.getSupplierLinkMan().get(i).setId(null);
                        }
                        isPurchaseError = false;
                    } else {
                        errStr.append(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"oldPurchaseInfoNull"));
                        isPurchaseError = true;
                    }
                    if (!isPurchaseError) {
                        this.getBizInterface().submit((CoreBaseInfo)purchaseInfo);
                        errStr.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
                        break block8;
                    }
                    isSaveSuccess = false;
                    errStr.append(EASResource.getString((String)"saveFailed"));
                }
                catch (Exception e) {
                    isSaveSuccess = false;
                    errStr.append(e.getMessage() + "  " + EASResource.getString((String)"saveFailed"));
                }
            } else {
                isSaveSuccess = false;
                errStr.append(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"isNotPurchase"));
                errStr.append(EASResource.getString((String)"saveFailed"));
            }
        }
        return isSaveSuccess;
    }

    public EditUI createEditUI(Map uicontext, Map dataObjects, String operate) throws Exception {
        this.currentUI = (EditUI)UIFactoryHelper.initUIObject((String)SupplierPurchaseUI.class.getName(), (Map)uicontext, (Map)dataObjects, (String)operate);
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.currentUI.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.initDefaultOrgUnit(this.curCtrlUnitInfo);
        ((SupplierPurchaseUI)this.currentUI).setUiHelper((ICSSPAttributeUIHelper)this);
        return this.currentUI;
    }
}

