/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.mm.qm.QIBizTypeInfo;
import com.kingdee.eas.basedata.mm.qm.QISchemeCollection;
import com.kingdee.eas.basedata.mm.qm.QISchemeException;
import com.kingdee.eas.basedata.mm.qm.QISchemeFactory;
import com.kingdee.eas.basedata.mm.qm.QISchemeGroupFactory;
import com.kingdee.eas.basedata.mm.qm.QISchemeGroupInfo;
import com.kingdee.eas.basedata.mm.qm.QISchemeInfo;
import com.kingdee.eas.basedata.mm.qm.client.AbstractQISchemeListUI;
import com.kingdee.eas.basedata.mm.qm.client.DataBaseDAssignmentUIPIEX;
import com.kingdee.eas.basedata.mm.qm.client.MaterialCantNotFoundException;
import com.kingdee.eas.basedata.mm.qm.client.QISchemeGroupEditUI;
import com.kingdee.eas.basedata.mm.qm.client.qiSchemeF7Utils.HeadQISchemeF7Invoker;
import com.kingdee.eas.basedata.mm.qm.client.qiSchemeF7Utils.IQISchemeF7Invoker;
import com.kingdee.eas.basedata.mm.qm.utils.QMUtils;
import com.kingdee.eas.basedata.mm.qm.utils.STQMUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.F7Render;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.st.common.client.STCommonQueryProcessor;
import com.kingdee.eas.st.common.client.queryevent.AbstractQueryEvent;
import com.kingdee.eas.st.common.client.queryevent.QIStandardF7Event;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class QISchemeListUI
extends AbstractQISchemeListUI
implements KDPromptSelector {
    private static final Logger logger = CoreUIObject.getLogger((Class)QISchemeListUI.class);
    private IQISchemeF7Invoker invoker = null;
    private F7Render f7Delegate;
    private boolean isF7Use;
    private boolean isShowOnlyAudit = true;
    private KDTSelectBlock sb = null;
    protected STCommonQueryProcessor queryProcessor = new STCommonQueryProcessor();

    public QISchemeListUI() throws Exception {
    }

    public QISchemeListUI(HashMap ctx) throws Exception {
        this.isF7Use = true;
        this.f7Delegate = new F7Render((ListUI)this, (Map)ctx);
        this.f7Delegate.init();
    }

    public void show() {
        if (this.isF7Use) {
            this.f7Delegate.show();
        } else {
            super.show();
        }
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.separator5.setVisible(false);
        this.btnQIItemView.setEnabled(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode;
        if (this.hasChild()) {
            super.handUIExceptionAndAbort((Exception)((Object)new QISchemeException(QISchemeException.QISCHEME_GROUP_DETAIL_ERROR)));
        }
        if (null != (treeNode = this.getSelectedTreeNode())) {
            this.getUIContext().put("qiSchemeGroup", this.getSelectedNodInfo());
            super.actionAddNew_actionPerformed(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.tblMain.getSelectManager().getActiveRowIndex() >= 0) {
            ObjectUuidPK id = new ObjectUuidPK(this.getSelectedKeyValue().toString());
            QISchemeInfo info = QISchemeFactory.getRemoteInstance().getQISchemeInfo((IObjectPK)id);
            boolean isUsed = info.isIsAudit();
            if (isUsed) {
                throw new QISchemeException(QISchemeException.EDIT_QISCHEME_ISAUDIT);
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.hasInterface()) {
            super.handUIExceptionAndAbort((Exception)((Object)new QISchemeException(QISchemeException.QISCHEME_GROUP_ADD_ERROR)));
        }
        this.getUIContext().put("QISchemeGroup", this.getSelectedNodInfo());
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.size() == 0) {
            return;
        }
        QISchemeCollection imColl = this.getQISchemeCollection(ids);
        ObjectStringPK[] pks = this.getIdIsAudit(imColl, false);
        String sFNumber = this.getNumberIsAudit(imColl, true);
        String errormsg = "";
        if (pks.length > 0) {
            errormsg = QISchemeFactory.getRemoteInstance().audit((IObjectPK[])pks);
        }
        if (errormsg != null && errormsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)QMUtils.getResource("MSG_AUDIT_ERROR"), (String)errormsg, (int)8188);
        } else if (sFNumber.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)(sFNumber + QMUtils.getResource("QISCHEME_HAS_AUDIT")));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)QMUtils.getResource("QISCHEME_AUDIT_OK"));
        }
        this.refresh(e);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.size() == 0) {
            return;
        }
        QISchemeCollection imColl = this.getQISchemeCollection(ids);
        ObjectStringPK[] pks = this.getIdIsAudit(imColl, true);
        String sFNumber = this.getNumberIsAudit(imColl, false);
        QISchemeFactory.getRemoteInstance().unAudit((IObjectPK[])pks);
        if (sFNumber.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)(sFNumber + QMUtils.getResource("QISCHEME_HAS_UNAUDIT")));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)QMUtils.getResource("QISCHEME_UNAUDIT_OK"));
        }
        this.refresh(e);
    }

    public String getNumberIsAudit(QISchemeCollection imColl, boolean IsAudit) {
        StringBuffer sbNumber = new StringBuffer();
        int size = imColl.size();
        for (int i = 0; i < size; ++i) {
            QISchemeInfo info = imColl.get(i);
            if (info.isIsAudit() != IsAudit) continue;
            sbNumber.append(info.getNumber()).append("\u3001");
        }
        String sFNumber = sbNumber.toString();
        if (sFNumber.length() > 0) {
            sFNumber = sFNumber.substring(0, sFNumber.length() - 1);
        }
        return sFNumber;
    }

    public ObjectStringPK[] getIdIsAudit(QISchemeCollection imColl, boolean IsAudit) {
        ObjectStringPK[] pks;
        ObjectStringPK id = null;
        ArrayList<ObjectStringPK> pkList = new ArrayList<ObjectStringPK>();
        int size = imColl.size();
        for (int i = 0; i < size; ++i) {
            QISchemeInfo info = imColl.get(i);
            if (info.isIsAudit() != IsAudit) continue;
            id = new ObjectStringPK(info.getId().toString());
            pkList.add(id);
        }
        if (pkList.size() > 0) {
            pks = new ObjectStringPK[pkList.size()];
            pkList.toArray(pks);
        } else {
            pks = new ObjectStringPK[]{};
        }
        return pks;
    }

    public QISchemeCollection getQISchemeCollection(ArrayList pks) throws Exception {
        HashSet<String> set = new HashSet<String>();
        int size = pks.size();
        for (int i = 0; i < size; ++i) {
            set.add(pks.get(i).toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        QISchemeCollection coll = QISchemeFactory.getRemoteInstance().getQISchemeCollection(viewInfo);
        return coll;
    }

    private boolean hasChild() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (null != treeNode) {
            if (null != treeNode.getParent()) {
                QISchemeGroupInfo groupInfo = (QISchemeGroupInfo)treeNode.getUserObject();
                return this.hasChild(groupInfo.getId().toString());
            }
            return this.hasChild(null);
        }
        return false;
    }

    private boolean hasChild(String InterfaceGroupID) {
        boolean flag = false;
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            if (InterfaceGroupID != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)InterfaceGroupID, CompareType.EQUALS));
                filterInfo.setMaskString("#0");
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            flag = !QISchemeGroupFactory.getRemoteInstance().getCollection(viewInfo).isEmpty();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return flag;
    }

    private boolean hasInterface() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (null != treeNode) {
            if (null != treeNode.getParent()) {
                QISchemeGroupInfo groupInfo = (QISchemeGroupInfo)treeNode.getUserObject();
                return this.hasInterface(groupInfo.getId().toString());
            }
            return this.hasInterface(null);
        }
        return false;
    }

    private boolean hasInterface(String InterfaceGroupID) {
        boolean flag = false;
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            if (InterfaceGroupID != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("qiSchemeGroup", (Object)InterfaceGroupID, CompareType.EQUALS));
                filterInfo.setMaskString("#0");
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("qiSchemeGroup", null, CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            flag = !QISchemeFactory.getRemoteInstance().getCollection(viewInfo).isEmpty();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return flag;
    }

    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupView_actionPerformed(e);
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupEdit_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        boolean temp = this.isIsIncludeChild();
        this.setIsIncludeChild(true);
        super.buildTreeFilter();
        boolean flag = this.hasInterface();
        this.setIsIncludeChild(temp);
        if (flag) {
            super.handUIExceptionAndAbort((Exception)((Object)new QISchemeException(QISchemeException.CAN_NOT_REMOVETREE_THAT_HAVE_ENTRY)));
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        super.refreshList();
    }

    public void actionGroupMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupMoveTree_actionPerformed(e);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTree_actionPerformed(e);
    }

    public void actionAssignDataBaseD_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssignDataBaseD_actionPerformed(e);
    }

    public void actionReferDataBaseD_actionPerformed(ActionEvent e) throws Exception {
        super.actionReferDataBaseD_actionPerformed(e);
    }

    public void actionBathAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionBathAssign_actionPerformed(e);
    }

    public void actionUpgrade_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpgrade_actionPerformed(e);
    }

    public void actionViewAssigned_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAssigned_actionPerformed(e);
    }

    public void actionQIItemView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.tblMain.getSelectManager().getActiveRowIndex() >= 0) {
            ObjectUuidPK id = new ObjectUuidPK(this.getSelectedKeyValue().toString());
            QISchemeInfo qiSchemeInfo = QISchemeFactory.getRemoteInstance().getQISchemeInfo((IObjectPK)id, this.getSelectors());
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"qiSchemeId", (Object)id.toString());
            uiContext.put((Object)"qiSchemeInfo", (Object)qiSchemeInfo);
            IUIWindow qiItemWindow = null;
            qiItemWindow = UIFactory.createUIFactory((String)UIFactoryName.NEWWIN).create("com.kingdee.eas.basedata.mm.qm.client.QISchemeQIItemViewUI", (Map)uiContext, null, OprtState.VIEW);
            qiItemWindow.show();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QISchemeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        QISchemeInfo objectValue = new QISchemeInfo();
        return objectValue;
    }

    protected String getGroupEditUIName() {
        return QISchemeGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "qiSchemeGroup.id";
    }

    protected String getRootName() {
        return "\u8d28\u68c0\u65b9\u6848\u5206\u7c7b";
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        QISchemeInfo QISchemeInfo2 = null;
        ObjectUuidPK detail = new ObjectUuidPK(this.getSelectedKeyValue());
        try {
            QISchemeInfo2 = (QISchemeInfo)this.getBizInterface().getValue((IObjectPK)detail);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (QISchemeInfo2 == null || QISchemeInfo2.getQiSchemeGroup() == null || QISchemeInfo2.getQiSchemeGroup().getId() == null) {
            return null;
        }
        return new ObjectUuidPK(QISchemeInfo2.getQiSchemeGroup().getId());
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return QISchemeGroupFactory.getRemoteInstance();
    }

    private QISchemeGroupInfo getSelectedNodInfo() {
        QISchemeGroupInfo groupInfo = null;
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            groupInfo = (QISchemeGroupInfo)treeNode.getUserObject();
        }
        return groupInfo;
    }

    protected String getEditUIModal() {
        return UIFactoryName.EDITWIN;
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"number", "name", "simpleName", "exeStdCode.standardType", "qiBizType.name", "exeStdCode.name", "materialCode.name", "productID.name", "isAudit", "description"};
        return strMergeColKeys;
    }

    protected MetaDataPK getQueryPKFromEntity() throws Exception {
        MetaDataPK pkQuery = new MetaDataPK("com.kingdee.eas.basedata.mm.qm.app.QISchemeForAssignQuery");
        if (pkQuery == null) {
            EntityObjectInfo eoi1 = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizInterface().getType());
            String queryName = eoi1.getExtendedProperty("defaultF7Query");
            pkQuery = new MetaDataPK(queryName);
        }
        return pkQuery;
    }

    protected String getBatchAssignUIName() {
        return DataBaseDAssignmentUIPIEX.class.getName();
    }

    public FilterInfo getDefaultFilterForQuery() {
        FilterInfo mainFilter = super.getDefaultFilterForQuery();
        if (!this.isF7Use) {
            return mainFilter;
        }
        FilterInfo filter = new FilterInfo();
        if (this.isShowOnlyAudit) {
            filter.getFilterItems().add(new FilterItemInfo("isAudit", (Object)Boolean.TRUE, CompareType.EQUALS));
        }
        if (this.invoker != null) {
            try {
                HeadQISchemeF7Invoker headInvoker;
                QIBizTypeInfo qti;
                MaterialInfo material = this.invoker.getMaterial();
                if (material == null) {
                    throw new MaterialCantNotFoundException();
                }
                MaterialInfo mi = material;
                filter.getFilterItems().add(new FilterItemInfo("RelaMaterialEntry.material.id", (Object)mi.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("RelaMaterialEntry.isDisabled", (Object)"0", CompareType.EQUALS));
                if (this.invoker instanceof HeadQISchemeF7Invoker && STQMUtils.isNotNull(qti = (headInvoker = (HeadQISchemeF7Invoker)this.invoker).getQIBizType())) {
                    filter.getFilterItems().add(new FilterItemInfo("qiBizType.number", (Object)qti.getNumber(), CompareType.EQUALS));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MaterialCantNotFoundException();
            }
        }
        if (mainFilter != null && FilterUtility.hasFilterItem((FilterInfo)mainFilter)) {
            if (null != filter) {
                try {
                    mainFilter.mergeFilter(filter, "AND");
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
            }
            return mainFilter;
        }
        return filter;
    }

    public IQISchemeF7Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(IQISchemeF7Invoker invoker) {
        this.invoker = invoker;
    }

    protected boolean initDefaultFilter() {
        if (this.isF7Use) {
            return true;
        }
        return true;
    }

    protected boolean isIgnoreCUFilter() {
        if (this.isF7Use) {
            return !this.f7Delegate.isF7HasCuDefaultFilter();
        }
        return super.isIgnoreCUFilter();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor f7QueryExecutor;
        if (this.isF7Use && this.mainQueryPK.equals(queryPK) && (f7QueryExecutor = this.f7Delegate.getF7QueryExecutor(queryPK, viewInfo)) != null) {
            return f7QueryExecutor;
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        viewInfo.setIngorePreOrders(false);
        return exec;
    }

    protected void beforeExcutQuery(EntityViewInfo queryFilter) {
        super.beforeExcutQuery(queryFilter);
        if (this.isF7Use) {
            this.f7Delegate.mergeF7Filter(queryFilter);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.isF7Use) {
            this.f7Delegate.actionConfirm();
        } else {
            super.tblMain_tableClicked(e);
            if (STQMUtils.isNotNull(this.sb)) {
                this.tblMain.getSelectManager().select(this.sb);
            }
        }
    }

    public boolean isCanceled() {
        return this.f7Delegate.isF7Cancel();
    }

    public Object getData() {
        return this.f7Delegate.getF7Data();
    }

    public void setF7Use(boolean isF7Use, HashMap ctx) {
        this.isF7Use = isF7Use;
        if (isF7Use) {
            try {
                this.setPreferredSize(new Dimension(800, 600));
                if (ctx == null) {
                    ctx = new HashMap();
                }
                this.f7Delegate = new F7Render((ListUI)this, ctx);
                this.f7Delegate.init();
                this.initLayout();
            }
            catch (MaterialCantNotFoundException ex) {
                this.invoker.showErrorMsg();
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
    }

    protected String getSelectDetailTreeName() {
        return "qiSchemeGroup";
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("exeStdCode.*"));
        sic.add(new SelectorItemInfo("exeStdCode.standardType"));
        sic.add(new SelectorItemInfo("qiBizType.name"));
        sic.add(new SelectorItemInfo("exeStdCode.name"));
        sic.add(new SelectorItemInfo("materialCode.name"));
        sic.add(new SelectorItemInfo("productID.name"));
        sic.add(new SelectorItemInfo("isAudit"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("qiStandard.name"));
        sic.add(new SelectorItemInfo("qiStandard.number"));
        sic.add(new SelectorItemInfo("qiStandardGroup.*"));
        sic.add(new SelectorItemInfo("qiStandardGroup.name"));
        sic.add(new SelectorItemInfo("modifyType.name"));
        sic.add(new SelectorItemInfo("qiStandard.description"));
        sic.add(new SelectorItemInfo("qiSchemeGroup.*"));
        sic.add(new SelectorItemInfo("qiSchemeGroup.name"));
        return sic;
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog conditionDialog = super.initCommonQueryDialog();
        this.queryProcessor.putQueryEvent((Object)"qiStandard.number", (AbstractQueryEvent)new QIStandardF7Event());
        conditionDialog.setProcessor((IProcessor)this.queryProcessor);
        return conditionDialog;
    }

    public boolean isShowOnlyAudit() {
        return this.isShowOnlyAudit;
    }

    public void setShowOnlyAudit(boolean isShowOnlyAudit) {
        this.isShowOnlyAudit = isShowOnlyAudit;
    }
}

