/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboBoxItem;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.mm.qm.JudgeTypeEnum;
import com.kingdee.eas.basedata.mm.qm.QIBizTypeInfo;
import com.kingdee.eas.basedata.mm.qm.QIStandardFacadeFactory;
import com.kingdee.eas.basedata.mm.qm.client.AbstractQIStandardFilterUI;
import com.kingdee.eas.basedata.mm.qm.client.SelectorListenerUtils;
import com.kingdee.eas.basedata.mm.qm.utils.STQMUtils;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class QIStandardFilterUI
extends AbstractQIStandardFilterUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)QIStandardFilterUI.class);
    public static final KDComboBoxItem COMBO_NULL_ITEM = new KDComboBoxItem("");
    public static final KDComboBoxItem COMBO_AUDIT_ITEM = new KDComboBoxItem("\u5df2\u6838\u51c6");
    public static final KDComboBoxItem COMBO_NOT_AUDIT_ITEM = new KDComboBoxItem("\u672a\u6838\u51c6");

    private static final void setJudgeTypeCombo(KDComboBox box) {
        box.addItem((Object)COMBO_NULL_ITEM);
        box.addItems(JudgeTypeEnum.getEnumList().toArray());
        box.setSelectedIndex(0);
    }

    private static final void setAuditStatusCombo(KDComboBox box) {
        box.addItem((Object)COMBO_NULL_ITEM);
        box.addItem((Object)COMBO_AUDIT_ITEM);
        box.addItem((Object)COMBO_NOT_AUDIT_ITEM);
        box.setSelectedIndex(0);
    }

    public QIStandardFilterUI() throws Exception {
        this.prmtQIBizType.setQueryInfo("com.kingdee.eas.basedata.mm.qm.app.QIBizTypeQuery");
        this.prmtQIBizType.setEditFormat("$number$");
        this.prmtQIBizType.setCommitFormat("$number$");
        this.prmtQIBizType.setDisplayFormat("$name$");
        QIStandardFilterUI.setJudgeTypeCombo(this.combJudgeType);
        GeneralKDPromptSelectorAdaptor selectorLisenterFrom = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.prmtMaterialFrom, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", (Object)this, "com.kingdee.eas.basedata.master.material.app.F7MaterialQuery");
        selectorLisenterFrom.setIsMultiSelect(false);
        this.prmtMaterialFrom.setSelector((KDPromptSelector)selectorLisenterFrom);
        this.prmtMaterialFrom.addSelectorListener((SelectorListener)selectorLisenterFrom);
        selectorLisenterFrom.setQueryProperty("helpCode", "or");
        GeneralKDPromptSelectorAdaptor selectorLisenterTo = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.prmtMaterialTo, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", (Object)this, "com.kingdee.eas.basedata.master.material.app.F7MaterialQuery");
        selectorLisenterTo.setIsMultiSelect(false);
        this.prmtMaterialTo.setSelector((KDPromptSelector)selectorLisenterTo);
        this.prmtMaterialTo.addSelectorListener((SelectorListener)selectorLisenterTo);
        selectorLisenterTo.setQueryProperty("helpCode", "or");
        this.prmtMaterialFrom.setEditFormat("$number$");
        this.prmtMaterialFrom.setDisplayFormat("$number$");
        this.prmtMaterialTo.setEditFormat("$number$");
        this.prmtMaterialTo.setDisplayFormat("$number$");
        SelectorListenerUtils.attachPrmtF7UIWithQIStandardListUI((KDPromptBox)this.prmtNumberFrom);
        SelectorListenerUtils.attachPrmtF7UIWithQIStandardListUI((KDPromptBox)this.prmtNumberTo);
        this.prmtNumberFrom.setEditFormat("$number$");
        this.prmtNumberFrom.setDisplayFormat("$number$");
        this.prmtNumberTo.setEditFormat("$number$");
        this.prmtNumberTo.setDisplayFormat("$number$");
        QIStandardFilterUI.setAuditStatusCombo(this.combAuditStatus);
    }

    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        CustomerParams params = this.getCustParams();
        try {
            FilterInfo tempFilter;
            if (STQMUtils.isNotNull(this.prmtQIBizType.getValue()) && this.prmtQIBizType.getValue() instanceof QIBizTypeInfo) {
                tempFilter = new FilterInfo();
                tempFilter.getFilterItems().add(new FilterItemInfo("qiBizType.number", (Object)((QIBizTypeInfo)this.prmtQIBizType.getValue()).getNumber(), CompareType.EQUALS));
                filterInfo.mergeFilter(tempFilter, "AND");
            }
            if (this.combJudgeType.getSelectedIndex() > 0) {
                tempFilter = new FilterInfo();
                tempFilter.getFilterItems().add(new FilterItemInfo("judgeType", (Object)new Integer(((JudgeTypeEnum)((Object)this.combJudgeType.getSelectedItem())).getValue()), CompareType.EQUALS));
                filterInfo.mergeFilter(tempFilter, "AND");
            }
            if (!StringUtils.isEmpty((String)this.prmtNumberFrom.getText())) {
                tempFilter = new FilterInfo();
                tempFilter.getFilterItems().add(new FilterItemInfo("number", (Object)this.prmtNumberFrom.getText().trim(), CompareType.GREATER_EQUALS));
                filterInfo.mergeFilter(tempFilter, "AND");
            }
            if (!StringUtils.isEmpty((String)this.prmtNumberTo.getText())) {
                tempFilter = new FilterInfo();
                tempFilter.getFilterItems().add(new FilterItemInfo("number", (Object)this.prmtNumberTo.getText().trim(), CompareType.LESS_EQUALS));
                filterInfo.mergeFilter(tempFilter, "AND");
            }
            if (this.combAuditStatus.getSelectedIndex() == 1) {
                tempFilter = new FilterInfo();
                tempFilter.getFilterItems().add(new FilterItemInfo("isAudited", (Object)new Boolean(true)));
                filterInfo.mergeFilter(tempFilter, "AND");
            } else if (this.combAuditStatus.getSelectedIndex() == 2) {
                tempFilter = new FilterInfo();
                tempFilter.getFilterItems().add(new FilterItemInfo("isAudited", (Object)new Boolean(false)));
                filterInfo.mergeFilter(tempFilter, "AND");
            }
            String materialNumberFrom = "";
            String materialNumberTo = "";
            FilterInfo materialFilter = new FilterInfo();
            if (!StringUtils.isEmpty((String)this.prmtMaterialFrom.getText())) {
                materialNumberFrom = this.prmtMaterialFrom.getText().trim();
            }
            if (!StringUtils.isEmpty((String)this.prmtMaterialTo.getText())) {
                materialNumberTo = this.prmtMaterialTo.getText().trim();
            }
            params.addCustomerParam("materialFrom", materialNumberFrom);
            params.addCustomerParam("materialTo", materialNumberTo);
            this.setCustomerParams(params);
            if (!StringUtils.isEmpty((String)this.prmtMaterialFrom.getText()) || !StringUtils.isEmpty((String)this.prmtMaterialTo.getText())) {
                HashMap<String, String> m = new HashMap<String, String>();
                IRowSet rs = QIStandardFacadeFactory.getRemoteInstance().getStandardIDsByMaterial(materialNumberFrom, materialNumberTo);
                while (rs.next()) {
                    String id = rs.getString("fparentid");
                    if (m.containsKey(id)) continue;
                    m.put(id, id);
                    FilterInfo tempFilter2 = new FilterInfo();
                    tempFilter2.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
                    materialFilter.mergeFilter(tempFilter2, "OR");
                }
                if (materialFilter.getFilterItems().size() > 0) {
                    filterInfo.mergeFilter(materialFilter, "AND");
                } else {
                    FilterInfo tempFilter3 = new FilterInfo();
                    tempFilter3.getFilterItems().add(new FilterItemInfo("id", (Object)"zzzzz", CompareType.EQUALS));
                    filterInfo.mergeFilter(tempFilter3, "AND");
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.clearUI();
        FilterItemCollection c = new FilterItemCollection();
        if (entityViewInfo != null && entityViewInfo.getFilter() != null) {
            c = entityViewInfo.getFilter().getFilterItems();
        }
        for (int i = 0; i < c.size(); ++i) {
            Integer obj;
            FilterItemInfo filter = c.get(i);
            CompareType compareType = filter.getCompareType();
            String propertyName = filter.getPropertyName();
            if (propertyName == null) continue;
            if (propertyName.equals("qiBizType.number")) {
                this.prmtQIBizType.setText((String)filter.getCompareValue());
                try {
                    this.prmtQIBizType.commitEdit();
                }
                catch (ParseException e) {
                    this.prmtQIBizType.setValue(null);
                }
                continue;
            }
            if (propertyName.equals("judgeType")) {
                this.combJudgeType.setSelectedItem((Object)JudgeTypeEnum.getEnum((Integer)filter.getCompareValue()));
                continue;
            }
            if (propertyName.equals("number")) {
                if (CompareType.GREATER_EQUALS.equals((Object)compareType)) {
                    this.prmtNumberFrom.setText((String)filter.getCompareValue());
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)compareType)) continue;
                this.prmtNumberTo.setText((String)filter.getCompareValue());
                continue;
            }
            if (!propertyName.equals("isAudited") || (obj = (Integer)filter.getCompareValue()) == null) continue;
            int value = obj;
            if (value == 1) {
                this.combAuditStatus.setSelectedItem((Object)COMBO_AUDIT_ITEM);
                continue;
            }
            this.combAuditStatus.setSelectedItem((Object)COMBO_NOT_AUDIT_ITEM);
        }
        CustomerParams cond = this.getCustomerParams();
        this.prmtMaterialFrom.setText(cond.getCustomerParam("materialFrom"));
        this.prmtMaterialTo.setText(cond.getCustomerParam("materialTo"));
    }

    protected CustomerParams getCustParams() {
        CustomerParams params = new CustomerParams();
        return params;
    }

    public void clear() {
        this.clearUI();
    }

    private void clearUI() {
        this.prmtQIBizType.setValue(null);
        this.combJudgeType.setSelectedIndex(0);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtNumberFrom.setValue(null);
        this.prmtNumberTo.setValue(null);
        this.combAuditStatus.setSelectedIndex(0);
    }
}

