/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.mm.qm.IQIScheme;
import com.kingdee.eas.basedata.mm.qm.QIBizTypeInfo;
import com.kingdee.eas.basedata.mm.qm.QIItemInfo;
import com.kingdee.eas.basedata.mm.qm.QISchemeFactory;
import com.kingdee.eas.basedata.mm.qm.QISchemeInfo;
import com.kingdee.eas.basedata.mm.qm.QISchemeRelaMaterialEntryCollection;
import com.kingdee.eas.basedata.mm.qm.QISchemeRelaMaterialEntryFactory;
import com.kingdee.eas.basedata.mm.qm.QISchemeRelaMaterialEntryInfo;
import com.kingdee.eas.basedata.mm.qm.QIStandardInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.st.common.util.STUtils;

public class QISchemeUtils {
    public static QISchemeInfo getQISchemesByMaterial(MaterialInfo material) throws BOSException, EASBizException {
        if (null == material || null == material.getId()) {
            return null;
        }
        return QISchemeFactory.getRemoteInstance().getQISchemeByMaterial(material.getId().toString(), null);
    }

    public static QISchemeInfo getQISchemeByMaterial(MaterialInfo material) throws BOSException, EASBizException {
        if (null == material || null == material.getId()) {
            return null;
        }
        return QISchemeFactory.getRemoteInstance().getQISchemeByMaterial(material.getId().toString());
    }

    public static MaterialInfo getFirstMaterialByQIScheme(QISchemeInfo qiScheme) throws BOSException {
        if (qiScheme == null || qiScheme.getId() == null) {
            return null;
        }
        MaterialInfo material = QISchemeUtils.getFirstNotForbidMaterialInQIStandard(qiScheme);
        if (material == null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)qiScheme.getId().toString(), CompareType.EQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("materialEntry.material.id"));
            selector.add(new SelectorItemInfo("materialEntry.isForbid"));
            selector.add(new SelectorItemInfo("materialEntry.material.name"));
            selector.add(new SelectorItemInfo("materialEntry.material.number"));
            selector.add(new SelectorItemInfo("materialEntry.material.model"));
            selector.add(new SelectorItemInfo("materialEntry.material.baseUnit.*"));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            STUtils.setSelectorOfView((EntityViewInfo)view, (SelectorItemCollection)selector);
            try {
                QISchemeInfo info = QISchemeFactory.getRemoteInstance().getQISchemeInfo((IObjectPK)new ObjectStringPK(qiScheme.getId().toString()), selector);
                material = QISchemeUtils.getFirstNotForbidMaterialInQIStandard(info);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return material;
    }

    private static MaterialInfo getFirstNotForbidMaterialInQIStandard(QISchemeInfo qiScheme) {
        if (qiScheme == null) {
            return null;
        }
        if (qiScheme.getRelaMaterialEntry().size() > 0) {
            QISchemeRelaMaterialEntryCollection materialEntry = qiScheme.getRelaMaterialEntry();
            try {
                int size = materialEntry.size();
                for (int i = 0; i < size; ++i) {
                    QISchemeRelaMaterialEntryInfo meInfo = materialEntry.get(i);
                    if (meInfo.isIsDisabled() || meInfo.getMaterial() == null || meInfo.getMaterial().getId() == null) continue;
                    return MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectStringPK(meInfo.getMaterial().getId().toString()));
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static boolean isValidQIScheme(QISchemeInfo qiScheme, MaterialInfo material) throws BOSException {
        if (material == null || material.getId() == null || qiScheme == null || qiScheme.getId() == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)qiScheme.getId().toString(), CompareType.EQUALS));
        EntityViewInfo fromView = new EntityViewInfo();
        fromView.setFilter(filter);
        fromView.getSelector().add(new SelectorItemInfo("id"));
        QISchemeRelaMaterialEntryCollection col = QISchemeRelaMaterialEntryFactory.getRemoteInstance().getQISchemeRelaMaterialEntryCollection(fromView);
        return col != null && col.size() > 0;
    }

    public static boolean isRowBlankOnTable(KDTable detailTable, int row, String[] cols) throws Exception {
        if (detailTable == null) {
            throw new Exception("table is null!");
        }
        if (cols == null) {
            return true;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (detailTable.getCell(row, cols[i]).getValue() == null) continue;
            return false;
        }
        return true;
    }

    public static void removeLine(KDTable table, int rowIndex) {
        if (table == null) {
            return;
        }
        if (table.getRow(rowIndex) != null) {
            table.getSelectManager().select(rowIndex, 0, rowIndex, 0, 2);
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            table.removeRow(rowIndex);
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            if (collection != null && detailData != null) {
                collection.removeObject(detailData);
            }
        }
    }

    public static QISchemeInfo getQISchemeByMaterial(MaterialInfo material, QIBizTypeInfo qibiztype) throws BOSException, EASBizException {
        if (null == material || null == material.getId()) {
            return null;
        }
        String qibiztypeid = null;
        if (null != qibiztype && null != qibiztype.getId()) {
            qibiztypeid = qibiztype.getId().toString();
        }
        return QISchemeFactory.getRemoteInstance().getQISchemeByMaterial(material.getId().toString(), qibiztypeid);
    }

    public static boolean isVisibleForQIC(Context ctx, QISchemeInfo qiScheme, QIStandardInfo qiStandard, QIItemInfo qiItem) throws BOSException, EASBizException {
        if (qiItem == null || qiScheme == null || qiStandard == null) {
            return true;
        }
        IQIScheme iQIScheme = null;
        iQIScheme = ctx == null ? QISchemeFactory.getRemoteInstance() : QISchemeFactory.getLocalInstance(ctx);
        return iQIScheme.isVisibleForQIC(qiScheme.getId().toString(), qiStandard.getId().toString(), qiItem.getId().toString());
    }

    public static String getExeStdCodeNameByQISchemeID(String qiSchemeID) throws BOSException, EASBizException {
        String exeStdCodeName = null;
        if (qiSchemeID == null) {
            return null;
        }
        IQIScheme iQIScheme = QISchemeFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("exeStdCode.*"));
        selectors.add(new SelectorItemInfo("exeStdCode.name"));
        QISchemeInfo qiSchemeInfo = iQIScheme.getQISchemeInfo((IObjectPK)new ObjectStringPK(qiSchemeID), selectors);
        if (qiSchemeInfo != null && qiSchemeInfo.getExeStdCode() != null) {
            exeStdCodeName = qiSchemeInfo.getExeStdCode().getName();
        }
        return exeStdCodeName;
    }
}

