/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class QMUtils {
    private static final String resource = "com.kingdee.eas.basedata.mm.qm.QMBDResource";

    public static String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)resource, (String)strKey);
    }

    public static String toIDString(Object[] ids) {
        StringBuffer paramString = new StringBuffer();
        if (QMUtils.isNotNull(ids) && ids.length != 0) {
            Object item = null;
            int j = 0;
            int c = ids.length;
            for (int i = 0; i < c; ++i) {
                item = ids[i];
                if (!QMUtils.isNotNull(item) || item.toString().trim().length() == 0) continue;
                if (j > 0) {
                    paramString.append(",");
                }
                paramString.append("'");
                paramString.append(item.toString());
                paramString.append("'");
                ++j;
            }
        }
        return paramString.toString();
    }

    public static String toIDString(Iterator itor) {
        int count = 0;
        int stringLen = 0;
        Object o = null;
        StringBuffer paramString = new StringBuffer();
        while (itor.hasNext()) {
            o = itor.next();
            if (o == null || o.toString().trim().length() == 0) continue;
            if (count > 0) {
                paramString.append("'");
            }
            paramString.append(o.toString());
            paramString.append("',");
            ++count;
        }
        if (count == 0) {
            paramString.setLength(0);
        } else {
            stringLen = paramString.length() - 1;
            paramString.setLength(stringLen);
        }
        return paramString.toString();
    }

    public static String toParamString(Object[] ids, List params) {
        StringBuffer paramString = new StringBuffer();
        if (QMUtils.isNotNull(ids) && ids.length != 0) {
            Object item = null;
            int j = 0;
            int c = ids.length;
            for (int i = 0; i < c; ++i) {
                item = ids[i];
                if (!QMUtils.isNotNull(item) || item.toString().trim().length() == 0) continue;
                if (j > 0) {
                    paramString.append(",");
                }
                paramString.append(" ? ");
                params.add(item.toString());
                ++j;
            }
        }
        return paramString.toString();
    }

    public static String toParamString(Iterator itor, List params) {
        int count = 0;
        Object o = null;
        if (params == null) {
            params = new ArrayList<String>();
        }
        StringBuffer paramString = new StringBuffer("(");
        while (itor.hasNext()) {
            o = itor.next();
            if (o == null) continue;
            if (count > 0) {
                paramString.append(",");
            }
            paramString.append(" ? ");
            params.add(o.toString());
            ++count;
        }
        if (count == 0) {
            paramString.setLength(0);
        } else {
            paramString.append(")");
        }
        return paramString.toString();
    }

    public static IObjectValue getDynamicObject(Context ctx, String bosId) throws BOSException {
        IObjectValue objectValue = null;
        if (bosId != null && bosId.trim().length() != 0) {
            BOSUuid uuid = BOSUuid.read((String)bosId);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            BOSObjectType objType = uuid.getType();
            IDynamicObject dynamicObject = null;
            dynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
            objectValue = dynamicObject.getValue(objType, (IObjectPK)pk);
        }
        return objectValue;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNotNull(Object o) {
        return !QMUtils.isNull(o);
    }

    public static String getBOSTypeStringById(String objectId) {
        BOSObjectType bosType;
        BOSUuid id;
        String s = null;
        if (!StringUtils.isEmpty((String)objectId) && QMUtils.isNotNull(id = BOSUuid.read((String)objectId)) && QMUtils.isNotNull(bosType = id.getType())) {
            s = bosType.toString();
        }
        return s;
    }

    public static String getLocalePropertyName(Context ctx, String propertyName) {
        return QMUtils.getLocaleName(propertyName, ctx.getLocale());
    }

    public static String getLocaleName(String propertyName, Locale locale) {
        String ln = propertyName;
        if (!StringUtils.isEmpty((String)propertyName) && QMUtils.isNotNull(locale)) {
            ln = propertyName + "_" + LocaleUtils.getLocaleString((Locale)locale);
        }
        return ln;
    }
}

