/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.mm.qm.constant.STConstant;
import com.kingdee.eas.basedata.mm.qm.utils.NumericUtils;
import com.kingdee.eas.basedata.mm.qm.utils.STQMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.st.common.util.STUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class QtyMultiMeasureUtils {
    public static final int POSINDEX_SOURCEBASERATE = 0;
    public static final int POSINDEX_TARGETBASERATE = 1;
    private static HashMap multiMeasureUnitMap = new HashMap();
    private static HashMap precisionMap = new HashMap();

    public static BigDecimal baseExchangeRate(MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.multiUnitBaseExchangeRate(QtyMultiMeasureUtils.multiMeasureUnit(null, material, unit));
    }

    public static BigDecimal baseExchangeRate(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.multiUnitBaseExchangeRate(QtyMultiMeasureUtils.multiMeasureUnit(ctx, material, unit));
    }

    public static int qtyPrecision(MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.multiUnitQTYPrecision(QtyMultiMeasureUtils.multiMeasureUnit(null, material, unit));
    }

    public static int qtyPrecision(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.multiUnitQTYPrecision(QtyMultiMeasureUtils.multiMeasureUnit(ctx, material, unit));
    }

    public static int qtyPrecision(Context ctx, String materialID, String unitID) throws EASBizException, BOSException {
        int precision = -1;
        if (!StringUtils.isEmpty((String)materialID) && !StringUtils.isEmpty((String)unitID)) {
            String key = materialID + "AND" + unitID;
            Object o = precisionMap.get(key);
            if (o instanceof Integer) {
                precision = (Integer)o;
            } else {
                precision = QtyMultiMeasureUtils.getMultiUnitBizInterface(ctx).getQtyPrecision(materialID, unitID);
                precisionMap.put(key, new Integer(precision));
            }
        }
        return QtyMultiMeasureUtils.effectualQtyPrecision(precision);
    }

    public static BigDecimal effectualExchangeRate(BigDecimal v) {
        return NumericUtils.equalsZero(v) ? STConstant.EXCHANGERATE_DEFAULT : v;
    }

    public static int effectualQtyPrecision(int scale) {
        return scale >= 0 ? scale : 16;
    }

    public static MultiMeasureUnitInfo multiMeasureUnit(MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.multiMeasureUnit(null, material, unit);
    }

    public static MultiMeasureUnitInfo multiMeasureUnit(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        String key;
        MultiMeasureUnitInfo multiUnit = null;
        if (STQMUtils.isNotNull(material) && STQMUtils.isNotNull(material.getId()) && STQMUtils.isNotNull(unit) && STQMUtils.isNotNull(unit.getId()) && (multiUnit = (MultiMeasureUnitInfo)multiMeasureUnitMap.get(key = material.getId().toString() + "AND" + unit.getId().toString())) == null) {
            multiUnit = QtyMultiMeasureUtils.getMultiUnitBizInterface(ctx).getMultiUnit(material.getId().toString(), unit.getId().toString());
            multiMeasureUnitMap.put(key, multiUnit);
        }
        return multiUnit;
    }

    public static int multiUnitQTYPrecision(MultiMeasureUnitInfo multiUnit) {
        int scale = 16;
        if (STQMUtils.isNotNull(multiUnit)) {
            scale = QtyMultiMeasureUtils.effectualQtyPrecision(multiUnit.getQtyPrecision());
        }
        return scale;
    }

    public static BigDecimal multiUnitBaseExchangeRate(MultiMeasureUnitInfo multiUnit) {
        BigDecimal rate = QtyMultiMeasureUtils.effectualExchangeRate(null);
        if (STQMUtils.isNotNull(multiUnit) && NumericUtils.isDistrustExchangeRate(multiUnit.getBaseConvsRate())) {
            rate = multiUnit.getBaseConvsRate();
        }
        return rate;
    }

    public static BigDecimal calculateQty(MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal qty) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.calculateQty(null, material, sourceUnit, targetUnit, qty);
    }

    public static BigDecimal[] calculateQty(Context ctx, MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal[] qty) throws EASBizException, BOSException {
        if (STQMUtils.isNull(material) || STQMUtils.isNull(sourceUnit) || STQMUtils.isNull(targetUnit) || STQMUtils.isNull(qty)) {
            return null;
        }
        BigDecimal[] qtys = new BigDecimal[qty.length];
        if (sourceUnit.getId().equals((Object)targetUnit.getId())) {
            for (int i = 0; i < qty.length; ++i) {
                qtys[i] = qty[i];
            }
        } else {
            MultiMeasureUnitInfo[] multiUnits = QtyMultiMeasureUtils.multiMeasureUnits(ctx, material, sourceUnit, targetUnit);
            MultiMeasureUnitInfo sourceMUnit = multiUnits[0];
            MultiMeasureUnitInfo targetMUnit = multiUnits[1];
            BigDecimal sourceMExchangeRate = QtyMultiMeasureUtils.multiUnitBaseExchangeRate(sourceMUnit);
            BigDecimal targetMExchangeRate = QtyMultiMeasureUtils.multiUnitBaseExchangeRate(targetMUnit);
            int multiUnitQTYPrecision = QtyMultiMeasureUtils.multiUnitQTYPrecision(targetMUnit);
            for (int i = 0; i < qty.length; ++i) {
                qtys[i] = STQMUtils.isNotNull(qty[i]) ? QtyMultiMeasureUtils.calculateQty(sourceMExchangeRate, targetMExchangeRate, qty[i], multiUnitQTYPrecision) : null;
            }
        }
        return qtys;
    }

    public static BigDecimal[] toBaseQty(Context ctx, MaterialInfo material, MeasureUnitInfo unit, BigDecimal[] qty) throws EASBizException, BOSException {
        BigDecimal[] qtys = new BigDecimal[4];
        MaterialInfo m = QtyMultiMeasureUtils.fullUnitMaterialInfo(ctx, material);
        if (unit != null && m.getBaseUnit() != null && unit.getId().equals((Object)m.getBaseUnit().getId())) {
            for (int i = 0; i < qty.length; ++i) {
                qtys[i] = qty[i];
            }
        } else {
            MultiMeasureUnitInfo[] multiUnits = QtyMultiMeasureUtils.multiMeasureUnits(ctx, material, unit, m.getBaseUnit());
            MultiMeasureUnitInfo multiMUnit = multiUnits[0];
            MultiMeasureUnitInfo multiBaseUnit = multiUnits[1];
            int multiUnitQTYPrecision = QtyMultiMeasureUtils.multiUnitQTYPrecision(multiBaseUnit);
            BigDecimal exchange = QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiMUnit);
            for (int i = 0; i < qty.length; ++i) {
                qtys[i] = STQMUtils.isNotNull(qty[i]) ? QtyMultiMeasureUtils.toBaseQty(exchange, qty[i], multiUnitQTYPrecision) : null;
            }
        }
        return qtys;
    }

    public static BigDecimal calculateQty(Context ctx, MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal qty) throws EASBizException, BOSException {
        MultiMeasureUnitInfo[] multiUnits = QtyMultiMeasureUtils.multiMeasureUnits(ctx, material, sourceUnit, targetUnit);
        MultiMeasureUnitInfo sourceMUnit = multiUnits[0];
        MultiMeasureUnitInfo targetMUnit = multiUnits[1];
        return QtyMultiMeasureUtils.calculateQty(QtyMultiMeasureUtils.multiUnitBaseExchangeRate(sourceMUnit), QtyMultiMeasureUtils.multiUnitBaseExchangeRate(targetMUnit), qty, QtyMultiMeasureUtils.multiUnitQTYPrecision(targetMUnit));
    }

    public static BigDecimal calculateQty(Context ctx, MultiMeasureUnitInfo[] multiUnits, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal qty) throws EASBizException, BOSException {
        MultiMeasureUnitInfo sourceMUnit = multiUnits[0];
        MultiMeasureUnitInfo targetMUnit = multiUnits[1];
        return QtyMultiMeasureUtils.calculateQty(QtyMultiMeasureUtils.multiUnitBaseExchangeRate(sourceMUnit), QtyMultiMeasureUtils.multiUnitBaseExchangeRate(targetMUnit), qty, QtyMultiMeasureUtils.multiUnitQTYPrecision(targetMUnit));
    }

    public static BigDecimal calculateQty(MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.calculateQty(null, material, sourceUnit, targetUnit, qty, scale);
    }

    public static BigDecimal calculateQty(Context ctx, MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        MultiMeasureUnitInfo[] multiUnits = QtyMultiMeasureUtils.multiMeasureUnits(ctx, material, sourceUnit, targetUnit);
        return QtyMultiMeasureUtils.calculateQty(QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiUnits[0]), QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiUnits[1]), qty, scale);
    }

    public static BigDecimal calculateQty(BigDecimal sourceBaseRate, BigDecimal targetBaseRate, BigDecimal qty, int scale) {
        return QtyMultiMeasureUtils.baseQtyTo(QtyMultiMeasureUtils.toBaseQty(sourceBaseRate, qty), targetBaseRate, scale);
    }

    public static BigDecimal baseQtyTo(BigDecimal baseQty, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.baseQtyTo(null, baseQty, material, unit);
    }

    public static BigDecimal baseQtyTo(Context ctx, BigDecimal baseQty, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        MultiMeasureUnitInfo multiUnit = QtyMultiMeasureUtils.multiMeasureUnit(ctx, material, unit);
        return QtyMultiMeasureUtils.baseQtyTo(baseQty, QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiUnit), QtyMultiMeasureUtils.multiUnitQTYPrecision(multiUnit));
    }

    public static BigDecimal baseQtyTo(Context ctx, BigDecimal baseQty, MultiMeasureUnitInfo multiUnit) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.baseQtyTo(baseQty, QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiUnit), QtyMultiMeasureUtils.multiUnitQTYPrecision(multiUnit));
    }

    public static BigDecimal baseQtyTo(MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.baseQtyTo(null, material, unit, qty, scale);
    }

    public static BigDecimal baseQtyTo(Context ctx, MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.baseQtyTo(qty, QtyMultiMeasureUtils.baseExchangeRate(ctx, material, unit), scale);
    }

    public static BigDecimal baseQtyTo(BigDecimal baseQty, BigDecimal targetUnitBaseRate) {
        return QtyMultiMeasureUtils.baseQtyTo(baseQty, targetUnitBaseRate, 16);
    }

    public static BigDecimal baseQtyTo(BigDecimal baseQty, BigDecimal targetUnitBaseRate, int scale) {
        return NumericUtils.effectualNumeric(baseQty).divide(QtyMultiMeasureUtils.effectualExchangeRate(targetUnitBaseRate), QtyMultiMeasureUtils.effectualQtyPrecision(scale), 4);
    }

    public static BigDecimal toBaseQty(MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.toBaseQty(null, material, unit, qty);
    }

    public static BigDecimal toBaseQty(Context ctx, MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty) throws EASBizException, BOSException {
        MaterialInfo m = QtyMultiMeasureUtils.fullUnitMaterialInfo(ctx, material);
        MultiMeasureUnitInfo[] multiUnits = QtyMultiMeasureUtils.multiMeasureUnits(ctx, material, unit, m.getBaseUnit());
        return QtyMultiMeasureUtils.toBaseQty(QtyMultiMeasureUtils.multiUnitBaseExchangeRate(multiUnits[0]), qty, QtyMultiMeasureUtils.multiUnitQTYPrecision(multiUnits[1]));
    }

    public static BigDecimal toBaseQty(MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.toBaseQty(QtyMultiMeasureUtils.baseExchangeRate(null, material, unit), qty, scale);
    }

    public static BigDecimal toBaseQty(Context ctx, MaterialInfo material, MeasureUnitInfo unit, BigDecimal qty, int scale) throws EASBizException, BOSException {
        return QtyMultiMeasureUtils.toBaseQty(QtyMultiMeasureUtils.baseExchangeRate(ctx, material, unit), qty, scale);
    }

    public static BigDecimal toBaseQty(BigDecimal baseRate, BigDecimal qty) {
        return QtyMultiMeasureUtils.toBaseQty(baseRate, qty, 16);
    }

    public static BigDecimal toBaseQty(BigDecimal baseRate, BigDecimal qty, int scale) {
        return NumericUtils.effectualNumeric(qty).multiply(QtyMultiMeasureUtils.effectualExchangeRate(baseRate)).setScale(QtyMultiMeasureUtils.effectualQtyPrecision(scale), 4);
    }

    public static MultiMeasureUnitInfo[] multiMeasureUnits(Context ctx, MaterialInfo material, MeasureUnitInfo sourceUnit, MeasureUnitInfo targetUnit) throws EASBizException, BOSException {
        MultiMeasureUnitInfo[] mus = new MultiMeasureUnitInfo[2];
        if (STQMUtils.isNotNull(material) && STQMUtils.isNotNull(material.getId())) {
            if (STQMUtils.isNotNull(sourceUnit) && STQMUtils.isNotNull(targetUnit)) {
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("material.id"));
                view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
                view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
                view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)sourceUnit.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)targetUnit.getId().toString(), CompareType.EQUALS));
                filter.setMaskString("(#0 AND (#1 OR #2))");
                MultiMeasureUnitCollection ls = QtyMultiMeasureUtils.getMultiUnitBizInterface(ctx).getMultiMeasureUnitCollection(view);
                if (STQMUtils.isNotNull(ls)) {
                    MultiMeasureUnitInfo mi = null;
                    MeasureUnitInfo unit = null;
                    int size = ls.size();
                    for (int i = 0; i < size; ++i) {
                        mi = ls.get(i);
                        if (!STQMUtils.isNotNull(mi) || !STQMUtils.isNotNull(mi.getMeasureUnit())) continue;
                        unit = mi.getMeasureUnit();
                        if (sourceUnit.getId().toString().equalsIgnoreCase(unit.getId().toString())) {
                            mus[0] = mi;
                        }
                        if (!targetUnit.getId().toString().equalsIgnoreCase(unit.getId().toString())) continue;
                        mus[1] = mi;
                    }
                }
            } else if (STQMUtils.isNotNull(sourceUnit)) {
                mus[0] = QtyMultiMeasureUtils.multiMeasureUnit(ctx, material, sourceUnit);
            } else if (STQMUtils.isNotNull(targetUnit)) {
                mus[1] = QtyMultiMeasureUtils.multiMeasureUnit(ctx, material, targetUnit);
            }
        }
        return mus;
    }

    public static MaterialInfo fullUnitMaterialInfo(MaterialInfo material) throws BOSException, EASBizException {
        return QtyMultiMeasureUtils.fullUnitMaterialInfo(null, material);
    }

    public static MaterialInfo fullUnitMaterialInfo(Context ctx, MaterialInfo material) throws BOSException, EASBizException {
        MaterialInfo fm = null;
        if (STQMUtils.isNotNull(material) && STQMUtils.isNotNull(material.getId())) {
            if (STQMUtils.isNull(material.getBaseUnit()) || STQMUtils.isNull(material.getBaseUnit().getId()) || STQMUtils.isNull(material.getBaseUnit().getNumber()) || STQMUtils.isNull(material.getBaseUnit().getName()) || STQMUtils.isNull(material.getMaterialGroup().getId()) || STQMUtils.isNull(material.getMaterialGroup().getNumber()) || STQMUtils.isNull(material.getMaterialGroup().getName())) {
                IMaterial ie = null;
                ie = STQMUtils.isNull(ctx) ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add("id");
                selectors.add("number");
                selectors.add("name");
                selectors.add("model");
                selectors.add("helpCode");
                selectors.add("pricePrecision");
                selectors.add("baseUnit.id");
                selectors.add("baseUnit.number");
                selectors.add("baseUnit.name");
                selectors.add("assistUnit.id");
                selectors.add("assistUnit.number");
                selectors.add("assistUnit.name");
                selectors.add("materialGroup.id");
                selectors.add("materialGroup.number");
                selectors.add("materialGroup.name");
                fm = ie.getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId()), selectors);
            } else {
                fm = material;
            }
        } else {
            fm = new MaterialInfo();
        }
        return fm;
    }

    private static IMultiMeasureUnit getMultiUnitBizInterface(Context ctx) throws BOSException {
        IMultiMeasureUnit ie = null;
        ie = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        return ie;
    }

    public static Map getMultiUnitsPrecision(Context ctx, HashMap materialIDMap, HashMap baseUnitMap, HashMap unitMap, HashMap assUnitMap) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String materialID = null;
        String mouId = null;
        String baseMouId = null;
        String assMouId = null;
        int size = materialIDMap.size();
        for (int idxOfMaterial = 0; idxOfMaterial < size; ++idxOfMaterial) {
            Object o;
            if (materialIDMap.get(new Integer(idxOfMaterial)) == null) continue;
            materialID = materialIDMap.get(new Integer(idxOfMaterial)).toString();
            if (unitMap != null) {
                if (unitMap.get(new Integer(idxOfMaterial)) != null) {
                    mouId = unitMap.get(new Integer(idxOfMaterial)).toString();
                }
                if (materialID != null && mouId != null) {
                    if (sb.length() > 0) {
                        sb.append(" OR ");
                    }
                    sb.append("(material.id = '").append(materialID).append("' AND measureUnit.id = '").append(mouId).append("')");
                } else {
                    mouId = null;
                }
            }
            if (baseUnitMap != null) {
                o = baseUnitMap.get(new Integer(idxOfMaterial));
                if (STUtils.isNotNull(o)) {
                    baseMouId = o.toString();
                }
                if (baseMouId != null && !baseMouId.equals(mouId)) {
                    if (sb.length() > 0) {
                        sb.append(" OR ");
                    }
                    sb.append("(material.id = '").append(materialID).append("' AND measureUnit.id = '").append(baseMouId).append("')");
                } else {
                    baseMouId = null;
                }
            }
            if (assUnitMap == null) continue;
            o = assUnitMap.get(new Integer(idxOfMaterial));
            if (STUtils.isNotNull(o)) {
                assMouId = o.toString();
            }
            if (assMouId != null && !assMouId.equals(mouId)) {
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("(material.id = '").append(materialID).append("' AND measureUnit.id = '").append(assMouId).append("')");
                continue;
            }
            assMouId = null;
        }
        if (sb.length() > 0) {
            String oql = "select material.id, measureUnit.id, qtyPrecision, baseConvsRate where " + sb.toString();
            IMultiMeasureUnit imultiUnit = QtyMultiMeasureUtils.getMultiUnitBizInterface(ctx);
            MultiMeasureUnitCollection mulUnits = imultiUnit.getMultiMeasureUnitCollection(oql);
            HashMap<String, Integer> precisionMap = new HashMap<String, Integer>();
            HashMap<String, BigDecimal> convsRateMap = new HashMap<String, BigDecimal>();
            int size2 = mulUnits.size();
            for (int i = 0; i < size2; ++i) {
                MultiMeasureUnitInfo mmu = mulUnits.get(i);
                String key = mmu.getMaterial().getId().toString() + mmu.getMeasureUnit().getId().toString();
                precisionMap.put(key, new Integer(mmu.getQtyPrecision()));
                convsRateMap.put(key, mmu.getBaseConvsRate());
            }
            return precisionMap;
        }
        return null;
    }

    public static void iniColumnsPrecision(int precision, String[] fields, IRowSet rowSet) throws SQLException {
        for (int i = 0; i < fields.length; ++i) {
            QtyMultiMeasureUtils.iniColumnsPrecision(precision, fields[i], rowSet);
        }
    }

    public static void iniColumnsPrecision(int precision, String field, IRowSet rowSet) throws SQLException {
        BigDecimal temp = rowSet.getBigDecimal(field);
        if (temp != null) {
            temp = temp.setScale(precision, 4);
            rowSet.updateObject(field, (Object)temp);
        }
    }
}

