/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.AssistantOrgFacadeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAssistantOrgFacade;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.client.AbstractAssistantOrgMaintainUI;
import com.kingdee.eas.basedata.org.client.OUEditUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;

public class AssistantOrgMaintainUI
extends AbstractAssistantOrgMaintainUI {
    private static final Color normalColor = new Color(0xF9F9F9);
    private static final Color sealedupColor = new Color(0xD9D9D2);
    private String mainOrgId = null;

    public AssistantOrgMaintainUI() throws Exception {
        this.initButtons();
        this.initTblMain();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadTblMainData();
    }

    private void initTblMain() {
        this.tblMain.checkParsed();
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(3).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(4).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(5).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(6).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(7).getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    private boolean isTheOUSealedUp(int rowIndex) {
        return (Boolean)this.tblMain.getCell(rowIndex, "isOUSealUp").getValue();
    }

    private void initButtons() {
        this.btnAddNew.setEnabled(true);
        this.btnDelete.setVisible(false);
        this.btnDelete.setEnabled(false);
        this.btnSealUp.setEnabled(true);
        this.btnUnSealUp.setEnabled(true);
        this.btnUpdate.setVisible(true);
        this.btnUpdate.setEnabled(true);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_sealup"));
        this.btnUnSealUp.setIcon(EASResource.getIcon((String)"imgTbtn_unsealup"));
    }

    public void loadTblMainData() throws Exception {
        int rows;
        FullOrgUnitInfo mainUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("mainOrg");
        this.mainOrgId = mainUnitInfo.getId().toString();
        IAssistantOrgFacade iAssistantOrgFacade = AssistantOrgFacadeFactory.getRemoteInstance();
        CompanyOrgUnitCollection col = iAssistantOrgFacade.getAssistantOrgs(this.mainOrgId);
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        if (col != null && col.size() > 0) {
            CompanyOrgUnitInfo assistantUnitInfo = null;
            IRow row = null;
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                assistantUnitInfo = col.get(i);
                String tableName = null;
                String typeName = null;
                String currencyName = null;
                if (assistantUnitInfo.getAccountTable() != null) {
                    tableName = assistantUnitInfo.getAccountTable().getName();
                }
                if (assistantUnitInfo.getAccountPeriodType() != null) {
                    typeName = assistantUnitInfo.getAccountPeriodType().getName();
                }
                if (assistantUnitInfo.getBaseCurrency() != null) {
                    currencyName = assistantUnitInfo.getBaseCurrency().getName();
                }
                row = this.tblMain.addRow();
                AcountSchemeInfo accountSchemeInfo = assistantUnitInfo.getAccountScheme();
                row.getCell("schemeId").setValue((Object)accountSchemeInfo.getId().toString());
                row.getCell("schemeNumber").setValue((Object)accountSchemeInfo.getNumber());
                row.getCell("schemeName").setValue((Object)accountSchemeInfo.getName());
                row.getCell("assistantOrgId").setValue((Object)assistantUnitInfo.getId().toString());
                row.getCell("assistantOrgNumber").setValue((Object)assistantUnitInfo.getNumber());
                row.getCell("assistantOrgName").setValue((Object)assistantUnitInfo.getName());
                row.getCell("accountTable").setValue((Object)tableName);
                row.getCell("accountPeriod").setValue((Object)typeName);
                row.getCell("accountCurrency").setValue((Object)currencyName);
                row.getCell("isOUSealUp").setValue((Object)new Boolean(assistantUnitInfo.isIsOUSealUp()));
            }
        }
        if ((rows = this.tblMain.getRowCount()) != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (this.isTheOUSealedUp(i)) {
                this.tblMain.getRow(i).getStyleAttributes().setBackground(sealedupColor);
                continue;
            }
            this.tblMain.getRow(i).getStyleAttributes().setBackground(normalColor);
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        KDTSelectBlock block;
        if (e.getClickCount() == 2) {
            // empty if block
        }
        if (e.getType() == 1 && (block = this.tblMain.getSelectManager().get()) != null) {
            int rowIndex = block.getBeginRow();
            if (this.isTheOUSealedUp(rowIndex)) {
                this.btnUpdate.setEnabled(false);
                this.btnSealUp.setEnabled(false);
                this.btnUnSealUp.setEnabled(true);
            } else {
                this.btnUpdate.setEnabled(true);
                this.btnSealUp.setEnabled(true);
                this.btnUnSealUp.setEnabled(false);
            }
        }
    }

    private void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private String getSelectedKeyValue() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            ICell cell = row.getCell("assistantOrgId");
            return cell.getValue().toString();
        }
        return null;
    }

    private ArrayList getAllSchemeIds() {
        ArrayList<String> idList = new ArrayList<String>();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            idList.add(row.getCell("schemeId").getValue().toString());
        }
        return idList;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        block2: {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            uiContext.put((Object)"mainOrgId", (Object)this.mainOrgId);
            uiContext.put((Object)"schemeIds", (Object)this.getAllSchemeIds());
            IUIFactory uiFactory = null;
            try {
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow curDialog = uiFactory.create("com.kingdee.eas.basedata.org.client.AccountSchemeSelectUI", (Map)uiContext);
                curDialog.show();
            }
            catch (Throwable ex) {
                if (!(ex instanceof Exception)) break block2;
                this.handleException((Exception)ex);
            }
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OUEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.loadTblMainData();
    }

    @Override
    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OUEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.loadTblMainData();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            String unitId = this.getSelectedKeyValue();
            IAssistantOrgFacade iAssistantOrg = AssistantOrgFacadeFactory.getRemoteInstance();
            iAssistantOrg.deleteAssistantOrg((IObjectPK)new ObjectUuidPK(unitId));
            if (CacheConfigManager.getConfig() != null) {
                CacheServiceFactory.getInstance().discardAll();
            }
            this.loadTblMainData();
        }
    }

    @Override
    public void actionSealUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String unitId = this.getSelectedKeyValue();
        INewOUInnerFacade iOUI = NewOUInnerFacadeFactory.getRemoteInstance();
        iOUI.bizSealUp(unitId, 1);
        iOUI.ouSealUp(unitId);
        this.tblMain.getRow(this.tblMain.getSelectManager().get().getBeginRow()).getStyleAttributes().setBackground(sealedupColor);
        this.tblMain.getRow(this.tblMain.getSelectManager().get().getBeginRow()).getCell("isOUSealUp").setValue((Object)new Boolean(true));
        this.btnUpdate.setEnabled(false);
        this.btnSealUp.setEnabled(false);
        this.btnUnSealUp.setEnabled(true);
    }

    @Override
    public void actionUnSealUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String unitId = this.getSelectedKeyValue();
        INewOUInnerFacade iOUI = NewOUInnerFacadeFactory.getRemoteInstance();
        iOUI.bizUnSealUp(unitId, 1);
        iOUI.ouUnSealUp(unitId);
        this.tblMain.getRow(this.tblMain.getSelectManager().get().getBeginRow()).getStyleAttributes().setBackground(normalColor);
        this.tblMain.getRow(this.tblMain.getSelectManager().get().getBeginRow()).getCell("isOUSealUp").setValue((Object)new Boolean(false));
        this.btnUpdate.setEnabled(true);
        this.btnSealUp.setEnabled(true);
        this.btnUnSealUp.setEnabled(false);
    }
}

