/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.f7;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

public class AdminByCompanyF7
extends AdminF7 {
    private String companyOrgUnitID = "";
    private boolean useGrayNodeStyle = false;
    private boolean useOrgRangeFilter = true;

    public AdminByCompanyF7(String companyOrgUnitID) {
        this.companyOrgUnitID = companyOrgUnitID;
    }

    public AdminByCompanyF7(IUIObject iuio, String companyOrgUnitID) {
        super(iuio);
        this.companyOrgUnitID = companyOrgUnitID;
    }

    public AdminByCompanyF7(Frame frm, String companyOrgUnitID) {
        super(frm);
        this.companyOrgUnitID = companyOrgUnitID;
    }

    public AdminByCompanyF7(Dialog dlg, String companyOrgUnitID) {
        super(dlg);
        this.companyOrgUnitID = companyOrgUnitID;
    }

    public void setUseGrayNodeStyle() {
        this.useGrayNodeStyle = true;
    }

    public void setDoNotUseOrgRangeFilter() {
        this.useOrgRangeFilter = false;
    }

    public DefaultKingdeeTreeNode getRoot() throws Exception {
        OrgViewType ovt = OrgViewType.ADMIN;
        OrgTreeInfo oti = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgViewType)ovt)));
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTreeModel(ovt, oti).getRoot();
        this.convertNodeUserObjectToAdminOrgUnitInfo(root);
        return root;
    }

    private void convertNodeUserObjectToAdminOrgUnitInfo(DefaultKingdeeTreeNode root) throws Exception {
        Enumeration enu = root.breadthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo osi = null;
        AdminOrgUnitInfo aoui = null;
        IAdminOrgUnit iaou = AdminOrgUnitFactory.getRemoteInstance();
        while (enu.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enu.nextElement();
            osi = (OrgStructureInfo)node.getUserObject();
            aoui = iaou.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(osi.getUnit().getId()));
            node.setUserObject((Object)aoui);
        }
    }

    protected void prepareDisplayOrgIDs(OrgViewType orgViewType, OrgTreeInfo orgTree) throws Exception {
        this.innerPrepareDisplayOrgIDs();
    }

    protected void prepareDisplayOrgIDs() throws Exception {
        this.innerPrepareDisplayOrgIDs();
    }

    private void innerPrepareDisplayOrgIDs() throws Exception {
        ICompanyOrgUnit icou = CompanyOrgUnitFactory.getRemoteInstance();
        AdminOrgUnitCollection aouc = icou.getAdminOrgUnitCollectionWithOrgRangeFilter(this.companyOrgUnitID);
        if (!this.useOrgRangeFilter) {
            aouc = icou.getAdminOrgUnitCollection(this.companyOrgUnitID);
        }
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        int n = aouc.size();
        for (int i = 0; i < n; ++i) {
            hm.put(aouc.get(i).getId().toString(), Boolean.FALSE);
        }
        this.displayOrgIds = hm;
        if (this.rootUnitID == null || this.rootUnitID.equals("11111111-1111-1111-1111-111111111111CCE7AED4")) {
            this.rootUnitID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
    }

    protected void clipTreeModel(TreeModel model) {
        if (this.useGrayNodeStyle) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)model;
        this.moveTheWantedTreeNodesTogether(treeModel);
        this.removeAllTheUnwantedTreeNodes(treeModel);
    }

    private void moveTheWantedTreeNodesTogether(DefaultTreeModel treeModel) {
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode parnode = null;
        ArrayList nodes = this.getAListOfAllTreeNodes(treeModel);
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            node = (DefaultKingdeeTreeNode)nodes.get(i);
            if (node.isRoot() || !this.isTheWantedTreeNode(node)) continue;
            parnode = (DefaultKingdeeTreeNode)node.getParent();
            while (!parnode.isRoot() && !this.isTheWantedTreeNode(parnode)) {
                parnode = (DefaultKingdeeTreeNode)parnode.getParent();
                treeModel.removeNodeFromParent((MutableTreeNode)node);
                parnode.add((MutableTreeNode)node);
            }
        }
    }

    private void removeAllTheUnwantedTreeNodes(DefaultTreeModel treeModel) {
        ArrayList nodes = this.getAListOfAllTreeNodes(treeModel);
        DefaultKingdeeTreeNode node = null;
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            node = (DefaultKingdeeTreeNode)nodes.get(i);
            if (node.isRoot() || node.getParent() == null || this.isTheWantedTreeNode(node)) continue;
            treeModel.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    private boolean isTheWantedTreeNode(DefaultKingdeeTreeNode node) {
        return !OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node);
    }

    private ArrayList getAListOfAllTreeNodes(DefaultTreeModel treeModel) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        Enumeration nodes = root.breadthFirstEnumeration();
        ArrayList al = new ArrayList();
        while (nodes.hasMoreElements()) {
            al.add(nodes.nextElement());
        }
        return al;
    }
}

