/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.client.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgF7WithIndustryAndRegionUI;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Map;
import org.apache.log4j.Logger;

public class NewCompany4ImportCompanyInUnionGroup
extends NewCompanyF7 {
    private static Logger logger = Logger.getLogger((String)NewCompany4ImportCompanyInUnionGroup.class.getName());
    private static final String INDUSTRYSQL = "select funitid from t_org_oupartfi where FIndustry = 'INDUSTRYID'";
    private IndustryInfo industryInfo;
    private String territoryValue;
    private String importedCompanyQuerySQL;

    @Override
    protected void init() {
        super.init();
        StringBuffer extraFilters = new StringBuffer();
        extraFilters.append("\"OUPART\"").append(".FIsBizUnit = ").append(1);
        this.setExtraTreeFilters(extraFilters.toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.partFI.isBizUnit", (Object)new Integer(1)));
        this.setOuterFilterInfo(filter);
    }

    public void show() {
        try {
            if (this.uiOwner != null) {
                this.owner = ComponentUtil.getOwnerWindow((Component)((Component)this.uiOwner));
            }
            UIContext uiContext = new UIContext((Object)this.owner);
            uiContext.put((Object)"OrgF7Proxy", (Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NewOrgF7WithIndustryAndRegionUI.class.getName(), (Map)uiContext);
            this.f7ui = (NewOrgF7WithIndustryAndRegionUI)uiWindow.getUIObject();
            if (uiWindow instanceof Dialog) {
                ((Dialog)uiWindow).setTitle(this.getTtile());
            } else if (uiWindow instanceof Frame) {
                ((Frame)uiWindow).setTitle(this.getTtile());
            }
            uiWindow.show();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void setIndustry(IndustryInfo industryInfo) {
        this.industryInfo = industryInfo;
    }

    public void setTerritoryValue(String territoryValue) {
        this.territoryValue = territoryValue;
    }

    public void setImportedCompanyQuerySQL(String importedCompanyQuerySQL) {
        this.importedCompanyQuerySQL = importedCompanyQuerySQL;
    }

    protected EntityViewInfo getEntityViewExceptTreeFilter() throws BOSException {
        EntityViewInfo viewInfo = super.getEntityViewExceptTreeFilter();
        FilterInfo filter = viewInfo.getFilter();
        if (this.industryInfo != null && this.industryInfo.getId() != null) {
            try {
                filter.mergeFilter(new FilterInfo("unit.id in (" + INDUSTRYSQL.replaceFirst("INDUSTRYID", this.industryInfo.getId().toString()) + ")"), "AND");
            }
            catch (ParserException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)this.importedCompanyQuerySQL)) {
            try {
                filter.mergeFilter(new FilterInfo("unit.id not in (" + this.importedCompanyQuerySQL + ")"), "AND");
            }
            catch (ParserException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return viewInfo;
    }

    protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
        OrgAssistInfo assistInfo = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
        StringBuffer value = new StringBuffer();
        String originFilter = StringUtils.isEmpty((String)assistInfo.getExtraFilters()) ? "" : assistInfo.getExtraFilters();
        value.append(originFilter);
        if (!StringUtils.isEmpty((String)this.territoryValue)) {
            if (this.isBlured()) {
                value.append(" AND ").append("\"BASEUNIT\"").append(".FID IN (select FUnitID from t_org_oupartfi where fterritory_").append(SysContext.getSysContext().getLocale().toString()).append(" like '%").append(this.territoryValue).append("%')");
            } else {
                value.append(" AND ").append("\"BASEUNIT\"").append(".FID IN (select FUnitID from t_org_oupartfi where fterritory_").append(SysContext.getSysContext().getLocale().toString()).append(" = '").append(this.territoryValue).append("')");
            }
        }
        if (this.industryInfo != null && this.industryInfo.getId() != null) {
            value.append(" AND ").append("\"BASEUNIT\"").append(".FID IN (").append(INDUSTRYSQL.replaceFirst("INDUSTRYID", this.industryInfo.getId().toString())).append(")");
        }
        if (!StringUtils.isEmpty((String)this.importedCompanyQuerySQL)) {
            value.append(" AND ").append("\"BASEUNIT\"").append(".FID NOT IN (").append(this.importedCompanyQuerySQL).append(")");
        }
        assistInfo.setExtraFilters(value.toString());
        return assistInfo;
    }
}

