/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public abstract class AbstractDataImport
extends AbstractDataTransmission {
    private Map infoMap = new HashMap(100);

    public Map getInfoMap() {
        return this.infoMap;
    }

    public void setInfoMap(Map infoMap) {
        this.infoMap = infoMap;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return this._getController(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this._transmit(hsData, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            return this._exportTransmit(rs, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public String getString(IRowSet rs, String columnName) {
        try {
            String value = rs.getString(columnName);
            return value;
        }
        catch (SQLException e) {
            return "";
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            this._submit(coreBaseInfo, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract ICoreBase _getController(Context var1) throws EASBizException, BOSException;

    protected abstract CoreBaseInfo _transmit(Hashtable var1, Context var2) throws EASBizException, BOSException;

    protected abstract void _submit(CoreBaseInfo var1, Context var2) throws BOSException, EASBizException;

    protected Hashtable _exportTransmit(IRowSet rs, Context ctx) throws EASBizException, BOSException {
        return null;
    }

    public Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    protected void prepareImport(Context ctx, IObjectValue info, Hashtable hsData) throws BOSException {
        this.prepareImport(ctx, info, hsData, null);
    }

    protected void prepareImport(Context ctx, IObjectValue info, Hashtable hsData, String prefix) throws BOSException {
        this.verifyEmpty(ctx, hsData);
        BOSObjectType type = info.getBOSType();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
        PropertyCollection properties = entity.getPropertiesRuntime();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo prop = properties.get(i);
            String name = prop.getName();
            if (name == null) continue;
            String importKey = null;
            importKey = AbstractDataImport.isEmpty(prefix) ? name : prefix + "." + name;
            Object data = this.getData(hsData, importKey);
            if (data == null) continue;
            if (prop instanceof LinkPropertyInfo) {
                IObjectValue value = null;
                LinkPropertyInfo new_name = (LinkPropertyInfo)prop;
                EntityObjectInfo sobj = new_name.getRelationship().getSupplierObject();
                BOSObjectType sobjtype = sobj.getType();
                IObjectCollection obj = this.getCollectionByNumber(ctx, data, sobjtype);
                if (obj != null && obj.size() == 1) {
                    value = obj.getObject(0);
                    info.put(name, (Object)value);
                    continue;
                }
                if (obj == null || obj.size() == 0) {
                    // empty if block
                }
            }
            if (!(prop instanceof OwnPropertyInfo)) continue;
            OwnPropertyInfo new_name = (OwnPropertyInfo)prop;
            DataType datatype = new_name.getDataType();
            if (datatype == DataType.STRING) {
                info.setString(name, this.getString(ctx, data));
                continue;
            }
            if (datatype == DataType.DATE) {
                info.setDate(name, this.getDate(ctx, data));
                continue;
            }
            if (datatype == DataType.TIMESTAMP) {
                info.setDate(name, this.getDate(ctx, data));
                continue;
            }
            if (datatype == DataType.DECIMAL) {
                info.setBigDecimal(name, this.getAmount(ctx, data));
                continue;
            }
            if (datatype != DataType.INTEGER) continue;
            info.setInt(name, this.getInt(ctx, data));
        }
    }

    private IObjectCollection getCollectionByNumber(Context ctx, Object data, BOSObjectType sobjtype) throws BOSException {
        IObjectCollection obj = null;
        try {
            obj = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(sobjtype, "select * where number ='" + data + "' or name='" + "'");
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return obj;
    }

    private void verifyEmpty(Context ctx, Hashtable hsData) throws BOSException {
        String templateNum = this.getTemplateNumber();
        if (AbstractDataImport.isEmpty(templateNum)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)templateNum));
        view.setFilter(filter);
        DIETemplateCollection tepleteColl = DIETemplateFactory.getLocalInstance((Context)ctx).getDIETemplateCollection(view);
        if (tepleteColl.size() == 0) {
            return;
        }
        DIETemplateInfo teplateInfo = tepleteColl.get(0);
        DIETemplateFieldEntryCollection entryColl = teplateInfo.getFieldEntries();
        for (DIETemplateFieldEntryInfo entry : entryColl) {
            String fieldNum = entry.getNumber();
            boolean isRequired = entry.isIsNeed();
            Object data = ((DataToken)hsData.get((Object)fieldNum)).data;
            if (!isRequired || !AbstractDataImport.isEmpty(data)) continue;
            String fieldName = entry.getName();
            throw new BOSException("\u5b57\u6bb5:" + fieldName + " \u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected String getTemplateNumber() {
        return "";
    }

    protected AccountBankInfo getAccountBank(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        String number = data.toString().trim();
        IAccountBank acb = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection coll = acb.getAccountBankCollection("select * where number ='" + number + "'");
        if (coll == null || coll.size() == 0) {
            throw new BOSException("\u7f16\u7801\u4e3a" + data + "\u94f6\u884c\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        return coll.get(0);
    }

    protected BigDecimal getAmount(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return new BigDecimal("0");
        }
        BigDecimal value = null;
        try {
            value = TypeConversionUtils.objToBigDecimal((Object)data);
        }
        catch (Exception e) {
            throw new BOSException(data + "\u6570\u503c\u8f6c\u6362\u51fa\u9519\uff01");
        }
        return value;
    }

    protected int getInt(Context ctx, Object data) throws BOSException {
        int value;
        if (data == null || data.toString().trim().length() == 0) {
            return 0;
        }
        try {
            value = TypeConversionUtils.objToInt((Object)data);
        }
        catch (Exception e) {
            throw new BOSException(data + "\u6570\u503c\u8f6c\u6362\u51fa\u9519\uff01");
        }
        return value;
    }

    protected String getString(Context ctx, Object data) {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        return data.toString().trim();
    }

    protected Date getDate(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        Date date = null;
        try {
            date = TypeConversionUtils.objToUtilDate((Object)data);
        }
        catch (Exception e) {
            try {
                date = BOSLocaleUtil.getDateFormat().parse(data.toString());
            }
            catch (ParseException e1) {
                throw new BOSException(data + "\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u65e5\u671f\u8f93\u5165\u662f\u5426\u6b63\u786e\uff01");
            }
            throw new BOSException(data + "\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u65e5\u671f\u8f93\u5165\u662f\u5426\u6b63\u786e\uff01");
        }
        return date;
    }

    protected CurrencyInfo getCurrency(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        ICurrency cur = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection coll = cur.getCurrencyCollection("select * where name ='" + data + "'");
        if (coll == null || coll.size() == 0) {
            throw new BOSException("\u7f16\u7801\u4e3a" + data + "\u5e01\u522b\u4e0d\u5b58\u5728");
        }
        return coll.get(0);
    }

    protected SettlementTypeInfo getSettlementType(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        ISettlementType st = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        SettlementTypeCollection coll = st.getSettlementTypeCollection(ev);
        if (coll == null || coll.size() == 0) {
            throw new BOSException("\u7f16\u7801\u4e3a" + data + "\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u5b58\u5728");
        }
        return coll.get(0);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(Object o) {
        if (o instanceof String) {
            return o == null || o.toString().trim().length() == 0;
        }
        return o == null;
    }
}

