/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BOTPUtil {
    public static void saveBOTRelation(Context ctx, List srcIdList, String destBillId) throws BOSException {
        if (srcIdList == null || srcIdList.isEmpty() || EmptyUtil.isEmpty(destBillId)) {
            return;
        }
        String srcBillId = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        int size = srcIdList.size();
        for (int i = 0; i < size; ++i) {
            BOTRelationInfo relateInfo = new BOTRelationInfo();
            srcBillId = (String)srcIdList.get(i);
            relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
            relateInfo.setSrcObjectID(srcBillId);
            relateInfo.setDestObjectID(destBillId);
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            iBOTRelation.addnew(relateInfo);
        }
    }

    public static void saveBOTRelation(Context ctx, Map idMap) throws BOSException {
        if (idMap == null || idMap.isEmpty()) {
            return;
        }
        BOTRelationInfo relateInfo = null;
        String srcBillId = null;
        String destBillId = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        for (Map.Entry entry : idMap.entrySet()) {
            srcBillId = (String)entry.getKey();
            destBillId = (String)entry.getValue();
            relateInfo = new BOTRelationInfo();
            relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
            relateInfo.setSrcObjectID(srcBillId);
            relateInfo.setDestObjectID(destBillId);
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            iBOTRelation.addnew(relateInfo);
        }
    }

    public static Set getSrcBillIdSet(Context ctx, String destBillId) throws BOSException {
        HashSet<String> destBillIdSet = new HashSet<String>();
        destBillIdSet.add(destBillId);
        return BOTPUtil.getSrcBillIdSet(ctx, destBillIdSet);
    }

    public static Set getSrcBillIdSet(Context ctx, Set destBillIdSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destBillIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        IBOTRelation iBOTRelation = null;
        iBOTRelation = ctx != null ? BOTRelationFactory.getLocalInstance((Context)ctx) : BOTRelationFactory.getRemoteInstance();
        BOTRelationCollection relateColl = iBOTRelation.getCollection(evi);
        HashSet<String> idSet = new HashSet<String>();
        int size = relateColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(relateColl.get(i).getSrcObjectID());
        }
        return idSet;
    }

    public static Set getDestBillIdSet(Context ctx, String srcBillId) throws BTPException, BOSException {
        IBTPManager iBTPManager = null;
        iBTPManager = ctx == null ? BTPManagerFactory.getRemoteInstance() : BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection relateColl = iBTPManager.getDestRelation(srcBillId);
        HashSet<String> idSet = new HashSet<String>();
        if (relateColl == null || relateColl.size() < 1) {
            return idSet;
        }
        int size = relateColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(relateColl.get(i).getDestObjectID());
        }
        return idSet;
    }

    public static boolean isZERO(BigDecimal o) {
        return o == null || o.compareTo(Constants.ZERO) == 0;
    }
}

