/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class OrgRelationUtils {
    public static OrgUnitInfo[] getOrgUnitInfosByType(FullOrgUnitCollection orgs, OrgType orgType) {
        OrgUnitInfo[] results = null;
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getRemoteInstance();
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getRemoteInstance();
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getRemoteInstance();
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isDiffrent4OrgCollection(OrgUnitCollection collection1, OrgUnitCollection collection2) {
        boolean isChanged = false;
        if (collection1 == null && collection2 != null) {
            isChanged = collection2.size() > 0;
        } else if (collection1 != null && collection2 == null) {
            isChanged = collection1.size() > 0;
        } else if (collection1 != null && collection2 != null) {
            if (collection1.size() != collection2.size()) {
                isChanged = true;
            } else {
                int i;
                ArrayList<String> list = new ArrayList<String>();
                for (i = 0; i < collection1.size(); ++i) {
                    list.add(collection1.get(i).getId().toString());
                }
                for (i = 0; i < collection2.size(); ++i) {
                    if (list.contains(collection2.get(i).getId().toString())) continue;
                    isChanged = true;
                    break;
                }
            }
        }
        return isChanged;
    }

    public static OrgUnitCollection getOrgsByRelation(OrgType srcOrgType, OrgType destOrgType, BOSUuid orgPK) throws BOSException, EASBizException {
        Object result = null;
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        switch (iSrcOrg) {
            case 0: 
            case 4: {
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 1: {
                return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 2: {
                if (iDestOrg == 4) {
                    return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
                }
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 3: {
                if (iDestOrg == 1) {
                    return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
                }
                return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 24: {
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
        }
        return null;
    }

    public static String getAdminOrgUnitInfo(String orgID) throws Exception {
        ObjectUuidPK pk;
        if (orgID == null || orgID.length() == 0) {
            return null;
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitInfo aFullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)(pk = new ObjectUuidPK(orgID)));
        if (aFullOrgUnitInfo.isIsAdminOrgUnit()) {
            return orgID;
        }
        String parentID = aFullOrgUnitInfo.getParent().getId().toString();
        return OrgRelationUtils.getAdminOrgUnitInfo(parentID);
    }
}

